# coding: utf-8

"""
    Street Manager API

    See API specification Resource Guide > Work API for more information on endpoints NOTE: Swagger Editor/UI does not display all description text for enumerations and child elements, check swagger.json for full description text  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class PermitAlterationCreateRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'internal_user_identifier': 'str',
        'internal_user_name': 'str',
        'secondary_contact': 'str',
        'secondary_contact_number': 'str',
        'secondary_contact_email': 'str',
        'proposed_start_date': 'datetime',
        'proposed_start_time': 'datetime',
        'proposed_end_date': 'datetime',
        'proposed_end_time': 'datetime',
        'description_of_work': 'str',
        'excavation': 'bool',
        'project_reference_number': 'str',
        'traffic_management_plan': 'bool',
        'lane_rental_applicable': 'bool',
        'permit_conditions': 'list[PermitCondition]',
        'works_location_description': 'str',
        'works_coordinates': 'object',
        'collaborative_working': 'bool',
        'collaboration_details': 'str',
        'collaborative_works': 'str',
        'activity_type': 'ActivityType',
        'traffic_management_type': 'TrafficManagementType',
        'application_type': 'ApplicationType',
        'collaboration_type': 'AllOfPermitAlterationCreateRequestCollaborationType',
        'location_types': 'list[LocationType]',
        'early_start_pre_approval': 'bool',
        'pre_approval_details': 'str',
        'pre_approval_authoriser': 'str',
        'early_start_reason': 'str',
        'work_type': 'WorkType',
        'is_ttro_required': 'bool',
        'immediate_risk': 'bool',
        'file_ids': 'list[float]',
        'additional_info': 'str',
        'close_footway': 'CloseFootway',
        'close_footpath': 'CloseFootpath',
        'permit_asds': 'list[PermitASD]',
        'additional_contact': 'str',
        'additional_contact_number': 'str',
        'additional_contact_email': 'str',
        'hs2_consultation_requested_response_date': 'datetime',
        'hs2_highway_emails': 'list[str]',
        'emergency_contact_name': 'str',
        'emergency_contact_number': 'str',
        'permit_alteration_reason': 'str'
    }

    attribute_map = {
        'internal_user_identifier': 'internal_user_identifier',
        'internal_user_name': 'internal_user_name',
        'secondary_contact': 'secondary_contact',
        'secondary_contact_number': 'secondary_contact_number',
        'secondary_contact_email': 'secondary_contact_email',
        'proposed_start_date': 'proposed_start_date',
        'proposed_start_time': 'proposed_start_time',
        'proposed_end_date': 'proposed_end_date',
        'proposed_end_time': 'proposed_end_time',
        'description_of_work': 'description_of_work',
        'excavation': 'excavation',
        'project_reference_number': 'project_reference_number',
        'traffic_management_plan': 'traffic_management_plan',
        'lane_rental_applicable': 'lane_rental_applicable',
        'permit_conditions': 'permit_conditions',
        'works_location_description': 'works_location_description',
        'works_coordinates': 'works_coordinates',
        'collaborative_working': 'collaborative_working',
        'collaboration_details': 'collaboration_details',
        'collaborative_works': 'collaborative_works',
        'activity_type': 'activity_type',
        'traffic_management_type': 'traffic_management_type',
        'application_type': 'application_type',
        'collaboration_type': 'collaboration_type',
        'location_types': 'location_types',
        'early_start_pre_approval': 'early_start_pre_approval',
        'pre_approval_details': 'pre_approval_details',
        'pre_approval_authoriser': 'pre_approval_authoriser',
        'early_start_reason': 'early_start_reason',
        'work_type': 'work_type',
        'is_ttro_required': 'is_ttro_required',
        'immediate_risk': 'immediate_risk',
        'file_ids': 'file_ids',
        'additional_info': 'additional_info',
        'close_footway': 'close_footway',
        'close_footpath': 'close_footpath',
        'permit_asds': 'permit_asds',
        'additional_contact': 'additional_contact',
        'additional_contact_number': 'additional_contact_number',
        'additional_contact_email': 'additional_contact_email',
        'hs2_consultation_requested_response_date': 'hs2_consultation_requested_response_date',
        'hs2_highway_emails': 'hs2_highway_emails',
        'emergency_contact_name': 'emergency_contact_name',
        'emergency_contact_number': 'emergency_contact_number',
        'permit_alteration_reason': 'permit_alteration_reason'
    }

    def __init__(self, internal_user_identifier=None, internal_user_name=None, secondary_contact=None, secondary_contact_number=None, secondary_contact_email=None, proposed_start_date=None, proposed_start_time=None, proposed_end_date=None, proposed_end_time=None, description_of_work=None, excavation=None, project_reference_number=None, traffic_management_plan=None, lane_rental_applicable=None, permit_conditions=None, works_location_description=None, works_coordinates=None, collaborative_working=None, collaboration_details=None, collaborative_works=None, activity_type=None, traffic_management_type=None, application_type=None, collaboration_type=None, location_types=None, early_start_pre_approval=None, pre_approval_details=None, pre_approval_authoriser=None, early_start_reason=None, work_type=None, is_ttro_required=None, immediate_risk=None, file_ids=None, additional_info=None, close_footway=None, close_footpath=None, permit_asds=None, additional_contact=None, additional_contact_number=None, additional_contact_email=None, hs2_consultation_requested_response_date=None, hs2_highway_emails=None, emergency_contact_name=None, emergency_contact_number=None, permit_alteration_reason=None):  # noqa: E501
        """PermitAlterationCreateRequest - a model defined in Swagger"""  # noqa: E501
        self._internal_user_identifier = None
        self._internal_user_name = None
        self._secondary_contact = None
        self._secondary_contact_number = None
        self._secondary_contact_email = None
        self._proposed_start_date = None
        self._proposed_start_time = None
        self._proposed_end_date = None
        self._proposed_end_time = None
        self._description_of_work = None
        self._excavation = None
        self._project_reference_number = None
        self._traffic_management_plan = None
        self._lane_rental_applicable = None
        self._permit_conditions = None
        self._works_location_description = None
        self._works_coordinates = None
        self._collaborative_working = None
        self._collaboration_details = None
        self._collaborative_works = None
        self._activity_type = None
        self._traffic_management_type = None
        self._application_type = None
        self._collaboration_type = None
        self._location_types = None
        self._early_start_pre_approval = None
        self._pre_approval_details = None
        self._pre_approval_authoriser = None
        self._early_start_reason = None
        self._work_type = None
        self._is_ttro_required = None
        self._immediate_risk = None
        self._file_ids = None
        self._additional_info = None
        self._close_footway = None
        self._close_footpath = None
        self._permit_asds = None
        self._additional_contact = None
        self._additional_contact_number = None
        self._additional_contact_email = None
        self._hs2_consultation_requested_response_date = None
        self._hs2_highway_emails = None
        self._emergency_contact_name = None
        self._emergency_contact_number = None
        self._permit_alteration_reason = None
        self.discriminator = None
        if internal_user_identifier is not None:
            self.internal_user_identifier = internal_user_identifier
        if internal_user_name is not None:
            self.internal_user_name = internal_user_name
        self.secondary_contact = secondary_contact
        self.secondary_contact_number = secondary_contact_number
        if secondary_contact_email is not None:
            self.secondary_contact_email = secondary_contact_email
        self.proposed_start_date = proposed_start_date
        if proposed_start_time is not None:
            self.proposed_start_time = proposed_start_time
        self.proposed_end_date = proposed_end_date
        if proposed_end_time is not None:
            self.proposed_end_time = proposed_end_time
        self.description_of_work = description_of_work
        self.excavation = excavation
        if project_reference_number is not None:
            self.project_reference_number = project_reference_number
        self.traffic_management_plan = traffic_management_plan
        self.lane_rental_applicable = lane_rental_applicable
        if permit_conditions is not None:
            self.permit_conditions = permit_conditions
        self.works_location_description = works_location_description
        if works_coordinates is not None:
            self.works_coordinates = works_coordinates
        self.collaborative_working = collaborative_working
        if collaboration_details is not None:
            self.collaboration_details = collaboration_details
        if collaborative_works is not None:
            self.collaborative_works = collaborative_works
        self.activity_type = activity_type
        self.traffic_management_type = traffic_management_type
        self.application_type = application_type
        if collaboration_type is not None:
            self.collaboration_type = collaboration_type
        self.location_types = location_types
        if early_start_pre_approval is not None:
            self.early_start_pre_approval = early_start_pre_approval
        if pre_approval_details is not None:
            self.pre_approval_details = pre_approval_details
        if pre_approval_authoriser is not None:
            self.pre_approval_authoriser = pre_approval_authoriser
        if early_start_reason is not None:
            self.early_start_reason = early_start_reason
        self.work_type = work_type
        if is_ttro_required is not None:
            self.is_ttro_required = is_ttro_required
        if immediate_risk is not None:
            self.immediate_risk = immediate_risk
        if file_ids is not None:
            self.file_ids = file_ids
        if additional_info is not None:
            self.additional_info = additional_info
        self.close_footway = close_footway
        self.close_footpath = close_footpath
        if permit_asds is not None:
            self.permit_asds = permit_asds
        if additional_contact is not None:
            self.additional_contact = additional_contact
        if additional_contact_number is not None:
            self.additional_contact_number = additional_contact_number
        if additional_contact_email is not None:
            self.additional_contact_email = additional_contact_email
        if hs2_consultation_requested_response_date is not None:
            self.hs2_consultation_requested_response_date = hs2_consultation_requested_response_date
        if hs2_highway_emails is not None:
            self.hs2_highway_emails = hs2_highway_emails
        if emergency_contact_name is not None:
            self.emergency_contact_name = emergency_contact_name
        if emergency_contact_number is not None:
            self.emergency_contact_number = emergency_contact_number
        self.permit_alteration_reason = permit_alteration_reason

    @property
    def internal_user_identifier(self):
        """Gets the internal_user_identifier of this PermitAlterationCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The internal_user_identifier of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._internal_user_identifier

    @internal_user_identifier.setter
    def internal_user_identifier(self, internal_user_identifier):
        """Sets the internal_user_identifier of this PermitAlterationCreateRequest.

        Max length 100 characters  # noqa: E501

        :param internal_user_identifier: The internal_user_identifier of this PermitAlterationCreateRequest.  # noqa: E501
        :type: str
        """

        self._internal_user_identifier = internal_user_identifier

    @property
    def internal_user_name(self):
        """Gets the internal_user_name of this PermitAlterationCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The internal_user_name of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._internal_user_name

    @internal_user_name.setter
    def internal_user_name(self, internal_user_name):
        """Sets the internal_user_name of this PermitAlterationCreateRequest.

        Max length 100 characters  # noqa: E501

        :param internal_user_name: The internal_user_name of this PermitAlterationCreateRequest.  # noqa: E501
        :type: str
        """

        self._internal_user_name = internal_user_name

    @property
    def secondary_contact(self):
        """Gets the secondary_contact of this PermitAlterationCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The secondary_contact of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._secondary_contact

    @secondary_contact.setter
    def secondary_contact(self, secondary_contact):
        """Sets the secondary_contact of this PermitAlterationCreateRequest.

        Max length 100 characters  # noqa: E501

        :param secondary_contact: The secondary_contact of this PermitAlterationCreateRequest.  # noqa: E501
        :type: str
        """
        if secondary_contact is None:
            raise ValueError("Invalid value for `secondary_contact`, must not be `None`")  # noqa: E501

        self._secondary_contact = secondary_contact

    @property
    def secondary_contact_number(self):
        """Gets the secondary_contact_number of this PermitAlterationCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The secondary_contact_number of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._secondary_contact_number

    @secondary_contact_number.setter
    def secondary_contact_number(self, secondary_contact_number):
        """Sets the secondary_contact_number of this PermitAlterationCreateRequest.

        Max length 100 characters  # noqa: E501

        :param secondary_contact_number: The secondary_contact_number of this PermitAlterationCreateRequest.  # noqa: E501
        :type: str
        """
        if secondary_contact_number is None:
            raise ValueError("Invalid value for `secondary_contact_number`, must not be `None`")  # noqa: E501

        self._secondary_contact_number = secondary_contact_number

    @property
    def secondary_contact_email(self):
        """Gets the secondary_contact_email of this PermitAlterationCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The secondary_contact_email of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._secondary_contact_email

    @secondary_contact_email.setter
    def secondary_contact_email(self, secondary_contact_email):
        """Sets the secondary_contact_email of this PermitAlterationCreateRequest.

        Max length 100 characters  # noqa: E501

        :param secondary_contact_email: The secondary_contact_email of this PermitAlterationCreateRequest.  # noqa: E501
        :type: str
        """

        self._secondary_contact_email = secondary_contact_email

    @property
    def proposed_start_date(self):
        """Gets the proposed_start_date of this PermitAlterationCreateRequest.  # noqa: E501


        :return: The proposed_start_date of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._proposed_start_date

    @proposed_start_date.setter
    def proposed_start_date(self, proposed_start_date):
        """Sets the proposed_start_date of this PermitAlterationCreateRequest.


        :param proposed_start_date: The proposed_start_date of this PermitAlterationCreateRequest.  # noqa: E501
        :type: datetime
        """
        if proposed_start_date is None:
            raise ValueError("Invalid value for `proposed_start_date`, must not be `None`")  # noqa: E501

        self._proposed_start_date = proposed_start_date

    @property
    def proposed_start_time(self):
        """Gets the proposed_start_time of this PermitAlterationCreateRequest.  # noqa: E501

        Required if work_type is immediate proposed_start_time is required if proposed_start_date is in the past  # noqa: E501

        :return: The proposed_start_time of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._proposed_start_time

    @proposed_start_time.setter
    def proposed_start_time(self, proposed_start_time):
        """Sets the proposed_start_time of this PermitAlterationCreateRequest.

        Required if work_type is immediate proposed_start_time is required if proposed_start_date is in the past  # noqa: E501

        :param proposed_start_time: The proposed_start_time of this PermitAlterationCreateRequest.  # noqa: E501
        :type: datetime
        """

        self._proposed_start_time = proposed_start_time

    @property
    def proposed_end_date(self):
        """Gets the proposed_end_date of this PermitAlterationCreateRequest.  # noqa: E501

        proposed_end_date must be on or after proposed_start_date If work_type = planned, the maximum date range between proposed_start_date and proposed_end_date is 5 years  # noqa: E501

        :return: The proposed_end_date of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._proposed_end_date

    @proposed_end_date.setter
    def proposed_end_date(self, proposed_end_date):
        """Sets the proposed_end_date of this PermitAlterationCreateRequest.

        proposed_end_date must be on or after proposed_start_date If work_type = planned, the maximum date range between proposed_start_date and proposed_end_date is 5 years  # noqa: E501

        :param proposed_end_date: The proposed_end_date of this PermitAlterationCreateRequest.  # noqa: E501
        :type: datetime
        """
        if proposed_end_date is None:
            raise ValueError("Invalid value for `proposed_end_date`, must not be `None`")  # noqa: E501

        self._proposed_end_date = proposed_end_date

    @property
    def proposed_end_time(self):
        """Gets the proposed_end_time of this PermitAlterationCreateRequest.  # noqa: E501

        proposed_end_time is required if proposed_end_date is in the past proposed_end_time must be after the date and time for proposed_start_time  # noqa: E501

        :return: The proposed_end_time of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._proposed_end_time

    @proposed_end_time.setter
    def proposed_end_time(self, proposed_end_time):
        """Sets the proposed_end_time of this PermitAlterationCreateRequest.

        proposed_end_time is required if proposed_end_date is in the past proposed_end_time must be after the date and time for proposed_start_time  # noqa: E501

        :param proposed_end_time: The proposed_end_time of this PermitAlterationCreateRequest.  # noqa: E501
        :type: datetime
        """

        self._proposed_end_time = proposed_end_time

    @property
    def description_of_work(self):
        """Gets the description_of_work of this PermitAlterationCreateRequest.  # noqa: E501

        Max length 500 characters  # noqa: E501

        :return: The description_of_work of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._description_of_work

    @description_of_work.setter
    def description_of_work(self, description_of_work):
        """Sets the description_of_work of this PermitAlterationCreateRequest.

        Max length 500 characters  # noqa: E501

        :param description_of_work: The description_of_work of this PermitAlterationCreateRequest.  # noqa: E501
        :type: str
        """
        if description_of_work is None:
            raise ValueError("Invalid value for `description_of_work`, must not be `None`")  # noqa: E501

        self._description_of_work = description_of_work

    @property
    def excavation(self):
        """Gets the excavation of this PermitAlterationCreateRequest.  # noqa: E501

        Whether an excavation will be required  # noqa: E501

        :return: The excavation of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._excavation

    @excavation.setter
    def excavation(self, excavation):
        """Sets the excavation of this PermitAlterationCreateRequest.

        Whether an excavation will be required  # noqa: E501

        :param excavation: The excavation of this PermitAlterationCreateRequest.  # noqa: E501
        :type: bool
        """
        if excavation is None:
            raise ValueError("Invalid value for `excavation`, must not be `None`")  # noqa: E501

        self._excavation = excavation

    @property
    def project_reference_number(self):
        """Gets the project_reference_number of this PermitAlterationCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The project_reference_number of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._project_reference_number

    @project_reference_number.setter
    def project_reference_number(self, project_reference_number):
        """Sets the project_reference_number of this PermitAlterationCreateRequest.

        Max length 100 characters  # noqa: E501

        :param project_reference_number: The project_reference_number of this PermitAlterationCreateRequest.  # noqa: E501
        :type: str
        """

        self._project_reference_number = project_reference_number

    @property
    def traffic_management_plan(self):
        """Gets the traffic_management_plan of this PermitAlterationCreateRequest.  # noqa: E501


        :return: The traffic_management_plan of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._traffic_management_plan

    @traffic_management_plan.setter
    def traffic_management_plan(self, traffic_management_plan):
        """Sets the traffic_management_plan of this PermitAlterationCreateRequest.


        :param traffic_management_plan: The traffic_management_plan of this PermitAlterationCreateRequest.  # noqa: E501
        :type: bool
        """
        if traffic_management_plan is None:
            raise ValueError("Invalid value for `traffic_management_plan`, must not be `None`")  # noqa: E501

        self._traffic_management_plan = traffic_management_plan

    @property
    def lane_rental_applicable(self):
        """Gets the lane_rental_applicable of this PermitAlterationCreateRequest.  # noqa: E501


        :return: The lane_rental_applicable of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._lane_rental_applicable

    @lane_rental_applicable.setter
    def lane_rental_applicable(self, lane_rental_applicable):
        """Sets the lane_rental_applicable of this PermitAlterationCreateRequest.


        :param lane_rental_applicable: The lane_rental_applicable of this PermitAlterationCreateRequest.  # noqa: E501
        :type: bool
        """
        if lane_rental_applicable is None:
            raise ValueError("Invalid value for `lane_rental_applicable`, must not be `None`")  # noqa: E501

        self._lane_rental_applicable = lane_rental_applicable

    @property
    def permit_conditions(self):
        """Gets the permit_conditions of this PermitAlterationCreateRequest.  # noqa: E501

        Array values must be unique  # noqa: E501

        :return: The permit_conditions of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: list[PermitCondition]
        """
        return self._permit_conditions

    @permit_conditions.setter
    def permit_conditions(self, permit_conditions):
        """Sets the permit_conditions of this PermitAlterationCreateRequest.

        Array values must be unique  # noqa: E501

        :param permit_conditions: The permit_conditions of this PermitAlterationCreateRequest.  # noqa: E501
        :type: list[PermitCondition]
        """

        self._permit_conditions = permit_conditions

    @property
    def works_location_description(self):
        """Gets the works_location_description of this PermitAlterationCreateRequest.  # noqa: E501

        Max length 500 characters  # noqa: E501

        :return: The works_location_description of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._works_location_description

    @works_location_description.setter
    def works_location_description(self, works_location_description):
        """Sets the works_location_description of this PermitAlterationCreateRequest.

        Max length 500 characters  # noqa: E501

        :param works_location_description: The works_location_description of this PermitAlterationCreateRequest.  # noqa: E501
        :type: str
        """
        if works_location_description is None:
            raise ValueError("Invalid value for `works_location_description`, must not be `None`")  # noqa: E501

        self._works_location_description = works_location_description

    @property
    def works_coordinates(self):
        """Gets the works_coordinates of this PermitAlterationCreateRequest.  # noqa: E501

        Must be a GeoJSON geometry (using British National Grid easting and northing coordinate pairs) and must be a point, line string or polygon  # noqa: E501

        :return: The works_coordinates of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: object
        """
        return self._works_coordinates

    @works_coordinates.setter
    def works_coordinates(self, works_coordinates):
        """Sets the works_coordinates of this PermitAlterationCreateRequest.

        Must be a GeoJSON geometry (using British National Grid easting and northing coordinate pairs) and must be a point, line string or polygon  # noqa: E501

        :param works_coordinates: The works_coordinates of this PermitAlterationCreateRequest.  # noqa: E501
        :type: object
        """

        self._works_coordinates = works_coordinates

    @property
    def collaborative_working(self):
        """Gets the collaborative_working of this PermitAlterationCreateRequest.  # noqa: E501


        :return: The collaborative_working of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._collaborative_working

    @collaborative_working.setter
    def collaborative_working(self, collaborative_working):
        """Sets the collaborative_working of this PermitAlterationCreateRequest.


        :param collaborative_working: The collaborative_working of this PermitAlterationCreateRequest.  # noqa: E501
        :type: bool
        """
        if collaborative_working is None:
            raise ValueError("Invalid value for `collaborative_working`, must not be `None`")  # noqa: E501

        self._collaborative_working = collaborative_working

    @property
    def collaboration_details(self):
        """Gets the collaboration_details of this PermitAlterationCreateRequest.  # noqa: E501

        Required if collaborative_working = true Max length 500 characters  # noqa: E501

        :return: The collaboration_details of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._collaboration_details

    @collaboration_details.setter
    def collaboration_details(self, collaboration_details):
        """Sets the collaboration_details of this PermitAlterationCreateRequest.

        Required if collaborative_working = true Max length 500 characters  # noqa: E501

        :param collaboration_details: The collaboration_details of this PermitAlterationCreateRequest.  # noqa: E501
        :type: str
        """

        self._collaboration_details = collaboration_details

    @property
    def collaborative_works(self):
        """Gets the collaborative_works of this PermitAlterationCreateRequest.  # noqa: E501

        Optional but only saved if collaborative_working = true Max length 500 characters Work Reference Number of collaborative works  # noqa: E501

        :return: The collaborative_works of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._collaborative_works

    @collaborative_works.setter
    def collaborative_works(self, collaborative_works):
        """Sets the collaborative_works of this PermitAlterationCreateRequest.

        Optional but only saved if collaborative_working = true Max length 500 characters Work Reference Number of collaborative works  # noqa: E501

        :param collaborative_works: The collaborative_works of this PermitAlterationCreateRequest.  # noqa: E501
        :type: str
        """

        self._collaborative_works = collaborative_works

    @property
    def activity_type(self):
        """Gets the activity_type of this PermitAlterationCreateRequest.  # noqa: E501


        :return: The activity_type of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: ActivityType
        """
        return self._activity_type

    @activity_type.setter
    def activity_type(self, activity_type):
        """Sets the activity_type of this PermitAlterationCreateRequest.


        :param activity_type: The activity_type of this PermitAlterationCreateRequest.  # noqa: E501
        :type: ActivityType
        """
        if activity_type is None:
            raise ValueError("Invalid value for `activity_type`, must not be `None`")  # noqa: E501

        self._activity_type = activity_type

    @property
    def traffic_management_type(self):
        """Gets the traffic_management_type of this PermitAlterationCreateRequest.  # noqa: E501


        :return: The traffic_management_type of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: TrafficManagementType
        """
        return self._traffic_management_type

    @traffic_management_type.setter
    def traffic_management_type(self, traffic_management_type):
        """Sets the traffic_management_type of this PermitAlterationCreateRequest.


        :param traffic_management_type: The traffic_management_type of this PermitAlterationCreateRequest.  # noqa: E501
        :type: TrafficManagementType
        """
        if traffic_management_type is None:
            raise ValueError("Invalid value for `traffic_management_type`, must not be `None`")  # noqa: E501

        self._traffic_management_type = traffic_management_type

    @property
    def application_type(self):
        """Gets the application_type of this PermitAlterationCreateRequest.  # noqa: E501


        :return: The application_type of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: ApplicationType
        """
        return self._application_type

    @application_type.setter
    def application_type(self, application_type):
        """Sets the application_type of this PermitAlterationCreateRequest.


        :param application_type: The application_type of this PermitAlterationCreateRequest.  # noqa: E501
        :type: ApplicationType
        """
        if application_type is None:
            raise ValueError("Invalid value for `application_type`, must not be `None`")  # noqa: E501

        self._application_type = application_type

    @property
    def collaboration_type(self):
        """Gets the collaboration_type of this PermitAlterationCreateRequest.  # noqa: E501

        Required if collaborative_working = true  # noqa: E501

        :return: The collaboration_type of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: AllOfPermitAlterationCreateRequestCollaborationType
        """
        return self._collaboration_type

    @collaboration_type.setter
    def collaboration_type(self, collaboration_type):
        """Sets the collaboration_type of this PermitAlterationCreateRequest.

        Required if collaborative_working = true  # noqa: E501

        :param collaboration_type: The collaboration_type of this PermitAlterationCreateRequest.  # noqa: E501
        :type: AllOfPermitAlterationCreateRequestCollaborationType
        """

        self._collaboration_type = collaboration_type

    @property
    def location_types(self):
        """Gets the location_types of this PermitAlterationCreateRequest.  # noqa: E501

        Array values must be unique  # noqa: E501

        :return: The location_types of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: list[LocationType]
        """
        return self._location_types

    @location_types.setter
    def location_types(self, location_types):
        """Sets the location_types of this PermitAlterationCreateRequest.

        Array values must be unique  # noqa: E501

        :param location_types: The location_types of this PermitAlterationCreateRequest.  # noqa: E501
        :type: list[LocationType]
        """
        if location_types is None:
            raise ValueError("Invalid value for `location_types`, must not be `None`")  # noqa: E501

        self._location_types = location_types

    @property
    def early_start_pre_approval(self):
        """Gets the early_start_pre_approval of this PermitAlterationCreateRequest.  # noqa: E501

        See business rules section 3.4.6 - Early start  # noqa: E501

        :return: The early_start_pre_approval of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._early_start_pre_approval

    @early_start_pre_approval.setter
    def early_start_pre_approval(self, early_start_pre_approval):
        """Sets the early_start_pre_approval of this PermitAlterationCreateRequest.

        See business rules section 3.4.6 - Early start  # noqa: E501

        :param early_start_pre_approval: The early_start_pre_approval of this PermitAlterationCreateRequest.  # noqa: E501
        :type: bool
        """

        self._early_start_pre_approval = early_start_pre_approval

    @property
    def pre_approval_details(self):
        """Gets the pre_approval_details of this PermitAlterationCreateRequest.  # noqa: E501

        Required if early_start_pre_approval = true Max length 500 characters  # noqa: E501

        :return: The pre_approval_details of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._pre_approval_details

    @pre_approval_details.setter
    def pre_approval_details(self, pre_approval_details):
        """Sets the pre_approval_details of this PermitAlterationCreateRequest.

        Required if early_start_pre_approval = true Max length 500 characters  # noqa: E501

        :param pre_approval_details: The pre_approval_details of this PermitAlterationCreateRequest.  # noqa: E501
        :type: str
        """

        self._pre_approval_details = pre_approval_details

    @property
    def pre_approval_authoriser(self):
        """Gets the pre_approval_authoriser of this PermitAlterationCreateRequest.  # noqa: E501

        Required if early_start_pre_approval = true Max length 100 characters  # noqa: E501

        :return: The pre_approval_authoriser of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._pre_approval_authoriser

    @pre_approval_authoriser.setter
    def pre_approval_authoriser(self, pre_approval_authoriser):
        """Sets the pre_approval_authoriser of this PermitAlterationCreateRequest.

        Required if early_start_pre_approval = true Max length 100 characters  # noqa: E501

        :param pre_approval_authoriser: The pre_approval_authoriser of this PermitAlterationCreateRequest.  # noqa: E501
        :type: str
        """

        self._pre_approval_authoriser = pre_approval_authoriser

    @property
    def early_start_reason(self):
        """Gets the early_start_reason of this PermitAlterationCreateRequest.  # noqa: E501

        Required if early_start_pre_approval = false Max length 500 characters  # noqa: E501

        :return: The early_start_reason of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._early_start_reason

    @early_start_reason.setter
    def early_start_reason(self, early_start_reason):
        """Sets the early_start_reason of this PermitAlterationCreateRequest.

        Required if early_start_pre_approval = false Max length 500 characters  # noqa: E501

        :param early_start_reason: The early_start_reason of this PermitAlterationCreateRequest.  # noqa: E501
        :type: str
        """

        self._early_start_reason = early_start_reason

    @property
    def work_type(self):
        """Gets the work_type of this PermitAlterationCreateRequest.  # noqa: E501


        :return: The work_type of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: WorkType
        """
        return self._work_type

    @work_type.setter
    def work_type(self, work_type):
        """Sets the work_type of this PermitAlterationCreateRequest.


        :param work_type: The work_type of this PermitAlterationCreateRequest.  # noqa: E501
        :type: WorkType
        """
        if work_type is None:
            raise ValueError("Invalid value for `work_type`, must not be `None`")  # noqa: E501

        self._work_type = work_type

    @property
    def is_ttro_required(self):
        """Gets the is_ttro_required of this PermitAlterationCreateRequest.  # noqa: E501

        Required when work_type is planned  # noqa: E501

        :return: The is_ttro_required of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._is_ttro_required

    @is_ttro_required.setter
    def is_ttro_required(self, is_ttro_required):
        """Sets the is_ttro_required of this PermitAlterationCreateRequest.

        Required when work_type is planned  # noqa: E501

        :param is_ttro_required: The is_ttro_required of this PermitAlterationCreateRequest.  # noqa: E501
        :type: bool
        """

        self._is_ttro_required = is_ttro_required

    @property
    def immediate_risk(self):
        """Gets the immediate_risk of this PermitAlterationCreateRequest.  # noqa: E501

        Required when work_type is immediate  # noqa: E501

        :return: The immediate_risk of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._immediate_risk

    @immediate_risk.setter
    def immediate_risk(self, immediate_risk):
        """Sets the immediate_risk of this PermitAlterationCreateRequest.

        Required when work_type is immediate  # noqa: E501

        :param immediate_risk: The immediate_risk of this PermitAlterationCreateRequest.  # noqa: E501
        :type: bool
        """

        self._immediate_risk = immediate_risk

    @property
    def file_ids(self):
        """Gets the file_ids of this PermitAlterationCreateRequest.  # noqa: E501

        Array values must be unique Must not contain null or undefined values A file_id can only be associated with one section of Street Manager See API specification Resource Guide > Works API > File upload for more information  # noqa: E501

        :return: The file_ids of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: list[float]
        """
        return self._file_ids

    @file_ids.setter
    def file_ids(self, file_ids):
        """Sets the file_ids of this PermitAlterationCreateRequest.

        Array values must be unique Must not contain null or undefined values A file_id can only be associated with one section of Street Manager See API specification Resource Guide > Works API > File upload for more information  # noqa: E501

        :param file_ids: The file_ids of this PermitAlterationCreateRequest.  # noqa: E501
        :type: list[float]
        """

        self._file_ids = file_ids

    @property
    def additional_info(self):
        """Gets the additional_info of this PermitAlterationCreateRequest.  # noqa: E501

        Max length 500 characters  # noqa: E501

        :return: The additional_info of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._additional_info

    @additional_info.setter
    def additional_info(self, additional_info):
        """Sets the additional_info of this PermitAlterationCreateRequest.

        Max length 500 characters  # noqa: E501

        :param additional_info: The additional_info of this PermitAlterationCreateRequest.  # noqa: E501
        :type: str
        """

        self._additional_info = additional_info

    @property
    def close_footway(self):
        """Gets the close_footway of this PermitAlterationCreateRequest.  # noqa: E501


        :return: The close_footway of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: CloseFootway
        """
        return self._close_footway

    @close_footway.setter
    def close_footway(self, close_footway):
        """Sets the close_footway of this PermitAlterationCreateRequest.


        :param close_footway: The close_footway of this PermitAlterationCreateRequest.  # noqa: E501
        :type: CloseFootway
        """
        if close_footway is None:
            raise ValueError("Invalid value for `close_footway`, must not be `None`")  # noqa: E501

        self._close_footway = close_footway

    @property
    def close_footpath(self):
        """Gets the close_footpath of this PermitAlterationCreateRequest.  # noqa: E501


        :return: The close_footpath of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: CloseFootpath
        """
        return self._close_footpath

    @close_footpath.setter
    def close_footpath(self, close_footpath):
        """Sets the close_footpath of this PermitAlterationCreateRequest.


        :param close_footpath: The close_footpath of this PermitAlterationCreateRequest.  # noqa: E501
        :type: CloseFootpath
        """
        if close_footpath is None:
            raise ValueError("Invalid value for `close_footpath`, must not be `None`")  # noqa: E501

        self._close_footpath = close_footpath

    @property
    def permit_asds(self):
        """Gets the permit_asds of this PermitAlterationCreateRequest.  # noqa: E501


        :return: The permit_asds of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: list[PermitASD]
        """
        return self._permit_asds

    @permit_asds.setter
    def permit_asds(self, permit_asds):
        """Sets the permit_asds of this PermitAlterationCreateRequest.


        :param permit_asds: The permit_asds of this PermitAlterationCreateRequest.  # noqa: E501
        :type: list[PermitASD]
        """

        self._permit_asds = permit_asds

    @property
    def additional_contact(self):
        """Gets the additional_contact of this PermitAlterationCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The additional_contact of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._additional_contact

    @additional_contact.setter
    def additional_contact(self, additional_contact):
        """Sets the additional_contact of this PermitAlterationCreateRequest.

        Max length 100 characters  # noqa: E501

        :param additional_contact: The additional_contact of this PermitAlterationCreateRequest.  # noqa: E501
        :type: str
        """

        self._additional_contact = additional_contact

    @property
    def additional_contact_number(self):
        """Gets the additional_contact_number of this PermitAlterationCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The additional_contact_number of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._additional_contact_number

    @additional_contact_number.setter
    def additional_contact_number(self, additional_contact_number):
        """Sets the additional_contact_number of this PermitAlterationCreateRequest.

        Max length 100 characters  # noqa: E501

        :param additional_contact_number: The additional_contact_number of this PermitAlterationCreateRequest.  # noqa: E501
        :type: str
        """

        self._additional_contact_number = additional_contact_number

    @property
    def additional_contact_email(self):
        """Gets the additional_contact_email of this PermitAlterationCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The additional_contact_email of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._additional_contact_email

    @additional_contact_email.setter
    def additional_contact_email(self, additional_contact_email):
        """Sets the additional_contact_email of this PermitAlterationCreateRequest.

        Max length 100 characters  # noqa: E501

        :param additional_contact_email: The additional_contact_email of this PermitAlterationCreateRequest.  # noqa: E501
        :type: str
        """

        self._additional_contact_email = additional_contact_email

    @property
    def hs2_consultation_requested_response_date(self):
        """Gets the hs2_consultation_requested_response_date of this PermitAlterationCreateRequest.  # noqa: E501

        Date must occur today or a date in the future  # noqa: E501

        :return: The hs2_consultation_requested_response_date of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._hs2_consultation_requested_response_date

    @hs2_consultation_requested_response_date.setter
    def hs2_consultation_requested_response_date(self, hs2_consultation_requested_response_date):
        """Sets the hs2_consultation_requested_response_date of this PermitAlterationCreateRequest.

        Date must occur today or a date in the future  # noqa: E501

        :param hs2_consultation_requested_response_date: The hs2_consultation_requested_response_date of this PermitAlterationCreateRequest.  # noqa: E501
        :type: datetime
        """

        self._hs2_consultation_requested_response_date = hs2_consultation_requested_response_date

    @property
    def hs2_highway_emails(self):
        """Gets the hs2_highway_emails of this PermitAlterationCreateRequest.  # noqa: E501

        Array Max length 2 items Array values must be valid email addresses Array values max length 100 characters  # noqa: E501

        :return: The hs2_highway_emails of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._hs2_highway_emails

    @hs2_highway_emails.setter
    def hs2_highway_emails(self, hs2_highway_emails):
        """Sets the hs2_highway_emails of this PermitAlterationCreateRequest.

        Array Max length 2 items Array values must be valid email addresses Array values max length 100 characters  # noqa: E501

        :param hs2_highway_emails: The hs2_highway_emails of this PermitAlterationCreateRequest.  # noqa: E501
        :type: list[str]
        """

        self._hs2_highway_emails = hs2_highway_emails

    @property
    def emergency_contact_name(self):
        """Gets the emergency_contact_name of this PermitAlterationCreateRequest.  # noqa: E501

        Max length 100 characters Required if traffic_management_type = 'multi_way_signals' or 'two_way_signals'  # noqa: E501

        :return: The emergency_contact_name of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._emergency_contact_name

    @emergency_contact_name.setter
    def emergency_contact_name(self, emergency_contact_name):
        """Sets the emergency_contact_name of this PermitAlterationCreateRequest.

        Max length 100 characters Required if traffic_management_type = 'multi_way_signals' or 'two_way_signals'  # noqa: E501

        :param emergency_contact_name: The emergency_contact_name of this PermitAlterationCreateRequest.  # noqa: E501
        :type: str
        """

        self._emergency_contact_name = emergency_contact_name

    @property
    def emergency_contact_number(self):
        """Gets the emergency_contact_number of this PermitAlterationCreateRequest.  # noqa: E501

        Max length 100 characters Required if traffic_management_type = 'multi_way_signals' or 'two_way_signals'  # noqa: E501

        :return: The emergency_contact_number of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._emergency_contact_number

    @emergency_contact_number.setter
    def emergency_contact_number(self, emergency_contact_number):
        """Sets the emergency_contact_number of this PermitAlterationCreateRequest.

        Max length 100 characters Required if traffic_management_type = 'multi_way_signals' or 'two_way_signals'  # noqa: E501

        :param emergency_contact_number: The emergency_contact_number of this PermitAlterationCreateRequest.  # noqa: E501
        :type: str
        """

        self._emergency_contact_number = emergency_contact_number

    @property
    def permit_alteration_reason(self):
        """Gets the permit_alteration_reason of this PermitAlterationCreateRequest.  # noqa: E501

        Max length 500 characters  # noqa: E501

        :return: The permit_alteration_reason of this PermitAlterationCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._permit_alteration_reason

    @permit_alteration_reason.setter
    def permit_alteration_reason(self, permit_alteration_reason):
        """Sets the permit_alteration_reason of this PermitAlterationCreateRequest.

        Max length 500 characters  # noqa: E501

        :param permit_alteration_reason: The permit_alteration_reason of this PermitAlterationCreateRequest.  # noqa: E501
        :type: str
        """
        if permit_alteration_reason is None:
            raise ValueError("Invalid value for `permit_alteration_reason`, must not be `None`")  # noqa: E501

        self._permit_alteration_reason = permit_alteration_reason

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PermitAlterationCreateRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PermitAlterationCreateRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
