# coding: utf-8

"""
    Street Manager API

    See API specification Resource Guide > Work API for more information on endpoints NOTE: Swagger Editor/UI does not display all description text for enumerations and child elements, check swagger.json for full description text  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class WorkCreateRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'internal_user_identifier': 'str',
        'internal_user_name': 'str',
        'promoter_swa_code': 'str',
        'highway_authority_swa_code': 'str',
        'works_coordinates': 'object',
        'street_name': 'str',
        'town': 'str',
        'area_name': 'str',
        'usrn': 'float',
        'road_category': 'float',
        'work_reference_number': 'str',
        'secondary_contact': 'str',
        'secondary_contact_number': 'str',
        'secondary_contact_email': 'str',
        'proposed_start_date': 'datetime',
        'proposed_start_time': 'datetime',
        'proposed_end_date': 'datetime',
        'proposed_end_time': 'datetime',
        'description_of_work': 'str',
        'excavation': 'bool',
        'project_reference_number': 'str',
        'traffic_management_plan': 'bool',
        'lane_rental_applicable': 'bool',
        'permit_conditions': 'list[PermitCondition]',
        'collaborative_working': 'bool',
        'collaboration_details': 'str',
        'collaborative_works': 'str',
        'activity_type': 'ActivityType',
        'traffic_management_type': 'TrafficManagementType',
        'application_type': 'ApplicationType',
        'collaboration_type': 'AllOfWorkCreateRequestCollaborationType',
        'location_types': 'list[LocationType]',
        'file_ids': 'list[float]',
        'permit_asds': 'list[PermitASD]',
        'work_type': 'WorkType',
        'is_ttro_required': 'bool',
        'immediate_risk': 'bool',
        'early_start_pre_approval': 'bool',
        'pre_approval_details': 'str',
        'pre_approval_authoriser': 'str',
        'early_start_reason': 'str',
        'additional_info': 'str',
        'close_footway': 'CloseFootway',
        'close_footpath': 'CloseFootpath',
        'works_location_description': 'str',
        'workstream_prefix': 'str',
        'hs2_in_act_limits': 'bool',
        'hs2_consultation_requested_response_date': 'datetime',
        'hs2_highway_exemption': 'AllOfWorkCreateRequestHs2HighwayExemption',
        'hs2_highway_emails': 'list[str]',
        'additional_contact': 'str',
        'additional_contact_number': 'str',
        'additional_contact_email': 'str',
        'hs2_additional_usrns': 'list[float]',
        'emergency_contact_name': 'str',
        'emergency_contact_number': 'str'
    }

    attribute_map = {
        'internal_user_identifier': 'internal_user_identifier',
        'internal_user_name': 'internal_user_name',
        'promoter_swa_code': 'promoter_swa_code',
        'highway_authority_swa_code': 'highway_authority_swa_code',
        'works_coordinates': 'works_coordinates',
        'street_name': 'street_name',
        'town': 'town',
        'area_name': 'area_name',
        'usrn': 'usrn',
        'road_category': 'road_category',
        'work_reference_number': 'work_reference_number',
        'secondary_contact': 'secondary_contact',
        'secondary_contact_number': 'secondary_contact_number',
        'secondary_contact_email': 'secondary_contact_email',
        'proposed_start_date': 'proposed_start_date',
        'proposed_start_time': 'proposed_start_time',
        'proposed_end_date': 'proposed_end_date',
        'proposed_end_time': 'proposed_end_time',
        'description_of_work': 'description_of_work',
        'excavation': 'excavation',
        'project_reference_number': 'project_reference_number',
        'traffic_management_plan': 'traffic_management_plan',
        'lane_rental_applicable': 'lane_rental_applicable',
        'permit_conditions': 'permit_conditions',
        'collaborative_working': 'collaborative_working',
        'collaboration_details': 'collaboration_details',
        'collaborative_works': 'collaborative_works',
        'activity_type': 'activity_type',
        'traffic_management_type': 'traffic_management_type',
        'application_type': 'application_type',
        'collaboration_type': 'collaboration_type',
        'location_types': 'location_types',
        'file_ids': 'file_ids',
        'permit_asds': 'permit_asds',
        'work_type': 'work_type',
        'is_ttro_required': 'is_ttro_required',
        'immediate_risk': 'immediate_risk',
        'early_start_pre_approval': 'early_start_pre_approval',
        'pre_approval_details': 'pre_approval_details',
        'pre_approval_authoriser': 'pre_approval_authoriser',
        'early_start_reason': 'early_start_reason',
        'additional_info': 'additional_info',
        'close_footway': 'close_footway',
        'close_footpath': 'close_footpath',
        'works_location_description': 'works_location_description',
        'workstream_prefix': 'workstream_prefix',
        'hs2_in_act_limits': 'hs2_in_act_limits',
        'hs2_consultation_requested_response_date': 'hs2_consultation_requested_response_date',
        'hs2_highway_exemption': 'hs2_highway_exemption',
        'hs2_highway_emails': 'hs2_highway_emails',
        'additional_contact': 'additional_contact',
        'additional_contact_number': 'additional_contact_number',
        'additional_contact_email': 'additional_contact_email',
        'hs2_additional_usrns': 'hs2_additional_usrns',
        'emergency_contact_name': 'emergency_contact_name',
        'emergency_contact_number': 'emergency_contact_number'
    }

    def __init__(self, internal_user_identifier=None, internal_user_name=None, promoter_swa_code=None, highway_authority_swa_code=None, works_coordinates=None, street_name=None, town=None, area_name=None, usrn=None, road_category=None, work_reference_number=None, secondary_contact=None, secondary_contact_number=None, secondary_contact_email=None, proposed_start_date=None, proposed_start_time=None, proposed_end_date=None, proposed_end_time=None, description_of_work=None, excavation=None, project_reference_number=None, traffic_management_plan=None, lane_rental_applicable=None, permit_conditions=None, collaborative_working=None, collaboration_details=None, collaborative_works=None, activity_type=None, traffic_management_type=None, application_type=None, collaboration_type=None, location_types=None, file_ids=None, permit_asds=None, work_type=None, is_ttro_required=None, immediate_risk=None, early_start_pre_approval=None, pre_approval_details=None, pre_approval_authoriser=None, early_start_reason=None, additional_info=None, close_footway=None, close_footpath=None, works_location_description=None, workstream_prefix=None, hs2_in_act_limits=None, hs2_consultation_requested_response_date=None, hs2_highway_exemption=None, hs2_highway_emails=None, additional_contact=None, additional_contact_number=None, additional_contact_email=None, hs2_additional_usrns=None, emergency_contact_name=None, emergency_contact_number=None):  # noqa: E501
        """WorkCreateRequest - a model defined in Swagger"""  # noqa: E501
        self._internal_user_identifier = None
        self._internal_user_name = None
        self._promoter_swa_code = None
        self._highway_authority_swa_code = None
        self._works_coordinates = None
        self._street_name = None
        self._town = None
        self._area_name = None
        self._usrn = None
        self._road_category = None
        self._work_reference_number = None
        self._secondary_contact = None
        self._secondary_contact_number = None
        self._secondary_contact_email = None
        self._proposed_start_date = None
        self._proposed_start_time = None
        self._proposed_end_date = None
        self._proposed_end_time = None
        self._description_of_work = None
        self._excavation = None
        self._project_reference_number = None
        self._traffic_management_plan = None
        self._lane_rental_applicable = None
        self._permit_conditions = None
        self._collaborative_working = None
        self._collaboration_details = None
        self._collaborative_works = None
        self._activity_type = None
        self._traffic_management_type = None
        self._application_type = None
        self._collaboration_type = None
        self._location_types = None
        self._file_ids = None
        self._permit_asds = None
        self._work_type = None
        self._is_ttro_required = None
        self._immediate_risk = None
        self._early_start_pre_approval = None
        self._pre_approval_details = None
        self._pre_approval_authoriser = None
        self._early_start_reason = None
        self._additional_info = None
        self._close_footway = None
        self._close_footpath = None
        self._works_location_description = None
        self._workstream_prefix = None
        self._hs2_in_act_limits = None
        self._hs2_consultation_requested_response_date = None
        self._hs2_highway_exemption = None
        self._hs2_highway_emails = None
        self._additional_contact = None
        self._additional_contact_number = None
        self._additional_contact_email = None
        self._hs2_additional_usrns = None
        self._emergency_contact_name = None
        self._emergency_contact_number = None
        self.discriminator = None
        if internal_user_identifier is not None:
            self.internal_user_identifier = internal_user_identifier
        if internal_user_name is not None:
            self.internal_user_name = internal_user_name
        self.promoter_swa_code = promoter_swa_code
        self.highway_authority_swa_code = highway_authority_swa_code
        self.works_coordinates = works_coordinates
        if street_name is not None:
            self.street_name = street_name
        if town is not None:
            self.town = town
        if area_name is not None:
            self.area_name = area_name
        self.usrn = usrn
        if road_category is not None:
            self.road_category = road_category
        if work_reference_number is not None:
            self.work_reference_number = work_reference_number
        self.secondary_contact = secondary_contact
        self.secondary_contact_number = secondary_contact_number
        if secondary_contact_email is not None:
            self.secondary_contact_email = secondary_contact_email
        self.proposed_start_date = proposed_start_date
        if proposed_start_time is not None:
            self.proposed_start_time = proposed_start_time
        self.proposed_end_date = proposed_end_date
        if proposed_end_time is not None:
            self.proposed_end_time = proposed_end_time
        self.description_of_work = description_of_work
        self.excavation = excavation
        if project_reference_number is not None:
            self.project_reference_number = project_reference_number
        self.traffic_management_plan = traffic_management_plan
        self.lane_rental_applicable = lane_rental_applicable
        if permit_conditions is not None:
            self.permit_conditions = permit_conditions
        self.collaborative_working = collaborative_working
        if collaboration_details is not None:
            self.collaboration_details = collaboration_details
        if collaborative_works is not None:
            self.collaborative_works = collaborative_works
        self.activity_type = activity_type
        self.traffic_management_type = traffic_management_type
        self.application_type = application_type
        if collaboration_type is not None:
            self.collaboration_type = collaboration_type
        self.location_types = location_types
        if file_ids is not None:
            self.file_ids = file_ids
        if permit_asds is not None:
            self.permit_asds = permit_asds
        self.work_type = work_type
        if is_ttro_required is not None:
            self.is_ttro_required = is_ttro_required
        if immediate_risk is not None:
            self.immediate_risk = immediate_risk
        if early_start_pre_approval is not None:
            self.early_start_pre_approval = early_start_pre_approval
        if pre_approval_details is not None:
            self.pre_approval_details = pre_approval_details
        if pre_approval_authoriser is not None:
            self.pre_approval_authoriser = pre_approval_authoriser
        if early_start_reason is not None:
            self.early_start_reason = early_start_reason
        if additional_info is not None:
            self.additional_info = additional_info
        self.close_footway = close_footway
        self.close_footpath = close_footpath
        self.works_location_description = works_location_description
        if workstream_prefix is not None:
            self.workstream_prefix = workstream_prefix
        if hs2_in_act_limits is not None:
            self.hs2_in_act_limits = hs2_in_act_limits
        if hs2_consultation_requested_response_date is not None:
            self.hs2_consultation_requested_response_date = hs2_consultation_requested_response_date
        if hs2_highway_exemption is not None:
            self.hs2_highway_exemption = hs2_highway_exemption
        if hs2_highway_emails is not None:
            self.hs2_highway_emails = hs2_highway_emails
        if additional_contact is not None:
            self.additional_contact = additional_contact
        if additional_contact_number is not None:
            self.additional_contact_number = additional_contact_number
        if additional_contact_email is not None:
            self.additional_contact_email = additional_contact_email
        if hs2_additional_usrns is not None:
            self.hs2_additional_usrns = hs2_additional_usrns
        if emergency_contact_name is not None:
            self.emergency_contact_name = emergency_contact_name
        if emergency_contact_number is not None:
            self.emergency_contact_number = emergency_contact_number

    @property
    def internal_user_identifier(self):
        """Gets the internal_user_identifier of this WorkCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The internal_user_identifier of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._internal_user_identifier

    @internal_user_identifier.setter
    def internal_user_identifier(self, internal_user_identifier):
        """Sets the internal_user_identifier of this WorkCreateRequest.

        Max length 100 characters  # noqa: E501

        :param internal_user_identifier: The internal_user_identifier of this WorkCreateRequest.  # noqa: E501
        :type: str
        """

        self._internal_user_identifier = internal_user_identifier

    @property
    def internal_user_name(self):
        """Gets the internal_user_name of this WorkCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The internal_user_name of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._internal_user_name

    @internal_user_name.setter
    def internal_user_name(self, internal_user_name):
        """Sets the internal_user_name of this WorkCreateRequest.

        Max length 100 characters  # noqa: E501

        :param internal_user_name: The internal_user_name of this WorkCreateRequest.  # noqa: E501
        :type: str
        """

        self._internal_user_name = internal_user_name

    @property
    def promoter_swa_code(self):
        """Gets the promoter_swa_code of this WorkCreateRequest.  # noqa: E501

        Max length 4 characters  # noqa: E501

        :return: The promoter_swa_code of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._promoter_swa_code

    @promoter_swa_code.setter
    def promoter_swa_code(self, promoter_swa_code):
        """Sets the promoter_swa_code of this WorkCreateRequest.

        Max length 4 characters  # noqa: E501

        :param promoter_swa_code: The promoter_swa_code of this WorkCreateRequest.  # noqa: E501
        :type: str
        """
        if promoter_swa_code is None:
            raise ValueError("Invalid value for `promoter_swa_code`, must not be `None`")  # noqa: E501

        self._promoter_swa_code = promoter_swa_code

    @property
    def highway_authority_swa_code(self):
        """Gets the highway_authority_swa_code of this WorkCreateRequest.  # noqa: E501

        Max length 4 characters  # noqa: E501

        :return: The highway_authority_swa_code of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._highway_authority_swa_code

    @highway_authority_swa_code.setter
    def highway_authority_swa_code(self, highway_authority_swa_code):
        """Sets the highway_authority_swa_code of this WorkCreateRequest.

        Max length 4 characters  # noqa: E501

        :param highway_authority_swa_code: The highway_authority_swa_code of this WorkCreateRequest.  # noqa: E501
        :type: str
        """
        if highway_authority_swa_code is None:
            raise ValueError("Invalid value for `highway_authority_swa_code`, must not be `None`")  # noqa: E501

        self._highway_authority_swa_code = highway_authority_swa_code

    @property
    def works_coordinates(self):
        """Gets the works_coordinates of this WorkCreateRequest.  # noqa: E501

        Must be a GeoJSON geometry (using British National Grid easting and northing coordinate pairs) and must be a point, line string or polygon  # noqa: E501

        :return: The works_coordinates of this WorkCreateRequest.  # noqa: E501
        :rtype: object
        """
        return self._works_coordinates

    @works_coordinates.setter
    def works_coordinates(self, works_coordinates):
        """Sets the works_coordinates of this WorkCreateRequest.

        Must be a GeoJSON geometry (using British National Grid easting and northing coordinate pairs) and must be a point, line string or polygon  # noqa: E501

        :param works_coordinates: The works_coordinates of this WorkCreateRequest.  # noqa: E501
        :type: object
        """
        if works_coordinates is None:
            raise ValueError("Invalid value for `works_coordinates`, must not be `None`")  # noqa: E501

        self._works_coordinates = works_coordinates

    @property
    def street_name(self):
        """Gets the street_name of this WorkCreateRequest.  # noqa: E501

        Max length 100 characters Use Street Lookup API endpoint /nsg/streets to lookup this information If not provided, populated with NSG data related to supplied USRN  # noqa: E501

        :return: The street_name of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._street_name

    @street_name.setter
    def street_name(self, street_name):
        """Sets the street_name of this WorkCreateRequest.

        Max length 100 characters Use Street Lookup API endpoint /nsg/streets to lookup this information If not provided, populated with NSG data related to supplied USRN  # noqa: E501

        :param street_name: The street_name of this WorkCreateRequest.  # noqa: E501
        :type: str
        """

        self._street_name = street_name

    @property
    def town(self):
        """Gets the town of this WorkCreateRequest.  # noqa: E501

        Max length 100 characters Use Street Lookup API endpoint /nsg/streets to lookup this information If not provided, populated with NSG data related to supplied USRN  # noqa: E501

        :return: The town of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._town

    @town.setter
    def town(self, town):
        """Sets the town of this WorkCreateRequest.

        Max length 100 characters Use Street Lookup API endpoint /nsg/streets to lookup this information If not provided, populated with NSG data related to supplied USRN  # noqa: E501

        :param town: The town of this WorkCreateRequest.  # noqa: E501
        :type: str
        """

        self._town = town

    @property
    def area_name(self):
        """Gets the area_name of this WorkCreateRequest.  # noqa: E501

        Max length 100 characters Use Street Lookup API endpoint /nsg/streets to lookup this information If not provided, populated with NSG data related to supplied USRN  # noqa: E501

        :return: The area_name of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._area_name

    @area_name.setter
    def area_name(self, area_name):
        """Sets the area_name of this WorkCreateRequest.

        Max length 100 characters Use Street Lookup API endpoint /nsg/streets to lookup this information If not provided, populated with NSG data related to supplied USRN  # noqa: E501

        :param area_name: The area_name of this WorkCreateRequest.  # noqa: E501
        :type: str
        """

        self._area_name = area_name

    @property
    def usrn(self):
        """Gets the usrn of this WorkCreateRequest.  # noqa: E501

        Is whole number between 1000001 and 99999999 inclusive See business rules section 1.4 - USRN  # noqa: E501

        :return: The usrn of this WorkCreateRequest.  # noqa: E501
        :rtype: float
        """
        return self._usrn

    @usrn.setter
    def usrn(self, usrn):
        """Sets the usrn of this WorkCreateRequest.

        Is whole number between 1000001 and 99999999 inclusive See business rules section 1.4 - USRN  # noqa: E501

        :param usrn: The usrn of this WorkCreateRequest.  # noqa: E501
        :type: float
        """
        if usrn is None:
            raise ValueError("Invalid value for `usrn`, must not be `None`")  # noqa: E501

        self._usrn = usrn

    @property
    def road_category(self):
        """Gets the road_category of this WorkCreateRequest.  # noqa: E501

        Is whole number between 0 and 10 inclusive If not provided, populated with NSG data related to supplied USRN  # noqa: E501

        :return: The road_category of this WorkCreateRequest.  # noqa: E501
        :rtype: float
        """
        return self._road_category

    @road_category.setter
    def road_category(self, road_category):
        """Sets the road_category of this WorkCreateRequest.

        Is whole number between 0 and 10 inclusive If not provided, populated with NSG data related to supplied USRN  # noqa: E501

        :param road_category: The road_category of this WorkCreateRequest.  # noqa: E501
        :type: float
        """

        self._road_category = road_category

    @property
    def work_reference_number(self):
        """Gets the work_reference_number of this WorkCreateRequest.  # noqa: E501

        Max length 24 characters Must be unique in the system Must contain only alphanumeric characters, dashes and underscores If not supplied it will be auto-generated  # noqa: E501

        :return: The work_reference_number of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._work_reference_number

    @work_reference_number.setter
    def work_reference_number(self, work_reference_number):
        """Sets the work_reference_number of this WorkCreateRequest.

        Max length 24 characters Must be unique in the system Must contain only alphanumeric characters, dashes and underscores If not supplied it will be auto-generated  # noqa: E501

        :param work_reference_number: The work_reference_number of this WorkCreateRequest.  # noqa: E501
        :type: str
        """

        self._work_reference_number = work_reference_number

    @property
    def secondary_contact(self):
        """Gets the secondary_contact of this WorkCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The secondary_contact of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._secondary_contact

    @secondary_contact.setter
    def secondary_contact(self, secondary_contact):
        """Sets the secondary_contact of this WorkCreateRequest.

        Max length 100 characters  # noqa: E501

        :param secondary_contact: The secondary_contact of this WorkCreateRequest.  # noqa: E501
        :type: str
        """
        if secondary_contact is None:
            raise ValueError("Invalid value for `secondary_contact`, must not be `None`")  # noqa: E501

        self._secondary_contact = secondary_contact

    @property
    def secondary_contact_number(self):
        """Gets the secondary_contact_number of this WorkCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The secondary_contact_number of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._secondary_contact_number

    @secondary_contact_number.setter
    def secondary_contact_number(self, secondary_contact_number):
        """Sets the secondary_contact_number of this WorkCreateRequest.

        Max length 100 characters  # noqa: E501

        :param secondary_contact_number: The secondary_contact_number of this WorkCreateRequest.  # noqa: E501
        :type: str
        """
        if secondary_contact_number is None:
            raise ValueError("Invalid value for `secondary_contact_number`, must not be `None`")  # noqa: E501

        self._secondary_contact_number = secondary_contact_number

    @property
    def secondary_contact_email(self):
        """Gets the secondary_contact_email of this WorkCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The secondary_contact_email of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._secondary_contact_email

    @secondary_contact_email.setter
    def secondary_contact_email(self, secondary_contact_email):
        """Sets the secondary_contact_email of this WorkCreateRequest.

        Max length 100 characters  # noqa: E501

        :param secondary_contact_email: The secondary_contact_email of this WorkCreateRequest.  # noqa: E501
        :type: str
        """

        self._secondary_contact_email = secondary_contact_email

    @property
    def proposed_start_date(self):
        """Gets the proposed_start_date of this WorkCreateRequest.  # noqa: E501


        :return: The proposed_start_date of this WorkCreateRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._proposed_start_date

    @proposed_start_date.setter
    def proposed_start_date(self, proposed_start_date):
        """Sets the proposed_start_date of this WorkCreateRequest.


        :param proposed_start_date: The proposed_start_date of this WorkCreateRequest.  # noqa: E501
        :type: datetime
        """
        if proposed_start_date is None:
            raise ValueError("Invalid value for `proposed_start_date`, must not be `None`")  # noqa: E501

        self._proposed_start_date = proposed_start_date

    @property
    def proposed_start_time(self):
        """Gets the proposed_start_time of this WorkCreateRequest.  # noqa: E501

        proposed_start_time is required if proposed_start_date is in the past  # noqa: E501

        :return: The proposed_start_time of this WorkCreateRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._proposed_start_time

    @proposed_start_time.setter
    def proposed_start_time(self, proposed_start_time):
        """Sets the proposed_start_time of this WorkCreateRequest.

        proposed_start_time is required if proposed_start_date is in the past  # noqa: E501

        :param proposed_start_time: The proposed_start_time of this WorkCreateRequest.  # noqa: E501
        :type: datetime
        """

        self._proposed_start_time = proposed_start_time

    @property
    def proposed_end_date(self):
        """Gets the proposed_end_date of this WorkCreateRequest.  # noqa: E501

        proposed_end_date must be on or after proposed_start_date If work_type = planned, the maximum date range between proposed_start_date and proposed_end_date is 5 years  # noqa: E501

        :return: The proposed_end_date of this WorkCreateRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._proposed_end_date

    @proposed_end_date.setter
    def proposed_end_date(self, proposed_end_date):
        """Sets the proposed_end_date of this WorkCreateRequest.

        proposed_end_date must be on or after proposed_start_date If work_type = planned, the maximum date range between proposed_start_date and proposed_end_date is 5 years  # noqa: E501

        :param proposed_end_date: The proposed_end_date of this WorkCreateRequest.  # noqa: E501
        :type: datetime
        """
        if proposed_end_date is None:
            raise ValueError("Invalid value for `proposed_end_date`, must not be `None`")  # noqa: E501

        self._proposed_end_date = proposed_end_date

    @property
    def proposed_end_time(self):
        """Gets the proposed_end_time of this WorkCreateRequest.  # noqa: E501

        proposed_end_time is required if proposed_end_date is in the past proposed_end_time must be after the date and time for proposed_start_time  # noqa: E501

        :return: The proposed_end_time of this WorkCreateRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._proposed_end_time

    @proposed_end_time.setter
    def proposed_end_time(self, proposed_end_time):
        """Sets the proposed_end_time of this WorkCreateRequest.

        proposed_end_time is required if proposed_end_date is in the past proposed_end_time must be after the date and time for proposed_start_time  # noqa: E501

        :param proposed_end_time: The proposed_end_time of this WorkCreateRequest.  # noqa: E501
        :type: datetime
        """

        self._proposed_end_time = proposed_end_time

    @property
    def description_of_work(self):
        """Gets the description_of_work of this WorkCreateRequest.  # noqa: E501

        Max length 500 characters  # noqa: E501

        :return: The description_of_work of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._description_of_work

    @description_of_work.setter
    def description_of_work(self, description_of_work):
        """Sets the description_of_work of this WorkCreateRequest.

        Max length 500 characters  # noqa: E501

        :param description_of_work: The description_of_work of this WorkCreateRequest.  # noqa: E501
        :type: str
        """
        if description_of_work is None:
            raise ValueError("Invalid value for `description_of_work`, must not be `None`")  # noqa: E501

        self._description_of_work = description_of_work

    @property
    def excavation(self):
        """Gets the excavation of this WorkCreateRequest.  # noqa: E501

        Whether an excavation will be required  # noqa: E501

        :return: The excavation of this WorkCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._excavation

    @excavation.setter
    def excavation(self, excavation):
        """Sets the excavation of this WorkCreateRequest.

        Whether an excavation will be required  # noqa: E501

        :param excavation: The excavation of this WorkCreateRequest.  # noqa: E501
        :type: bool
        """
        if excavation is None:
            raise ValueError("Invalid value for `excavation`, must not be `None`")  # noqa: E501

        self._excavation = excavation

    @property
    def project_reference_number(self):
        """Gets the project_reference_number of this WorkCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The project_reference_number of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._project_reference_number

    @project_reference_number.setter
    def project_reference_number(self, project_reference_number):
        """Sets the project_reference_number of this WorkCreateRequest.

        Max length 100 characters  # noqa: E501

        :param project_reference_number: The project_reference_number of this WorkCreateRequest.  # noqa: E501
        :type: str
        """

        self._project_reference_number = project_reference_number

    @property
    def traffic_management_plan(self):
        """Gets the traffic_management_plan of this WorkCreateRequest.  # noqa: E501


        :return: The traffic_management_plan of this WorkCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._traffic_management_plan

    @traffic_management_plan.setter
    def traffic_management_plan(self, traffic_management_plan):
        """Sets the traffic_management_plan of this WorkCreateRequest.


        :param traffic_management_plan: The traffic_management_plan of this WorkCreateRequest.  # noqa: E501
        :type: bool
        """
        if traffic_management_plan is None:
            raise ValueError("Invalid value for `traffic_management_plan`, must not be `None`")  # noqa: E501

        self._traffic_management_plan = traffic_management_plan

    @property
    def lane_rental_applicable(self):
        """Gets the lane_rental_applicable of this WorkCreateRequest.  # noqa: E501


        :return: The lane_rental_applicable of this WorkCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._lane_rental_applicable

    @lane_rental_applicable.setter
    def lane_rental_applicable(self, lane_rental_applicable):
        """Sets the lane_rental_applicable of this WorkCreateRequest.


        :param lane_rental_applicable: The lane_rental_applicable of this WorkCreateRequest.  # noqa: E501
        :type: bool
        """
        if lane_rental_applicable is None:
            raise ValueError("Invalid value for `lane_rental_applicable`, must not be `None`")  # noqa: E501

        self._lane_rental_applicable = lane_rental_applicable

    @property
    def permit_conditions(self):
        """Gets the permit_conditions of this WorkCreateRequest.  # noqa: E501

        Array values must be unique  # noqa: E501

        :return: The permit_conditions of this WorkCreateRequest.  # noqa: E501
        :rtype: list[PermitCondition]
        """
        return self._permit_conditions

    @permit_conditions.setter
    def permit_conditions(self, permit_conditions):
        """Sets the permit_conditions of this WorkCreateRequest.

        Array values must be unique  # noqa: E501

        :param permit_conditions: The permit_conditions of this WorkCreateRequest.  # noqa: E501
        :type: list[PermitCondition]
        """

        self._permit_conditions = permit_conditions

    @property
    def collaborative_working(self):
        """Gets the collaborative_working of this WorkCreateRequest.  # noqa: E501


        :return: The collaborative_working of this WorkCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._collaborative_working

    @collaborative_working.setter
    def collaborative_working(self, collaborative_working):
        """Sets the collaborative_working of this WorkCreateRequest.


        :param collaborative_working: The collaborative_working of this WorkCreateRequest.  # noqa: E501
        :type: bool
        """
        if collaborative_working is None:
            raise ValueError("Invalid value for `collaborative_working`, must not be `None`")  # noqa: E501

        self._collaborative_working = collaborative_working

    @property
    def collaboration_details(self):
        """Gets the collaboration_details of this WorkCreateRequest.  # noqa: E501

        Required if collaborative_working = true Max length 500 characters  # noqa: E501

        :return: The collaboration_details of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._collaboration_details

    @collaboration_details.setter
    def collaboration_details(self, collaboration_details):
        """Sets the collaboration_details of this WorkCreateRequest.

        Required if collaborative_working = true Max length 500 characters  # noqa: E501

        :param collaboration_details: The collaboration_details of this WorkCreateRequest.  # noqa: E501
        :type: str
        """

        self._collaboration_details = collaboration_details

    @property
    def collaborative_works(self):
        """Gets the collaborative_works of this WorkCreateRequest.  # noqa: E501

        Optional but only saved if collaborative_working = true Max length 500 characters Work Reference Number of collaborative works  # noqa: E501

        :return: The collaborative_works of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._collaborative_works

    @collaborative_works.setter
    def collaborative_works(self, collaborative_works):
        """Sets the collaborative_works of this WorkCreateRequest.

        Optional but only saved if collaborative_working = true Max length 500 characters Work Reference Number of collaborative works  # noqa: E501

        :param collaborative_works: The collaborative_works of this WorkCreateRequest.  # noqa: E501
        :type: str
        """

        self._collaborative_works = collaborative_works

    @property
    def activity_type(self):
        """Gets the activity_type of this WorkCreateRequest.  # noqa: E501


        :return: The activity_type of this WorkCreateRequest.  # noqa: E501
        :rtype: ActivityType
        """
        return self._activity_type

    @activity_type.setter
    def activity_type(self, activity_type):
        """Sets the activity_type of this WorkCreateRequest.


        :param activity_type: The activity_type of this WorkCreateRequest.  # noqa: E501
        :type: ActivityType
        """
        if activity_type is None:
            raise ValueError("Invalid value for `activity_type`, must not be `None`")  # noqa: E501

        self._activity_type = activity_type

    @property
    def traffic_management_type(self):
        """Gets the traffic_management_type of this WorkCreateRequest.  # noqa: E501


        :return: The traffic_management_type of this WorkCreateRequest.  # noqa: E501
        :rtype: TrafficManagementType
        """
        return self._traffic_management_type

    @traffic_management_type.setter
    def traffic_management_type(self, traffic_management_type):
        """Sets the traffic_management_type of this WorkCreateRequest.


        :param traffic_management_type: The traffic_management_type of this WorkCreateRequest.  # noqa: E501
        :type: TrafficManagementType
        """
        if traffic_management_type is None:
            raise ValueError("Invalid value for `traffic_management_type`, must not be `None`")  # noqa: E501

        self._traffic_management_type = traffic_management_type

    @property
    def application_type(self):
        """Gets the application_type of this WorkCreateRequest.  # noqa: E501


        :return: The application_type of this WorkCreateRequest.  # noqa: E501
        :rtype: ApplicationType
        """
        return self._application_type

    @application_type.setter
    def application_type(self, application_type):
        """Sets the application_type of this WorkCreateRequest.


        :param application_type: The application_type of this WorkCreateRequest.  # noqa: E501
        :type: ApplicationType
        """
        if application_type is None:
            raise ValueError("Invalid value for `application_type`, must not be `None`")  # noqa: E501

        self._application_type = application_type

    @property
    def collaboration_type(self):
        """Gets the collaboration_type of this WorkCreateRequest.  # noqa: E501

        Required if collaborative_working = true  # noqa: E501

        :return: The collaboration_type of this WorkCreateRequest.  # noqa: E501
        :rtype: AllOfWorkCreateRequestCollaborationType
        """
        return self._collaboration_type

    @collaboration_type.setter
    def collaboration_type(self, collaboration_type):
        """Sets the collaboration_type of this WorkCreateRequest.

        Required if collaborative_working = true  # noqa: E501

        :param collaboration_type: The collaboration_type of this WorkCreateRequest.  # noqa: E501
        :type: AllOfWorkCreateRequestCollaborationType
        """

        self._collaboration_type = collaboration_type

    @property
    def location_types(self):
        """Gets the location_types of this WorkCreateRequest.  # noqa: E501

        Array values must be unique  # noqa: E501

        :return: The location_types of this WorkCreateRequest.  # noqa: E501
        :rtype: list[LocationType]
        """
        return self._location_types

    @location_types.setter
    def location_types(self, location_types):
        """Sets the location_types of this WorkCreateRequest.

        Array values must be unique  # noqa: E501

        :param location_types: The location_types of this WorkCreateRequest.  # noqa: E501
        :type: list[LocationType]
        """
        if location_types is None:
            raise ValueError("Invalid value for `location_types`, must not be `None`")  # noqa: E501

        self._location_types = location_types

    @property
    def file_ids(self):
        """Gets the file_ids of this WorkCreateRequest.  # noqa: E501

        Array values must be unique Must not contain null or undefined values A file_id can only be associated with one section of Street Manager See API specification Resource Guide > Works API > File upload for more information  # noqa: E501

        :return: The file_ids of this WorkCreateRequest.  # noqa: E501
        :rtype: list[float]
        """
        return self._file_ids

    @file_ids.setter
    def file_ids(self, file_ids):
        """Sets the file_ids of this WorkCreateRequest.

        Array values must be unique Must not contain null or undefined values A file_id can only be associated with one section of Street Manager See API specification Resource Guide > Works API > File upload for more information  # noqa: E501

        :param file_ids: The file_ids of this WorkCreateRequest.  # noqa: E501
        :type: list[float]
        """

        self._file_ids = file_ids

    @property
    def permit_asds(self):
        """Gets the permit_asds of this WorkCreateRequest.  # noqa: E501


        :return: The permit_asds of this WorkCreateRequest.  # noqa: E501
        :rtype: list[PermitASD]
        """
        return self._permit_asds

    @permit_asds.setter
    def permit_asds(self, permit_asds):
        """Sets the permit_asds of this WorkCreateRequest.


        :param permit_asds: The permit_asds of this WorkCreateRequest.  # noqa: E501
        :type: list[PermitASD]
        """

        self._permit_asds = permit_asds

    @property
    def work_type(self):
        """Gets the work_type of this WorkCreateRequest.  # noqa: E501


        :return: The work_type of this WorkCreateRequest.  # noqa: E501
        :rtype: WorkType
        """
        return self._work_type

    @work_type.setter
    def work_type(self, work_type):
        """Sets the work_type of this WorkCreateRequest.


        :param work_type: The work_type of this WorkCreateRequest.  # noqa: E501
        :type: WorkType
        """
        if work_type is None:
            raise ValueError("Invalid value for `work_type`, must not be `None`")  # noqa: E501

        self._work_type = work_type

    @property
    def is_ttro_required(self):
        """Gets the is_ttro_required of this WorkCreateRequest.  # noqa: E501

        Required when work_type is planned  # noqa: E501

        :return: The is_ttro_required of this WorkCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._is_ttro_required

    @is_ttro_required.setter
    def is_ttro_required(self, is_ttro_required):
        """Sets the is_ttro_required of this WorkCreateRequest.

        Required when work_type is planned  # noqa: E501

        :param is_ttro_required: The is_ttro_required of this WorkCreateRequest.  # noqa: E501
        :type: bool
        """

        self._is_ttro_required = is_ttro_required

    @property
    def immediate_risk(self):
        """Gets the immediate_risk of this WorkCreateRequest.  # noqa: E501

        Required when work_type is immediate  # noqa: E501

        :return: The immediate_risk of this WorkCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._immediate_risk

    @immediate_risk.setter
    def immediate_risk(self, immediate_risk):
        """Sets the immediate_risk of this WorkCreateRequest.

        Required when work_type is immediate  # noqa: E501

        :param immediate_risk: The immediate_risk of this WorkCreateRequest.  # noqa: E501
        :type: bool
        """

        self._immediate_risk = immediate_risk

    @property
    def early_start_pre_approval(self):
        """Gets the early_start_pre_approval of this WorkCreateRequest.  # noqa: E501

        See business rules section 3.4.6 - Early start  # noqa: E501

        :return: The early_start_pre_approval of this WorkCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._early_start_pre_approval

    @early_start_pre_approval.setter
    def early_start_pre_approval(self, early_start_pre_approval):
        """Sets the early_start_pre_approval of this WorkCreateRequest.

        See business rules section 3.4.6 - Early start  # noqa: E501

        :param early_start_pre_approval: The early_start_pre_approval of this WorkCreateRequest.  # noqa: E501
        :type: bool
        """

        self._early_start_pre_approval = early_start_pre_approval

    @property
    def pre_approval_details(self):
        """Gets the pre_approval_details of this WorkCreateRequest.  # noqa: E501

        Required if early_start_pre_approval = true Max length 500 characters  # noqa: E501

        :return: The pre_approval_details of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._pre_approval_details

    @pre_approval_details.setter
    def pre_approval_details(self, pre_approval_details):
        """Sets the pre_approval_details of this WorkCreateRequest.

        Required if early_start_pre_approval = true Max length 500 characters  # noqa: E501

        :param pre_approval_details: The pre_approval_details of this WorkCreateRequest.  # noqa: E501
        :type: str
        """

        self._pre_approval_details = pre_approval_details

    @property
    def pre_approval_authoriser(self):
        """Gets the pre_approval_authoriser of this WorkCreateRequest.  # noqa: E501

        Required if early_start_pre_approval = true Max length 100 characters  # noqa: E501

        :return: The pre_approval_authoriser of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._pre_approval_authoriser

    @pre_approval_authoriser.setter
    def pre_approval_authoriser(self, pre_approval_authoriser):
        """Sets the pre_approval_authoriser of this WorkCreateRequest.

        Required if early_start_pre_approval = true Max length 100 characters  # noqa: E501

        :param pre_approval_authoriser: The pre_approval_authoriser of this WorkCreateRequest.  # noqa: E501
        :type: str
        """

        self._pre_approval_authoriser = pre_approval_authoriser

    @property
    def early_start_reason(self):
        """Gets the early_start_reason of this WorkCreateRequest.  # noqa: E501

        Required if early_start_pre_approval = false Max length 500 characters  # noqa: E501

        :return: The early_start_reason of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._early_start_reason

    @early_start_reason.setter
    def early_start_reason(self, early_start_reason):
        """Sets the early_start_reason of this WorkCreateRequest.

        Required if early_start_pre_approval = false Max length 500 characters  # noqa: E501

        :param early_start_reason: The early_start_reason of this WorkCreateRequest.  # noqa: E501
        :type: str
        """

        self._early_start_reason = early_start_reason

    @property
    def additional_info(self):
        """Gets the additional_info of this WorkCreateRequest.  # noqa: E501

        Max length 500 characters  # noqa: E501

        :return: The additional_info of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._additional_info

    @additional_info.setter
    def additional_info(self, additional_info):
        """Sets the additional_info of this WorkCreateRequest.

        Max length 500 characters  # noqa: E501

        :param additional_info: The additional_info of this WorkCreateRequest.  # noqa: E501
        :type: str
        """

        self._additional_info = additional_info

    @property
    def close_footway(self):
        """Gets the close_footway of this WorkCreateRequest.  # noqa: E501


        :return: The close_footway of this WorkCreateRequest.  # noqa: E501
        :rtype: CloseFootway
        """
        return self._close_footway

    @close_footway.setter
    def close_footway(self, close_footway):
        """Sets the close_footway of this WorkCreateRequest.


        :param close_footway: The close_footway of this WorkCreateRequest.  # noqa: E501
        :type: CloseFootway
        """
        if close_footway is None:
            raise ValueError("Invalid value for `close_footway`, must not be `None`")  # noqa: E501

        self._close_footway = close_footway

    @property
    def close_footpath(self):
        """Gets the close_footpath of this WorkCreateRequest.  # noqa: E501


        :return: The close_footpath of this WorkCreateRequest.  # noqa: E501
        :rtype: CloseFootpath
        """
        return self._close_footpath

    @close_footpath.setter
    def close_footpath(self, close_footpath):
        """Sets the close_footpath of this WorkCreateRequest.


        :param close_footpath: The close_footpath of this WorkCreateRequest.  # noqa: E501
        :type: CloseFootpath
        """
        if close_footpath is None:
            raise ValueError("Invalid value for `close_footpath`, must not be `None`")  # noqa: E501

        self._close_footpath = close_footpath

    @property
    def works_location_description(self):
        """Gets the works_location_description of this WorkCreateRequest.  # noqa: E501

        Max length 500 characters  # noqa: E501

        :return: The works_location_description of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._works_location_description

    @works_location_description.setter
    def works_location_description(self, works_location_description):
        """Sets the works_location_description of this WorkCreateRequest.

        Max length 500 characters  # noqa: E501

        :param works_location_description: The works_location_description of this WorkCreateRequest.  # noqa: E501
        :type: str
        """
        if works_location_description is None:
            raise ValueError("Invalid value for `works_location_description`, must not be `None`")  # noqa: E501

        self._works_location_description = works_location_description

    @property
    def workstream_prefix(self):
        """Gets the workstream_prefix of this WorkCreateRequest.  # noqa: E501

        Must consist of 3 positive whole numbers  # noqa: E501

        :return: The workstream_prefix of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._workstream_prefix

    @workstream_prefix.setter
    def workstream_prefix(self, workstream_prefix):
        """Sets the workstream_prefix of this WorkCreateRequest.

        Must consist of 3 positive whole numbers  # noqa: E501

        :param workstream_prefix: The workstream_prefix of this WorkCreateRequest.  # noqa: E501
        :type: str
        """

        self._workstream_prefix = workstream_prefix

    @property
    def hs2_in_act_limits(self):
        """Gets the hs2_in_act_limits of this WorkCreateRequest.  # noqa: E501

        Required if promoter_swa_code = '7374'  # noqa: E501

        :return: The hs2_in_act_limits of this WorkCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._hs2_in_act_limits

    @hs2_in_act_limits.setter
    def hs2_in_act_limits(self, hs2_in_act_limits):
        """Sets the hs2_in_act_limits of this WorkCreateRequest.

        Required if promoter_swa_code = '7374'  # noqa: E501

        :param hs2_in_act_limits: The hs2_in_act_limits of this WorkCreateRequest.  # noqa: E501
        :type: bool
        """

        self._hs2_in_act_limits = hs2_in_act_limits

    @property
    def hs2_consultation_requested_response_date(self):
        """Gets the hs2_consultation_requested_response_date of this WorkCreateRequest.  # noqa: E501

        Date must occur today or a date in the future  # noqa: E501

        :return: The hs2_consultation_requested_response_date of this WorkCreateRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._hs2_consultation_requested_response_date

    @hs2_consultation_requested_response_date.setter
    def hs2_consultation_requested_response_date(self, hs2_consultation_requested_response_date):
        """Sets the hs2_consultation_requested_response_date of this WorkCreateRequest.

        Date must occur today or a date in the future  # noqa: E501

        :param hs2_consultation_requested_response_date: The hs2_consultation_requested_response_date of this WorkCreateRequest.  # noqa: E501
        :type: datetime
        """

        self._hs2_consultation_requested_response_date = hs2_consultation_requested_response_date

    @property
    def hs2_highway_exemption(self):
        """Gets the hs2_highway_exemption of this WorkCreateRequest.  # noqa: E501

        Required if work_type = 'hs2_highway_works' and hs2_in_act_limits = true  # noqa: E501

        :return: The hs2_highway_exemption of this WorkCreateRequest.  # noqa: E501
        :rtype: AllOfWorkCreateRequestHs2HighwayExemption
        """
        return self._hs2_highway_exemption

    @hs2_highway_exemption.setter
    def hs2_highway_exemption(self, hs2_highway_exemption):
        """Sets the hs2_highway_exemption of this WorkCreateRequest.

        Required if work_type = 'hs2_highway_works' and hs2_in_act_limits = true  # noqa: E501

        :param hs2_highway_exemption: The hs2_highway_exemption of this WorkCreateRequest.  # noqa: E501
        :type: AllOfWorkCreateRequestHs2HighwayExemption
        """

        self._hs2_highway_exemption = hs2_highway_exemption

    @property
    def hs2_highway_emails(self):
        """Gets the hs2_highway_emails of this WorkCreateRequest.  # noqa: E501

        Array Max length 2 items Array values must be valid email addresses Array values max length 100 characters  # noqa: E501

        :return: The hs2_highway_emails of this WorkCreateRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._hs2_highway_emails

    @hs2_highway_emails.setter
    def hs2_highway_emails(self, hs2_highway_emails):
        """Sets the hs2_highway_emails of this WorkCreateRequest.

        Array Max length 2 items Array values must be valid email addresses Array values max length 100 characters  # noqa: E501

        :param hs2_highway_emails: The hs2_highway_emails of this WorkCreateRequest.  # noqa: E501
        :type: list[str]
        """

        self._hs2_highway_emails = hs2_highway_emails

    @property
    def additional_contact(self):
        """Gets the additional_contact of this WorkCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The additional_contact of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._additional_contact

    @additional_contact.setter
    def additional_contact(self, additional_contact):
        """Sets the additional_contact of this WorkCreateRequest.

        Max length 100 characters  # noqa: E501

        :param additional_contact: The additional_contact of this WorkCreateRequest.  # noqa: E501
        :type: str
        """

        self._additional_contact = additional_contact

    @property
    def additional_contact_number(self):
        """Gets the additional_contact_number of this WorkCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The additional_contact_number of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._additional_contact_number

    @additional_contact_number.setter
    def additional_contact_number(self, additional_contact_number):
        """Sets the additional_contact_number of this WorkCreateRequest.

        Max length 100 characters  # noqa: E501

        :param additional_contact_number: The additional_contact_number of this WorkCreateRequest.  # noqa: E501
        :type: str
        """

        self._additional_contact_number = additional_contact_number

    @property
    def additional_contact_email(self):
        """Gets the additional_contact_email of this WorkCreateRequest.  # noqa: E501

        Max length 100 characters  # noqa: E501

        :return: The additional_contact_email of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._additional_contact_email

    @additional_contact_email.setter
    def additional_contact_email(self, additional_contact_email):
        """Sets the additional_contact_email of this WorkCreateRequest.

        Max length 100 characters  # noqa: E501

        :param additional_contact_email: The additional_contact_email of this WorkCreateRequest.  # noqa: E501
        :type: str
        """

        self._additional_contact_email = additional_contact_email

    @property
    def hs2_additional_usrns(self):
        """Gets the hs2_additional_usrns of this WorkCreateRequest.  # noqa: E501

        Array max length 10 items Array values must be valid USRNs  # noqa: E501

        :return: The hs2_additional_usrns of this WorkCreateRequest.  # noqa: E501
        :rtype: list[float]
        """
        return self._hs2_additional_usrns

    @hs2_additional_usrns.setter
    def hs2_additional_usrns(self, hs2_additional_usrns):
        """Sets the hs2_additional_usrns of this WorkCreateRequest.

        Array max length 10 items Array values must be valid USRNs  # noqa: E501

        :param hs2_additional_usrns: The hs2_additional_usrns of this WorkCreateRequest.  # noqa: E501
        :type: list[float]
        """

        self._hs2_additional_usrns = hs2_additional_usrns

    @property
    def emergency_contact_name(self):
        """Gets the emergency_contact_name of this WorkCreateRequest.  # noqa: E501

        Max length 100 characters Required if traffic_management_type = 'multi_way_signals' or 'two_way_signals'  # noqa: E501

        :return: The emergency_contact_name of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._emergency_contact_name

    @emergency_contact_name.setter
    def emergency_contact_name(self, emergency_contact_name):
        """Sets the emergency_contact_name of this WorkCreateRequest.

        Max length 100 characters Required if traffic_management_type = 'multi_way_signals' or 'two_way_signals'  # noqa: E501

        :param emergency_contact_name: The emergency_contact_name of this WorkCreateRequest.  # noqa: E501
        :type: str
        """

        self._emergency_contact_name = emergency_contact_name

    @property
    def emergency_contact_number(self):
        """Gets the emergency_contact_number of this WorkCreateRequest.  # noqa: E501

        Max length 100 characters Required if traffic_management_type = 'multi_way_signals' or 'two_way_signals'  # noqa: E501

        :return: The emergency_contact_number of this WorkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._emergency_contact_number

    @emergency_contact_number.setter
    def emergency_contact_number(self, emergency_contact_number):
        """Sets the emergency_contact_number of this WorkCreateRequest.

        Max length 100 characters Required if traffic_management_type = 'multi_way_signals' or 'two_way_signals'  # noqa: E501

        :param emergency_contact_number: The emergency_contact_number of this WorkCreateRequest.  # noqa: E501
        :type: str
        """

        self._emergency_contact_number = emergency_contact_number

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(WorkCreateRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WorkCreateRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
