"""
    VRt.Account [AC]

    The version of the OpenAPI document: 6.3.1926
    Contact: servicedesk@veeroute.com
    Auto Generated
"""


import re  # noqa: F401
import sys  # noqa: F401

from vrt_lss_account.api_client import ApiClient, Endpoint as _Endpoint
from vrt_lss_account.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from vrt_lss_account.model.flow_convert import FlowConvert
from vrt_lss_account.model.flow_type import FlowType
from vrt_lss_account.model.inline_response400 import InlineResponse400
from vrt_lss_account.model.inline_response401 import InlineResponse401
from vrt_lss_account.model.inline_response402 import InlineResponse402
from vrt_lss_account.model.inline_response403 import InlineResponse403
from vrt_lss_account.model.inline_response404 import InlineResponse404
from vrt_lss_account.model.inline_response429 import InlineResponse429
from vrt_lss_account.model.inline_response500 import InlineResponse500


class DataApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.read_data_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/account/data/{tracecode}',
                'operation_id': 'read_data',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'tracecode',
                    'data_flow_type',
                    'data_flow_stage',
                    'data_flow_convert',
                ],
                'required': [
                    'tracecode',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'data_flow_stage',
                ]
            },
            root_map={
                'validations': {
                    ('data_flow_stage',): {

                        'inclusive_maximum': 3,
                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tracecode':
                        (str,),
                    'data_flow_type':
                        (FlowType,),
                    'data_flow_stage':
                        (int,),
                    'data_flow_convert':
                        (FlowConvert,),
                },
                'attribute_map': {
                    'tracecode': 'tracecode',
                    'data_flow_type': 'data_flow_type',
                    'data_flow_stage': 'data_flow_stage',
                    'data_flow_convert': 'data_flow_convert',
                },
                'location_map': {
                    'tracecode': 'path',
                    'data_flow_type': 'query',
                    'data_flow_stage': 'query',
                    'data_flow_convert': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/octet-stream',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def read_data(
        self,
        tracecode,
        **kwargs
    ):
        """Reading input data  

        Receiving an incoming request by `tracecode`.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_data(tracecode, async_req=True)
        >>> result = thread.get()

        Args:
            tracecode (str): Unique process identifier.

        Keyword Args:
            data_flow_type (FlowType): Data flow type.. [optional]
            data_flow_stage (int): Data flow stage.. [optional] if omitted the server will use the default value of 0
            data_flow_convert (FlowConvert): Data result convert.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['tracecode'] = \
            tracecode
        return self.read_data_endpoint.call_with_http_info(**kwargs)

