/*
 * Decompiled with CFR 0.152.
 */
package io.ray.serve.api;

import io.ray.api.ActorHandle;
import io.ray.api.BaseActorHandle;
import io.ray.api.PyActorHandle;
import io.ray.api.Ray;
import io.ray.api.exception.RayActorException;
import io.ray.api.exception.RayTimeoutException;
import io.ray.api.function.PyActorMethod;
import io.ray.serve.controller.ServeController;
import io.ray.serve.deployment.Deployment;
import io.ray.serve.deployment.DeploymentRoute;
import io.ray.serve.exception.RayServeException;
import io.ray.serve.generated.ApplicationStatus;
import io.ray.serve.generated.DeploymentArgs;
import io.ray.serve.generated.EndpointInfo;
import io.ray.serve.generated.StatusOverview;
import io.ray.serve.handle.DeploymentHandle;
import io.ray.serve.util.CollectionUtil;
import io.ray.serve.util.MessageFormatter;
import io.ray.serve.util.ServeProtoUtil;
import io.ray.shaded.com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServeControllerClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServeControllerClient.class);
    private static long CLIENT_POLLING_INTERVAL_S = 1L;
    private BaseActorHandle controller;
    private boolean shutdown;
    private Map<String, DeploymentHandle> handleCache = new ConcurrentHashMap<String, DeploymentHandle>();
    private String rootUrl;

    public ServeControllerClient(BaseActorHandle controller) {
        this.controller = controller;
        this.rootUrl = controller instanceof PyActorHandle ? (String)((PyActorHandle)controller).task(PyActorMethod.of("get_root_url")).remote().get() : ((ActorHandle)controller).task(ServeController::getRootUrl).remote().get();
    }

    public DeploymentHandle getDeploymentHandle(String deploymentName, String appName, boolean missingOk) {
        String cacheKey = StringUtils.join(new Object[]{deploymentName, appName, missingOk}, "#");
        if (this.handleCache.containsKey(cacheKey)) {
            return this.handleCache.get(cacheKey);
        }
        Map<String, EndpointInfo> endpoints = null;
        if (this.controller instanceof PyActorHandle) {
            endpoints = ServeProtoUtil.parseEndpointSet((byte[])((PyActorHandle)this.controller).task(PyActorMethod.of("get_all_endpoints_java")).remote().get());
        } else {
            LOGGER.warn("Client currently only supports the Python controller.");
            endpoints = ServeProtoUtil.parseEndpointSet(((ActorHandle)this.controller).task(ServeController::getAllEndpoints).remote().get());
        }
        if (!(missingOk || endpoints != null && endpoints.containsKey(deploymentName))) {
            throw new RayServeException(MessageFormatter.format("Deployment {} does not exist.", deploymentName));
        }
        DeploymentHandle handle = new DeploymentHandle(deploymentName, appName);
        this.handleCache.put(cacheKey, handle);
        return handle;
    }

    public synchronized void shutdown(Long timeoutS) {
        if (Ray.isInitialized() && !this.shutdown) {
            if (timeoutS == null) {
                timeoutS = 30L;
            }
            try {
                ((PyActorHandle)this.controller).task(PyActorMethod.of("graceful_shutdown")).remote().get(timeoutS * 1000L);
            }
            catch (RayActorException e) {
                return;
            }
            catch (RayTimeoutException e) {
                LOGGER.warn("Controller failed to shut down within {}s. Check controller logs for more details.", (Object)timeoutS);
            }
            this.shutdown = true;
        }
    }

    public String getRootUrl() {
        return this.rootUrl;
    }

    @Deprecated
    public DeploymentRoute getDeploymentInfo(String name) {
        return DeploymentRoute.fromProtoBytes((byte[])((PyActorHandle)this.controller).task(PyActorMethod.of("get_deployment_info"), name).remote().get());
    }

    public BaseActorHandle getController() {
        return this.controller;
    }

    public void deployApplication(String name, String routePrefix, List<Deployment> deployments, String ingressDeploymentName, boolean blocking) {
        Object[] deploymentArgsArray = new Object[deployments.size()];
        for (int i = 0; i < deployments.size(); ++i) {
            Deployment deployment = deployments.get(i);
            DeploymentArgs.Builder deploymentArgs = DeploymentArgs.newBuilder().setDeploymentName(deployment.getName()).setReplicaConfig(ByteString.copyFrom(deployment.getReplicaConfig().toProtoBytes())).setDeploymentConfig(ByteString.copyFrom(deployment.getDeploymentConfig().toProtoBytes())).setIngress(deployment.isIngress()).setDeployerJobId(Ray.getRuntimeContext().getCurrentJobId().toString());
            if (deployment.getName() == ingressDeploymentName) {
                deploymentArgs.setRoutePrefix(routePrefix);
            }
            deploymentArgsArray[i] = deploymentArgs.build().toByteArray();
        }
        ((PyActorHandle)this.controller).task(PyActorMethod.of("deploy_application"), name, deploymentArgsArray).remote().get();
        if (blocking) {
            this.waitForApplicationRunning(name, null);
            for (Deployment deployment : deployments) {
                this.logDeploymentReady(deployment.getName(), deployment.getVersion(), "component=serve deployment=" + deployment.getName());
            }
        }
    }

    private void waitForApplicationRunning(String name, Long timeoutS) {
        long start = System.currentTimeMillis();
        while (timeoutS == null || System.currentTimeMillis() - start < timeoutS * 1000L) {
            StatusOverview status = this.getServeStatus(name);
            if (status.getAppStatus().getStatus() == ApplicationStatus.APPLICATION_STATUS_RUNNING) {
                return;
            }
            if (status.getAppStatus().getStatus() == ApplicationStatus.APPLICATION_STATUS_DEPLOY_FAILED) {
                throw new RayServeException(MessageFormatter.format("Deploying application {} is failed: {}", name, status.getAppStatus().getMessage()));
            }
            LOGGER.debug("Waiting for {} to be RUNNING, current status: {}.", (Object)name, (Object)status.getAppStatus().getStatus());
            try {
                Thread.sleep(CLIENT_POLLING_INTERVAL_S * 1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        throw new RayServeException(MessageFormatter.format("Application {} did not become RUNNING after {}s.", name, timeoutS));
    }

    private void logDeploymentReady(String name, String version, String tag) {
        LOGGER.info("Deployment '{}{}' is ready. {}", name, StringUtils.isNotBlank(version) ? "':'" + version : "", tag);
    }

    public void deleteApps(List<String> names, boolean blocking) {
        if (CollectionUtil.isEmpty(names)) {
            return;
        }
        LOGGER.info("Deleting app {}", (Object)names);
        ((PyActorHandle)this.controller).task(PyActorMethod.of("delete_apps"), names.toArray()).remote().get();
        if (blocking) {
            long start = System.currentTimeMillis();
            ArrayList<String> undeleted = new ArrayList<String>(names);
            while (System.currentTimeMillis() - start < 60000L) {
                Iterator iterator = undeleted.iterator();
                while (iterator.hasNext()) {
                    String name = (String)iterator.next();
                    StatusOverview status = this.getServeStatus(name);
                    if (status.getAppStatus().getStatus() != ApplicationStatus.APPLICATION_STATUS_NOT_STARTED) continue;
                    iterator.remove();
                }
                if (undeleted.isEmpty()) {
                    return;
                }
                try {
                    Thread.sleep(CLIENT_POLLING_INTERVAL_S * 1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            throw new RayServeException(MessageFormatter.format("Some of these applications weren't deleted after 60s: {}", names));
        }
    }

    public StatusOverview getServeStatus(String name) {
        byte[] statusBytes = (byte[])((PyActorHandle)this.controller).task(PyActorMethod.of("get_serve_status"), name).remote().get();
        return ServeProtoUtil.bytesToProto(statusBytes, StatusOverview::parseFrom);
    }
}

