# eis-gdv
The EMIL GdvService API description

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
- Package version: 2.1.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.emil.de](https://www.emil.de)

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install eis.gdv
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import eis.gdv
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import eis.gdv
```

## Getting Started

The environment variables must be set in order to properly use this SDK.

```shell 
export EMIL_USERNAME=XXXXXXX
export EMIL_PASSWORD=XXXXXXX
```

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
import time
import eis.gdv
from pprint import pprint
from eis.gdv.api import mailbox_api
from eis.gdv.model.create_mailbox_request_dto import CreateMailboxRequestDto
# Defining the host is optional and defaults to https://apiv2.emil.de
# See configuration.py for a list of all supported configuration parameters.
configuration = eis.gdv.Configuration(
    host = "https://apiv2.emil.de"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Bearer is automatically handled with exported environment variables. However, you
# can manuallay configure Bearer authorization (JWT): bearer
configuration = eis.gdv.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)

# After manual token becomes invalid, the SDK will default to re-login automatically
# with environment variable credentials.


# Enter a context with an instance of the API client
with eis.gdv.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = mailbox_api.MailboxApi(api_client)
    create_mailbox_request_dto = CreateMailboxRequestDto(
        provider_id="provider_id_example",
        name="name_example",
        is_default=True,
    ) # CreateMailboxRequestDto | 
    authorization = "Authorization_example" # str | Bearer Token (optional)

    try:
        api_instance.create_mailbox(create_mailbox_request_dto, authorization=authorization)
    except eis.gdv.ApiException as e:
        print("Exception when calling MailboxApi->create_mailbox: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://apiv2.emil.de*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*MailboxApi* | [**create_mailbox**](docs/MailboxApi.md#create_mailbox) | **POST** /gdvservice/v1/mailboxes | 
*MailboxApi* | [**download_messages**](docs/MailboxApi.md#download_messages) | **POST** /gdvservice/v1/mailboxes/download-messages | 
*MessageApi* | [**get_request_message**](docs/MessageApi.md#get_request_message) | **GET** /gdvservice/v1/messages/requests/{code} | Retrieve the request message
*MessageApi* | [**get_response_message**](docs/MessageApi.md#get_response_message) | **GET** /gdvservice/v1/messages/responses/{code} | Retrieve the response message
*MessageApi* | [**list_all_messages**](docs/MessageApi.md#list_all_messages) | **GET** /gdvservice/v1/messages | List messages
*MessageApi* | [**list_requests_messages**](docs/MessageApi.md#list_requests_messages) | **GET** /gdvservice/v1/messages/requests | List requests messages
*MessageApi* | [**list_responses_messages**](docs/MessageApi.md#list_responses_messages) | **GET** /gdvservice/v1/messages/responses | List responses messages
*MessageApi* | [**update_request_message**](docs/MessageApi.md#update_request_message) | **PUT** /gdvservice/v1/messages/requests/{code} | Update the request message
*MessageApi* | [**update_response_message**](docs/MessageApi.md#update_response_message) | **PUT** /gdvservice/v1/messages/responses/{code} | Update the request message
*UserApi* | [**create_user**](docs/UserApi.md#create_user) | **POST** /gdvservice/v1/users | Create the gdv tenant user
*UserApi* | [**get_user**](docs/UserApi.md#get_user) | **GET** /gdvservice/v1/users/{code} | Retrieve the gdv tenant user
*UserApi* | [**list_users**](docs/UserApi.md#list_users) | **GET** /gdvservice/v1/users | List gdv tenant users
*UserApi* | [**update_user**](docs/UserApi.md#update_user) | **PUT** /gdvservice/v1/users/{code} | Update the gdv tenant user
*VbasApi* | [**create_vba**](docs/VbasApi.md#create_vba) | **POST** /gdvservice/v1/vbas | Create the vba
*VbasApi* | [**get_vba**](docs/VbasApi.md#get_vba) | **GET** /gdvservice/v1/vbas/{code} | Retrieve the vba
*VbasApi* | [**list_vbas**](docs/VbasApi.md#list_vbas) | **GET** /gdvservice/v1/vbas | List vbas
*VbasApi* | [**update_vba**](docs/VbasApi.md#update_vba) | **PUT** /gdvservice/v1/vbas/{code} | Update the vba
*VbuApi* | [**create_vbu**](docs/VbuApi.md#create_vbu) | **POST** /gdvservice/v1/vbus/create-vbu | 
*VbuApi* | [**create_vbuv**](docs/VbuApi.md#create_vbuv) | **POST** /gdvservice/v1/vbus/create-vbuv | 
*VbuApi* | [**get_vbu**](docs/VbuApi.md#get_vbu) | **GET** /gdvservice/v1/vbus/{code} | Retrieve the vbu
*VbuApi* | [**list_vbus**](docs/VbuApi.md#list_vbus) | **GET** /gdvservice/v1/vbus | List vbus
*VbuApi* | [**update_vbu**](docs/VbuApi.md#update_vbu) | **PUT** /gdvservice/v1/vbus/{code} | Update the vbu
*ZipCodeApi* | [**get_zip_code**](docs/ZipCodeApi.md#get_zip_code) | **GET** /gdvservice/v1/zipcodes/{code} | Retrieve the zip code
*ZipCodeApi* | [**list_zip_codes**](docs/ZipCodeApi.md#list_zip_codes) | **GET** /gdvservice/v1/zipcodes | List zip codes
*ZipCodeApi* | [**store_zip_codes**](docs/ZipCodeApi.md#store_zip_codes) | **POST** /gdvservice/v1/zipcodes | Create the zip codes
*DefaultApi* | [**check**](docs/DefaultApi.md#check) | **GET** /gdvservice/health | 


## Documentation For Models

 - [AddressClass](docs/AddressClass.md)
 - [CreateMailboxRequestDto](docs/CreateMailboxRequestDto.md)
 - [CreateUserRequestDto](docs/CreateUserRequestDto.md)
 - [CreateUserResponseClass](docs/CreateUserResponseClass.md)
 - [CreateVbaRequestDto](docs/CreateVbaRequestDto.md)
 - [CreateVbaResponseClass](docs/CreateVbaResponseClass.md)
 - [CreateVbuRequestDto](docs/CreateVbuRequestDto.md)
 - [CreateVbuResponseClass](docs/CreateVbuResponseClass.md)
 - [CreateVbuvRequestDto](docs/CreateVbuvRequestDto.md)
 - [CreateVbuvResponseClass](docs/CreateVbuvResponseClass.md)
 - [GetRequestMessageResponseClass](docs/GetRequestMessageResponseClass.md)
 - [GetResponseMessageResponseClass](docs/GetResponseMessageResponseClass.md)
 - [GetUserResponseClass](docs/GetUserResponseClass.md)
 - [GetVbaResponseClass](docs/GetVbaResponseClass.md)
 - [GetVbuResponseClass](docs/GetVbuResponseClass.md)
 - [GetZipCodeResponseClass](docs/GetZipCodeResponseClass.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse503](docs/InlineResponse503.md)
 - [ListAllMessagesResponseClass](docs/ListAllMessagesResponseClass.md)
 - [ListRequestsMessagesResponseClass](docs/ListRequestsMessagesResponseClass.md)
 - [ListResponsesMessagesResponseClass](docs/ListResponsesMessagesResponseClass.md)
 - [ListUsersResponseClass](docs/ListUsersResponseClass.md)
 - [ListVbasResponseClass](docs/ListVbasResponseClass.md)
 - [ListVbusResponseClass](docs/ListVbusResponseClass.md)
 - [ListZipCodesResponseClass](docs/ListZipCodesResponseClass.md)
 - [MessageClass](docs/MessageClass.md)
 - [RequestDetailsClass](docs/RequestDetailsClass.md)
 - [RequestMessageClass](docs/RequestMessageClass.md)
 - [ResponseDetailsClass](docs/ResponseDetailsClass.md)
 - [ResponseMessageClass](docs/ResponseMessageClass.md)
 - [StoreZipCodesRequestDto](docs/StoreZipCodesRequestDto.md)
 - [StoreZipCodesResponseClass](docs/StoreZipCodesResponseClass.md)
 - [UpdateRequestMessageRequestDto](docs/UpdateRequestMessageRequestDto.md)
 - [UpdateRequestMessageResponseClass](docs/UpdateRequestMessageResponseClass.md)
 - [UpdateResponseMessageRequestDto](docs/UpdateResponseMessageRequestDto.md)
 - [UpdateResponseMessageResponseClass](docs/UpdateResponseMessageResponseClass.md)
 - [UpdateUserRequestDto](docs/UpdateUserRequestDto.md)
 - [UpdateUserResponseClass](docs/UpdateUserResponseClass.md)
 - [UpdateVbaRequestDto](docs/UpdateVbaRequestDto.md)
 - [UpdateVbuRequestDto](docs/UpdateVbuRequestDto.md)
 - [UpdateVbuResponseClass](docs/UpdateVbuResponseClass.md)
 - [UserClass](docs/UserClass.md)
 - [VbaClass](docs/VbaClass.md)
 - [VbaResponseClass](docs/VbaResponseClass.md)
 - [VbuClass](docs/VbuClass.md)
 - [VbuResponseClass](docs/VbuResponseClass.md)
 - [XlsxZipCodeDto](docs/XlsxZipCodeDto.md)
 - [ZipCodeClass](docs/ZipCodeClass.md)


## Documentation For Authorization


## bearer

- **Type**: Bearer authentication (JWT)


## Author

kontakt@emil.de


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in eis.gdv.apis and eis.gdv.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from eis.gdv.api.default_api import DefaultApi`
- `from eis.gdv.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import eis.gdv
from eis.gdv.apis import *
from eis.gdv.models import *
```

