"""
    EMIL GdvService

    The EMIL GdvService API description  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: kontakt@emil.de
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from eis.gdv.api_client import ApiClient, Endpoint as _Endpoint
from eis.gdv.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from eis.gdv.model.create_vbu_request_dto import CreateVbuRequestDto
from eis.gdv.model.create_vbu_response_class import CreateVbuResponseClass
from eis.gdv.model.create_vbuv_request_dto import CreateVbuvRequestDto
from eis.gdv.model.create_vbuv_response_class import CreateVbuvResponseClass
from eis.gdv.model.get_vbu_response_class import GetVbuResponseClass
from eis.gdv.model.list_vbus_response_class import ListVbusResponseClass
from eis.gdv.model.update_vbu_request_dto import UpdateVbuRequestDto
from eis.gdv.model.update_vbu_response_class import UpdateVbuResponseClass


class VbuApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_vbu_endpoint = _Endpoint(
            settings={
                'response_type': (CreateVbuResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/gdvservice/v1/vbus/create-vbu',
                'operation_id': 'create_vbu',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_vbu_request_dto',
                    'authorization',
                ],
                'required': [
                    'create_vbu_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_vbu_request_dto':
                        (CreateVbuRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'create_vbu_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_vbuv_endpoint = _Endpoint(
            settings={
                'response_type': (CreateVbuvResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/gdvservice/v1/vbus/create-vbuv',
                'operation_id': 'create_vbuv',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_vbuv_request_dto',
                    'authorization',
                ],
                'required': [
                    'create_vbuv_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_vbuv_request_dto':
                        (CreateVbuvRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'create_vbuv_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_vbu_endpoint = _Endpoint(
            settings={
                'response_type': (GetVbuResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/gdvservice/v1/vbus/{code}',
                'operation_id': 'get_vbu',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'code',
                    'authorization',
                    'expand',
                ],
                'required': [
                    'code',
                ],
                'nullable': [
                ],
                'enum': [
                    'expand',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('expand',): {

                        "RESPONSES": "responses"
                    },
                },
                'openapi_types': {
                    'code':
                        (str,),
                    'authorization':
                        (str,),
                    'expand':
                        (str,),
                },
                'attribute_map': {
                    'code': 'code',
                    'authorization': 'Authorization',
                    'expand': 'expand',
                },
                'location_map': {
                    'code': 'path',
                    'authorization': 'header',
                    'expand': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_vbus_endpoint = _Endpoint(
            settings={
                'response_type': (ListVbusResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/gdvservice/v1/vbus',
                'operation_id': 'list_vbus',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'authorization',
                    'page_size',
                    'page_token',
                    'filter',
                    'search',
                    'order',
                    'expand',
                    'filters',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'authorization':
                        (str,),
                    'page_size':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'page_token':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'filter':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'search':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'order':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'expand':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'filters':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                    'page_size': 'pageSize',
                    'page_token': 'pageToken',
                    'filter': 'filter',
                    'search': 'search',
                    'order': 'order',
                    'expand': 'expand',
                    'filters': 'filters',
                },
                'location_map': {
                    'authorization': 'header',
                    'page_size': 'query',
                    'page_token': 'query',
                    'filter': 'query',
                    'search': 'query',
                    'order': 'query',
                    'expand': 'query',
                    'filters': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_vbu_endpoint = _Endpoint(
            settings={
                'response_type': (UpdateVbuResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/gdvservice/v1/vbus/{code}',
                'operation_id': 'update_vbu',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'code',
                    'update_vbu_request_dto',
                    'authorization',
                ],
                'required': [
                    'code',
                    'update_vbu_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'code':
                        (str,),
                    'update_vbu_request_dto':
                        (UpdateVbuRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'code': 'code',
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'code': 'path',
                    'update_vbu_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_vbu(
        self,
        create_vbu_request_dto,
        **kwargs
    ):
        """create_vbu  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_vbu(create_vbu_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            create_vbu_request_dto (CreateVbuRequestDto):

        Keyword Args:
            authorization (str): Bearer Token. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CreateVbuResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['create_vbu_request_dto'] = \
            create_vbu_request_dto
        return self.create_vbu_endpoint.call_with_http_info(**kwargs)

    def create_vbuv(
        self,
        create_vbuv_request_dto,
        **kwargs
    ):
        """create_vbuv  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_vbuv(create_vbuv_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            create_vbuv_request_dto (CreateVbuvRequestDto):

        Keyword Args:
            authorization (str): Bearer Token. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CreateVbuvResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['create_vbuv_request_dto'] = \
            create_vbuv_request_dto
        return self.create_vbuv_endpoint.call_with_http_info(**kwargs)

    def get_vbu(
        self,
        code,
        **kwargs
    ):
        """Retrieve the vbu  # noqa: E501

        Retrieves the details of the vbu that was previously created. Supply the unique vbu code that was returned when you created it and Emil Api will return the corresponding vbu information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vbu(code, async_req=True)
        >>> result = thread.get()

        Args:
            code (str): Unique identifier for the object.

        Keyword Args:
            authorization (str): Bearer Token. [optional]
            expand (str): You can expand policy in this endpoint.        By default, versions will be an empty array.. [optional] if omitted the server will use the default value of "responses"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetVbuResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['code'] = \
            code
        return self.get_vbu_endpoint.call_with_http_info(**kwargs)

    def list_vbus(
        self,
        **kwargs
    ):
        """List vbus  # noqa: E501

        Returns a list of vbus you have previously created. The vbus are returned in sorted order, with the oldest one appearing first. For more information about pagination, read the Pagination documentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_vbus(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            authorization (str): Bearer Token. [optional]
            page_size (bool, date, datetime, dict, float, int, list, str, none_type): A limit on the number of objects to be returned.     Limit ranges between 1 and 50. Default: 10.. [optional]
            page_token (bool, date, datetime, dict, float, int, list, str, none_type): A cursor for use in pagination.     pageToken is an ID that defines your place in the list.     For instance, if you make a list request and receive 100 objects and pageToken=1,     your subsequent call can include pageToken=2 in order to fetch the next page of the list.. [optional]
            filter (bool, date, datetime, dict, float, int, list, str, none_type): Filter the response by one or multiple fields. In general, fetching filtered responses will       conserve bandwidth and reduce response time.<br/>       <br/>       <i>Allowed values: id, code, leadNumber, policyNumber, leadCode, policyCode, customerName</i>       <br/>       <i>policyCode</i> is required, other filters are optional.. [optional]
            search (bool, date, datetime, dict, float, int, list, str, none_type): To search the list by any field, pass search=xxx to fetch the result.. [optional]
            order (bool, date, datetime, dict, float, int, list, str, none_type): Order allowing you to specify the desired order of entities retrieved from the server.<br/>     <br/>     <i>Allowed values: id, code, transmissionStart, createdAt, updatedAt</i>. [optional]
            expand (bool, date, datetime, dict, float, int, list, str, none_type): No expanding supported. [optional]
            filters (bool, date, datetime, dict, float, int, list, str, none_type): Filters the response by one or multiple fields.          Advanced filter functionality allows you to perform more complex filtering operations.          In general, fetching filtered responses conserves bandwidth and reduces response time.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListVbusResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_vbus_endpoint.call_with_http_info(**kwargs)

    def update_vbu(
        self,
        code,
        update_vbu_request_dto,
        **kwargs
    ):
        """Update the vbu  # noqa: E501

        Updates the specified vbu by setting the values of the parameters passed. Any parameters not provided will be left unchanged.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vbu(code, update_vbu_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            code (str): Unique identifier for the object.
            update_vbu_request_dto (UpdateVbuRequestDto):

        Keyword Args:
            authorization (str): Bearer Token. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UpdateVbuResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['code'] = \
            code
        kwargs['update_vbu_request_dto'] = \
            update_vbu_request_dto
        return self.update_vbu_endpoint.call_with_http_info(**kwargs)

