from __future__ import unicode_literals

import re


def check_for_drop(s):
    return not not re.search('(drop\s+)', s, re.IGNORECASE)


class Statements(list):

    def __init__(self, *args, **kwargs):
        self.safe = True
        super(Statements, self).__init__(*args, **kwargs)

    @property
    def sql(self):
        if self.safe:
            self.raise_if_unsafe()
        if not self:
            return ''

        return '\n\n'.join(self) + '\n\n'

    def raise_if_unsafe(self):
        if any(check_for_drop(s) for s in self):
            raise UnsafeMigrationException(
                'unsafe/destructive change being autogenerated, refusing to carry on further'
            )

    def __add__(self, other):
        self += list(other)
        return self


class UnsafeMigrationException(Exception):
    pass
