# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.


_autopystampl = False
try:
    import matplotlib.pyplot as plt
    _autopystampl=True
except:
    print("Error: matplotlib is not installed, drawing functions disabled")



from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _autopysta
else:
    import _autopysta

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _autopysta.delete_SwigPyIterator

    def value(self):
        return _autopysta.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _autopysta.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _autopysta.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _autopysta.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _autopysta.SwigPyIterator_equal(self, x)

    def copy(self):
        return _autopysta.SwigPyIterator_copy(self)

    def next(self):
        return _autopysta.SwigPyIterator_next(self)

    def __next__(self):
        return _autopysta.SwigPyIterator___next__(self)

    def previous(self):
        return _autopysta.SwigPyIterator_previous(self)

    def advance(self, n):
        return _autopysta.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _autopysta.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _autopysta.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _autopysta.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _autopysta.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _autopysta.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _autopysta.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _autopysta:
_autopysta.SwigPyIterator_swigregister(SwigPyIterator)

def version():
    r"""
    Get the software version information.

    This function returns a string that contains the current version of the software, along
    with the build date, time, and the system platform (Linux or Windows). It also includes
    the version of Python being used in the environment.

    :rtype: string
    :return: A string containing version, build date, system platform, and Python version.
    """
    return _autopysta.version()
class test(object):
    r"""
    A utility class that provides common testing functions.

    This class contains utility functions for common tasks like checking if a number falls
    within a range and checking the length of a vector. It is designed to be a lightweight
    helper for various validation tasks.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def range_inc(number, min, max):
        r"""
        Check if a number is within an inclusive range.

        This method checks whether a given number lies between a minimum and a maximum value
        (both bounds inclusive).

        :type number: float
        :param number: The number to be checked.
        :type min: float
        :param min: The minimum allowable value.
        :type max: float
        :param max: The maximum allowable value.
        :rtype: boolean
        :return: True if the number lies within the range, false otherwise.
        """
        return _autopysta.test_range_inc(number, min, max)

    def __init__(self):
        _autopysta.test_swiginit(self, _autopysta.new_test())
    __swig_destroy__ = _autopysta.delete_test

# Register test in _autopysta:
_autopysta.test_swigregister(test)
class RandomGenerator(object):
    r"""
    Utility class for generating random numbers using various distributions.

    `RandomGenerator` provides static methods for generating random values from:
    - Uniform distributions ([0,1] or [a,b])
    - Normal (Gaussian) distribution
    - Logistic distribution

    The class uses a Mersenne Twister engine to produce high-quality random numbers.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def init(*args):
        r"""
        Initialize the random number generator with a seed.

        This method initializes the Mersenne Twister generator using the current time as the seed.
        This ensures that the generator produces different random sequences each time the program runs.
        :type seed: int, optional
        :param seed: Optional seed for the random generator. Uses current time if not provided.
        """
        return _autopysta.RandomGenerator_init(*args)

    @staticmethod
    def uniform(a=0.0, b=1.0):
        r"""
        Generate a random value from a uniform distribution [a, b].

        This method returns a random value sampled from a uniform distribution with bounds `a` and `b`.

        :type a: float, optional
        :param a: The minimum value of the distribution.
        :type b: float, optional
        :param b: The maximum value of the distribution.
        :rtype: float
        :return: A random double value between `a` and `b`.
        """
        return _autopysta.RandomGenerator_uniform(a, b)

    @staticmethod
    def uniform01():
        r"""
        Generate a random value from a standard uniform distribution [0, 1].

        This method returns a random value sampled from a uniform distribution between 0 and 1.

        :rtype: float
        :return: A random double value between 0 and 1.
        """
        return _autopysta.RandomGenerator_uniform01()

    @staticmethod
    def logistic(location=0.0, scale=1.0):
        r"""
        Generate a random value from a logistic distribution.

        This method returns a random value sampled from a logistic distribution with location `mu` and scale `s`.
        The logistic distribution is commonly used in various models, including machine learning and statistics.

        :param mu: The location parameter of the logistic distribution (mean).
        :param s: The scale parameter (related to the standard deviation).
        :rtype: float
        :return: A random double value sampled from a logistic distribution.
        """
        return _autopysta.RandomGenerator_logistic(location, scale)

    @staticmethod
    def normal(mean=0.0, stddev=1.0):
        r"""
        Generates a random value from a normal (Gaussian) distribution.

        :type mean: float, optional
        :param mean: The mean of the normal distribution.
        :type stddev: float, optional
        :param stddev: The standard deviation of the normal distribution.
        :rtype: float
        :return: A random double from the specified normal distribution.
        """
        return _autopysta.RandomGenerator_normal(mean, stddev)

    def __init__(self):
        _autopysta.RandomGenerator_swiginit(self, _autopysta.new_RandomGenerator())
    __swig_destroy__ = _autopysta.delete_RandomGenerator

# Register RandomGenerator in _autopysta:
_autopysta.RandomGenerator_swigregister(RandomGenerator)
class params(object):
    r"""
    Base class for car-following model parameters.

    This class is a base class that stores common or general parameters used by various car-following models.
    Specific models, such as `newell`, will have their own parameter sets that inherit from this class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
         Default constructor for the params class.
        Initializes the base class for car-following model parameters.
        """
        _autopysta.params_swiginit(self, _autopysta.new_params())
    __swig_destroy__ = _autopysta.delete_params

# Register params in _autopysta:
_autopysta.params_swigregister(params)
class params_cust(params):
    r"""
    Custom parameters class for storing key-value pairs.

    This class inherits from the `params` class and stores custom parameters in a dictionary-like structure.
    The `params_cust` class allows for flexible key-value pair storage of parameters.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    map = property(_autopysta.params_cust_map_get, _autopysta.params_cust_map_set, doc=r""" Dictionary storing custom parameters.""")

    def __init__(self):
        r"""Initializes the dictionary for custom parameters."""
        _autopysta.params_cust_swiginit(self, _autopysta.new_params_cust())

    def add(self, new_name, new_value):
        r"""
         Adds a new parameter to the dictionary.
        Adds a new parameter to the dictionary.

        :type new_name: string
        :param new_name: Key or name of the parameter.
        :type new_value: float
        :param new_value: Value associated with the parameter.
        """
        return _autopysta.params_cust_add(self, new_name, new_value)

    def get(self, name):
        r"""
        Retrieves the value of a parameter by its key.

        :type name: string
        :param name: Key or name of the parameter to retrieve.
        :rtype: float
        :return: The value associated with the given key.
        """
        return _autopysta.params_cust_get(self, name)
    __swig_destroy__ = _autopysta.delete_params_cust

# Register params_cust in _autopysta:
_autopysta.params_cust_swigregister(params_cust)
class p_gipps(params):
    r"""
    Parameter class for the Gipps car-following model.

    This class stores the parameters required for simulating vehicle behavior in the Gipps car-following model.
    The parameters represent key driver behaviors and vehicle constraints, such as:

    - an: Maximum acceleration that the driver is willing to undertake.

    - bn: Maximum deceleration (braking) that the driver considers safe.

    - sn: Jam spacing, the minimum distance the driver maintains when the vehicle is stopped.

    - vn: Free-flow speed, the desired speed when no vehicles are ahead.

    - tau: Reaction time, the time it takes for the driver to respond to the vehicle ahead.

    - bg: Leader's estimated maximum deceleration, used to predict the worst-case scenario for sudden braking.

    These parameters are essential for reproducing realistic traffic behavior in simulations, such as maintaining safe
    following distances and appropriate speed adjustments in response to changing traffic conditions.

    Reference: Gipps, P.G. (1981), "A Behavioural Car-Following Model for Computer Simulation",
    Transport Research Part B, Vol. 15, pp. 105-111.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    an = property(_autopysta.p_gipps_an_get, _autopysta.p_gipps_an_set, doc=r""" Maximum acceleration in m/s².""")
    bn = property(_autopysta.p_gipps_bn_get, _autopysta.p_gipps_bn_set, doc=r""" Maximum deceleration (braking) in m/s².""")
    sn = property(_autopysta.p_gipps_sn_get, _autopysta.p_gipps_sn_set, doc=r""" Jam spacing in meters (the minimum safe distance between stopped vehicles).""")
    vn = property(_autopysta.p_gipps_vn_get, _autopysta.p_gipps_vn_set, doc=r""" Free-flow speed in m/s (default value: 120 km/h).""")
    tau = property(_autopysta.p_gipps_tau_get, _autopysta.p_gipps_tau_set, doc=r""" Driver's reaction time in seconds.""")
    bg = property(_autopysta.p_gipps_bg_get, _autopysta.p_gipps_bg_set, doc=r""" Estimated maximum deceleration of the leader in m/s².""")

    def __init__(self, *args):
        r"""
        *Overload 1:*
         Default constructor for p_gipps.
        Initializes the parameters with default values based on general traffic conditions:
        an = 1.7 m/s² (maximum acceleration),
        bn = -3.4 m/s² (maximum deceleration),
        sn = 6.5 meters (jam spacing),
        vn = 120 km/h (free-flow speed),
        tau = 0.8 seconds (reaction time),
        bg = -3.2 m/s² (leader's estimated maximum deceleration).

        |

        *Overload 2:*
         Constructor with custom parameter values.
        This constructor allows initializing the parameters with custom values, allowing for specific
        scenarios to be modeled. These parameters correspond directly to driver and vehicle behaviors.

        :type an: float
        :param an:  Maximum acceleration in m/s².
        :type bn: float
        :param bn:  Maximum deceleration (braking) in m/s².
        :type sn: float
        :param sn:  Jam spacing in meters.
        :type vn: float
        :param vn:  Free-flow speed in m/s.
        :type tau: float
        :param tau: Reaction time in seconds.
        :type bg: float
        :param bg:  Leader's estimated maximum deceleration in m/s².
        """
        _autopysta.p_gipps_swiginit(self, _autopysta.new_p_gipps(*args))
    __swig_destroy__ = _autopysta.delete_p_gipps

# Register p_gipps in _autopysta:
_autopysta.p_gipps_swigregister(p_gipps)
class p_idm(params):
    r"""
    Parameters for the Intelligent Driver Model (IDM).

    This class contains the specific parameters for the Intelligent Driver Model (IDM), including
    maximum desired speed, acceleration and deceleration capabilities, and desired time headway.
    These parameters control the behavior of vehicles in the IDM and can be tuned based on empirical data.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    v0 = property(_autopysta.p_idm_v0_get, _autopysta.p_idm_v0_set, doc=r""" Maximum desired speed (m/s).""")
    T = property(_autopysta.p_idm_T_get, _autopysta.p_idm_T_set, doc=r""" Desired time headway (s).""")
    a = property(_autopysta.p_idm_a_get, _autopysta.p_idm_a_set, doc=r""" Maximum acceleration (m/s²).""")
    b = property(_autopysta.p_idm_b_get, _autopysta.p_idm_b_set, doc=r""" Comfortable deceleration (m/s²).""")
    dl = property(_autopysta.p_idm_dl_get, _autopysta.p_idm_dl_set, doc=r""" Acceleration exponent.""")
    s0 = property(_autopysta.p_idm_s0_get, _autopysta.p_idm_s0_set, doc=r""" Minimum gap (jam distance) in congested traffic (m).""")
    l = property(_autopysta.p_idm_l_get, _autopysta.p_idm_l_set, doc=r""" Vehicle length (m).""")

    def __init__(self, *args):
        r"""
        *Overload 1:*

        Default constructor with standard IDM parameters.

        Initializes the IDM parameters with default values based on empirical studies.

        See also: M. Treiber, A. Hennecke, and D. Helbing, "Congested traffic states in empirical observations
        and microscopic simulations," Phys. Rev. E, 62, 1805 (2000).

        |

        *Overload 2:*

        Constructor for IDM parameters with custom values.

        This constructor allows the user to define custom values for the IDM parameters, including
        maximum speed, time headway, and acceleration properties.

        :type v0: float
        :param v0: Maximum desired speed (m/s).
        :type T: float
        :param T: Desired time headway (s).
        :type a: float
        :param a: Maximum acceleration (m/s²).
        :type b: float
        :param b: Comfortable deceleration (m/s²).
        :type s0: float
        :param s0: Minimum gap in congested traffic (m).
        :type l: float
        :param l: Vehicle length (m).
        """
        _autopysta.p_idm_swiginit(self, _autopysta.new_p_idm(*args))
    __swig_destroy__ = _autopysta.delete_p_idm

# Register p_idm in _autopysta:
_autopysta.p_idm_swigregister(p_idm)
class p_linear(params):
    r"""
    Parameter class for the linear car-following model.

    This class stores the parameters used in the linear car-following model. These parameters include:

    - Free-flow speed (V): The desired speed when no vehicles are ahead.
    - Coefficients (c1, c2, c3): Constants that control the sensitivity to speed and spacing differences.
    - Jam spacing (sr): The minimum distance maintained between vehicles when stopped.
    - Reaction time (tau): The time it takes for the driver to react to changes in the vehicle ahead.

    These parameters are essential for simulating vehicle behavior in traffic flow.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    V = property(_autopysta.p_linear_V_get, _autopysta.p_linear_V_set, doc=r""" Free-flow speed in m/s (default value: 120 km/h).""")
    c1 = property(_autopysta.p_linear_c1_get, _autopysta.p_linear_c1_set, doc=r""" Coefficient for speed difference sensitivity.""")
    c2 = property(_autopysta.p_linear_c2_get, _autopysta.p_linear_c2_set, doc=r""" Coefficient for follower's speed difference sensitivity.""")
    c3 = property(_autopysta.p_linear_c3_get, _autopysta.p_linear_c3_set, doc=r""" Coefficient for spacing sensitivity.""")
    sr = property(_autopysta.p_linear_sr_get, _autopysta.p_linear_sr_set, doc=r""" Jam spacing (minimum distance between vehicles when stopped).""")
    tau = property(_autopysta.p_linear_tau_get, _autopysta.p_linear_tau_set, doc=r""" Driver's reaction time in seconds.""")

    def __init__(self, *args):
        r"""
        *Overload 1:*
         Default constructor for p_linear.
        Initializes the parameters with default values based on typical traffic conditions:
        Free-flow speed = 120 km/h, reaction time = 4/6 seconds, and default coefficients for speed and spacing.

        |

        *Overload 2:*
         Constructor with custom parameter values.
        This constructor allows setting custom values for the linear model parameters.

        :type V: float
        :param V: Free-flow speed in m/s.
        :type c1: float
        :param c1: Coefficient for speed difference sensitivity.
        :type c2: float
        :param c2: Coefficient for follower's speed difference sensitivity.
        :type c3: float
        :param c3: Coefficient for spacing sensitivity.
        :type sr: float
        :param sr: Jam spacing in meters.
        :type tau: float
        :param tau: Driver's reaction time in seconds.
        """
        _autopysta.p_linear_swiginit(self, _autopysta.new_p_linear(*args))
    __swig_destroy__ = _autopysta.delete_p_linear

# Register p_linear in _autopysta:
_autopysta.p_linear_swigregister(p_linear)
class p_martinez_jin_2020(object):
    r"""
    Parameter class for Martinez and Jin (2020) stochastic car-following model.

    This class defines the parameters for the Martinez and Jin (2020) model, an extension of Newell's car-following theory.
    The model accounts for heterogeneous driver behavior by introducing a wave travel time parameter (`tau`) and stochastic jam density.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    tau = property(_autopysta.p_martinez_jin_2020_tau_get, _autopysta.p_martinez_jin_2020_tau_set, doc=r""" Wave travel time (τ), controlling the delay in vehicle reactions to changes in traffic.""")

    def __init__(self, *args):
        r"""
        *Overload 1:*

        Default constructor for the p_martinez_jin_2020 parameter class.

        Initializes the model with default values for wave travel time (`tau`) and inherited parameters from the Newell model.

        |

        *Overload 2:*

        Constructor with custom parameter values.

        Allows setting custom values for the free-flow speed (`u`) and wave travel time (`tau`).

        :type u: float
        :param u: Free-flow speed in meters per second.
        :type tau: float
        :param tau: Wave travel time in seconds.
        """
        _autopysta.p_martinez_jin_2020_swiginit(self, _autopysta.new_p_martinez_jin_2020(*args))
    __swig_destroy__ = _autopysta.delete_p_martinez_jin_2020

# Register p_martinez_jin_2020 in _autopysta:
_autopysta.p_martinez_jin_2020_swigregister(p_martinez_jin_2020)
class p_newell_random_acceleration(object):
    r"""
    Parameter class for the random acceleration model based on Laval et al. (2014).

    This class manages the specific parameters required for Laval's random acceleration extension to Newell's car-following model. These parameters control the stochastic behavior of vehicles in traffic simulations.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    sigma_tilde = property(_autopysta.p_newell_random_acceleration_sigma_tilde_get, _autopysta.p_newell_random_acceleration_sigma_tilde_set, doc=r""" Standard deviation of the random acceleration term.""")
    beta = property(_autopysta.p_newell_random_acceleration_beta_get, _autopysta.p_newell_random_acceleration_beta_set, doc=r""" Inverse relaxation time, affecting the temporal responsiveness of vehicles.""")

    def __init__(self, *args):
        r"""
        *Overload 1:*

        Default constructor for the random acceleration parameters.

        Initializes the parameters with default values based on typical traffic conditions.

        |

        *Overload 2:*

        Constructor with custom parameter values.

        This constructor allows setting custom values for the standard deviation (`sigma_tilde`), inverse relaxation time (`beta`), as well as inherited parameters from p_newell.

        :type u: float
        :param u: Free-flow speed in meters per second.
        :type w: float
        :param w: Wave speed in meters per second.
        :type kj: float
        :param kj: Jam density in vehicles per meter.
        :type sigma_tilde: float
        :param sigma_tilde: Standard deviation of the random acceleration term.
        :type beta: float
        :param beta: Inverse relaxation time.
        """
        _autopysta.p_newell_random_acceleration_swiginit(self, _autopysta.new_p_newell_random_acceleration(*args))
    __swig_destroy__ = _autopysta.delete_p_newell_random_acceleration

# Register p_newell_random_acceleration in _autopysta:
_autopysta.p_newell_random_acceleration_swigregister(p_newell_random_acceleration)
class p_newell(params):
    r"""
    Parameter class for Newell's car-following model.

    The p_newell class manages the specific parameters required for Newell's car-following model.
    These parameters control the behavior of vehicles in free-flow and congested traffic conditions.

    Key Parameters:
    - Free-flow speed (`u`): The speed at which vehicles travel under free-flow conditions
      (i.e., no congestion). This is typically set in meters per second.
    - Wave speed (`w`): The speed at which congestion waves propagate backward through the
      traffic. This helps simulate how quickly disturbances in the flow of traffic spread.
    - Jam density (`kj`): The density of vehicles in a jammed traffic condition, which helps
      define the minimum spacing between vehicles.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    u = property(_autopysta.p_newell_u_get, _autopysta.p_newell_u_set, doc=r""" Free-flow speed in meters per second (default: 90 km/h).""")
    w = property(_autopysta.p_newell_w_get, _autopysta.p_newell_w_set, doc=r""" Wave speed in meters per second (default: 18 km/h).""")
    kj = property(_autopysta.p_newell_kj_get, _autopysta.p_newell_kj_set, doc=r""" Jam density in vehicles per meter (default: 0.15 vehicles/meter).""")

    def __init__(self, *args):
        r"""
        *Overload 1:*

        Default constructor for p_newell.

        Initializes the parameters with default values for free-flow speed, wave speed,
        and jam density. These defaults represent typical traffic conditions.

        Default Values:
        - Free-flow speed: 90 km/h
        - Wave speed: 18 km/h
        - Jam density: 0.15 vehicles per meter

        |

        *Overload 2:*

        Constructor with custom parameter values.

        This constructor allows setting custom values for free-flow speed (`u`), wave speed (`w`),
        and jam density (`kj`). These values can be used to simulate specific traffic scenarios.

        :type u: float
        :param u: Free-flow speed in meters per second.
        :type w: float
        :param w: Wave speed in meters per second.
        :type kj: float
        :param kj: Jam density in vehicles per meter.
        """
        _autopysta.p_newell_swiginit(self, _autopysta.new_p_newell(*args))
    __swig_destroy__ = _autopysta.delete_p_newell

# Register p_newell in _autopysta:
_autopysta.p_newell_swigregister(p_newell)
class Point(object):
    r"""
    Represents a point in time for a vehicle in a traffic simulation.

    The point class stores and manages the time, position, velocity,
    acceleration, and lane of a vehicle during simulation.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*

        Constructor for the Point class.

        Initializes the Point object with specified time, position, velocity,
        acceleration, and lane.

        :type time: float
        :param time: Initial time.
        :type position: float
        :param position: Initial position.
        :type velocity: float
        :param velocity: Initial velocity.
        :type acceleration: float
        :param acceleration: Initial acceleration.
        :type lane: int
        :param lane: Initial lane.

        |

        *Overload 2:*

        Copy constructor for the Point class.

        Creates a new Point object by copying values from another Point object.

        :type other: :py:class:`Point`
        :param other: Point object to duplicate.
        """
        _autopysta.Point_swiginit(self, _autopysta.new_Point(*args))

    def to_string(self):
        r"""
        Converts the Point object to a string representation.

        This function generates a string that represents the current state
        of the Point object.

        :rtype: string
        :return: A string representing the Point object.
        """
        return _autopysta.Point_to_string(self)

    def set_accel(self, _a):
        r"""
        Sets the acceleration of the point.

        :param newAcceleration: New acceleration value.
        """
        return _autopysta.Point_set_accel(self, _a)

    def set_velocity(self, _v):
        r"""
        Sets the velocity of the point.

        :param newVelocity: New velocity value.
        """
        return _autopysta.Point_set_velocity(self, _v)

    def set_x(self, _x):
        r"""
        Sets the position of the point.

        :param newPosition: New position value.
        """
        return _autopysta.Point_set_x(self, _x)

    def set_lane(self, _lane):
        r"""
        Sets the lane of the point.

        :param newLane: New lane value.
        """
        return _autopysta.Point_set_lane(self, _lane)

    def reset_time(self):
        r"""
        Resets the time of the point to zero.

        This function resets the time value of the point object to zero.
        """
        return _autopysta.Point_reset_time(self)

    def T(self):
        r"""
        Gets the time value.

        :rtype: float
        :return: Current time value.
        """
        return _autopysta.Point_T(self)

    def X(self):
        r"""
        Gets the position value.

        :rtype: float
        :return: Current position value.
        """
        return _autopysta.Point_X(self)

    def V(self):
        r"""
        Gets the velocity value.

        :rtype: float
        :return: Current velocity value.
        """
        return _autopysta.Point_V(self)

    def A(self):
        r"""
        Gets the acceleration value.

        :rtype: float
        :return: Current acceleration value.
        """
        return _autopysta.Point_A(self)

    def LANE(self):
        r"""
        Gets the lane value.

        :rtype: int
        :return: Current lane value.
        """
        return _autopysta.Point_LANE(self)
    __swig_destroy__ = _autopysta.delete_Point

# Register Point in _autopysta:
_autopysta.Point_swigregister(Point)
class GeneralizedTrajectory(object):
    r"""
    Base class for different types of trajectories.

    This class provides an interface for retrieving points in a trajectory. Both `trajectory` and
    `static_trajectory` classes inherit from this class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def get_current_point(self):
        r"""
        Get the current point of the trajectory.

        :rtype: :py:class:`Point`
        :return: Pointer to the current point.
        """
        return _autopysta.GeneralizedTrajectory_get_current_point(self)
    __swig_destroy__ = _autopysta.delete_GeneralizedTrajectory

# Register GeneralizedTrajectory in _autopysta:
_autopysta.GeneralizedTrajectory_swigregister(GeneralizedTrajectory)
class Trajectory(GeneralizedTrajectory):
    r"""
    Represents a dynamic trajectory of a moving object.

    This class stores a series of `point` objects that define the trajectory of a moving vehicle.
    It allows retrieving points using integer or floating-point indices, and handles extrapolation
    for negative indices.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, starting_point):
        r"""
        Constructs a trajectory with an initial starting point.

        :type starting_point: :py:class:`Point`
        :param starting_point: Initial point of the trajectory.
        """
        _autopysta.Trajectory_swiginit(self, _autopysta.new_Trajectory(starting_point))

    def push_back(self, point):
        r"""
        Adds a point to the trajectory.

        :type point: :py:class:`Point`
        :param point: Pointer to the point to add.
        """
        return _autopysta.Trajectory_push_back(self, point)

    def add_point(self, point):
        r"""
        Adds a point to the trajectory.

        :type point: :py:class:`Point`
        :param point: Pointer to the point to add.
        """
        return _autopysta.Trajectory_add_point(self, point)

    def add_and_return(self, new_point):
        r"""
        Adds a point and returns it.

        :type new_point: :py:class:`Point`
        :param new_point: Pointer to the new point to add.
        :rtype: :py:class:`Point`
        :return: The added point.
        """
        return _autopysta.Trajectory_add_and_return(self, new_point)

    def get_point_at(self, index):
        r"""
        Retrieves a point at the specified index.

        :type index: int
        :param index: Index of the point to retrieve.
        :rtype: :py:class:`Point`
        :return: Pointer to the point at the specified index.
        """
        return _autopysta.Trajectory_get_point_at(self, index)

    def get_trajectory_length(self):
        r"""
        Returns the length of the trajectory.

        :rtype: int
        :return: Number of points in the trajectory.
        """
        return _autopysta.Trajectory_get_trajectory_length(self)

    def get_current_point(self):
        r"""
        Gets the current position of the vehicle in the trajectory.

        :rtype: :py:class:`Point`
        :return: The current point.
        """
        return _autopysta.Trajectory_get_current_point(self)

    def __getitem__(self, i):
        return _autopysta.Trajectory___getitem__(self, i)

    def __len__(self):
        return _autopysta.Trajectory___len__(self)
    __swig_destroy__ = _autopysta.delete_Trajectory

# Register Trajectory in _autopysta:
_autopysta.Trajectory_swigregister(Trajectory)
class StaticTrajectory(GeneralizedTrajectory):
    r"""
    Represents a static trajectory for a fixed object on the road.

    This class handles the trajectory of static objects (such as a fixed vehicle or roadblock).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, fixed_position):
        r"""
        Constructs a static trajectory with a fixed position.

        :type fixed_position: :py:class:`Point`
        :param fixed_position: The position of the static object.
        """
        _autopysta.StaticTrajectory_swiginit(self, _autopysta.new_StaticTrajectory(fixed_position))

    def get_current_point(self):
        r"""
        Returns the current position of the static object.

        :rtype: :py:class:`Point`
        :return: The current position as a point.
        """
        return _autopysta.StaticTrajectory_get_current_point(self)
    __swig_destroy__ = _autopysta.delete_StaticTrajectory

# Register StaticTrajectory in _autopysta:
_autopysta.StaticTrajectory_swigregister(StaticTrajectory)
class Model(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def free_flow_speed(self, *args):
        return _autopysta.Model_free_flow_speed(self, *args)

    def new_point(self, *args):
        return _autopysta.Model_new_point(self, *args)
    __swig_destroy__ = _autopysta.delete_Model

# Register Model in _autopysta:
_autopysta.Model_swigregister(Model)
class gipps(Model):
    r"""
    Gipps car-following model (1981).

    This class implements the Gipps (1981) car-following model, which aims to simulate the
    behavior of vehicles in a traffic stream, particularly how a vehicle responds to the
    movement of the preceding vehicle. The model is based on realistic driver and vehicle
    behavior constraints such as maximum acceleration, braking, and desired speeds.

    The model introduces two main constraints:
    - A free acceleration component that limits acceleration as the vehicle approaches its desired speed.
    - A braking component that ensures the vehicle can safely stop if the vehicle ahead brakes suddenly.

    Reference: Gipps, P.G. (1981), "A Behavioural Car-Following Model for Computer Simulation",
    Transport Research Part B, Vol. 15, pp. 105-111.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*

        Default constructor for the Gipps model.

        Initializes the model with default parameter values, including default values for
        maximum acceleration, braking, and reaction time.

        |

        *Overload 2:*

        Constructor with custom parameters for the Gipps model.

        Initializes the model with a custom set of parameters, allowing the simulation to
        represent different vehicle and driver behaviors.

        :type p: :py:class:`p_gipps`
        :param p: A pointer to a p_gipps parameter class containing the custom parameters.
        """
        _autopysta.gipps_swiginit(self, _autopysta.new_gipps(*args))

    def validate_parameters(self, *args):
        r"""
        Validates the parameters of the Gipps model.

        Ensures that the parameters for maximum acceleration, braking, and reaction time are
        non-zero and valid. If invalid, an exception is thrown.

        :type p: :py:class:`params`, optional
        :param p: Parameters for the Gipps model. If null, the model uses its default parameters.
        """
        return _autopysta.gipps_validate_parameters(self, *args)

    def equil_spcg(self, *args):
        r"""
        Computes the equilibrium spacing between vehicles according to the Gipps model.

        The equilibrium spacing is the safe distance that vehicles should maintain, accounting for
        the vehicle's speed and the driver's braking limits.

        :type vl: float
        :param vl: The velocity of the leader vehicle.
        :type vf: float
        :param vf: The velocity of the follower vehicle.
        :type p: :py:class:`params`, optional
        :param p: Parameters for the Gipps model. If null, the model uses its default parameters.
        :rtype: float
        :return: The equilibrium spacing between the vehicles.
        """
        return _autopysta.gipps_equil_spcg(self, *args)

    def wave_speed(self, leader, follower, p):
        r"""
        This function is a placeholder for the wave speed calculation. In the Gipps model,
        the wave speed is not explicitly calculated.

        :type leader: :py:class:`Point`
        :param leader: A point representing the leader's position and speed.
        :type follower: :py:class:`Point`
        :param follower: A point representing the follower's position and speed.
        :type p: :py:class:`params`
        :param p: Parameters for the Gipps model.
        :rtype: float
        :return: Always returns zero (0.0).
        """
        return _autopysta.gipps_wave_speed(self, leader, follower, p)

    def free_flow_speed(self, *args):
        r"""
        Computes the free-flow speed for the Gipps model.
        The free-flow speed represents the maximum speed the vehicle can travel at, assuming
        there is no interaction with other vehicles ahead (i.e., no leader).

        :type p: :py:class:`params`, optional
        :param p: Parameters for the Gipps model. If null, the model uses its default parameters.
        :rtype: float
        :return: The free-flow speed of the vehicle.
        """
        return _autopysta.gipps_free_flow_speed(self, *args)

    def new_point(self, *args):
        r"""
        Computes the next point in the follower's trajectory based on the leader's movement.
        This function computes the next position, speed, and acceleration of the follower vehicle
        based on the current position of both the leader and follower vehicles. The model applies
        both acceleration and braking constraints to ensure safe car-following behavior.

        :type leader: :py:class:`GeneralizedTrajectory`
        :param leader: Generalized trajectory of the leader vehicle.
        :type follower: :py:class:`Trajectory`
        :param follower: Trajectory of the follower vehicle.
        :type p: :py:class:`params`, optional
        :param p: Parameters for the Gipps model. If null, the model uses its default parameters.
        :rtype: :py:class:`Point`
        :return: A new point representing the updated position, speed, and acceleration of the follower.
        """
        return _autopysta.gipps_new_point(self, *args)

# Register gipps in _autopysta:
_autopysta.gipps_swigregister(gipps)
class idm(Model):
    r"""
    The Intelligent Driver Model (IDM) for car-following behavior.

    This class implements the IDM, a widely used microscopic traffic model for simulating
    car-following behavior. The model computes the acceleration of vehicles based on the
    distance to the leading vehicle, the relative velocity, and various model parameters.

    The IDM captures the transition between free-flow, congested traffic, and stop-and-go waves
    based on a nonlinear formulation of acceleration and braking.

    Notes: Reference: M. Treiber, A. Hennecke, and D. Helbing, "Congested traffic states in empirical
    observations and microscopic simulations," Phys. Rev. E, 62, 1805 (2000).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*

        Default constructor for the IDM model.

        Initializes the IDM model with default parameters.

        |

        *Overload 2:*

        Constructor for the IDM model with custom parameters.

        Initializes the IDM model with custom parameters specified in the `p_idm` parameter object.

        :type pars: :py:class:`p_idm`
        :param pars: Pointer to the IDM-specific parameters.
        """
        _autopysta.idm_swiginit(self, _autopysta.new_idm(*args))

    def equil_spcg(self, vl, vf, q=None):
        r"""
        Computes the equilibrium spacing between the leader and follower.

        Calculates the equilibrium spacing based on the velocities of the leader and follower vehicles.
        The equilibrium spacing increases with the follower's speed and is influenced by parameters
        like the safe time headway and jam distance.

        :type vl: float
        :param vl: Velocity of the leader.
        :type vf: float
        :param vf: Velocity of the follower.
        :type q: :py:class:`params`, optional
        :param q: Pointer to the IDM parameters. If null, default parameters are used.
        :rtype: float
        :return: The equilibrium spacing.
        """
        return _autopysta.idm_equil_spcg(self, vl, vf, q)

    def wave_speed(self, leader, follower, p):
        r"""
        Computes the wave speed in a traffic disturbance.

        Calculates the wave speed of a traffic disturbance, typically returning 0 unless overridden.

        :type leader: :py:class:`Point`
        :param leader: A point representing the leader's position and velocity.
        :type follower: :py:class:`Point`
        :param follower: A point representing the follower's position and velocity.
        :type p: :py:class:`params`
        :param p: Pointer to the IDM parameters.
        :rtype: float
        :return: The wave speed.
        """
        return _autopysta.idm_wave_speed(self, leader, follower, p)

    def free_flow_speed(self, p=None):
        r"""
        Returns the free-flow speed of the IDM model.

        The free-flow speed is the speed that vehicles would travel at in the absence of traffic.

        :type p: :py:class:`params`, optional
        :param p: Pointer to the IDM parameters. If null, default parameters are used.
        :rtype: float
        :return: The free-flow speed.
        """
        return _autopysta.idm_free_flow_speed(self, p)

# Register idm in _autopysta:
_autopysta.idm_swigregister(idm)
class newell(Model):
    r"""
    Newell's car-following model (2002).

    This class implements Newell's car-following model, which is a simplified model
    that describes how vehicles follow one another in traffic. The model assumes that
    each vehicle follows the same trajectory as the vehicle in front but delayed by
    a time gap (τ) and space gap (δ). These parameters are derived from the wave
    speed (w) and jam density (kj), which are the core elements of the model.

    Notes: Reference: Newell, G. F. (2002). "A Simplified Car-Following Theory: A Lower Order Model."
    Institute of Transportation Studies, University of California, Berkeley.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*

        Default constructor for Newell's model.

        This constructor initializes the model using default values for the wave speed (w),
        jam density (kj), and free-flow speed.

        |

        *Overload 2:*

        Constructor for Newell's model with custom parameters.

        This constructor allows initializing the model with custom values for the wave speed,
        jam density, and free-flow speed using the p_newell parameter class.

        :type p: :py:class:`p_newell`
        :param p: Pointer to the p_newell class containing the parameters for Newell's model.
        """
        _autopysta.newell_swiginit(self, _autopysta.new_newell(*args))

    def equil_spcg(self, vl, vf, p=None):
        r"""
        Computes the equilibrium spacing between the leader and follower vehicles.

        This method calculates the equilibrium spacing between the leader and follower vehicles
        based on their velocities. The equilibrium spacing increases with higher speeds.

        :type vl: float
        :param vl: The velocity of the leader vehicle.
        :type vf: float
        :param vf: The velocity of the follower vehicle.
        :type p: :py:class:`params`, optional
        :param p: Pointer to the parameters for Newell's model.
        :rtype: float
        :return: The computed equilibrium spacing between the vehicles.
        """
        return _autopysta.newell_equil_spcg(self, vl, vf, p)

    def wave_speed(self, leader, follower, p):
        r"""
        Returns the wave speed for Newell's model.

        The wave speed represents the speed at which traffic disturbances propagate backward
        through a line of vehicles in congestion.

        :type leader: :py:class:`Point`
        :param leader: A point representing the leader's position and speed.
        :type follower: :py:class:`Point`
        :param follower: A point representing the follower's position and speed.
        :type p: :py:class:`params`
        :param p: Parameters for Newell's model.
        :rtype: float
        :return: The wave speed.
        """
        return _autopysta.newell_wave_speed(self, leader, follower, p)

    def free_flow_speed(self, p=None):
        r"""
        Returns the free-flow speed for Newell's model.

        The free-flow speed is the maximum speed at which vehicles travel when there is no congestion.

        :type p: :py:class:`params`, optional
        :param p: Parameters for Newell's model.
        :rtype: float
        :return: The free-flow speed of the model.
        """
        return _autopysta.newell_free_flow_speed(self, p)

    def new_point(self, leader, follower, p=None):
        r"""
        Computes the next point in the follower's trajectory using generalized trajectories.

        This method calculates the next point in the follower vehicle's trajectory by considering
        both the leader and follower's current trajectories. It applies Newell's piecewise linear
        trajectory rule to compute the follower's next position and velocity.

        :type leader: :py:class:`GeneralizedTrajectory`
        :param leader: Generalized trajectory representing the leader vehicle's path.
        :type follower: :py:class:`Trajectory`
        :param follower: Trajectory representing the follower vehicle's path.
        :type p: :py:class:`params`, optional
        :param p: Parameters for Newell's model.
        :rtype: :py:class:`Point`
        :return: A point representing the follower's updated position and speed.
        """
        return _autopysta.newell_new_point(self, leader, follower, p)

# Register newell in _autopysta:
_autopysta.newell_swigregister(newell)
class newell_constrained_timestep(newell):
    r"""
    Newell (2002) car-following model with a constrained timestep of 1.

    This class is a variant of the Newell car-following model, with the only difference being that the timestep is validated and fixed to 1. It inherits all properties and functionalities of the original Newell model.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*

        Default constructor for the newell_constrained_timestep model.

        This constructor initializes the model using default parameters for Newell’s car-following model with the timestep constrained to 1.

        |

        *Overload 2:*

        Constructor with custom parameters for Newell's model.

        This constructor allows setting custom values for Newell’s car-following model, with the timestep validation constrained to 1.

        :type p: :py:class:`p_newell`
        :param p: Pointer to the p_newell parameter class containing model parameters.
        """
        _autopysta.newell_constrained_timestep_swiginit(self, _autopysta.new_newell_constrained_timestep(*args))

    def validate_parameters(self, p=None):
        r"""
        Validates the model parameters, ensuring the timestep is constrained to 1.

        This method ensures that the timestep of the model adheres to the fixed value of 1. If any parameter violates this condition, an exception is raised.

        :type p: :py:class:`params`, optional
        :param p: Pointer to the params class containing model parameters.
        """
        return _autopysta.newell_constrained_timestep_validate_parameters(self, p)

    def new_point(self, leader, follower, p=None):
        r"""
        Computes the next point in the follower's trajectory.

        This method calculates the follower’s next position and velocity based on the constrained timestep model.

        :type leader: :py:class:`GeneralizedTrajectory`
        :param leader: Generalized trajectory of the leader vehicle.
        :type follower: :py:class:`Trajectory`
        :param follower: Trajectory of the follower vehicle.
        :type p: :py:class:`params`, optional
        :param p: Parameters for Newell's car-following model.
        :rtype: :py:class:`Point`
        :return: A point representing the follower's updated position and speed.
        """
        return _autopysta.newell_constrained_timestep_new_point(self, leader, follower, p)
    __swig_destroy__ = _autopysta.delete_newell_constrained_timestep

# Register newell_constrained_timestep in _autopysta:
_autopysta.newell_constrained_timestep_swigregister(newell_constrained_timestep)
class newell_random_acceleration(newell):
    r"""
    Laval et al. (2014) car-following model with random acceleration behavior.

    This class implements a variant of Newell’s car-following model that includes random acceleration dynamics, as introduced by Laval et al. (2014). The model captures variability in driver behavior, incorporating stochastic fluctuations in vehicle acceleration.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*

        Default constructor for the random acceleration model.

        Initializes the model using default values for both Newell’s and Laval’s model parameters, including random acceleration settings.

        |

        *Overload 2:*

        Constructor with custom parameters for Newell's and Laval's models.

        This constructor allows initializing the model with custom values for both Newell’s car-following parameters and Laval's random acceleration model parameters.

        :type p: :py:class:`p_newell_random_acceleration`
        :param p: Pointer to the p_newell_random_acceleration class containing the parameters.
        """
        _autopysta.newell_random_acceleration_swiginit(self, _autopysta.new_newell_random_acceleration(*args))

    def validate_parameters(self, *args):
        r"""
        Validates the model parameters for consistency.

        This method checks the parameters for both Newell's and Laval’s models to ensure they meet the required conditions.

        :type p: :py:class:`params`, optional
        :param p: Pointer to the params class containing model parameters.
        """
        return _autopysta.newell_random_acceleration_validate_parameters(self, *args)

    def new_point(self, *args):
        r"""
        Computes the next point in the follower's trajectory considering random acceleration.

        This method calculates the follower's next position and velocity, incorporating the random acceleration behavior introduced by Laval's model.

        :type leader: :py:class:`GeneralizedTrajectory`
        :param leader: Generalized trajectory representing the leader's position and speed int time. Leave null for no leader.
        :type follower: :py:class:`Trajectory`
        :param follower: Trajectory representing the follower's position and speed in time. Leave null for no follower.
        :type p: :py:class:`params`, optional
        :param p: Parameters for Laval’s car-following model.
        :rtype: :py:class:`Point`
        :return: A point representing the follower's updated position and speed.
        """
        return _autopysta.newell_random_acceleration_new_point(self, *args)
    __swig_destroy__ = _autopysta.delete_newell_random_acceleration

# Register newell_random_acceleration in _autopysta:
_autopysta.newell_random_acceleration_swigregister(newell_random_acceleration)
class linear(Model):
    r"""
    Linear car-following model.

    The linear car-following model is a simple model that calculates the acceleration of a vehicle based on a linear function
    of the speed difference between the vehicle and the vehicle ahead (leader). It uses parameters such as free-flow speed,
    reaction time, and spacing to simulate vehicle behavior in traffic flow.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*
         Default constructor for the linear model.
        Initializes the linear model with default parameter values.

        |

        *Overload 2:*
         Constructor with custom parameters.
        Initializes the linear model with custom parameters provided via the p_linear class.

        :type p: :py:class:`p_linear`
        :param p: A pointer to the p_linear parameter object containing the model's parameters.
        """
        _autopysta.linear_swiginit(self, _autopysta.new_linear(*args))

    def equil_spcg(self, vl, vf, p):
        r"""
         Computes the equilibrium spacing between vehicles.
        This function calculates the equilibrium spacing between the leader and follower vehicles based on their velocities.
        The equilibrium spacing depends on the free-flow speed, reaction time, and spacing parameters.

        :type vl: float
        :param vl: The velocity of the leader vehicle.
        :type vf: float
        :param vf: The velocity of the follower vehicle.
        :type p: :py:class:`params`
        :param p: Pointer to the linear model parameters.
        :rtype: float
        :return: The equilibrium spacing between the vehicles.
        """
        return _autopysta.linear_equil_spcg(self, vl, vf, p)

    def wave_speed(self, leader, follower, p):
        r"""
         Computes the wave speed in the model.
        The wave speed represents the speed at which traffic congestion propagates backward through a line of vehicles.
        This function calculates the wave speed based on model parameters such as reaction time and spacing.

        :type leader: :py:class:`Point`
        :param leader: The point representing the leader's position and speed.
        :type follower: :py:class:`Point`
        :param follower: The point representing the follower's position and speed.
        :type p: :py:class:`params`
        :param p: Pointer to the linear model parameters.
        :rtype: float
        :return: The computed wave speed.
        """
        return _autopysta.linear_wave_speed(self, leader, follower, p)

    def free_flow_speed(self, p=None):
        r"""
         Returns the free-flow speed of the linear model.
        This function returns the free-flow speed, which is the speed at which vehicles travel in the absence of traffic congestion.

        :type p: :py:class:`params`, optional
        :param p: Pointer to the linear model parameters.
        :rtype: float
        :return: The free-flow speed.
        """
        return _autopysta.linear_free_flow_speed(self, p)
    __swig_destroy__ = _autopysta.delete_linear

# Register linear in _autopysta:
_autopysta.linear_swigregister(linear)
class p_lcm_gipps(params):
    r"""
    Parameter manager for the Gipps (1986) lane-changing model.

    This class handles the lane-changing parameters, including the fractions
    of free-flow speed required to initiate overtaking (left lane change) and to
    revert to the original lane (right lane change).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    _pvl = property(_autopysta.p_lcm_gipps__pvl_get, _autopysta.p_lcm_gipps__pvl_set, doc=r""" Fraction of free-flow speed for overtaking (left lane change).""")
    _pvh = property(_autopysta.p_lcm_gipps__pvh_get, _autopysta.p_lcm_gipps__pvh_set, doc=r""" Fraction of free-flow speed for returning (right lane change).""")

    def __init__(self, *args):
        r"""
        *Overload 1:*

        Default constructor for the Gipps lane-changing model parameters.

        Initializes parameters with default values: `_pvl = 0.9` and `_pvh = 0.95`.

        |

        *Overload 2:*

        Constructor with custom lane-changing parameters.

        Initializes parameters with the given values.

        :type pvlow: float
        :param pvlow: Fraction of free-flow speed for overtaking (must be between 0 and 1).
        :type pvhigh: float
        :param pvhigh: Fraction of free-flow speed for returning to the original lane (must be between `pvlow` and 1).
        :raises: Exception if the input values are not in the range 0 < `pvlow` < `pvhigh` < 1.
        """
        _autopysta.p_lcm_gipps_swiginit(self, _autopysta.new_p_lcm_gipps(*args))
    __swig_destroy__ = _autopysta.delete_p_lcm_gipps

# Register p_lcm_gipps in _autopysta:
_autopysta.p_lcm_gipps_swigregister(p_lcm_gipps)
class lcm_gipps(object):
    r"""
    Lane-changing model based on the Gipps (1986) behavioral model.

    This class manages the functionality for vehicle lane-changing decisions,
    according to the rules defined by Gipps's model. Vehicles decide when to
    overtake or return to their original lane based on traffic conditions and
    the parameters from the `p_lcm_gipps` class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*

        Default constructor for the Gipps lane-changing model.

        Initializes the model with default parameters.

        |

        *Overload 2:*

        Constructor for the Gipps lane-changing model with custom parameters.

        :type p: :py:class:`p_lcm_gipps`
        :param p: Custom lane-changing parameters.
        """
        _autopysta.lcm_gipps_swiginit(self, _autopysta.new_lcm_gipps(*args))

    def lch_left(self, leader, subject, new_leader, new_follower, cfm, lcmpars):
        r"""
        Determine if the vehicle should change lanes to the left.

        The decision to change lanes to the left is based on the vehicle's speed relative
        to a fraction of the free-flow speed. If the speed is lower than a certain threshold,
        the lane change will be considered.

        :type leader: :py:class:`Point`
        :param leader: Current leader in the lane.
        :type subject: :py:class:`Point`
        :param subject: Current vehicle's position and speed (follower).
        :type new_leader: :py:class:`Point`
        :param new_leader: The vehicle to become the subject's leader in the new lane.
        :type new_follower: :py:class:`Point`
        :param new_follower: The vehicle to become the subject's follower in the new lane.
        :type cfm: :py:class:`Model`
        :param cfm: A car-following model.
        :type lcmpars: :py:class:`params`
        :param lcmpars: Lane-changing model parameters.
        :rtype: boolean
        :return: True if the lane change to the left is feasible, false otherwise.
        """
        return _autopysta.lcm_gipps_lch_left(self, leader, subject, new_leader, new_follower, cfm, lcmpars)

    def lch_right(self, leader, follower, new_leader, new_follower, cfm, lcmpars):
        r"""
        Determine if the vehicle should change lanes to the right.

        The decision to change lanes to the right is based on the vehicle's speed relative
        to a fraction of the free-flow speed. If the speed is higher than a certain threshold,
        the lane change will be considered.

        :type leader: :py:class:`Point`
        :param leader: Current leader in the lane.
        :type follower: :py:class:`Point`
        :param follower: Current vehicle's position and speed (follower).
        :type new_leader: :py:class:`Point`
        :param new_leader: The vehicle to become the subject's leader in the new lane.
        :type new_follower: :py:class:`Point`
        :param new_follower: The vehicle to become the subject's follower in the new lane.
        :type cfm: :py:class:`Model`
        :param cfm: A car-following model.
        :type lcmpars: :py:class:`params`
        :param lcmpars: Lane-changing model parameters.
        :rtype: boolean
        :return: True if the lane change to the right is feasible, false otherwise.
        """
        return _autopysta.lcm_gipps_lch_right(self, leader, follower, new_leader, new_follower, cfm, lcmpars)
    __swig_destroy__ = _autopysta.delete_lcm_gipps

# Register lcm_gipps in _autopysta:
_autopysta.lcm_gipps_swigregister(lcm_gipps)
class no_lch(object):
    r"""
    A lane-changing model that forbids any lane changes.

    This class represents a model where no lane-changing maneuvers are allowed.
    It acts as a fallback or placeholder model when lane-changing is not
    considered in a traffic simulation.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        Default constructor for the `no_lch` model.

        Initializes the lane-changing model with no parameters and prohibits all
        lane changes.
        """
        _autopysta.no_lch_swiginit(self, _autopysta.new_no_lch())

    def lch_left(self, leader, follower, new_leader, new_follower, cfm, lcmpars):
        r"""
        Determine if the vehicle should change lanes to the left.

        Always returns `false` since lane changes are disallowed.

        :type leader: :py:class:`Point`
        :param leader: The current leader's position and speed (optional).
        :type follower: :py:class:`Point`
        :param follower: The subject vehicle's position and speed.
        :type new_leader: :py:class:`Point`
        :param new_leader: The position and speed of the new leader after lane change (optional).
        :type new_follower: :py:class:`Point`
        :param new_follower: The position and speed of the new follower after lane change (optional).
        :type cfm: :py:class:`Model`
        :param cfm: A car-following model.
        :type lcmpars: :py:class:`params`
        :param lcmpars: Lane-changing model parameters.
        :rtype: boolean
        :return: Always returns `false`.
        """
        return _autopysta.no_lch_lch_left(self, leader, follower, new_leader, new_follower, cfm, lcmpars)

    def lch_right(self, leader, follower, new_leader, new_follower, cfm, lcmpars):
        r"""
        Determine if the vehicle should change lanes to the right.

        Always returns `false` since lane changes are disallowed.

        :type leader: :py:class:`Point`
        :param leader: The current leader's position and speed (optional).
        :type follower: :py:class:`Point`
        :param follower: The subject vehicle's position and speed.
        :type new_leader: :py:class:`Point`
        :param new_leader: The position and speed of the new leader after lane change (optional).
        :type new_follower: :py:class:`Point`
        :param new_follower: The position and speed of the new follower after lane change (optional).
        :type cfm: :py:class:`Model`
        :param cfm: A car-following model.
        :type lcmpars: :py:class:`params`
        :param lcmpars: Lane-changing model parameters.
        :rtype: boolean
        :return: Always returns `false`.
        """
        return _autopysta.no_lch_lch_right(self, leader, follower, new_leader, new_follower, cfm, lcmpars)
    __swig_destroy__ = _autopysta.delete_no_lch

# Register no_lch in _autopysta:
_autopysta.no_lch_swigregister(no_lch)
class Creator(object):
    r"""
    Base class for generating vehicles in a traffic simulation.

    The `creator` class defines the logic for creating new vehicles either at the start of the simulation
    or during runtime. It handles the vehicle creation process based on specified models, parameters, and
    traffic conditions (such as gaps between vehicles). Derived classes should implement specific creation logic.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def validate_creator(self):
        r"""
        Validates the configuration of the creator.

        This method validates the configurations of the creator, such as ensuring that the maximum
        number of vehicles and the model are properly set. This ensures that vehicle creation follows
        the expected limits and behavior.
        """
        return _autopysta.Creator_validate_creator(self)

    def create(self, leader, immediate_follower=False):
        r"""
        Creates a new vehicle based on the current leader's position.

        This method checks whether it is possible to create a new vehicle based on the leader's state.
        If so, it generates a new vehicle at an appropriate position relative to the leader. If
        `immediate_follower` is true, the new vehicle will be placed just behind the leader; otherwise,
        it will start at the beginning of the lane.

        :type leader: :py:class:`Point`
        :param leader: The point representing the leader's current state (position, speed).
        :type immediate_follower: boolean, optional
        :param immediate_follower: Whether the new vehicle should follow immediately behind the leader.
        :rtype: :py:class:`Vehicle`
        :return: A pointer to the created vehicle, or `nullptr` if no vehicle was created.
        """
        return _autopysta.Creator_create(self, leader, immediate_follower)

    def create_no_leader(self, lane):
        r"""
        Creates a new vehicle in an empty lane.

        This method creates a new vehicle in a lane that has no leading vehicle. It is meant to be
        used for initializing lanes with vehicles at the beginning of the simulation or adding vehicles
        dynamically when no leader is present.

        :type lane: int
        :param lane: The lane number in which to create the vehicle.
        :rtype: :py:class:`Vehicle`
        :return: A pointer to the created vehicle, or `nullptr` if no vehicle was created.
        """
        return _autopysta.Creator_create_no_leader(self, lane)

    def initialize_state(self, leader):
        r"""
        Initializes vehicles in the first simulation timestep.

        This method is used to create and position vehicles during the first timestep of the simulation.
        It generates vehicles behind a manually-created leading vehicle and populates the lane with vehicles
        based on the traffic model.

        :type leader: :py:class:`Point`
        :param leader: The manually-created leader vehicle.
        :rtype: std::vector< Vehicle *,std::allocator< Vehicle * > >
        :return: A vector of pointers to the created vehicles.
        """
        return _autopysta.Creator_initialize_state(self, leader)

# Register Creator in _autopysta:
_autopysta.Creator_swigregister(Creator)
class CreatorMartinezJin2020(Creator):
    r"""
    Vehicle creator based on the Martinez and Jin (2020) model, with random jam density.

    The `creator_martinez_jin_2020` class generates vehicles according to the Martinez and Jin (2020) car-following model,
    with random variations in jam density. Vehicles are placed in a lane with a given spacing and initial speed, unless constrained
    by the lane's capacity or other vehicles.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    min_jam_density = property(_autopysta.CreatorMartinezJin2020_min_jam_density_get, _autopysta.CreatorMartinezJin2020_min_jam_density_set, doc=r""" Minimum value for random jam density (uniform distribution).""")
    max_jam_density = property(_autopysta.CreatorMartinezJin2020_max_jam_density_get, _autopysta.CreatorMartinezJin2020_max_jam_density_set, doc=r""" Maximum value for random jam density (uniform distribution).""")

    def __init__(self, *args):
        r"""
        *Overload 1:*

        Constructs a vehicle creator with the Martinez and Jin model.

        This constructor creates a vehicle creator that generates vehicles with a fixed spacing and initial speed.
        Jam density is randomly generated within a defined range.

        :type model_params: :py:class:`p_martinez_jin_2020`
        :param model_params: Parameters for the Martinez and Jin model.
        :type spacing: float
        :param spacing: Desired spacing between vehicles.
        :type speed: float
        :param speed: Initial speed for the created vehicles.

        |

        *Overload 2:*

        Constructs a vehicle creator with the Martinez and Jin model and custom jam density range.

        This constructor creates a vehicle creator that generates vehicles with a fixed spacing and initial speed.
        Jam density is randomly generated within the specified range.

        :type model_params: :py:class:`p_martinez_jin_2020`
        :param model_params: Parameters for the Martinez and Jin model.
        :type spacing: float
        :param spacing: Desired spacing between vehicles.
        :type speed: float
        :param speed: Initial speed for the created vehicles.
        :type deviation: float
        :param deviation: Maximum percentage deviation for the random jam density.
        :type avg_jam_density: float
        :param avg_jam_density: Average jam density.

        |

        *Overload 3:*

        Constructs a vehicle creator with a limit on the number of vehicles.

        This constructor creates a vehicle creator that generates vehicles with a fixed spacing and initial speed, up to a
        maximum number of vehicles.

        :type model_params: :py:class:`p_martinez_jin_2020`
        :param model_params: Parameters for the Martinez and Jin model.
        :type spacing: float
        :param spacing: Desired spacing between vehicles.
        :type speed: float
        :param speed: Initial speed for the created vehicles.
        :type max_vehicles: int
        :param max_vehicles: Maximum number of vehicles to be created.

        |

        *Overload 4:*

        Constructs a vehicle creator with a custom jam density range and vehicle limit.

        This constructor creates a vehicle creator that generates vehicles with a fixed spacing and initial speed,
        with a random jam density and a limit on the total number of vehicles created.

        :type model_params: :py:class:`p_martinez_jin_2020`
        :param model_params: Parameters for the Martinez and Jin model.
        :type spacing: float
        :param spacing: Desired spacing between vehicles.
        :type speed: float
        :param speed: Initial speed for the created vehicles.
        :type deviation: float
        :param deviation: Maximum percentage deviation for the random jam density.
        :type avg_jam_density: float
        :param avg_jam_density: Average jam density.
        :type max_vehicles: int
        :param max_vehicles: Maximum number of vehicles to be created.
        """
        _autopysta.CreatorMartinezJin2020_swiginit(self, _autopysta.new_CreatorMartinezJin2020(*args))

    def create(self, leader, immediate_follower=False):
        r"""
        Creates a vehicle with random jam density behind a leader.

        This method checks whether it is possible to create a vehicle based on the leader's current state. If allowed,
        it creates a new vehicle using the Martinez and Jin model with random jam density.

        :type leader: :py:class:`Point`
        :param leader: The current point of the leader vehicle.
        :type immediate_follower: boolean, optional
        :param immediate_follower: If `true`, the new vehicle is placed just behind the leader.
        :rtype: :py:class:`Vehicle`
        :return: A pointer to the created vehicle, or `nullptr` if no vehicle was created.
        """
        return _autopysta.CreatorMartinezJin2020_create(self, leader, immediate_follower)

    def create_no_leader(self, lane):
        r"""
        Creates a vehicle in an empty lane with random jam density.

        This method generates a vehicle at the start of an empty lane using the Martinez and Jin model with random jam density.

        :type lane: int
        :param lane: The lane number where the vehicle is created.
        :rtype: :py:class:`Vehicle`
        :return: A pointer to the created vehicle, or `nullptr` if no vehicle was created.
        """
        return _autopysta.CreatorMartinezJin2020_create_no_leader(self, lane)

    def validate_creator(self):
        r"""
        Validates the parameters of the Martinez and Jin model.

        This method ensures that the parameters of the Martinez and Jin model are valid and feasible for the simulation.
        """
        return _autopysta.CreatorMartinezJin2020_validate_creator(self)
    __swig_destroy__ = _autopysta.delete_CreatorMartinezJin2020

# Register CreatorMartinezJin2020 in _autopysta:
_autopysta.CreatorMartinezJin2020_swigregister(CreatorMartinezJin2020)
class FixedStateCreator(Creator):
    r"""
    Vehicle creator that injects vehicles with a fixed state (spacing and speed).

    The `FixedStateCreator` class generates vehicles based on a specified spacing and initial speed.
    Vehicles are placed at the start of the lane, or just behind a leader, if a leader vehicle is present.
    This class is typically used for scenarios where vehicles need to maintain a fixed headway and speed.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def validate_creator(self):
        r"""
        Validates the parameters of the fixed-state vehicle creator.

        Ensures that the model parameters are valid and the spacing is appropriate for the simulation.
        If the parameters are invalid, an error will be thrown.
        """
        return _autopysta.FixedStateCreator_validate_creator(self)

    def __init__(self, *args):
        r"""
        *Overload 1:*

        Constructs a fixed-state vehicle creator.

        This constructor creates a vehicle creator with specified model, spacing, and initial speed. It also
        allows limiting the maximum number of vehicles to be created.

        :type model: :py:class:`Model`
        :param model: A car-following model governing the lane's capacity.
        :type spacing: float
        :param spacing: Target spacing between vehicles.
        :type speed: float
        :param speed: Initial speed for the created vehicles.
        :type max_vehicles: int
        :param max_vehicles: Maximum number of vehicles to create.

        |

        *Overload 2:*

        Constructs a fixed-state vehicle creator.

        This constructor creates a vehicle creator with specified model, spacing, and initial speed.

        :type model: :py:class:`Model`
        :param model: A car-following model governing the lane's capacity.
        :type spacing: float
        :param spacing: Target spacing between vehicles.
        :type speed: float
        :param speed: Initial speed for the created vehicles.
        """
        _autopysta.FixedStateCreator_swiginit(self, _autopysta.new_FixedStateCreator(*args))

    def create_no_leader(self, lane):
        r"""
        Creates a new vehicle in a lane without a leader.

        This function generates a new vehicle in an empty lane if there is space, or returns `nullptr` if
        no more vehicles can be created.

        :type lane: int
        :param lane: The lane number where the vehicle is created.
        :rtype: :py:class:`Vehicle`
        :return: A pointer to the created vehicle, or `nullptr` if no vehicle was created.
        """
        return _autopysta.FixedStateCreator_create_no_leader(self, lane)
    __swig_destroy__ = _autopysta.delete_FixedStateCreator

# Register FixedStateCreator in _autopysta:
_autopysta.FixedStateCreator_swigregister(FixedStateCreator)
class FixedDemandCreator(Creator):
    r"""
    Vehicle creator that injects vehicles at a fixed rate (flow).

    The `fixed_demand_creator` class generates vehicles based on a specified flow rate, placing
    them at the beginning of a lane or behind a leader. Vehicles are injected at regular intervals
    based on the desired headway.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*

        Constructs a fixed-demand vehicle creator.

        This constructor creates a vehicle creator that generates vehicles at a specified flow rate.

        :type model: :py:class:`Model`
        :param model: A car-following model governing the lane's capacity.
        :type flow: float
        :param flow: The target flow rate (vehicles per second).

        |

        *Overload 2:*

        Constructs a limited fixed-demand vehicle creator.

        This constructor creates a vehicle creator that generates vehicles at a specified flow rate
        with a limit on the maximum number of vehicles created.

        :type model: :py:class:`Model`
        :param model: A car-following model governing the lane's capacity.
        :type flow: float
        :param flow: The target flow rate (vehicles per second).
        :type max_vehicles: int
        :param max_vehicles: The maximum number of vehicles to create.
        """
        _autopysta.FixedDemandCreator_swiginit(self, _autopysta.new_FixedDemandCreator(*args))

    def validate_creator(self):
        r"""
        Validates the flow rate parameters of the fixed-demand vehicle creator.

        This method checks that the specified flow rate is feasible given the time step (`dt`) of the
        simulation. If the demand is not feasible, an exception will be thrown.
        """
        return _autopysta.FixedDemandCreator_validate_creator(self)

    def create_no_leader(self, lane):
        r"""
        Creates a new vehicle in a lane without a leader.

        This function generates a new vehicle in an empty lane if there is space, or returns `nullptr` if
        no more vehicles can be created.

        :type lane: int
        :param lane: The lane number where the vehicle is created.
        :rtype: :py:class:`Vehicle`
        :return: A pointer to the created vehicle, or `nullptr` if no vehicle was created.
        """
        return _autopysta.FixedDemandCreator_create_no_leader(self, lane)
    __swig_destroy__ = _autopysta.delete_FixedDemandCreator

# Register FixedDemandCreator in _autopysta:
_autopysta.FixedDemandCreator_swigregister(FixedDemandCreator)
class CreatorFactory(object):
    r"""
    A factory class for creating different types of vehicle creators.

    The `CreatorFactory` class provides a convenient way to instantiate various `Creator` subclasses
    by specifying the type and relevant parameters. This pattern simplifies the instantiation logic.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    FixedDemand = _autopysta.CreatorFactory_FixedDemand
    FixedState = _autopysta.CreatorFactory_FixedState

    @staticmethod
    def create_creator(*args):
        r"""
        Creates a vehicle creator based on the specified type and parameters.

        This function returns a raw pointer to a `Creator` instance based on the `CreatorType`.
        The `model` parameter is required for all types, while others are specific to the creator type.

        :type type: int
        :param type: The type of creator to instantiate.
        :type model: :py:class:`Model`
        :param model: The traffic model used for vehicle creation.
        :type flow: float, optional
        :param flow: Mean flow rate (vehicles per second), applicable for demand creators.
        :type max_vehicles: int, optional
        :param max_vehicles: Max vehicles allowed, applicable for creators with a max limit.
        :type spacing: float, optional
        :param spacing: Desired spacing between vehicles, applicable for state creators.
        :type speed: float, optional
        :param speed: Desired initial speed of vehicles, applicable for state creators.
        :type variability: float, optional
        :param variability: Variability factor for stochastic creators.
        :rtype: :py:class:`Creator`
        :return: A raw pointer to the instantiated creator.
        """
        return _autopysta.CreatorFactory_create_creator(*args)

    def __init__(self):
        _autopysta.CreatorFactory_swiginit(self, _autopysta.new_CreatorFactory())
    __swig_destroy__ = _autopysta.delete_CreatorFactory

# Register CreatorFactory in _autopysta:
_autopysta.CreatorFactory_swigregister(CreatorFactory)
class Results(object):
    r"""
    The `results` class manages and processes simulation results.

    This class stores and organizes the trajectories of vehicles by lane, and provides methods
    to analyze the data, such as computing Edie's flow and density, or getting vehicle positions at
    specific times or distances.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, trajectories):
        r"""
        Constructor that initializes the `results` object with a list of trajectories.

        :type trajectories: std::vector< Trajectory *,std::allocator< Trajectory * > >
        :param trajectories: A vector of trajectories from the simulation.
        """
        _autopysta.Results_swiginit(self, _autopysta.new_Results(trajectories))

    def get_trajectory(self, index):
        return _autopysta.Results_get_trajectory(self, index)

    def get_trajectories_by_vehicle(self, vehicle_index):
        r"""
        Splits a vehicle's Trajectory by lane.

        This method processes the Trajectory of a specific vehicle and splits it into
        separate trajectories based on lane changes.

        :type vehicle_index: int
        :param vehicle_index: Index of the vehicle Trajectory.
        :rtype: std::vector< Trajectory *,std::allocator< Trajectory * > >
        :return: A vector of trajectories split by lane.
        """
        return _autopysta.Results_get_trajectories_by_vehicle(self, vehicle_index)

    def get_trajectories_by_lane(self, lane):
        r"""
        Retrieves all trajectories in a specific lane.

        :type lane: int
        :param lane: Lane number.
        :rtype: std::vector< Trajectory *,std::allocator< Trajectory * > >
        :return: A vector of trajectories in the specified lane.
        """
        return _autopysta.Results_get_trajectories_by_lane(self, lane)

    def get_all_trajectories_by_lane(self):
        r"""
        Retrieves all trajectories across all lanes.

        :rtype: std::vector< Trajectory *,std::allocator< Trajectory * > >
        :return: A vector containing all trajectories in the simulation.
        """
        return _autopysta.Results_get_all_trajectories_by_lane(self)

    def get_all_trajectories(self):
        r"""
        Gets all vehicle trajectories.

        :rtype: std::vector< Trajectory *,std::allocator< Trajectory * > >
        :return: A vector containing the trajectories of all vehicles.
        """
        return _autopysta.Results_get_all_trajectories(self)

    def calculate_edie(self, start_time, end_time, time_step, start_dist, end_dist, lane):
        r"""
        Computes Edie's flow and density for a specific time interval and distance.

        This method analyzes the Trajectory data to calculate flow and density values
        within a specified time-space region.

        :type start_time: float
        :param start_time: Start time.
        :type end_time: float
        :param end_time: End time.
        :type time_step: float
        :param time_step: Time step size.
        :type start_dist: float
        :param start_dist: Start distance.
        :type end_dist: float
        :param end_dist: End distance.
        :type lane: int
        :param lane: Lane number.
        :rtype: std::vector< std::vector< double,std::allocator< double > > *,std::allocator< std::vector< double,std::allocator< double > > * > >
        :return: A vector of vectors containing the computed flow and density values.
        """
        return _autopysta.Results_calculate_edie(self, start_time, end_time, time_step, start_dist, end_dist, lane)

    def passes_on_t(self, time, lane):
        r"""
        Retrieves the list of points where vehicles pass at a specific time in a given lane.

        :type time: float
        :param time: The time at which to check vehicle positions.
        :type lane: int
        :param lane: The lane number.
        :rtype: std::vector< Point *,std::allocator< Point * > >
        :return: A vector of points representing vehicle positions at the specified time and lane.
        """
        return _autopysta.Results_passes_on_t(self, time, lane)

    def passes_on_x(self, position, lane):
        r"""
        Retrieves the list of points where vehicles pass at a specific distance in a given lane.

        :type position: float
        :param position: The distance at which to check vehicle positions.
        :type lane: int
        :param lane: The lane number.
        :rtype: std::vector< Point *,std::allocator< Point * > >
        :return: A vector of points representing vehicle positions at the specified distance and lane.
        """
        return _autopysta.Results_passes_on_x(self, position, lane)
    __swig_destroy__ = _autopysta.delete_Results

# Register Results in _autopysta:
_autopysta.Results_swigregister(Results)
class Box(object):
    r"""
    The `Box` class defines a time-space region for measuring Edie's flow and density.

    A `Box` is a rectangular area in time and space used to calculate flow and density values based on
    the vehicle trajectories that pass through it.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    trails = property(_autopysta.Box_trails_get, _autopysta.Box_trails_set, doc=r""" Stores the start and end points of trajectories crossing the box.""")

    def __init__(self, xa, xb, ta, tb):
        r"""
        Constructor that defines a time-space box for measuring flow and density.

        :type xa: float
        :param xa: Lower bound of the distance range.
        :type xb: float
        :param xb: Upper bound of the distance range.
        :type ta: float
        :param ta: Lower bound of the time range.
        :type tb: float
        :param tb: Upper bound of the time range.
        """
        _autopysta.Box_swiginit(self, _autopysta.new_Box(xa, xb, ta, tb))

    def contains(self, p):
        r"""
        Checks whether a point lies within the box.

        :type p: :py:class:`Point`
        :param p: The point to check.
        :rtype: boolean
        :return: `true` if the point is inside the box, `false` otherwise.
        """
        return _autopysta.Box_contains(self, p)

    def get_intersection(self, p1, p2):
        r"""
        Computes the intersection of two points with the edges of the box.

        This method calculates the intersection point of a line segment defined by two points
        (p1, p2) with the edges of the box.

        :type p1: :py:class:`Point`
        :param p1: First point of the line segment.
        :type p2: :py:class:`Point`
        :param p2: Second point of the line segment.
        :rtype: :py:class:`Point`
        :return: The point of intersection with the box edges.
        """
        return _autopysta.Box_get_intersection(self, p1, p2)

    def inter_hor(self, p1, p2, x):
        r"""
        Calculates the intersection with a horizontal line at a given x value.

        :type p1: :py:class:`Point`
        :param p1: First point of the line segment.
        :type p2: :py:class:`Point`
        :param p2: Second point of the line segment.
        :type x: float
        :param x: The x-coordinate of the horizontal line.
        :rtype: :py:class:`Point`
        :return: The intersection point.
        """
        return _autopysta.Box_inter_hor(self, p1, p2, x)

    def inter_ver(self, p1, p2, t):
        r"""
        Calculates the intersection with a vertical line at a given t value.

        :type p1: :py:class:`Point`
        :param p1: First point of the line segment.
        :type p2: :py:class:`Point`
        :param p2: Second point of the line segment.
        :type t: float
        :param t: The t-coordinate of the vertical line.
        :rtype: :py:class:`Point`
        :return: The intersection point.
        """
        return _autopysta.Box_inter_ver(self, p1, p2, t)

    def get_edie(self):
        r"""
        Computes Edie's flow and density values for the box.

        :rtype: std::vector< double,std::allocator< double > >
        :return: A vector containing flow (Q) and density (K) values for the box.
        """
        return _autopysta.Box_get_edie(self)

    def _print(self):
        r"""
        Prints the trails (vehicle paths) that pass through the box.

        This is used for debugging and visualization purposes.
        """
        return _autopysta.Box__print(self)
    __swig_destroy__ = _autopysta.delete_Box

# Register Box in _autopysta:
_autopysta.Box_swigregister(Box)
class Exception(object):
    r"""
    A custom exception class for handling errors in the Autopysta application.

    This class provides detailed error handling with error codes and messages, facilitating
    better debugging and error tracking within the application. It is exposed to Python, allowing
    Python code to catch and handle C++ exceptions from Autopysta.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, code, message):
        r"""
        Constructs an Exception with a specific error code and message.
        :type code: int
        :param code: Error code representing the type of error.
        :type message: string
        :param message: Detailed error message providing context for the exception.
        """
        _autopysta.Exception_swiginit(self, _autopysta.new_Exception(code, message))

    def code(self):
        r"""
        Retrieves the error code associated with the exception.
        :rtype: int
        :return: An integer representing the error code.
        """
        return _autopysta.Exception_code(self)

    def message(self):
        r"""
        Retrieves the detailed error message.
        :rtype: string
        :return: A const reference to a string containing the error message.
        """
        return _autopysta.Exception_message(self)

    def what(self):
        r"""
        Provides a description of the exception, including the error code and message.
        :rtype: string
        :return: A C-style string with a combined error code and message, safe for logging.
        """
        return _autopysta.Exception_what(self)
    __swig_destroy__ = _autopysta.delete_Exception

# Register Exception in _autopysta:
_autopysta.Exception_swigregister(Exception)
class trajectories(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _autopysta.trajectories_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _autopysta.trajectories___nonzero__(self)

    def __bool__(self):
        return _autopysta.trajectories___bool__(self)

    def __len__(self):
        return _autopysta.trajectories___len__(self)

    def __getslice__(self, i, j):
        return _autopysta.trajectories___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _autopysta.trajectories___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _autopysta.trajectories___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _autopysta.trajectories___delitem__(self, *args)

    def __getitem__(self, *args):
        return _autopysta.trajectories___getitem__(self, *args)

    def __setitem__(self, *args):
        return _autopysta.trajectories___setitem__(self, *args)

    def pop(self):
        return _autopysta.trajectories_pop(self)

    def append(self, x):
        return _autopysta.trajectories_append(self, x)

    def empty(self):
        return _autopysta.trajectories_empty(self)

    def size(self):
        return _autopysta.trajectories_size(self)

    def swap(self, v):
        return _autopysta.trajectories_swap(self, v)

    def begin(self):
        return _autopysta.trajectories_begin(self)

    def end(self):
        return _autopysta.trajectories_end(self)

    def rbegin(self):
        return _autopysta.trajectories_rbegin(self)

    def rend(self):
        return _autopysta.trajectories_rend(self)

    def clear(self):
        return _autopysta.trajectories_clear(self)

    def get_allocator(self):
        return _autopysta.trajectories_get_allocator(self)

    def pop_back(self):
        return _autopysta.trajectories_pop_back(self)

    def erase(self, *args):
        return _autopysta.trajectories_erase(self, *args)

    def __init__(self, *args):
        _autopysta.trajectories_swiginit(self, _autopysta.new_trajectories(*args))

    def push_back(self, x):
        return _autopysta.trajectories_push_back(self, x)

    def front(self):
        return _autopysta.trajectories_front(self)

    def back(self):
        return _autopysta.trajectories_back(self)

    def assign(self, n, x):
        return _autopysta.trajectories_assign(self, n, x)

    def resize(self, *args):
        return _autopysta.trajectories_resize(self, *args)

    def insert(self, *args):
        return _autopysta.trajectories_insert(self, *args)

    def reserve(self, n):
        return _autopysta.trajectories_reserve(self, n)

    def capacity(self):
        return _autopysta.trajectories_capacity(self)
    __swig_destroy__ = _autopysta.delete_trajectories

# Register trajectories in _autopysta:
_autopysta.trajectories_swigregister(trajectories)
class vehvec(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _autopysta.vehvec_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _autopysta.vehvec___nonzero__(self)

    def __bool__(self):
        return _autopysta.vehvec___bool__(self)

    def __len__(self):
        return _autopysta.vehvec___len__(self)

    def __getslice__(self, i, j):
        return _autopysta.vehvec___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _autopysta.vehvec___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _autopysta.vehvec___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _autopysta.vehvec___delitem__(self, *args)

    def __getitem__(self, *args):
        return _autopysta.vehvec___getitem__(self, *args)

    def __setitem__(self, *args):
        return _autopysta.vehvec___setitem__(self, *args)

    def pop(self):
        return _autopysta.vehvec_pop(self)

    def append(self, x):
        return _autopysta.vehvec_append(self, x)

    def empty(self):
        return _autopysta.vehvec_empty(self)

    def size(self):
        return _autopysta.vehvec_size(self)

    def swap(self, v):
        return _autopysta.vehvec_swap(self, v)

    def begin(self):
        return _autopysta.vehvec_begin(self)

    def end(self):
        return _autopysta.vehvec_end(self)

    def rbegin(self):
        return _autopysta.vehvec_rbegin(self)

    def rend(self):
        return _autopysta.vehvec_rend(self)

    def clear(self):
        return _autopysta.vehvec_clear(self)

    def get_allocator(self):
        return _autopysta.vehvec_get_allocator(self)

    def pop_back(self):
        return _autopysta.vehvec_pop_back(self)

    def erase(self, *args):
        return _autopysta.vehvec_erase(self, *args)

    def __init__(self, *args):
        _autopysta.vehvec_swiginit(self, _autopysta.new_vehvec(*args))

    def push_back(self, x):
        return _autopysta.vehvec_push_back(self, x)

    def front(self):
        return _autopysta.vehvec_front(self)

    def back(self):
        return _autopysta.vehvec_back(self)

    def assign(self, n, x):
        return _autopysta.vehvec_assign(self, n, x)

    def resize(self, *args):
        return _autopysta.vehvec_resize(self, *args)

    def insert(self, *args):
        return _autopysta.vehvec_insert(self, *args)

    def reserve(self, n):
        return _autopysta.vehvec_reserve(self, n)

    def capacity(self):
        return _autopysta.vehvec_capacity(self)
    __swig_destroy__ = _autopysta.delete_vehvec

# Register vehvec in _autopysta:
_autopysta.vehvec_swigregister(vehvec)
class crtvec(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _autopysta.crtvec_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _autopysta.crtvec___nonzero__(self)

    def __bool__(self):
        return _autopysta.crtvec___bool__(self)

    def __len__(self):
        return _autopysta.crtvec___len__(self)

    def __getslice__(self, i, j):
        return _autopysta.crtvec___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _autopysta.crtvec___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _autopysta.crtvec___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _autopysta.crtvec___delitem__(self, *args)

    def __getitem__(self, *args):
        return _autopysta.crtvec___getitem__(self, *args)

    def __setitem__(self, *args):
        return _autopysta.crtvec___setitem__(self, *args)

    def pop(self):
        return _autopysta.crtvec_pop(self)

    def append(self, x):
        return _autopysta.crtvec_append(self, x)

    def empty(self):
        return _autopysta.crtvec_empty(self)

    def size(self):
        return _autopysta.crtvec_size(self)

    def swap(self, v):
        return _autopysta.crtvec_swap(self, v)

    def begin(self):
        return _autopysta.crtvec_begin(self)

    def end(self):
        return _autopysta.crtvec_end(self)

    def rbegin(self):
        return _autopysta.crtvec_rbegin(self)

    def rend(self):
        return _autopysta.crtvec_rend(self)

    def clear(self):
        return _autopysta.crtvec_clear(self)

    def get_allocator(self):
        return _autopysta.crtvec_get_allocator(self)

    def pop_back(self):
        return _autopysta.crtvec_pop_back(self)

    def erase(self, *args):
        return _autopysta.crtvec_erase(self, *args)

    def __init__(self, *args):
        _autopysta.crtvec_swiginit(self, _autopysta.new_crtvec(*args))

    def push_back(self, x):
        return _autopysta.crtvec_push_back(self, x)

    def front(self):
        return _autopysta.crtvec_front(self)

    def back(self):
        return _autopysta.crtvec_back(self)

    def assign(self, n, x):
        return _autopysta.crtvec_assign(self, n, x)

    def resize(self, *args):
        return _autopysta.crtvec_resize(self, *args)

    def insert(self, *args):
        return _autopysta.crtvec_insert(self, *args)

    def reserve(self, n):
        return _autopysta.crtvec_reserve(self, n)

    def capacity(self):
        return _autopysta.crtvec_capacity(self)
    __swig_destroy__ = _autopysta.delete_crtvec

# Register crtvec in _autopysta:
_autopysta.crtvec_swigregister(crtvec)
class pntvec(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _autopysta.pntvec_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _autopysta.pntvec___nonzero__(self)

    def __bool__(self):
        return _autopysta.pntvec___bool__(self)

    def __len__(self):
        return _autopysta.pntvec___len__(self)

    def __getslice__(self, i, j):
        return _autopysta.pntvec___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _autopysta.pntvec___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _autopysta.pntvec___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _autopysta.pntvec___delitem__(self, *args)

    def __getitem__(self, *args):
        return _autopysta.pntvec___getitem__(self, *args)

    def __setitem__(self, *args):
        return _autopysta.pntvec___setitem__(self, *args)

    def pop(self):
        return _autopysta.pntvec_pop(self)

    def append(self, x):
        return _autopysta.pntvec_append(self, x)

    def empty(self):
        return _autopysta.pntvec_empty(self)

    def size(self):
        return _autopysta.pntvec_size(self)

    def swap(self, v):
        return _autopysta.pntvec_swap(self, v)

    def begin(self):
        return _autopysta.pntvec_begin(self)

    def end(self):
        return _autopysta.pntvec_end(self)

    def rbegin(self):
        return _autopysta.pntvec_rbegin(self)

    def rend(self):
        return _autopysta.pntvec_rend(self)

    def clear(self):
        return _autopysta.pntvec_clear(self)

    def get_allocator(self):
        return _autopysta.pntvec_get_allocator(self)

    def pop_back(self):
        return _autopysta.pntvec_pop_back(self)

    def erase(self, *args):
        return _autopysta.pntvec_erase(self, *args)

    def __init__(self, *args):
        _autopysta.pntvec_swiginit(self, _autopysta.new_pntvec(*args))

    def push_back(self, x):
        return _autopysta.pntvec_push_back(self, x)

    def front(self):
        return _autopysta.pntvec_front(self)

    def back(self):
        return _autopysta.pntvec_back(self)

    def assign(self, n, x):
        return _autopysta.pntvec_assign(self, n, x)

    def resize(self, *args):
        return _autopysta.pntvec_resize(self, *args)

    def insert(self, *args):
        return _autopysta.pntvec_insert(self, *args)

    def reserve(self, n):
        return _autopysta.pntvec_reserve(self, n)

    def capacity(self):
        return _autopysta.pntvec_capacity(self)
    __swig_destroy__ = _autopysta.delete_pntvec

# Register pntvec in _autopysta:
_autopysta.pntvec_swigregister(pntvec)
class fltvec(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _autopysta.fltvec_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _autopysta.fltvec___nonzero__(self)

    def __bool__(self):
        return _autopysta.fltvec___bool__(self)

    def __len__(self):
        return _autopysta.fltvec___len__(self)

    def __getslice__(self, i, j):
        return _autopysta.fltvec___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _autopysta.fltvec___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _autopysta.fltvec___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _autopysta.fltvec___delitem__(self, *args)

    def __getitem__(self, *args):
        return _autopysta.fltvec___getitem__(self, *args)

    def __setitem__(self, *args):
        return _autopysta.fltvec___setitem__(self, *args)

    def pop(self):
        return _autopysta.fltvec_pop(self)

    def append(self, x):
        return _autopysta.fltvec_append(self, x)

    def empty(self):
        return _autopysta.fltvec_empty(self)

    def size(self):
        return _autopysta.fltvec_size(self)

    def swap(self, v):
        return _autopysta.fltvec_swap(self, v)

    def begin(self):
        return _autopysta.fltvec_begin(self)

    def end(self):
        return _autopysta.fltvec_end(self)

    def rbegin(self):
        return _autopysta.fltvec_rbegin(self)

    def rend(self):
        return _autopysta.fltvec_rend(self)

    def clear(self):
        return _autopysta.fltvec_clear(self)

    def get_allocator(self):
        return _autopysta.fltvec_get_allocator(self)

    def pop_back(self):
        return _autopysta.fltvec_pop_back(self)

    def erase(self, *args):
        return _autopysta.fltvec_erase(self, *args)

    def __init__(self, *args):
        _autopysta.fltvec_swiginit(self, _autopysta.new_fltvec(*args))

    def push_back(self, x):
        return _autopysta.fltvec_push_back(self, x)

    def front(self):
        return _autopysta.fltvec_front(self)

    def back(self):
        return _autopysta.fltvec_back(self)

    def assign(self, n, x):
        return _autopysta.fltvec_assign(self, n, x)

    def resize(self, *args):
        return _autopysta.fltvec_resize(self, *args)

    def insert(self, *args):
        return _autopysta.fltvec_insert(self, *args)

    def reserve(self, n):
        return _autopysta.fltvec_reserve(self, n)

    def capacity(self):
        return _autopysta.fltvec_capacity(self)
    __swig_destroy__ = _autopysta.delete_fltvec

# Register fltvec in _autopysta:
_autopysta.fltvec_swigregister(fltvec)
class fltvecvec(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _autopysta.fltvecvec_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _autopysta.fltvecvec___nonzero__(self)

    def __bool__(self):
        return _autopysta.fltvecvec___bool__(self)

    def __len__(self):
        return _autopysta.fltvecvec___len__(self)

    def __getslice__(self, i, j):
        return _autopysta.fltvecvec___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _autopysta.fltvecvec___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _autopysta.fltvecvec___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _autopysta.fltvecvec___delitem__(self, *args)

    def __getitem__(self, *args):
        return _autopysta.fltvecvec___getitem__(self, *args)

    def __setitem__(self, *args):
        return _autopysta.fltvecvec___setitem__(self, *args)

    def pop(self):
        return _autopysta.fltvecvec_pop(self)

    def append(self, x):
        return _autopysta.fltvecvec_append(self, x)

    def empty(self):
        return _autopysta.fltvecvec_empty(self)

    def size(self):
        return _autopysta.fltvecvec_size(self)

    def swap(self, v):
        return _autopysta.fltvecvec_swap(self, v)

    def begin(self):
        return _autopysta.fltvecvec_begin(self)

    def end(self):
        return _autopysta.fltvecvec_end(self)

    def rbegin(self):
        return _autopysta.fltvecvec_rbegin(self)

    def rend(self):
        return _autopysta.fltvecvec_rend(self)

    def clear(self):
        return _autopysta.fltvecvec_clear(self)

    def get_allocator(self):
        return _autopysta.fltvecvec_get_allocator(self)

    def pop_back(self):
        return _autopysta.fltvecvec_pop_back(self)

    def erase(self, *args):
        return _autopysta.fltvecvec_erase(self, *args)

    def __init__(self, *args):
        _autopysta.fltvecvec_swiginit(self, _autopysta.new_fltvecvec(*args))

    def push_back(self, x):
        return _autopysta.fltvecvec_push_back(self, x)

    def front(self):
        return _autopysta.fltvecvec_front(self)

    def back(self):
        return _autopysta.fltvecvec_back(self)

    def assign(self, n, x):
        return _autopysta.fltvecvec_assign(self, n, x)

    def resize(self, *args):
        return _autopysta.fltvecvec_resize(self, *args)

    def insert(self, *args):
        return _autopysta.fltvecvec_insert(self, *args)

    def reserve(self, n):
        return _autopysta.fltvecvec_reserve(self, n)

    def capacity(self):
        return _autopysta.fltvecvec_capacity(self)
    __swig_destroy__ = _autopysta.delete_fltvecvec

# Register fltvecvec in _autopysta:
_autopysta.fltvecvec_swigregister(fltvecvec)
class Geometry(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*

        Constructs a `Geometry` object with specified physical properties.

        Validates that the highway length and initial lanes are positive.
        Checks that merge and diverge positions are within the highway’s bounds and sorted in ascending order.
        Ensures that merges do not reduce lanes below one, and that diverges do not unrealistically increase lane count.

        :type length: float
        :param length: Length of the highway segment in meters.
        :type initial_lanes: int
        :param initial_lanes: Initial number of lanes at the start of the segment.
        :type merge_positions: std::vector< double,std::allocator< double > >
        :param merge_positions: Positions where lanes merge (sorted in ascending order).
        :type diverge_positions: std::vector< double,std::allocator< double > >
        :param diverge_positions: Positions where lanes diverge (sorted in ascending order).
        :raises: Exception if any of the input parameters are invalid.

        |

        *Overload 2:*

        Constructs a `Geometry` object with specified physical properties.

        :type length: float
        :param length: Length of the highway segment in meters.
        :type initial_lanes: int
        :param initial_lanes: Initial number of lanes at the start of the segment.
        :type merge_position: float
        :param merge_position: Position where lanes merge.
        :type diverge_position: float
        :param diverge_position: Positions where lanes diverge.
        :raises: Exception if any of the input parameters are invalid.

        |

        *Overload 3:*

        Constructs a `Geometry` object with specified physical properties.

        :type length: float
        :param length: Length of the highway segment in meters.
        :type initial_lanes: int
        :param initial_lanes: Initial number of lanes at the start of the segment.
        :type merge_positions: std::vector< double,std::allocator< double > >
        :param merge_positions: Positions where lanes merge (sorted in ascending order).
        :type diverge_position: float
        :param diverge_position: Position where a the lanes diverge.
        :raises: Exception if any of the input parameters are invalid.

        |

        *Overload 4:*

        Constructs a `Geometry` object with specified physical properties.

        :type length: float
        :param length: Length of the highway segment in meters.
        :type initial_lanes: int
        :param initial_lanes: Initial number of lanes at the start of the segment.
        :type merge_position: float
        :param merge_position: Position where lanes merge.
        :type diverge_positions: std::vector< double,std::allocator< double > >
        :param diverge_positions: Positions where a the lanes diverge (sorted in ascending order).
        :raises: Exception if any of the input parameters are invalid.

        |

        *Overload 5:*

        Constructs a `Geometry` object with minimal properties (no ramps).

        :type length: float
        :param length: Length of the highway segment in meters.
        :type lanes: int
        :param lanes: Number of lanes.
        """
        _autopysta.Geometry_swiginit(self, _autopysta.new_Geometry(*args))

    def get_length(self):
        r"""
        Returns the total length of the highway segment.

        :rtype: float
        :return: The length of the highway in meters.
        """
        return _autopysta.Geometry_get_length(self)

    def get_initial_lanes(self):
        r"""
        Returns the initial number of lanes on the highway.

        :rtype: int
        :return: The total number of lanes (excluding on/off-ramps).
        """
        return _autopysta.Geometry_get_initial_lanes(self)

    def get_max_lanes(self):
        r"""
        Returns the max amount of lanes on the highway

        :rtype: int
        :return: returns max_lanes which includes the ammount of merges and diverges
        """
        return _autopysta.Geometry_get_max_lanes(self)

    def get_current_lanes(self, position):
        r"""
        Returns the current number of lanes based on a given position.
        :type position: float
        :param position: The position along the highway segment in meters.
        :rtype: int
        :return: The current number of lanes.
        """
        return _autopysta.Geometry_get_current_lanes(self, position)

    def can_change_left(self, point):
        r"""
        Checks if a vehicle can change lanes to the left.

        :type point: :py:class:`Point`
        :param point: Pointer to the current position of the vehicle.
        :rtype: boolean
        :return: `true` if a left lane change is allowed, `false` otherwise.
        """
        return _autopysta.Geometry_can_change_left(self, point)

    def can_change_right(self, point):
        r"""
        Checks if a vehicle can change lanes to the right.

        :type point: :py:class:`Point`
        :param point: Pointer to the current position of the vehicle.
        :rtype: boolean
        :return: `true` if a right lane change is allowed, `false` otherwise.
        """
        return _autopysta.Geometry_can_change_right(self, point)

    def has_merge(self):
        r"""
        Checks if the highway segment has an on-ramp (merge).

        :rtype: boolean
        :return: `true` if there is an on-ramp, `false` otherwise.
        """
        return _autopysta.Geometry_has_merge(self)

    def has_diverge(self):
        r"""
        Checks if the highway segment has an off-ramp (diverge).

        :rtype: boolean
        :return: `true` if there is an off-ramp, `false` otherwise.
        """
        return _autopysta.Geometry_has_diverge(self)

    def get_merge_positions(self):
        r"""
        Returns the merge positions along the highway.
        :rtype: std::vector< double,std::allocator< double > >
        :return: A vector of merge positions in meters.
        """
        return _autopysta.Geometry_get_merge_positions(self)

    def get_diverge_positions(self):
        r"""
        Returns the diverge positions along the highway.
        :rtype: std::vector< double,std::allocator< double > >
        :return: A vector of diverge positions in meters.
        """
        return _autopysta.Geometry_get_diverge_positions(self)

    def print_highway(self):
        r"""
        Returns the current lane count at a specified position for debugging purposes.
        :param position: The position along the highway.
        :rtype: void
        :return: The current number of lanes at the given position.
        """
        return _autopysta.Geometry_print_highway(self)
    __swig_destroy__ = _autopysta.delete_Geometry

# Register Geometry in _autopysta:
_autopysta.Geometry_swigregister(Geometry)
class RoadObject(object):
    r"""
    Abstract base class representing any object on the road.

    The `RoadObject` class serves as a general interface for objects on the road, whether they are moving vehicles or fixed objects.
    It handles the object's trajectory and allows updating based on interactions with other road objects.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    model = property(_autopysta.RoadObject_model_get, _autopysta.RoadObject_model_set, doc=r""" Pointer to the model associated with the object (optional).""")
    trajectory = property(_autopysta.RoadObject_trajectory_get, _autopysta.RoadObject_trajectory_set, doc=r""" Object's trajectory, which defines its movement and positions over time.""")
    defined_t = property(_autopysta.RoadObject_defined_t_get, _autopysta.RoadObject_defined_t_set, doc=r""" A queue of defined trajectory points provided by the user.""")
    __swig_destroy__ = _autopysta.delete_RoadObject

    def current(self):
        r"""
        Get the current point of the object.

        This pure virtual function must be implemented by derived classes to return the object's current position and state.

        :rtype: :py:class:`Point`
        :return: A pointer to the current point representing the object's state.
        """
        return _autopysta.RoadObject_current(self)

    def update(self, leader):
        r"""
        Update the object's state based on another road object.

        This pure virtual function must be implemented by derived classes. It updates the object’s state, such as position and speed,
        possibly considering the position of a leader or other objects on the road.

        :type leader: :py:class:`RoadObject`
        :param leader: A pointer to the road object that may influence this object’s state.
        """
        return _autopysta.RoadObject_update(self, leader)

# Register RoadObject in _autopysta:
_autopysta.RoadObject_swigregister(RoadObject)
class Vehicle(RoadObject):
    r"""
    Class representing a moving vehicle on the road.

    The `vehicle` class models a moving vehicle, which can either follow a predefined trajectory or behave according to a dynamic model.
    It offers multiple constructors to accommodate different ways of specifying the vehicle’s movement, including position history,
    points, or models that dictate its behavior.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    needs_initialization = property(_autopysta.Vehicle_needs_initialization_get, _autopysta.Vehicle_needs_initialization_set, doc=r""" Flag indicating if the vehicle requires initialization within the simulation.""")
    placeholder_points = property(_autopysta.Vehicle_placeholder_points_get, _autopysta.Vehicle_placeholder_points_set, doc=r""" A vector of placeholder points used before simulation starts.""")

    def __init__(self, *args):
        r"""
        *Overload 1:*

        Create a vehicle with a predefined trajectory and a single lane.

        This constructor initializes a vehicle with a list of X positions and a single lane. It assumes that the positions are
        equally spaced in time, with a fixed delta time between points.

        :type x: std::vector< double,std::allocator< double > >
        :param x: A vector of X positions representing the vehicle’s position over time.
        :type l: int
        :param l: The lane in which the vehicle is moving.

        |

        *Overload 2:*

        Create a vehicle with a predefined trajectory across multiple lanes.

        This constructor initializes a vehicle with a list of X positions and a list of lane positions.
        It assumes that the positions are equally spaced in time, with a fixed delta time between points.

        :type x: std::vector< double,std::allocator< double > >
        :param x: A vector of X positions representing the vehicle’s position over time.
        :type l: std::vector< int,std::allocator< int > >
        :param l: A vector of lane positions corresponding to each X position.
        :raises: Exception If the size of `x` and `l` do not match.

        |

        *Overload 3:*

        Create a vehicle with a predefined trajectory based on points.

        This constructor initializes a vehicle with a list of `point` objects that define its trajectory over time.

        :type p: std::vector< Point *,std::allocator< Point * > >
        :param p: A vector of pointers to `point` objects representing the vehicle's trajectory.
        :raises: Exception If the size of the trajectory is too short.

        |

        *Overload 4:*

        Create a vehicle with a model, initial position, speed, and lane.

        This constructor initializes a vehicle with a dynamic model that dictates its behavior, along with its initial position,
        speed, and lane.

        :type model: :py:class:`Model`
        :param model: Pointer to the model that will describe the vehicle's behavior.
        :type position: float
        :param position: The initial position of the vehicle.
        :type speed: float
        :param speed: The initial speed of the vehicle.
        :type lane: int
        :param lane: The lane in which the vehicle starts.

        |

        *Overload 5:*

        Create a vehicle with a model and a starting point.

        This constructor initializes a vehicle with a dynamic model and a starting point, which contains information about its
        position, speed, and lane.

        :type model: :py:class:`Model`
        :param model: Pointer to the model that will describe the vehicle's behavior.
        :type point: :py:class:`Point`
        :param point: Pointer to the initial point of the vehicle.
        """
        _autopysta.Vehicle_swiginit(self, _autopysta.new_Vehicle(*args))

    def initialize_vehicle(self):
        r"""
        Initialize the vehicle’s trajectory with real points.

        This method initializes the placeholder points of a vehicle that was created with a predefined trajectory,
        replacing them with real points in the simulation.
        """
        return _autopysta.Vehicle_initialize_vehicle(self)

    def p(self):
        r"""
        Get the model parameters associated with the vehicle.

        :rtype: :py:class:`params`
        :return: A pointer to the model parameters (`params`).
        """
        return _autopysta.Vehicle_p(self)

    def current(self):
        r"""
        Get the current point of the vehicle.

        This method returns the vehicle's current position and state based on its trajectory.

        :rtype: :py:class:`Point`
        :return: A pointer to the current point.
        """
        return _autopysta.Vehicle_current(self)

    def update(self, leader):
        r"""
        Update the vehicle's state based on a leader vehicle.

        This method updates the vehicle's state (position, speed, etc.) based on the trajectory of a leading vehicle.
        If no leader is provided, the vehicle's state is updated according to its model or predefined trajectory.

        :type leader: :py:class:`RoadObject`
        :param leader: A pointer to the road object acting as the leader vehicle.
        :raises: Exception If the vehicle runs out of predefined points for the simulation.
        """
        return _autopysta.Vehicle_update(self, leader)
    __swig_destroy__ = _autopysta.delete_Vehicle

# Register Vehicle in _autopysta:
_autopysta.Vehicle_swigregister(Vehicle)
class FixedObject(RoadObject):
    r"""
    Class representing a fixed object on the road.

    The `FixedObject` class models a static object on the road, such as a roadblock or a parked vehicle.
    It remains stationary and has a fixed position in the simulation.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, pos):
        r"""
        Constructor for the `FixedObject` class.

        Initializes the object with a fixed position on the road.

        :type pos: :py:class:`Point`
        :param pos: A pointer to the position of the object.
        """
        _autopysta.FixedObject_swiginit(self, _autopysta.new_FixedObject(pos))

    def current(self):
        r"""
        Get the current position of the fixed object.

        Since the object is fixed, this method always returns the same position.

        :rtype: :py:class:`Point`
        :return: A pointer to the object's current position.
        """
        return _autopysta.FixedObject_current(self)

    def update(self, ro):
        r"""
        Update the state of the fixed object.

        Since the object is fixed, this method does nothing. It is provided to satisfy the interface.

        :type ro: :py:class:`RoadObject`
        :param ro: A pointer to another road object (unused in this context).
        """
        return _autopysta.FixedObject_update(self, ro)
    __swig_destroy__ = _autopysta.delete_FixedObject

# Register FixedObject in _autopysta:
_autopysta.FixedObject_swigregister(FixedObject)
class Simulation(object):
    r"""
    The `simulation` class manages a traffic simulation over time.

    This class controls the creation of vehicles, their movement, lane changes,
    and interactions on a highway-like scenario. It updates vehicle states in
    discrete time steps.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*

        Constructs a simulation with a common creator for all lanes.

        :type lane_change_model: LCM
        :param lane_change_model: Lane-changing model.
        :type total_time: float
        :param total_time: Total simulation time.
        :type geometry: :py:class:`Geometry`
        :param geometry: Highway geometry.
        :type creator: :py:class:`Creator`
        :param creator: Vehicle creator for all lanes.
        :type time_step: float
        :param time_step: Time step for the simulation.
        :type verbose: boolean, optional
        :param verbose: flag to enable verbose mode that prints some aditional info

        |

        *Overload 2:*

        Constructs a simulation with specific creators for each lane.

        :type lane_change_model: LCM
        :param lane_change_model: Lane-changing model.
        :type total_time: float
        :param total_time: Total simulation time.
        :type geometry: :py:class:`Geometry`
        :param geometry: Highway geometry.
        :type creators: std::vector< Creator *,std::allocator< Creator * > >
        :param creators: Vector of vehicle creators for each lane.
        :type vehicle: :py:class:`Vehicle`
        :param vehicle: A specific vehicle to insert into the simulation.
        :type time_step: float
        :param time_step: Time step for the simulation.
        :type verbose: boolean, optional
        :param verbose: flag to enable verbose mode that prints some aditional info

        |

        *Overload 3:*

        Constructs a simulation with specific creators for each lane.

        :type lane_change_model: LCM
        :param lane_change_model: Lane-changing model.
        :type total_time: float
        :param total_time: Total simulation time.
        :type geometry: :py:class:`Geometry`
        :param geometry: Highway geometry.
        :type creators: std::vector< Creator *,std::allocator< Creator * > >
        :param creators: Vector of vehicle creators for each lane.
        :type vehicle: :py:class:`Vehicle`
        :param vehicle: A specific vehicle to insert into the simulation.
        :type time_step: float
        :param time_step: Time step for the simulation.
        :param verbose: flag to enable verbose mode that prints some aditional info

        |

        *Overload 4:*

        Constructs a simulation with specific creators and vehicles.

        :type lane_change_model: LCM
        :param lane_change_model: Lane-changing model.
        :type total_time: float
        :param total_time: Total simulation time.
        :type geometry: :py:class:`Geometry`
        :param geometry: Highway geometry.
        :type creators: std::vector< Creator *,std::allocator< Creator * > >
        :param creators: Vector of vehicle creators for each lane.
        :type vehicles: std::vector< Vehicle *,std::allocator< Vehicle * > >
        :param vehicles: Vector of pre-existing vehicles to insert into the simulation.
        :type time_step: float
        :param time_step: Time step for the simulation.
        :type verbose: boolean, optional
        :param verbose: flag to enable verbose mode that prints some aditional info

        |

        *Overload 5:*

        Constructs a simulation with specific creators and vehicles.

        :type lane_change_model: LCM
        :param lane_change_model: Lane-changing model.
        :type total_time: float
        :param total_time: Total simulation time.
        :type geometry: :py:class:`Geometry`
        :param geometry: Highway geometry.
        :type creators: std::vector< Creator *,std::allocator< Creator * > >
        :param creators: Vector of vehicle creators for each lane.
        :type vehicles: std::vector< Vehicle *,std::allocator< Vehicle * > >
        :param vehicles: Vector of pre-existing vehicles to insert into the simulation.
        :type time_step: float
        :param time_step: Time step for the simulation.
        :param verbose: flag to enable verbose mode that prints some aditional info
        """
        _autopysta.Simulation_swiginit(self, _autopysta.new_Simulation(*args))

    def run(self, *args):
        r"""
        Runs the simulation.

        This method runs the simulation, advancing the simulation state step
        by step until completion.

        :rtype: :py:class:`Results`
        :return: A pointer to a `results` object containing the simulation results.
        """
        return _autopysta.Simulation_run(self, *args)
    __swig_destroy__ = _autopysta.delete_Simulation

# Register Simulation in _autopysta:
_autopysta.Simulation_swigregister(Simulation)

def is_python_builtin():
    return _autopysta.is_python_builtin()

def _autopysta_graph_trajectories(self, lane=-1):
    """
    Plot trajectories for all lanes or a specific lane.

    Args:
        lane (int): Lane number to plot. Default is -1 for all lanes.
    """
    colors = ['g-', 'r-', 'b-', 'k-', 'c-', 'm-', 'y-']
    plt.figure()
    if lane == -1:
        trys = self.get_all_trajectories_by_lane()
        plt.title("All lanes")
    else:
        trys = self.get_trajectories_by_lane(lane)
        plt.title(f"Lane {lane}")
    plt.xlabel("Time (seconds)")
    plt.ylabel("Position (meters)")
    for pi in range(len(trys)):
        pd = trys[pi]
        lane_num = pd[0].LANE()
        times = [pd[i].T() for i in range(len(pd))]
        positions = [pd[i].X() for i in range(len(pd))]
        plt.plot(times, positions, colors[lane_num % len(colors)])
    plt.show()

def _autopysta_graph_velocities(self, lane=-1):
    """
    Plot velocities for all lanes or a specific lane.

    Args:
        lane (int): Lane number to plot. Default is -1 for all lanes.
    """
    colors = ['g-', 'r-', 'b-', 'k-', 'c-', 'm-', 'y-']
    plt.figure()
    if(lane == -1):
        trys = self.get_all_trajectories_by_lane()
        plt.title("All lanes")
    else:
        trys = self.get_trajectories_by_lane(lane)
        plt.title(f"Lane {lane}")
    plt.xlabel("Time (seconds)")
    plt.ylabel("Velocity (m/s)")    
    for pi in range(len(trys)):
        pd = trys[pi]
        lane_num = pd[0].LANE()
        times = [pd[i].T() for i in range(len(pd))]
        velocities = [pd[i].V() for i in range(len(pd))]
        plt.plot(times, velocities, colors[lane_num % len(colors)])
    plt.show()

Results.plot_x_vs_t = _autopysta_graph_trajectories
Results.plot_v_vs_t = _autopysta_graph_velocities

class AutopystaException(BaseException):
    """
    Custom exception class for Autopysta errors.

    Attributes:
        code (int): The error code associated with the exception, representing the specific type of error.
        message (str): Detailed error message providing additional context for the exception.

    Methods:
        code(): Returns the error code associated with the exception.
        message(): Returns the error message describing the exception.

    Example usage in Python:
    ```python
    import autopysta as ap

    try:
        // Call a function that may raise an exception
        ap.some_function()
    except ap.AutopystaException as e:
        print(e)
    ```
    """
    def __init__(self):
        BaseException.__init__(self)
        self.myexc = Exception()

AutopystaException = _autopysta.Exception


