# AMPL Model by Hande Y. Benson
#
# Copyright (C) 2001 Princeton University
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and
# its documentation for any purpose and without fee is hereby
# granted, provided that the above copyright notice appear in all
# copies and that the copyright notice and this
# permission notice appear in all supporting documentation.                     

#   classification OOR2-MY-6-200

param np := 100;
param x{1..np};
param y{1..np};

var v1 := -40.0;
var w1 := 5.0;
var d >= 1e-8, := 1.0;
var a >= 1.0, := 2.0;
var t >= 0.0, <= 6.2831852, := 1.5;
var r >= 0.39, := 0.75;

minimize f:
	(d+r)^2*acos(-( (a*d)^2 - (a*d+r)^2 +(d+r)^2)/(2*(d+r)*a*d))
	-(a*d+r)^2*acos(( (a*d)^2+ (a*d+r)^2 -(d+r)^2)/(2*(a*d+r)*a*d))
	+(d+r)*a*d*sin(acos(-( (a*d)^2 - (a*d+r)^2 +(d+r)^2)/(2*(d+r)*a*d)));
subject to cons1{i in 1..np}:
	(v1+a*d*cos(t)-x[i])^2 + (w1+a*d*sin(t)-y[i])^2 - (d+r)^2<= 0.0;
subject to cons2{i in 1..np}:
	(v1-x[i])^2 + (w1-y[i])^2 - (a*d+r)^2 >= 0.0;
data;
param: x y :=
1                  0.544 0.492
2                  0.714 0.505
3                  0.594 0.094
4                  0.474 0.398
5                  0.470 0.804
6                  0.241 0.955
7                  0.503 0.097
8                  0.854 0.359
9                  0.438 0.477
10                 0.294 0.887
11                 0.479 0.372
12                 0.413 0.911
13                 0.722 0.082
14                 0.358 0.788
15                 0.836 0.225
16                 0.648 0.424
17                 0.267 0.932
18                 0.362 0.697
19                 0.232 0.969
20                 0.667 0.527
21                 0.476 0.735
22                 0.868 0.141
23                 0.603 0.550
24                 0.788 0.399
25                 0.745 0.365
26                 0.627 0.762
27                 0.394 0.779
28                 0.220 0.869
29                 0.548 0.625
30                 0.446 0.778
31                 0.463 0.762
32                 0.541 0.068
33                 0.631 0.670
34                 0.735 0.151
35                 0.674 0.490
36                 0.620 0.565
37                 0.257 0.862
38                 0.659 0.010
39                 0.475 0.585
40                 0.708 0.475
41                 0.545 0.371
42                 0.586 0.085
43                 0.796 0.309
44                 0.525 0.573
45                 0.498 0.530
46                 0.790 0.217
47                 0.632 0.169
48                 0.699 0.024
49                 0.758 0.436
50                 0.656 0.662
51                 0.652 0.251
52                 0.801 0.511
53                 0.730 0.611
54                 0.689 0.277
55                 0.527 0.612
56                 0.696 0.074
57                 0.911 0.052
58                 0.805 0.075
59                 0.764 0.067
60                 0.331 0.759
61                 0.078 0.983
62                 0.656 0.340
63                 0.480 0.232
64                 0.503 0.140
65                 0.412 0.683
66                 0.338 0.624
67                 0.920 0.139
68                 0.548 0.474
69                 0.826 0.443
70                 0.071 0.969
71                 0.635 0.728
72                 0.591 0.570
73                 0.489 0.427
74                 0.565 0.105
75                 0.791 0.554
76                 0.725 0.174
77                 0.091 0.951
78                 0.401 0.790
79                 0.226 0.968
80                 0.518 0.663
81                 0.651 0.166
82                 0.738 0.146
83                 0.509 0.280
84                 0.833 0.176
85                 0.669 0.044
86                 0.121 0.921
87                 0.809 0.458
88                 0.477 0.436
89                 0.267 0.840
90                 0.412 0.630
91                 0.663 0.648
92                 0.830 0.086
93                 0.324 0.862
94                 0.225 0.853
95                 0.870 0.331
96                 0.343 0.629
97		   0.849 0.521
98                 0.655 0.714
99                 0.558 0.005
100                0.830 0.526
;

solve;
display f;
display v1, w1, a, d, r, t;