#  _________________________________________________________________________
#
#  Coopr: A COmmon Optimization Python Repository
#  Copyright (c) 2010 Sandia Corporation.
#  This software is distributed under the BSD License.
#  Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
#  the U.S. Government retains certain rights in this software.
#  For more information, see the Coopr README.txt file.
#  _________________________________________________________________________

# Formulated in Pyomo by Carl D. Laird, Daniel P. Word, Brandon C. Barrera and Saumyajyoti Chaudhuri
#
#Taken from:

# AMPL Model by Hande Y. Benson
#
# Copyright (C) 2001 Princeton University
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and
# its documentation for any purpose and without fee is hereby
# granted, provided that the above copyright notice appear in all
# copies and that the copyright notice and this
# permission notice appear in all supporting documentation.

#   Source: another very simple box-constrained quadratic

#   classification QBR2-AN-2-0

from coopr.pyomo import *
model = AbstractModel()

model.x1 = Var(initialize = 10)
model.x2 = Var(bounds=(0,0.5),initialize=1)

def f(model):
    return model.x2 + (-model.x1+model.x2)**2 + (model.x1+model.x2)**2
model.f = Objective(rule=f,sense = minimize)
