
#  _________________________________________________________________________
#
#  Coopr: A COmmon Optimization Python Repository
#  Copyright (c) 2010 Sandia Corporation.
#  This software is distributed under the BSD License.
#  Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
#  the U.S. Government retains certain rights in this software.
#  For more information, see the Coopr README.txt file.
#  _________________________________________________________________________

# Formulated in Pyomo by Carl D. Laird, Daniel P. Word, Brandon C. Barrera and Saumyajyoti Chaudhuri
# Taken from:

# AMPL Model by Hande Y. Benson
#
# Copyright (C) 2001 Princeton University
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and
# its documentation for any purpose and without fee is hereby
# granted, provided that the above copyright notice appear in all
# copies and that the copyright notice and this
# permission notice appear in all supporting documentation.

#   Source:  problem 21 in
#   J.J. More', B.S. Garbow and K.E. Hillstrom,
#   "Testing Unconstrained Optimization Software",
#   ACM Transactions on Mathematical Software, vol. 7(1), pp. 17-41, 1981.

#   SIF input: Ph. Toint, Dec 1989.

#   classification SUR2-AN-V-0

from coopr.pyomo import *
model = AbstractModel()

model.N = Param(initialize=10000)

model.R1 = RangeSet(1,model.N)
def xrule(model, i):
    if(i%2==1):
        return -1.2
    else:
        return 1
model.x = Var(model.R1,initialize=xrule)

model.R2 = RangeSet(1,model.N/2.0)
def f(model):
    return sum([( 100*(model.x[2*i]-model.x[2*i-1]**2)**2 + (model.x[2*i-1]-1)**2 ) for i in model.R2])
model.f = Objective(rule=f,sense=minimize)
