class e{constructor(e){this.socketManager=e,this.currentWorkingDir=null,this.footerDirObserver=null,this._updatingFooter=!1,this.setupEventHandlers(),this.initialize(),console.log("Working directory manager initialized")}initialize(){this.initializeWorkingDirectory(),this.watchFooterDirectory()}setupEventHandlers(){const e=document.getElementById("change-dir-btn"),t=document.getElementById("working-dir-path");if(e&&e.addEventListener("click",()=>{this.showChangeDirDialog()}),t&&t.addEventListener("click",e=>{e.shiftKey?this.showChangeDirDialog():this.showWorkingDirectoryViewer()}),document.addEventListener("sessionChanged",e=>{const t=e.detail.sessionId;console.log("[WORKING-DIR-DEBUG] sessionChanged event received, sessionId:",this.repr(t)),t&&this.loadWorkingDirectoryForSession(t)}),this.socketManager&&this.socketManager.getSocket){const e=this.socketManager.getSocket();e&&(console.log("[WORKING-DIR-DEBUG] Setting up git_branch_response listener"),e.on("git_branch_response",e=>{console.log("[GIT-BRANCH-DEBUG] Received git_branch_response:",e),this.handleGitBranchResponse(e)}))}}initializeWorkingDirectory(){const e=document.getElementById("working-dir-path");e&&!e.textContent.trim()&&(e.textContent="Loading...");const t=document.getElementById("session-select");t&&t.value&&"all"!==t.value?this.loadWorkingDirectoryForSession(t.value):this.setWorkingDirectory(this.getDefaultWorkingDir())}watchFooterDirectory(){const e=document.getElementById("footer-working-dir");e&&(this.footerDirObserver=new MutationObserver(t=>{this._updatingFooter||t.forEach(t=>{if("childList"===t.type||"characterData"===t.type){const t=e.textContent.trim();console.log("Footer directory changed to:",t),t&&t!==this.currentWorkingDir&&(console.log("Syncing working directory from footer change"),this.setWorkingDirectory(t))}})}),this.footerDirObserver.observe(e,{childList:!0,characterData:!0,subtree:!0}),console.log("Started watching footer directory for changes"))}loadWorkingDirectoryForSession(e){if(console.log("[WORKING-DIR-DEBUG] loadWorkingDirectoryForSession called with sessionId:",this.repr(e)),!e||"all"===e){console.log('[WORKING-DIR-DEBUG] No sessionId or sessionId is "all", using default working dir');const e=this.getDefaultWorkingDir();return console.log("[WORKING-DIR-DEBUG] Default working dir:",this.repr(e)),void this.setWorkingDirectory(e)}const t=JSON.parse(localStorage.getItem("sessionWorkingDirs")||"{}");console.log("[WORKING-DIR-DEBUG] Session directories from localStorage:",t);const r=t[e],o=this.getDefaultWorkingDir(),i=r||o;console.log("[WORKING-DIR-DEBUG] Directory selection:",{sessionId:e,sessionDir:this.repr(r),defaultDir:this.repr(o),finalDir:this.repr(i)}),this.setWorkingDirectory(i)}setWorkingDirectory(e){console.log("[WORKING-DIR-DEBUG] setWorkingDirectory called with:",this.repr(e)),this.currentWorkingDir=e,e&&this.validateDirectoryPath(e)&&(sessionStorage.setItem("currentWorkingDirectory",e),console.log("[WORKING-DIR-DEBUG] Stored working directory in session storage:",e));const t=document.getElementById("working-dir-path");t?(console.log("[WORKING-DIR-DEBUG] Updating UI path element to:",e),t.textContent=e):console.warn("[WORKING-DIR-DEBUG] working-dir-path element not found");const r=document.getElementById("footer-working-dir");if(r){const t=r.textContent;console.log("[WORKING-DIR-DEBUG] Footer directory current text:",this.repr(t),"new text:",this.repr(e)),t!==e?(this._updatingFooter=!0,r.textContent=e,console.log("[WORKING-DIR-DEBUG] Updated footer directory to:",e),setTimeout(()=>{this._updatingFooter=!1,console.log("[WORKING-DIR-DEBUG] Cleared _updatingFooter flag")},100)):console.log("[WORKING-DIR-DEBUG] Footer directory already has correct text")}else console.warn("[WORKING-DIR-DEBUG] footer-working-dir element not found");const o=document.getElementById("session-select");if(o&&o.value&&"all"!==o.value){const t=o.value,r=JSON.parse(localStorage.getItem("sessionWorkingDirs")||"{}");r[t]=e,localStorage.setItem("sessionWorkingDirs",JSON.stringify(r)),console.log(`[WORKING-DIR-DEBUG] Saved working directory for session ${t}:`,e)}else console.log('[WORKING-DIR-DEBUG] No session selected or session is "all", not saving to localStorage');console.log("[WORKING-DIR-DEBUG] About to call updateGitBranch with:",this.repr(e)),this.validateDirectoryPath(e)?this.updateGitBranch(e):console.log("[WORKING-DIR-DEBUG] Skipping git branch update for invalid directory:",this.repr(e)),document.dispatchEvent(new CustomEvent("workingDirectoryChanged",{detail:{directory:e}})),console.log("[WORKING-DIR-DEBUG] Working directory set to:",e)}updateGitBranch(e){if(console.log("[GIT-BRANCH-DEBUG] updateGitBranch called with dir:",this.repr(e),"type:",typeof e),!this.socketManager||!this.socketManager.isConnected()){console.log("[GIT-BRANCH-DEBUG] Not connected to socket server");const e=document.getElementById("footer-git-branch");return void(e&&(e.textContent="Not Connected",e.style.display="inline"))}const t=this.validateDirectoryPath(e),r="Loading..."===e||"Loading"===e,o="Unknown"===e,i=!e||"string"==typeof e&&""===e.trim();if(console.log("[GIT-BRANCH-DEBUG] Validation results:",{dir:e,isValidPath:t,isLoadingState:r,isUnknown:o,isEmptyOrWhitespace:i,shouldReject:!t||r||o||i}),!t||r||o||i){console.warn("[GIT-BRANCH-DEBUG] Invalid working directory for git branch request:",e);const t=document.getElementById("footer-git-branch");return void(t&&(t.textContent=r?"Loading...":o||i?"No Directory":"Invalid Directory",t.style.display="inline"))}const n=this.socketManager.getSocket();n?(console.log("[GIT-BRANCH-DEBUG] Requesting git branch for directory:",e),console.log("[GIT-BRANCH-DEBUG] Socket state:",{connected:n.connected,id:n.id}),n.emit("get_git_branch",e)):console.error("[GIT-BRANCH-DEBUG] No socket available for git branch request")}getDefaultWorkingDir(){if(console.log("[WORKING-DIR-DEBUG] getDefaultWorkingDir called"),this.currentWorkingDir&&this.validateDirectoryPath(this.currentWorkingDir))return console.log("[WORKING-DIR-DEBUG] Using current working directory:",this.currentWorkingDir),this.currentWorkingDir;const e=document.querySelector(".working-dir-text");if(e?.textContent?.trim()){const t=e.textContent.trim();if("Loading..."!==t&&"Unknown"!==t&&this.validateDirectoryPath(t))return console.log("[WORKING-DIR-DEBUG] Using header working directory:",t),t}const t=document.getElementById("footer-working-dir");if(t?.textContent?.trim()){const e=t.textContent.trim();console.log("[WORKING-DIR-DEBUG] Footer path found:",this.repr(e));const r="Unknown"===e,o=this.validateDirectoryPath(e);if(console.log("[WORKING-DIR-DEBUG] Footer path validation:",{footerPath:this.repr(e),isUnknown:r,isValid:o,shouldUse:!r&&o}),!r&&o)return console.log("[WORKING-DIR-DEBUG] Using footer path as default:",e),e}else console.log("[WORKING-DIR-DEBUG] No footer directory element or no text content");if(window.socketClient&&window.socketClient.events){const e=window.socketClient.events.filter(e=>e.data&&(e.data.working_directory||e.data.cwd||e.data.working_dir)).reverse();if(e.length>0){const t=e[0],r=t.data.working_directory||t.data.cwd||t.data.working_dir;return console.log("[WORKING-DIR-DEBUG] Using working directory from recent event:",r),r}}const r=document.getElementById("working-dir-path");if(r?.textContent?.trim()){const e=r.textContent.trim();if(console.log("[WORKING-DIR-DEBUG] Found working-dir-path element text:",this.repr(e)),"Unknown"!==e&&this.validateDirectoryPath(e))return console.log("[WORKING-DIR-DEBUG] Using working-dir-path as fallback:",e),e}const o=sessionStorage.getItem("currentWorkingDirectory");if(o&&this.validateDirectoryPath(o))return console.log("[WORKING-DIR-DEBUG] Using session storage working directory:",this.repr(o)),o;const i=window.processWorkingDirectory||process?.cwd?.()||null;if(i&&this.validateDirectoryPath(i))return console.log("[WORKING-DIR-DEBUG] Using process working directory:",this.repr(i)),i;const n=window.homeDirectory||process?.env?.HOME||process?.env?.USERPROFILE||null||process?.cwd?.()||os?.homedir?.()||"/Users/masa";return console.log("[WORKING-DIR-DEBUG] Using fallback directory (home or cwd):",this.repr(n)),n}showChangeDirDialog(){const e=prompt("Enter new working directory:",this.currentWorkingDir||"");e&&""!==e.trim()&&this.setWorkingDirectory(e.trim())}showWorkingDirectoryViewer(){this.createDirectoryViewerOverlay()}createDirectoryViewerOverlay(){this.removeDirectoryViewerOverlay();const e=document.querySelector(".working-dir-display");if(!e)return;const t=document.createElement("div");t.id="directory-viewer-overlay",t.className="directory-viewer-overlay",t.innerHTML=`\n            <div class="directory-viewer-content">\n                <div class="directory-viewer-header">\n                    <h3 class="directory-viewer-title">\n                        📁 ${this.currentWorkingDir||"Working Directory"}\n                    </h3>\n                    <button class="close-btn" onclick="workingDirectoryManager.removeDirectoryViewerOverlay()">✕</button>\n                </div>\n                <div class="directory-viewer-body">\n                    <div class="loading-indicator">Loading directory contents...</div>\n                </div>\n                <div class="directory-viewer-footer">\n                    <span class="directory-hint">Click file to view • Shift+Click directory path to change</span>\n                </div>\n            </div>\n        `;const r=e.getBoundingClientRect();t.style.cssText=`\n            position: fixed;\n            top: ${r.bottom+5}px;\n            left: ${r.left}px;\n            min-width: 400px;\n            max-width: 600px;\n            max-height: 400px;\n            z-index: 1001;\n            background: white;\n            border-radius: 8px;\n            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.15);\n            border: 1px solid #e2e8f0;\n        `,document.body.appendChild(t),this.loadDirectoryContents(),setTimeout(()=>{document.addEventListener("click",this.handleOutsideClick.bind(this),!0)},100)}removeDirectoryViewerOverlay(){const e=document.getElementById("directory-viewer-overlay");e&&(e.remove(),document.removeEventListener("click",this.handleOutsideClick.bind(this),!0))}handleOutsideClick(e){const t=document.getElementById("directory-viewer-overlay"),r=document.getElementById("working-dir-path");t&&!t.contains(e.target)&&e.target!==r&&this.removeDirectoryViewerOverlay()}loadDirectoryContents(){if(!this.socketManager||!this.socketManager.isConnected())return void this.showDirectoryError("Not connected to server");const e=this.socketManager.getSocket();if(!e)return void this.showDirectoryError("No socket connection available");e.emit("get_directory_listing",{directory:this.currentWorkingDir,limit:50});const t=r=>{e.off("directory_listing_response",t),this.handleDirectoryListingResponse(r)};e.on("directory_listing_response",t),setTimeout(()=>{e.off("directory_listing_response",t);const r=document.getElementById("directory-viewer-overlay");r&&r.querySelector(".loading-indicator")&&this.showDirectoryError("Request timeout")},5e3)}handleDirectoryListingResponse(e){const t=document.querySelector(".directory-viewer-body");if(!t)return;if(!e.success)return void this.showDirectoryError(e.error||"Failed to load directory");const r=e.files||[],o=e.directories||[];let i="";if(this.currentWorkingDir&&"/"!==this.currentWorkingDir){const e=this.currentWorkingDir.split("/").slice(0,-1).join("/")||"/";i+=`\n                <div class="file-item directory-item" onclick="workingDirectoryManager.setWorkingDirectory('${e}')">\n                    <span class="file-icon">📁</span>\n                    <span class="file-name">..</span>\n                    <span class="file-type">parent directory</span>\n                </div>\n            `}o.forEach(e=>{const t=`${this.currentWorkingDir}/${e}`.replace(/\/+/g,"/");i+=`\n                <div class="file-item directory-item" onclick="workingDirectoryManager.setWorkingDirectory('${t}')">\n                    <span class="file-icon">📁</span>\n                    <span class="file-name">${e}</span>\n                    <span class="file-type">directory</span>\n                </div>\n            `}),r.forEach(e=>{const t=`${this.currentWorkingDir}/${e}`.replace(/\/+/g,"/"),r=e.split(".").pop().toLowerCase(),o=this.getFileIcon(r);i+=`\n                <div class="file-item" onclick="workingDirectoryManager.viewFile('${t}')">\n                    <span class="file-icon">${o}</span>\n                    <span class="file-name">${e}</span>\n                    <span class="file-type">${r}</span>\n                </div>\n            `}),""===i&&(i='<div class="no-files">Empty directory</div>'),t.innerHTML=i}showDirectoryError(e){const t=document.querySelector(".directory-viewer-body");t&&(t.innerHTML=`\n                <div class="directory-error">\n                    <span class="error-icon">⚠️</span>\n                    <span class="error-message">${e}</span>\n                </div>\n            `)}getFileIcon(e){return{js:"📄",py:"🐍",html:"🌐",css:"🎨",json:"📋",md:"📝",txt:"📝",yml:"⚙️",yaml:"⚙️",xml:"📄",pdf:"📕",png:"🖼️",jpg:"🖼️",jpeg:"🖼️",gif:"🖼️",svg:"🖼️",zip:"📦",tar:"📦",gz:"📦",sh:"🔧",bat:"🔧",exe:"⚙️",dll:"⚙️"}[e]||"📄"}viewFile(e){this.removeDirectoryViewerOverlay(),window.showFileViewerModal?window.showFileViewerModal(e):console.warn("File viewer modal function not available")}getCurrentWorkingDir(){return this.currentWorkingDir}getSessionDirectories(){return JSON.parse(localStorage.getItem("sessionWorkingDirs")||"{}")}setSessionDirectory(e,t){const r=this.getSessionDirectories();r[e]=t,localStorage.setItem("sessionWorkingDirs",JSON.stringify(r));const o=document.getElementById("session-select");o&&o.value===e&&this.setWorkingDirectory(t)}removeSessionDirectory(e){const t=this.getSessionDirectories();delete t[e],localStorage.setItem("sessionWorkingDirs",JSON.stringify(t))}clearAllSessionDirectories(){localStorage.removeItem("sessionWorkingDirs")}extractWorkingDirectoryFromPair(e){return e.pre?.working_dir?e.pre.working_dir:e.post?.working_dir?e.post.working_dir:e.pre?.data?.working_dir?e.pre.data.working_dir:e.post?.data?.working_dir?e.post.data.working_dir:this.currentWorkingDir||this.getDefaultWorkingDir()}validateDirectoryPath(e){if(!e||"string"!=typeof e)return!1;const t=e.trim();if(0===t.length)return!1;if(t.includes("\0"))return!1;return!["Loading...","Loading","Unknown","undefined","null","Not Connected","Invalid Directory","No Directory"].includes(t)&&(!(!t.startsWith("/")&&!/^[A-Za-z]:/.test(t))||!!(t.startsWith("./")||t.startsWith("../")||/^[a-zA-Z0-9._-]+/.test(t)))}handleGitBranchResponse(e){console.log("[GIT-BRANCH-DEBUG] handleGitBranchResponse called with:",e);const t=document.getElementById("footer-git-branch");if(t){if(e.success)console.log("[GIT-BRANCH-DEBUG] Git branch request successful, branch:",e.branch),t.textContent=e.branch,t.style.display="inline",t.classList.remove("git-error"),t.classList.add("git-success");else{let r="Git Error";const o=e.error||"Unknown error";r=o.includes("Directory not found")||o.includes("does not exist")?"Dir Not Found":o.includes("Not a directory")?"Invalid Path":o.includes("Not a git repository")?"No Git Repo":o.includes("git")?"Git Error":"Unknown",console.log("[GIT-BRANCH-DEBUG] Git branch request failed:",o,"- showing as:",r),t.textContent=r,t.style.display="inline",t.classList.remove("git-success"),t.classList.add("git-error")}e.original_working_dir&&console.log("[GIT-BRANCH-DEBUG] Server received original working_dir:",this.repr(e.original_working_dir)),e.working_dir&&console.log("[GIT-BRANCH-DEBUG] Server used working_dir:",this.repr(e.working_dir)),e.git_error&&console.log("[GIT-BRANCH-DEBUG] Git command stderr:",e.git_error)}else console.warn("[GIT-BRANCH-DEBUG] footer-git-branch element not found")}isWorkingDirectoryReady(){const e=this.getCurrentWorkingDir();return this.validateDirectoryPath(e)&&"Loading..."!==e&&"Unknown"!==e}whenDirectoryReady(e,t=5e3){const r=Date.now(),o=()=>{this.isWorkingDirectoryReady()?e():Date.now()-r<t?setTimeout(o,100):console.warn("[WORKING-DIR-DEBUG] Timeout waiting for directory to be ready")};o()}repr(e){return null===e?"null":void 0===e?"undefined":"string"==typeof e?`"${e}"`:String(e)}cleanup(){this.footerDirObserver&&(this.footerDirObserver.disconnect(),this.footerDirObserver=null),console.log("Working directory manager cleaned up")}}export{e as W};
//# sourceMappingURL=working-directory.js.map
