from typing import overload, Any, Callable, Dict, List, Optional, Set, Tuple, Type, Union
from pccm.stubs import EnumValue, EnumClassValue, enum
from cumm.tensorview import Tensor
from cumm.tensorview import CUDAKernelTimer
class ThrustCustomAllocatorV2:
    alloc_func: Callable[int, int]
class SpconvOps:
    @staticmethod
    def cumm_version() -> str: 
        """
        get cumm version when build spconv.
                
        """
        ...
    @staticmethod
    def is_cpu_only_build() -> bool: ...
    @staticmethod
    def pccm_version() -> str: 
        """
        get pccm version when build spconv.
                
        """
        ...
    @staticmethod
    def generate_conv_inds_stage1(indices: Tensor, indice_pairs: Tensor, indice_pairs_uniq: Tensor, indice_num_per_loc: Tensor, batch_size: int, output_dims: List[int], input_dims: List[int], ksize: List[int], stride: List[int], padding: List[int], dilation: List[int], transposed: bool = False, stream_int: int = 0) -> None: 
        """
        Args:
            indices: 
            indice_pairs: 
            indice_pairs_uniq: 
            indice_num_per_loc: 
            batch_size: 
            output_dims: 
            input_dims: 
            ksize: 
            stride: 
            padding: 
            dilation: 
            transposed: 
            stream_int: 
        """
        ...
    @staticmethod
    def generate_conv_inds_stage1_5(indice_pairs_uniq: Tensor, ndim: int, uniq_size: int, stream_int: int = 0) -> int: 
        """
        Args:
            indice_pairs_uniq: 
            ndim: 
            uniq_size: 
            stream_int: 
        """
        ...
    @staticmethod
    def generate_conv_inds_stage2(indices: Tensor, hashdata_k: Tensor, hashdata_v: Tensor, indice_pairs: Tensor, indice_pairs_uniq: Tensor, indice_pairs_uniq_before_sort: Tensor, out_inds: Tensor, indice_num_per_loc: Tensor, num_out_act: int, batch_size: int, output_dims: List[int], input_dims: List[int], ksize: List[int], stride: List[int], padding: List[int], dilation: List[int], transposed: bool = False, stream_int: int = 0, use_bound_algo: bool = False) -> int: 
        """
        Args:
            indices: 
            hashdata_k: 
            hashdata_v: 
            indice_pairs: 
            indice_pairs_uniq: 
            indice_pairs_uniq_before_sort: 
            out_inds: 
            indice_num_per_loc: 
            num_out_act: 
            batch_size: 
            output_dims: 
            input_dims: 
            ksize: 
            stride: 
            padding: 
            dilation: 
            transposed: 
            stream_int: 
            use_bound_algo: 
        """
        ...
    @staticmethod
    def generate_conv_inds_mask_stage1(indices: Tensor, indice_pairs_bwd: Tensor, indice_pairs_uniq: Tensor, indice_num_per_loc: Tensor, batch_size: int, output_dims: List[int], input_dims: List[int], ksize: List[int], stride: List[int], padding: List[int], dilation: List[int], transposed: bool = False, stream_int: int = 0) -> None: 
        """
        Args:
            indices: 
            indice_pairs_bwd: 
            indice_pairs_uniq: 
            indice_num_per_loc: 
            batch_size: 
            output_dims: 
            input_dims: 
            ksize: 
            stride: 
            padding: 
            dilation: 
            transposed: 
            stream_int: 
        """
        ...
    @staticmethod
    def generate_conv_inds_mask_stage1_direct_table(indices: Tensor, hashdata_k: Tensor, hashdata_v: Tensor, indice_pairs_bwd: Tensor, indice_pairs_uniq: Tensor, indice_num_per_loc: Tensor, batch_size: int, output_dims: List[int], input_dims: List[int], ksize: List[int], stride: List[int], padding: List[int], dilation: List[int], transposed: bool = False, stream_int: int = 0) -> None: 
        """
        Args:
            indices: 
            hashdata_k: 
            hashdata_v: 
            indice_pairs_bwd: 
            indice_pairs_uniq: 
            indice_num_per_loc: 
            batch_size: 
            output_dims: 
            input_dims: 
            ksize: 
            stride: 
            padding: 
            dilation: 
            transposed: 
            stream_int: 
        """
        ...
    @staticmethod
    def unique_hash(hashdata_k: Tensor, hashdata_v: Tensor, uniq_cnt: Tensor, out_indices_offset: Tensor, num_out_bound: int, stream_int: int = 0) -> int: 
        """
        Args:
            hashdata_k: 
            hashdata_v: 
            uniq_cnt: 
            out_indices_offset: 
            num_out_bound: 
            stream_int: 
        """
        ...
    @staticmethod
    def assign_output_direct_hash(out_indices_offset: Tensor, out_indices: Tensor, batch_size: int, output_dims: List[int], input_dims: List[int], ksize: List[int], stride: List[int], padding: List[int], dilation: List[int], stream_int: int = 0) -> None: 
        """
        Args:
            out_indices_offset: 
            out_indices: 
            batch_size: 
            output_dims: 
            input_dims: 
            ksize: 
            stride: 
            padding: 
            dilation: 
            stream_int: 
        """
        ...
    @staticmethod
    def generate_conv_inds_mask_stage2(indices: Tensor, hashdata_k: Tensor, hashdata_v: Tensor, indice_pairs_fwd: Tensor, indice_pairs_bwd: Tensor, indice_pairs_uniq: Tensor, indice_pairs_uniq_before_sort: Tensor, out_inds: Tensor, mask_fwd: Tensor, mask_bwd: Tensor, num_out_act: int, batch_size: int, output_dims: List[int], input_dims: List[int], ksize: List[int], stride: List[int], padding: List[int], dilation: List[int], transposed: bool = False, stream_int: int = 0) -> int: 
        """
        Args:
            indices: 
            hashdata_k: 
            hashdata_v: 
            indice_pairs_fwd: 
            indice_pairs_bwd: 
            indice_pairs_uniq: 
            indice_pairs_uniq_before_sort: 
            out_inds: 
            mask_fwd: 
            mask_bwd: 
            num_out_act: 
            batch_size: 
            output_dims: 
            input_dims: 
            ksize: 
            stride: 
            padding: 
            dilation: 
            transposed: 
            stream_int: 
        """
        ...
    @staticmethod
    def generate_conv_inds_stage2_mask_direct_table(indices: Tensor, hashdata_k: Tensor, hashdata_v: Tensor, indice_pairs_fwd: Tensor, indice_pairs_bwd: Tensor, indice_pairs_uniq: Tensor, indice_pairs_uniq_before_sort: Tensor, out_inds: Tensor, mask_fwd: Tensor, mask_bwd: Tensor, num_out_act: int, batch_size: int, output_dims: List[int], input_dims: List[int], ksize: List[int], stride: List[int], padding: List[int], dilation: List[int], transposed: bool = False, stream_int: int = 0) -> int: 
        """
        Args:
            indices: 
            hashdata_k: 
            hashdata_v: 
            indice_pairs_fwd: 
            indice_pairs_bwd: 
            indice_pairs_uniq: 
            indice_pairs_uniq_before_sort: 
            out_inds: 
            mask_fwd: 
            mask_bwd: 
            num_out_act: 
            batch_size: 
            output_dims: 
            input_dims: 
            ksize: 
            stride: 
            padding: 
            dilation: 
            transposed: 
            stream_int: 
        """
        ...
    @staticmethod
    def generate_subm_conv_inds(indices: Tensor, hashdata_k: Tensor, hashdata_v: Tensor, indice_pairs: Tensor, out_inds: Tensor, indice_num_per_loc: Tensor, batch_size: int, input_dims: List[int], ksize: List[int], dilation: List[int], indice_pair_mask: Tensor =  Tensor(), backward: bool = False, stream_int: int =  0) -> int: 
        """
        Args:
            indices: 
            hashdata_k: 
            hashdata_v: 
            indice_pairs: 
            out_inds: 
            indice_num_per_loc: 
            batch_size: 
            input_dims: 
            ksize: 
            dilation: 
            indice_pair_mask: 
            backward: 
            stream_int: 
        """
        ...
    @staticmethod
    def generate_conv_inds_cpu(indices: Tensor, indice_pairs: Tensor, out_inds: Tensor, indice_num_per_loc: Tensor, batch_size: int, output_dims: List[int], input_dims: List[int], ksize: List[int], stride: List[int], padding: List[int], dilation: List[int], transposed: bool = False) -> int: 
        """
        Args:
            indices: 
            indice_pairs: 
            out_inds: 
            indice_num_per_loc: 
            batch_size: 
            output_dims: 
            input_dims: 
            ksize: 
            stride: 
            padding: 
            dilation: 
            transposed: 
        """
        ...
    @staticmethod
    def generate_subm_conv_inds_cpu(indices: Tensor, indice_pairs: Tensor, out_inds: Tensor, indice_num_per_loc: Tensor, batch_size: int, input_dims: List[int], ksize: List[int], dilation: List[int]) -> int: 
        """
        Args:
            indices: 
            indice_pairs: 
            out_inds: 
            indice_num_per_loc: 
            batch_size: 
            input_dims: 
            ksize: 
            dilation: 
        """
        ...
    @staticmethod
    def maxpool_forward(out: Tensor, inp: Tensor, out_inds: Tensor, in_inds: Tensor, stream: int = 0) -> None: 
        """
        Args:
            out: 
            inp: 
            out_inds: 
            in_inds: 
            stream: 
        """
        ...
    @staticmethod
    def maxpool_backward(out: Tensor, inp: Tensor, dout: Tensor, dinp: Tensor, out_inds: Tensor, in_inds: Tensor, stream: int = 0) -> None: 
        """
        Args:
            out: 
            inp: 
            dout: 
            dinp: 
            out_inds: 
            in_inds: 
            stream: 
        """
        ...
    @staticmethod
    def indice_maxpool(out_features: Tensor, features: Tensor, indice_pairs: Tensor, indice_pair_num: Tensor, num_activate_out: int, stream: int = 0) -> None: 
        """
        Args:
            out_features: 
            features: 
            indice_pairs: 
            indice_pair_num: 
            num_activate_out: 
            stream: 
        """
        ...
    @staticmethod
    def indice_maxpool_backward(din: Tensor, features: Tensor, out_features: Tensor, out_bp: Tensor, indice_pairs: Tensor, indice_pair_num: Tensor, stream: int = 0) -> None: 
        """
        Args:
            din: 
            features: 
            out_features: 
            out_bp: 
            indice_pairs: 
            indice_pair_num: 
            stream: 
        """
        ...
    @staticmethod
    def global_pool_rearrange(out_indices: Tensor, coords: Tensor, counts: Tensor, stream: int = 0) -> None: 
        """
        Args:
            out_indices: 
            coords: 
            counts: 
            stream: 
        """
        ...
    @staticmethod
    def maxpool_implicit_gemm_forward(out: Tensor, inp: Tensor, inds: Tensor, stream: int = 0) -> None: 
        """
        Args:
            out: 
            inp: 
            inds: 
            stream: 
        """
        ...
    @staticmethod
    def maxpool_implicit_gemm_backward(out: Tensor, inp: Tensor, dout: Tensor, dinp: Tensor, inds: Tensor, stream: int = 0) -> None: 
        """
        Args:
            out: 
            inp: 
            dout: 
            dinp: 
            inds: 
            stream: 
        """
        ...
    @staticmethod
    def avgpool_implicit_gemm_forward(out: Tensor, inp: Tensor, inds: Tensor, count_out: Tensor, stream: int = 0) -> None: 
        """
        Args:
            out: 
            inp: 
            inds: 
            count_out: 
            stream: 
        """
        ...
    @staticmethod
    def avgpool_implicit_gemm_backward(dout: Tensor, dinp: Tensor, inds: Tensor, count_out: Tensor, stream: int = 0) -> None: 
        """
        Args:
            dout: 
            dinp: 
            inds: 
            count_out: 
            stream: 
        """
        ...
    @staticmethod
    def maxpool_forward_cpu(out: Tensor, inp: Tensor, out_inds: Tensor, in_inds: Tensor) -> None: 
        """
        Args:
            out: 
            inp: 
            out_inds: 
            in_inds: 
        """
        ...
    @staticmethod
    def maxpool_backward_cpu(out: Tensor, inp: Tensor, dout: Tensor, dinp: Tensor, out_inds: Tensor, in_inds: Tensor) -> None: 
        """
        Args:
            out: 
            inp: 
            dout: 
            dinp: 
            out_inds: 
            in_inds: 
        """
        ...
    @staticmethod
    def gather_cpu(out: Tensor, inp: Tensor, inds: Tensor) -> None: 
        """
        Args:
            out: 
            inp: 
            inds: 
        """
        ...
    @staticmethod
    def scatter_add_cpu(out: Tensor, inp: Tensor, inds: Tensor) -> None: 
        """
        Args:
            out: 
            inp: 
            inds: 
        """
        ...
    @staticmethod
    def sort_1d_by_key_allocator(data: Tensor, alloc_func, indices: Tensor =  Tensor(), stream: int = 0, mask_count: int = 1, do_sort: bool = True) -> Tensor: 
        """
        Args:
            data: 
            alloc_func: 
            indices: 
            stream: 
            mask_count: 
            do_sort: 
        """
        ...
    @staticmethod
    def sort_1d_by_key_allocator_v2(data: Tensor, allocator, indices: Tensor =  Tensor(), stream: int = 0, mask_count: int = 1, do_sort: bool = True) -> Tensor: 
        """
        Args:
            data: 
            allocator: 
            indices: 
            stream: 
            mask_count: 
            do_sort: 
        """
        ...
    @staticmethod
    def sort_1d_by_key_split(data: Tensor, mask: Tensor, indices: Tensor =  Tensor(), stream: int = 0, mask_output: bool = False) -> Tensor: 
        """
        Args:
            data: 
            mask: 
            indices: 
            stream: 
            mask_output: 
        """
        ...
    @staticmethod
    def sort_1d_by_key_split_allocator(data: Tensor, alloc_func, mask: Tensor, indices: Tensor =  Tensor(), stream: int = 0, mask_output: bool = False) -> Tensor: 
        """
        Args:
            data: 
            alloc_func: 
            mask: 
            indices: 
            stream: 
            mask_output: 
        """
        ...
    @staticmethod
    def sort_1d_by_key_split_allocator_v2(data: Tensor, allocator, mask: Tensor, indices: Tensor =  Tensor(), stream: int = 0, mask_output: bool = False) -> Tensor: 
        """
        Args:
            data: 
            allocator: 
            mask: 
            indices: 
            stream: 
            mask_output: 
        """
        ...
    @staticmethod
    def count_bits(a: Tensor) -> Tensor: 
        """
        Args:
            a: 
        """
        ...
    @staticmethod
    def reverse_bits(a: Tensor) -> Tensor: 
        """
        Args:
            a: 
        """
        ...
    @staticmethod
    def maximum_value_int(data: Tensor, value: int, stream_int: int) -> None: 
        """
        Args:
            data: 
            value: 
            stream_int: 
        """
        ...
    @staticmethod
    def sort_1d_by_key(data: Tensor, indices: Tensor =  Tensor(), stream: int = 0) -> Tensor: 
        """
        Args:
            data: 
            indices: 
            stream: 
        """
        ...
    @staticmethod
    def calc_point2voxel_meta_data(vsize_xyz: List[float], coors_range_xyz: List[float]) -> Tuple[List[float], List[int], List[int], List[float]]: 
        """
        Args:
            vsize_xyz: 
            coors_range_xyz: 
        """
        ...
    @staticmethod
    def point2voxel_cpu(points: Tensor, voxels: Tensor, indices: Tensor, num_per_voxel: Tensor, densehashdata: Tensor, pc_voxel_id: Tensor, vsize: List[float], grid_size: List[int], grid_stride: List[int], coors_range: List[float], empty_mean: bool = False, clear_voxels: bool = True) -> Tuple[Tensor, Tensor, Tensor]: 
        """
        Args:
            points: 
            voxels: 
            indices: 
            num_per_voxel: 
            densehashdata: 
            pc_voxel_id: 
            vsize: 
            grid_size: 
            grid_stride: 
            coors_range: 
            empty_mean: 
            clear_voxels: 
        """
        ...
    @staticmethod
    def point2voxel_cuda(points: Tensor, voxels: Tensor, indices: Tensor, num_per_voxel: Tensor, hashdata: Tensor, point_indice_data: Tensor, pc_voxel_id: Tensor, vsize: List[float], grid_size: List[int], grid_stride: List[int], coors_range: List[float], empty_mean: bool = False, clear_voxels: bool = True, stream_int: int = 0) -> Tuple[Tensor, Tensor, Tensor]: 
        """
        Args:
            points: 
            voxels: 
            indices: 
            num_per_voxel: 
            hashdata: 
            point_indice_data: 
            pc_voxel_id: 
            vsize: 
            grid_size: 
            grid_stride: 
            coors_range: 
            empty_mean: 
            clear_voxels: 
            stream_int: 
        """
        ...
    @staticmethod
    def get_int32_max() -> int: ...
    @staticmethod
    def get_handcrafted_max_act_out(num_act_in: int, ksize: List[int], stride: List[int], padding: List[int], dilation: List[int]) -> int: 
        """
        Args:
            num_act_in: 
            ksize: 
            stride: 
            padding: 
            dilation: 
        """
        ...
    @staticmethod
    def get_indice_gen_workspace_size(kv: int, num_act_in: int, num_act_out_bound: int, max_act_out_in_theory: int, subm: bool, use_int64_hash_k: bool, direct_table: bool) -> int: 
        """
        Args:
            kv: 
            num_act_in: 
            num_act_out_bound: 
            max_act_out_in_theory: 
            subm: 
            use_int64_hash_k: 
            direct_table: 
        """
        ...
    @staticmethod
    def get_indice_gen_tensors_from_workspace(workspace, kv: int, num_act_in: int, num_act_out_bound: int, max_act_out_in_theory: int, subm: bool, use_int64_hash_k: bool, direct_table: bool) -> Dict[str, Tensor]: 
        """
        Args:
            workspace: 
            kv: 
            num_act_in: 
            num_act_out_bound: 
            max_act_out_in_theory: 
            subm: 
            use_int64_hash_k: 
            direct_table: 
        """
        ...
    @staticmethod
    def get_indice_pairs_implicit_gemm(allocator, indices: Tensor, batch_size: int, input_dims: List[int], algo: int, ksize: List[int], stride: List[int], padding: List[int], dilation: List[int], out_padding: List[int], subm: bool, transposed: bool, is_train: bool, stream_int: int = 0, num_out_act_bound: int = -1, timer: CUDAKernelTimer =  CUDAKernelTimer(False), direct_table: bool = False, do_sort: bool = True, preallocated: Dict[str, Tensor] =  {}) -> Tuple[Tensor, int]: 
        """
        Args:
            allocator: 
            indices: 
            batch_size: 
            input_dims: 
            algo: 
            ksize: 
            stride: 
            padding: 
            dilation: 
            out_padding: 
            subm: 
            transposed: 
            is_train: 
            stream_int: 
            num_out_act_bound: 
            timer: 
            direct_table: 
            do_sort: 
            preallocated: 
        """
        ...
    @staticmethod
    def get_indice_pairs(allocator, indices: Tensor, batch_size: int, input_dims: List[int], algo: int, ksize: List[int], stride: List[int], padding: List[int], dilation: List[int], out_padding: List[int], subm: bool, transposed: bool, stream_int: int = 0, num_out_act_bound: int = -1, num_input_act_bound: int = -1) -> int: 
        """
        Args:
            allocator: 
            indices: 
            batch_size: 
            input_dims: 
            algo: 
            ksize: 
            stride: 
            padding: 
            dilation: 
            out_padding: 
            subm: 
            transposed: 
            stream_int: 
            num_out_act_bound: 
            num_input_act_bound: 
        """
        ...
