"""
Store some (but not all) constants.

Author: Nikolay Lysenko
"""


LILYPOND_RECIPROCAL_DURATIONS_BY_METER_SIGNATURE = {
    '2/4': {
        16: ['32'],
        8: ['16'],
        16 / 3: ['16.'],
        4: ['8'],
        3.2: ['8~', '32'],
        8 / 3: ['8.'],
        16 / 7: ['8.~', '32'],
        2: ['4'],
        16 / 9: ['4~', '32'],
        1.6: ['4~', '16'],
        16 / 11: ['4~', '16.'],
        4 / 3: ['4.'],
        16 / 13: ['4.~', '32'],
        8 / 7: ['4.~', '16'],
        16 / 15: ['4.~', '16.'],
        1: ['2'],
    },
    '3/4': {
        24: ['32'],
        12: ['16'],
        8: ['16.'],
        6: ['8'],
        4.8: ['8~', '32'],
        4: ['8.'],
        24 / 7: ['8.~', '32'],
        3: ['4'],
        8 / 3: ['4~', '32'],
        2.4: ['4~', '16'],
        24 / 11: ['4~', '16.'],
        2: ['4.'],
        24 / 13: ['4.~', '32'],
        12 / 7: ['4.~', '16'],
        8 / 5: ['4.~', '16.'],
        1.5: ['2'],
        24 / 17: ['2~', '32'],
        4 / 3: ['2~', '16'],
        24 / 19: ['2~', '16.'],
        1.2: ['2~', '8'],
        24 / 21: ['2~', '8~', '32'],
        12 / 11: ['2~', '8.'],
        24 / 23: ['2~', '8.~', '32'],
        1: ['2.'],
    },
    '4/4': {
        32: ['32'],
        16: ['16'],
        32 / 3: ['16.'],
        8: ['8'],
        6.4: ['8~', '32'],
        16 / 3: ['8.'],
        32 / 7: ['8.~', '32'],
        4: ['4'],
        32 / 9: ['4~', '32'],
        3.2: ['4~', '16'],
        32 / 11: ['4~', '16.'],
        8 / 3: ['4.'],
        32 / 13: ['4.~', '32'],
        16 / 7: ['4.~', '16'],
        32 / 15: ['4.~', '16.'],
        2: ['2'],
        32 / 17: ['2~', '32'],
        16 / 9: ['2~', '16'],
        32 / 19: ['2~', '16.'],
        1.6: ['2~', '8'],
        32 / 21: ['2~', '8~', '32'],
        16 / 11: ['2~', '8.'],
        32 / 23: ['2~', '8.~', '32'],
        4 / 3: ['2.'],
        1.28: ['2.~', '32'],
        16 / 13: ['2.~', '16'],
        32 / 27: ['2.~', '16.'],
        8 / 7: ['2.~', '8'],
        32 / 29: ['2.~', '8~', '32'],
        16 / 15: ['2.~', '8.'],
        32 / 31: ['2.~', '8.~', '32'],
        1: ['1']
    },
}
