/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AiFoundryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#application_insights_id AiFoundry#application_insights_id}
    */
    readonly applicationInsightsId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#container_registry_id AiFoundry#container_registry_id}
    */
    readonly containerRegistryId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#description AiFoundry#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#friendly_name AiFoundry#friendly_name}
    */
    readonly friendlyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#high_business_impact_enabled AiFoundry#high_business_impact_enabled}
    */
    readonly highBusinessImpactEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#id AiFoundry#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#key_vault_id AiFoundry#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#location AiFoundry#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#name AiFoundry#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#primary_user_assigned_identity AiFoundry#primary_user_assigned_identity}
    */
    readonly primaryUserAssignedIdentity?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#public_network_access AiFoundry#public_network_access}
    */
    readonly publicNetworkAccess?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#resource_group_name AiFoundry#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#storage_account_id AiFoundry#storage_account_id}
    */
    readonly storageAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#tags AiFoundry#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * encryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#encryption AiFoundry#encryption}
    */
    readonly encryption?: AiFoundryEncryption;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#identity AiFoundry#identity}
    */
    readonly identity: AiFoundryIdentity;
    /**
    * managed_network block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#managed_network AiFoundry#managed_network}
    */
    readonly managedNetwork?: AiFoundryManagedNetwork;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#timeouts AiFoundry#timeouts}
    */
    readonly timeouts?: AiFoundryTimeouts;
}
export interface AiFoundryEncryption {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#key_id AiFoundry#key_id}
    */
    readonly keyId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#key_vault_id AiFoundry#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#user_assigned_identity_id AiFoundry#user_assigned_identity_id}
    */
    readonly userAssignedIdentityId?: string;
}
export declare function aiFoundryEncryptionToTerraform(struct?: AiFoundryEncryptionOutputReference | AiFoundryEncryption): any;
export declare function aiFoundryEncryptionToHclTerraform(struct?: AiFoundryEncryptionOutputReference | AiFoundryEncryption): any;
export declare class AiFoundryEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AiFoundryEncryption | undefined;
    set internalValue(value: AiFoundryEncryption | undefined);
    private _keyId?;
    get keyId(): string;
    set keyId(value: string);
    get keyIdInput(): string | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    private _userAssignedIdentityId?;
    get userAssignedIdentityId(): string;
    set userAssignedIdentityId(value: string);
    resetUserAssignedIdentityId(): void;
    get userAssignedIdentityIdInput(): string | undefined;
}
export interface AiFoundryIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#identity_ids AiFoundry#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#type AiFoundry#type}
    */
    readonly type: string;
}
export declare function aiFoundryIdentityToTerraform(struct?: AiFoundryIdentityOutputReference | AiFoundryIdentity): any;
export declare function aiFoundryIdentityToHclTerraform(struct?: AiFoundryIdentityOutputReference | AiFoundryIdentity): any;
export declare class AiFoundryIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AiFoundryIdentity | undefined;
    set internalValue(value: AiFoundryIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface AiFoundryManagedNetwork {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#isolation_mode AiFoundry#isolation_mode}
    */
    readonly isolationMode?: string;
}
export declare function aiFoundryManagedNetworkToTerraform(struct?: AiFoundryManagedNetworkOutputReference | AiFoundryManagedNetwork): any;
export declare function aiFoundryManagedNetworkToHclTerraform(struct?: AiFoundryManagedNetworkOutputReference | AiFoundryManagedNetwork): any;
export declare class AiFoundryManagedNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AiFoundryManagedNetwork | undefined;
    set internalValue(value: AiFoundryManagedNetwork | undefined);
    private _isolationMode?;
    get isolationMode(): string;
    set isolationMode(value: string);
    resetIsolationMode(): void;
    get isolationModeInput(): string | undefined;
}
export interface AiFoundryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#create AiFoundry#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#delete AiFoundry#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#read AiFoundry#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#update AiFoundry#update}
    */
    readonly update?: string;
}
export declare function aiFoundryTimeoutsToTerraform(struct?: AiFoundryTimeouts | cdktf.IResolvable): any;
export declare function aiFoundryTimeoutsToHclTerraform(struct?: AiFoundryTimeouts | cdktf.IResolvable): any;
export declare class AiFoundryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AiFoundryTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AiFoundryTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry azurerm_ai_foundry}
*/
export declare class AiFoundry extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_ai_foundry";
    /**
    * Generates CDKTF code for importing a AiFoundry resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AiFoundry to import
    * @param importFromId The id of the existing AiFoundry that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AiFoundry to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/ai_foundry azurerm_ai_foundry} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AiFoundryConfig
    */
    constructor(scope: Construct, id: string, config: AiFoundryConfig);
    private _applicationInsightsId?;
    get applicationInsightsId(): string;
    set applicationInsightsId(value: string);
    resetApplicationInsightsId(): void;
    get applicationInsightsIdInput(): string | undefined;
    private _containerRegistryId?;
    get containerRegistryId(): string;
    set containerRegistryId(value: string);
    resetContainerRegistryId(): void;
    get containerRegistryIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get discoveryUrl(): string;
    private _friendlyName?;
    get friendlyName(): string;
    set friendlyName(value: string);
    resetFriendlyName(): void;
    get friendlyNameInput(): string | undefined;
    private _highBusinessImpactEnabled?;
    get highBusinessImpactEnabled(): boolean | cdktf.IResolvable;
    set highBusinessImpactEnabled(value: boolean | cdktf.IResolvable);
    resetHighBusinessImpactEnabled(): void;
    get highBusinessImpactEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _primaryUserAssignedIdentity?;
    get primaryUserAssignedIdentity(): string;
    set primaryUserAssignedIdentity(value: string);
    resetPrimaryUserAssignedIdentity(): void;
    get primaryUserAssignedIdentityInput(): string | undefined;
    private _publicNetworkAccess?;
    get publicNetworkAccess(): string;
    set publicNetworkAccess(value: string);
    resetPublicNetworkAccess(): void;
    get publicNetworkAccessInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get workspaceId(): string;
    private _encryption;
    get encryption(): AiFoundryEncryptionOutputReference;
    putEncryption(value: AiFoundryEncryption): void;
    resetEncryption(): void;
    get encryptionInput(): AiFoundryEncryption | undefined;
    private _identity;
    get identity(): AiFoundryIdentityOutputReference;
    putIdentity(value: AiFoundryIdentity): void;
    get identityInput(): AiFoundryIdentity | undefined;
    private _managedNetwork;
    get managedNetwork(): AiFoundryManagedNetworkOutputReference;
    putManagedNetwork(value: AiFoundryManagedNetwork): void;
    resetManagedNetwork(): void;
    get managedNetworkInput(): AiFoundryManagedNetwork | undefined;
    private _timeouts;
    get timeouts(): AiFoundryTimeoutsOutputReference;
    putTimeouts(value: AiFoundryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AiFoundryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
