/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementProductPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/api_management_product_policy#api_management_name ApiManagementProductPolicy#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/api_management_product_policy#id ApiManagementProductPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/api_management_product_policy#product_id ApiManagementProductPolicy#product_id}
    */
    readonly productId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/api_management_product_policy#resource_group_name ApiManagementProductPolicy#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/api_management_product_policy#xml_content ApiManagementProductPolicy#xml_content}
    */
    readonly xmlContent?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/api_management_product_policy#xml_link ApiManagementProductPolicy#xml_link}
    */
    readonly xmlLink?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/api_management_product_policy#timeouts ApiManagementProductPolicy#timeouts}
    */
    readonly timeouts?: ApiManagementProductPolicyTimeouts;
}
export interface ApiManagementProductPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/api_management_product_policy#create ApiManagementProductPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/api_management_product_policy#delete ApiManagementProductPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/api_management_product_policy#read ApiManagementProductPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/api_management_product_policy#update ApiManagementProductPolicy#update}
    */
    readonly update?: string;
}
export declare function apiManagementProductPolicyTimeoutsToTerraform(struct?: ApiManagementProductPolicyTimeouts | cdktf.IResolvable): any;
export declare function apiManagementProductPolicyTimeoutsToHclTerraform(struct?: ApiManagementProductPolicyTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementProductPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementProductPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementProductPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/api_management_product_policy azurerm_api_management_product_policy}
*/
export declare class ApiManagementProductPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management_product_policy";
    /**
    * Generates CDKTF code for importing a ApiManagementProductPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ApiManagementProductPolicy to import
    * @param importFromId The id of the existing ApiManagementProductPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/api_management_product_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ApiManagementProductPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/api_management_product_policy azurerm_api_management_product_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementProductPolicyConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementProductPolicyConfig);
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _productId?;
    get productId(): string;
    set productId(value: string);
    get productIdInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _xmlContent?;
    get xmlContent(): string;
    set xmlContent(value: string);
    resetXmlContent(): void;
    get xmlContentInput(): string | undefined;
    private _xmlLink?;
    get xmlLink(): string;
    set xmlLink(value: string);
    resetXmlLink(): void;
    get xmlLinkInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApiManagementProductPolicyTimeoutsOutputReference;
    putTimeouts(value: ApiManagementProductPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApiManagementProductPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
