/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppServicePlanConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/app_service_plan#app_service_environment_id AppServicePlan#app_service_environment_id}
    */
    readonly appServiceEnvironmentId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/app_service_plan#id AppServicePlan#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/app_service_plan#is_xenon AppServicePlan#is_xenon}
    */
    readonly isXenon?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/app_service_plan#kind AppServicePlan#kind}
    */
    readonly kind?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/app_service_plan#location AppServicePlan#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/app_service_plan#maximum_elastic_worker_count AppServicePlan#maximum_elastic_worker_count}
    */
    readonly maximumElasticWorkerCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/app_service_plan#name AppServicePlan#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/app_service_plan#per_site_scaling AppServicePlan#per_site_scaling}
    */
    readonly perSiteScaling?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/app_service_plan#reserved AppServicePlan#reserved}
    */
    readonly reserved?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/app_service_plan#resource_group_name AppServicePlan#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/app_service_plan#tags AppServicePlan#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/app_service_plan#zone_redundant AppServicePlan#zone_redundant}
    */
    readonly zoneRedundant?: boolean | cdktf.IResolvable;
    /**
    * sku block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/app_service_plan#sku AppServicePlan#sku}
    */
    readonly sku: AppServicePlanSku;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/app_service_plan#timeouts AppServicePlan#timeouts}
    */
    readonly timeouts?: AppServicePlanTimeouts;
}
export interface AppServicePlanSku {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/app_service_plan#capacity AppServicePlan#capacity}
    */
    readonly capacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/app_service_plan#size AppServicePlan#size}
    */
    readonly size: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/app_service_plan#tier AppServicePlan#tier}
    */
    readonly tier: string;
}
export declare function appServicePlanSkuToTerraform(struct?: AppServicePlanSkuOutputReference | AppServicePlanSku): any;
export declare function appServicePlanSkuToHclTerraform(struct?: AppServicePlanSkuOutputReference | AppServicePlanSku): any;
export declare class AppServicePlanSkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServicePlanSku | undefined;
    set internalValue(value: AppServicePlanSku | undefined);
    private _capacity?;
    get capacity(): number;
    set capacity(value: number);
    resetCapacity(): void;
    get capacityInput(): number | undefined;
    private _size?;
    get size(): string;
    set size(value: string);
    get sizeInput(): string | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    get tierInput(): string | undefined;
}
export interface AppServicePlanTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/app_service_plan#create AppServicePlan#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/app_service_plan#delete AppServicePlan#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/app_service_plan#read AppServicePlan#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/app_service_plan#update AppServicePlan#update}
    */
    readonly update?: string;
}
export declare function appServicePlanTimeoutsToTerraform(struct?: AppServicePlanTimeouts | cdktf.IResolvable): any;
export declare function appServicePlanTimeoutsToHclTerraform(struct?: AppServicePlanTimeouts | cdktf.IResolvable): any;
export declare class AppServicePlanTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServicePlanTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AppServicePlanTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/app_service_plan azurerm_app_service_plan}
*/
export declare class AppServicePlan extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_app_service_plan";
    /**
    * Generates CDKTF code for importing a AppServicePlan resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AppServicePlan to import
    * @param importFromId The id of the existing AppServicePlan that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/app_service_plan#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AppServicePlan to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/app_service_plan azurerm_app_service_plan} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppServicePlanConfig
    */
    constructor(scope: Construct, id: string, config: AppServicePlanConfig);
    private _appServiceEnvironmentId?;
    get appServiceEnvironmentId(): string;
    set appServiceEnvironmentId(value: string);
    resetAppServiceEnvironmentId(): void;
    get appServiceEnvironmentIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isXenon?;
    get isXenon(): boolean | cdktf.IResolvable;
    set isXenon(value: boolean | cdktf.IResolvable);
    resetIsXenon(): void;
    get isXenonInput(): boolean | cdktf.IResolvable | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    resetKind(): void;
    get kindInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _maximumElasticWorkerCount?;
    get maximumElasticWorkerCount(): number;
    set maximumElasticWorkerCount(value: number);
    resetMaximumElasticWorkerCount(): void;
    get maximumElasticWorkerCountInput(): number | undefined;
    get maximumNumberOfWorkers(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _perSiteScaling?;
    get perSiteScaling(): boolean | cdktf.IResolvable;
    set perSiteScaling(value: boolean | cdktf.IResolvable);
    resetPerSiteScaling(): void;
    get perSiteScalingInput(): boolean | cdktf.IResolvable | undefined;
    private _reserved?;
    get reserved(): boolean | cdktf.IResolvable;
    set reserved(value: boolean | cdktf.IResolvable);
    resetReserved(): void;
    get reservedInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _zoneRedundant?;
    get zoneRedundant(): boolean | cdktf.IResolvable;
    set zoneRedundant(value: boolean | cdktf.IResolvable);
    resetZoneRedundant(): void;
    get zoneRedundantInput(): boolean | cdktf.IResolvable | undefined;
    private _sku;
    get sku(): AppServicePlanSkuOutputReference;
    putSku(value: AppServicePlanSku): void;
    get skuInput(): AppServicePlanSku | undefined;
    private _timeouts;
    get timeouts(): AppServicePlanTimeoutsOutputReference;
    putTimeouts(value: AppServicePlanTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AppServicePlanTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
