/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ArcKubernetesProvisionedClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/arc_kubernetes_provisioned_cluster#arc_agent_auto_upgrade_enabled ArcKubernetesProvisionedCluster#arc_agent_auto_upgrade_enabled}
    */
    readonly arcAgentAutoUpgradeEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/arc_kubernetes_provisioned_cluster#arc_agent_desired_version ArcKubernetesProvisionedCluster#arc_agent_desired_version}
    */
    readonly arcAgentDesiredVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/arc_kubernetes_provisioned_cluster#id ArcKubernetesProvisionedCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/arc_kubernetes_provisioned_cluster#location ArcKubernetesProvisionedCluster#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/arc_kubernetes_provisioned_cluster#name ArcKubernetesProvisionedCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/arc_kubernetes_provisioned_cluster#resource_group_name ArcKubernetesProvisionedCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/arc_kubernetes_provisioned_cluster#tags ArcKubernetesProvisionedCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * azure_active_directory block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/arc_kubernetes_provisioned_cluster#azure_active_directory ArcKubernetesProvisionedCluster#azure_active_directory}
    */
    readonly azureActiveDirectory?: ArcKubernetesProvisionedClusterAzureActiveDirectory;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/arc_kubernetes_provisioned_cluster#identity ArcKubernetesProvisionedCluster#identity}
    */
    readonly identity: ArcKubernetesProvisionedClusterIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/arc_kubernetes_provisioned_cluster#timeouts ArcKubernetesProvisionedCluster#timeouts}
    */
    readonly timeouts?: ArcKubernetesProvisionedClusterTimeouts;
}
export interface ArcKubernetesProvisionedClusterAzureActiveDirectory {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/arc_kubernetes_provisioned_cluster#admin_group_object_ids ArcKubernetesProvisionedCluster#admin_group_object_ids}
    */
    readonly adminGroupObjectIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/arc_kubernetes_provisioned_cluster#azure_rbac_enabled ArcKubernetesProvisionedCluster#azure_rbac_enabled}
    */
    readonly azureRbacEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/arc_kubernetes_provisioned_cluster#tenant_id ArcKubernetesProvisionedCluster#tenant_id}
    */
    readonly tenantId?: string;
}
export declare function arcKubernetesProvisionedClusterAzureActiveDirectoryToTerraform(struct?: ArcKubernetesProvisionedClusterAzureActiveDirectoryOutputReference | ArcKubernetesProvisionedClusterAzureActiveDirectory): any;
export declare function arcKubernetesProvisionedClusterAzureActiveDirectoryToHclTerraform(struct?: ArcKubernetesProvisionedClusterAzureActiveDirectoryOutputReference | ArcKubernetesProvisionedClusterAzureActiveDirectory): any;
export declare class ArcKubernetesProvisionedClusterAzureActiveDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ArcKubernetesProvisionedClusterAzureActiveDirectory | undefined;
    set internalValue(value: ArcKubernetesProvisionedClusterAzureActiveDirectory | undefined);
    private _adminGroupObjectIds?;
    get adminGroupObjectIds(): string[];
    set adminGroupObjectIds(value: string[]);
    resetAdminGroupObjectIds(): void;
    get adminGroupObjectIdsInput(): string[] | undefined;
    private _azureRbacEnabled?;
    get azureRbacEnabled(): boolean | cdktf.IResolvable;
    set azureRbacEnabled(value: boolean | cdktf.IResolvable);
    resetAzureRbacEnabled(): void;
    get azureRbacEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
}
export interface ArcKubernetesProvisionedClusterIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/arc_kubernetes_provisioned_cluster#type ArcKubernetesProvisionedCluster#type}
    */
    readonly type: string;
}
export declare function arcKubernetesProvisionedClusterIdentityToTerraform(struct?: ArcKubernetesProvisionedClusterIdentityOutputReference | ArcKubernetesProvisionedClusterIdentity): any;
export declare function arcKubernetesProvisionedClusterIdentityToHclTerraform(struct?: ArcKubernetesProvisionedClusterIdentityOutputReference | ArcKubernetesProvisionedClusterIdentity): any;
export declare class ArcKubernetesProvisionedClusterIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ArcKubernetesProvisionedClusterIdentity | undefined;
    set internalValue(value: ArcKubernetesProvisionedClusterIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ArcKubernetesProvisionedClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/arc_kubernetes_provisioned_cluster#create ArcKubernetesProvisionedCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/arc_kubernetes_provisioned_cluster#delete ArcKubernetesProvisionedCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/arc_kubernetes_provisioned_cluster#read ArcKubernetesProvisionedCluster#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/arc_kubernetes_provisioned_cluster#update ArcKubernetesProvisionedCluster#update}
    */
    readonly update?: string;
}
export declare function arcKubernetesProvisionedClusterTimeoutsToTerraform(struct?: ArcKubernetesProvisionedClusterTimeouts | cdktf.IResolvable): any;
export declare function arcKubernetesProvisionedClusterTimeoutsToHclTerraform(struct?: ArcKubernetesProvisionedClusterTimeouts | cdktf.IResolvable): any;
export declare class ArcKubernetesProvisionedClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ArcKubernetesProvisionedClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ArcKubernetesProvisionedClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/arc_kubernetes_provisioned_cluster azurerm_arc_kubernetes_provisioned_cluster}
*/
export declare class ArcKubernetesProvisionedCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_arc_kubernetes_provisioned_cluster";
    /**
    * Generates CDKTF code for importing a ArcKubernetesProvisionedCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ArcKubernetesProvisionedCluster to import
    * @param importFromId The id of the existing ArcKubernetesProvisionedCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/arc_kubernetes_provisioned_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ArcKubernetesProvisionedCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/arc_kubernetes_provisioned_cluster azurerm_arc_kubernetes_provisioned_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ArcKubernetesProvisionedClusterConfig
    */
    constructor(scope: Construct, id: string, config: ArcKubernetesProvisionedClusterConfig);
    get agentVersion(): string;
    private _arcAgentAutoUpgradeEnabled?;
    get arcAgentAutoUpgradeEnabled(): boolean | cdktf.IResolvable;
    set arcAgentAutoUpgradeEnabled(value: boolean | cdktf.IResolvable);
    resetArcAgentAutoUpgradeEnabled(): void;
    get arcAgentAutoUpgradeEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _arcAgentDesiredVersion?;
    get arcAgentDesiredVersion(): string;
    set arcAgentDesiredVersion(value: string);
    resetArcAgentDesiredVersion(): void;
    get arcAgentDesiredVersionInput(): string | undefined;
    get distribution(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get infrastructure(): string;
    get kubernetesVersion(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get offering(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get totalCoreCount(): number;
    get totalNodeCount(): number;
    private _azureActiveDirectory;
    get azureActiveDirectory(): ArcKubernetesProvisionedClusterAzureActiveDirectoryOutputReference;
    putAzureActiveDirectory(value: ArcKubernetesProvisionedClusterAzureActiveDirectory): void;
    resetAzureActiveDirectory(): void;
    get azureActiveDirectoryInput(): ArcKubernetesProvisionedClusterAzureActiveDirectory | undefined;
    private _identity;
    get identity(): ArcKubernetesProvisionedClusterIdentityOutputReference;
    putIdentity(value: ArcKubernetesProvisionedClusterIdentity): void;
    get identityInput(): ArcKubernetesProvisionedClusterIdentity | undefined;
    private _timeouts;
    get timeouts(): ArcKubernetesProvisionedClusterTimeoutsOutputReference;
    putTimeouts(value: ArcKubernetesProvisionedClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ArcKubernetesProvisionedClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
