/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CdnEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#content_types_to_compress CdnEndpoint#content_types_to_compress}
    */
    readonly contentTypesToCompress?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#id CdnEndpoint#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#is_compression_enabled CdnEndpoint#is_compression_enabled}
    */
    readonly isCompressionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#is_http_allowed CdnEndpoint#is_http_allowed}
    */
    readonly isHttpAllowed?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#is_https_allowed CdnEndpoint#is_https_allowed}
    */
    readonly isHttpsAllowed?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#location CdnEndpoint#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#name CdnEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#optimization_type CdnEndpoint#optimization_type}
    */
    readonly optimizationType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#origin_host_header CdnEndpoint#origin_host_header}
    */
    readonly originHostHeader?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#origin_path CdnEndpoint#origin_path}
    */
    readonly originPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#probe_path CdnEndpoint#probe_path}
    */
    readonly probePath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#profile_name CdnEndpoint#profile_name}
    */
    readonly profileName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#querystring_caching_behaviour CdnEndpoint#querystring_caching_behaviour}
    */
    readonly querystringCachingBehaviour?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#resource_group_name CdnEndpoint#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#tags CdnEndpoint#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * delivery_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#delivery_rule CdnEndpoint#delivery_rule}
    */
    readonly deliveryRule?: CdnEndpointDeliveryRule[] | cdktf.IResolvable;
    /**
    * geo_filter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#geo_filter CdnEndpoint#geo_filter}
    */
    readonly geoFilter?: CdnEndpointGeoFilter[] | cdktf.IResolvable;
    /**
    * global_delivery_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#global_delivery_rule CdnEndpoint#global_delivery_rule}
    */
    readonly globalDeliveryRule?: CdnEndpointGlobalDeliveryRule;
    /**
    * origin block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#origin CdnEndpoint#origin}
    */
    readonly origin: CdnEndpointOrigin[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#timeouts CdnEndpoint#timeouts}
    */
    readonly timeouts?: CdnEndpointTimeouts;
}
export interface CdnEndpointDeliveryRuleCacheExpirationAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#behavior CdnEndpoint#behavior}
    */
    readonly behavior: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#duration CdnEndpoint#duration}
    */
    readonly duration?: string;
}
export declare function cdnEndpointDeliveryRuleCacheExpirationActionToTerraform(struct?: CdnEndpointDeliveryRuleCacheExpirationActionOutputReference | CdnEndpointDeliveryRuleCacheExpirationAction): any;
export declare function cdnEndpointDeliveryRuleCacheExpirationActionToHclTerraform(struct?: CdnEndpointDeliveryRuleCacheExpirationActionOutputReference | CdnEndpointDeliveryRuleCacheExpirationAction): any;
export declare class CdnEndpointDeliveryRuleCacheExpirationActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnEndpointDeliveryRuleCacheExpirationAction | undefined;
    set internalValue(value: CdnEndpointDeliveryRuleCacheExpirationAction | undefined);
    private _behavior?;
    get behavior(): string;
    set behavior(value: string);
    get behaviorInput(): string | undefined;
    private _duration?;
    get duration(): string;
    set duration(value: string);
    resetDuration(): void;
    get durationInput(): string | undefined;
}
export interface CdnEndpointDeliveryRuleCacheKeyQueryStringAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#behavior CdnEndpoint#behavior}
    */
    readonly behavior: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#parameters CdnEndpoint#parameters}
    */
    readonly parameters?: string;
}
export declare function cdnEndpointDeliveryRuleCacheKeyQueryStringActionToTerraform(struct?: CdnEndpointDeliveryRuleCacheKeyQueryStringActionOutputReference | CdnEndpointDeliveryRuleCacheKeyQueryStringAction): any;
export declare function cdnEndpointDeliveryRuleCacheKeyQueryStringActionToHclTerraform(struct?: CdnEndpointDeliveryRuleCacheKeyQueryStringActionOutputReference | CdnEndpointDeliveryRuleCacheKeyQueryStringAction): any;
export declare class CdnEndpointDeliveryRuleCacheKeyQueryStringActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnEndpointDeliveryRuleCacheKeyQueryStringAction | undefined;
    set internalValue(value: CdnEndpointDeliveryRuleCacheKeyQueryStringAction | undefined);
    private _behavior?;
    get behavior(): string;
    set behavior(value: string);
    get behaviorInput(): string | undefined;
    private _parameters?;
    get parameters(): string;
    set parameters(value: string);
    resetParameters(): void;
    get parametersInput(): string | undefined;
}
export interface CdnEndpointDeliveryRuleCookiesCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#match_values CdnEndpoint#match_values}
    */
    readonly matchValues?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#operator CdnEndpoint#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#selector CdnEndpoint#selector}
    */
    readonly selector: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#transforms CdnEndpoint#transforms}
    */
    readonly transforms?: string[];
}
export declare function cdnEndpointDeliveryRuleCookiesConditionToTerraform(struct?: CdnEndpointDeliveryRuleCookiesCondition | cdktf.IResolvable): any;
export declare function cdnEndpointDeliveryRuleCookiesConditionToHclTerraform(struct?: CdnEndpointDeliveryRuleCookiesCondition | cdktf.IResolvable): any;
export declare class CdnEndpointDeliveryRuleCookiesConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnEndpointDeliveryRuleCookiesCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnEndpointDeliveryRuleCookiesCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    resetMatchValues(): void;
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _selector?;
    get selector(): string;
    set selector(value: string);
    get selectorInput(): string | undefined;
    private _transforms?;
    get transforms(): string[];
    set transforms(value: string[]);
    resetTransforms(): void;
    get transformsInput(): string[] | undefined;
}
export declare class CdnEndpointDeliveryRuleCookiesConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnEndpointDeliveryRuleCookiesCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnEndpointDeliveryRuleCookiesConditionOutputReference;
}
export interface CdnEndpointDeliveryRuleDeviceCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#match_values CdnEndpoint#match_values}
    */
    readonly matchValues: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#operator CdnEndpoint#operator}
    */
    readonly operator?: string;
}
export declare function cdnEndpointDeliveryRuleDeviceConditionToTerraform(struct?: CdnEndpointDeliveryRuleDeviceConditionOutputReference | CdnEndpointDeliveryRuleDeviceCondition): any;
export declare function cdnEndpointDeliveryRuleDeviceConditionToHclTerraform(struct?: CdnEndpointDeliveryRuleDeviceConditionOutputReference | CdnEndpointDeliveryRuleDeviceCondition): any;
export declare class CdnEndpointDeliveryRuleDeviceConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnEndpointDeliveryRuleDeviceCondition | undefined;
    set internalValue(value: CdnEndpointDeliveryRuleDeviceCondition | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
}
export interface CdnEndpointDeliveryRuleHttpVersionCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#match_values CdnEndpoint#match_values}
    */
    readonly matchValues: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#operator CdnEndpoint#operator}
    */
    readonly operator?: string;
}
export declare function cdnEndpointDeliveryRuleHttpVersionConditionToTerraform(struct?: CdnEndpointDeliveryRuleHttpVersionCondition | cdktf.IResolvable): any;
export declare function cdnEndpointDeliveryRuleHttpVersionConditionToHclTerraform(struct?: CdnEndpointDeliveryRuleHttpVersionCondition | cdktf.IResolvable): any;
export declare class CdnEndpointDeliveryRuleHttpVersionConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnEndpointDeliveryRuleHttpVersionCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnEndpointDeliveryRuleHttpVersionCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
}
export declare class CdnEndpointDeliveryRuleHttpVersionConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnEndpointDeliveryRuleHttpVersionCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnEndpointDeliveryRuleHttpVersionConditionOutputReference;
}
export interface CdnEndpointDeliveryRuleModifyRequestHeaderAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#action CdnEndpoint#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#name CdnEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#value CdnEndpoint#value}
    */
    readonly value?: string;
}
export declare function cdnEndpointDeliveryRuleModifyRequestHeaderActionToTerraform(struct?: CdnEndpointDeliveryRuleModifyRequestHeaderAction | cdktf.IResolvable): any;
export declare function cdnEndpointDeliveryRuleModifyRequestHeaderActionToHclTerraform(struct?: CdnEndpointDeliveryRuleModifyRequestHeaderAction | cdktf.IResolvable): any;
export declare class CdnEndpointDeliveryRuleModifyRequestHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnEndpointDeliveryRuleModifyRequestHeaderAction | cdktf.IResolvable | undefined;
    set internalValue(value: CdnEndpointDeliveryRuleModifyRequestHeaderAction | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class CdnEndpointDeliveryRuleModifyRequestHeaderActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnEndpointDeliveryRuleModifyRequestHeaderAction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnEndpointDeliveryRuleModifyRequestHeaderActionOutputReference;
}
export interface CdnEndpointDeliveryRuleModifyResponseHeaderAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#action CdnEndpoint#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#name CdnEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#value CdnEndpoint#value}
    */
    readonly value?: string;
}
export declare function cdnEndpointDeliveryRuleModifyResponseHeaderActionToTerraform(struct?: CdnEndpointDeliveryRuleModifyResponseHeaderAction | cdktf.IResolvable): any;
export declare function cdnEndpointDeliveryRuleModifyResponseHeaderActionToHclTerraform(struct?: CdnEndpointDeliveryRuleModifyResponseHeaderAction | cdktf.IResolvable): any;
export declare class CdnEndpointDeliveryRuleModifyResponseHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnEndpointDeliveryRuleModifyResponseHeaderAction | cdktf.IResolvable | undefined;
    set internalValue(value: CdnEndpointDeliveryRuleModifyResponseHeaderAction | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class CdnEndpointDeliveryRuleModifyResponseHeaderActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnEndpointDeliveryRuleModifyResponseHeaderAction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnEndpointDeliveryRuleModifyResponseHeaderActionOutputReference;
}
export interface CdnEndpointDeliveryRulePostArgCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#match_values CdnEndpoint#match_values}
    */
    readonly matchValues?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#operator CdnEndpoint#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#selector CdnEndpoint#selector}
    */
    readonly selector: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#transforms CdnEndpoint#transforms}
    */
    readonly transforms?: string[];
}
export declare function cdnEndpointDeliveryRulePostArgConditionToTerraform(struct?: CdnEndpointDeliveryRulePostArgCondition | cdktf.IResolvable): any;
export declare function cdnEndpointDeliveryRulePostArgConditionToHclTerraform(struct?: CdnEndpointDeliveryRulePostArgCondition | cdktf.IResolvable): any;
export declare class CdnEndpointDeliveryRulePostArgConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnEndpointDeliveryRulePostArgCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnEndpointDeliveryRulePostArgCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    resetMatchValues(): void;
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _selector?;
    get selector(): string;
    set selector(value: string);
    get selectorInput(): string | undefined;
    private _transforms?;
    get transforms(): string[];
    set transforms(value: string[]);
    resetTransforms(): void;
    get transformsInput(): string[] | undefined;
}
export declare class CdnEndpointDeliveryRulePostArgConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnEndpointDeliveryRulePostArgCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnEndpointDeliveryRulePostArgConditionOutputReference;
}
export interface CdnEndpointDeliveryRuleQueryStringCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#match_values CdnEndpoint#match_values}
    */
    readonly matchValues?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#operator CdnEndpoint#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#transforms CdnEndpoint#transforms}
    */
    readonly transforms?: string[];
}
export declare function cdnEndpointDeliveryRuleQueryStringConditionToTerraform(struct?: CdnEndpointDeliveryRuleQueryStringCondition | cdktf.IResolvable): any;
export declare function cdnEndpointDeliveryRuleQueryStringConditionToHclTerraform(struct?: CdnEndpointDeliveryRuleQueryStringCondition | cdktf.IResolvable): any;
export declare class CdnEndpointDeliveryRuleQueryStringConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnEndpointDeliveryRuleQueryStringCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnEndpointDeliveryRuleQueryStringCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    resetMatchValues(): void;
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _transforms?;
    get transforms(): string[];
    set transforms(value: string[]);
    resetTransforms(): void;
    get transformsInput(): string[] | undefined;
}
export declare class CdnEndpointDeliveryRuleQueryStringConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnEndpointDeliveryRuleQueryStringCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnEndpointDeliveryRuleQueryStringConditionOutputReference;
}
export interface CdnEndpointDeliveryRuleRemoteAddressCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#match_values CdnEndpoint#match_values}
    */
    readonly matchValues?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#operator CdnEndpoint#operator}
    */
    readonly operator: string;
}
export declare function cdnEndpointDeliveryRuleRemoteAddressConditionToTerraform(struct?: CdnEndpointDeliveryRuleRemoteAddressCondition | cdktf.IResolvable): any;
export declare function cdnEndpointDeliveryRuleRemoteAddressConditionToHclTerraform(struct?: CdnEndpointDeliveryRuleRemoteAddressCondition | cdktf.IResolvable): any;
export declare class CdnEndpointDeliveryRuleRemoteAddressConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnEndpointDeliveryRuleRemoteAddressCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnEndpointDeliveryRuleRemoteAddressCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    resetMatchValues(): void;
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
}
export declare class CdnEndpointDeliveryRuleRemoteAddressConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnEndpointDeliveryRuleRemoteAddressCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnEndpointDeliveryRuleRemoteAddressConditionOutputReference;
}
export interface CdnEndpointDeliveryRuleRequestBodyCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#match_values CdnEndpoint#match_values}
    */
    readonly matchValues?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#operator CdnEndpoint#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#transforms CdnEndpoint#transforms}
    */
    readonly transforms?: string[];
}
export declare function cdnEndpointDeliveryRuleRequestBodyConditionToTerraform(struct?: CdnEndpointDeliveryRuleRequestBodyCondition | cdktf.IResolvable): any;
export declare function cdnEndpointDeliveryRuleRequestBodyConditionToHclTerraform(struct?: CdnEndpointDeliveryRuleRequestBodyCondition | cdktf.IResolvable): any;
export declare class CdnEndpointDeliveryRuleRequestBodyConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnEndpointDeliveryRuleRequestBodyCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnEndpointDeliveryRuleRequestBodyCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    resetMatchValues(): void;
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _transforms?;
    get transforms(): string[];
    set transforms(value: string[]);
    resetTransforms(): void;
    get transformsInput(): string[] | undefined;
}
export declare class CdnEndpointDeliveryRuleRequestBodyConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnEndpointDeliveryRuleRequestBodyCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnEndpointDeliveryRuleRequestBodyConditionOutputReference;
}
export interface CdnEndpointDeliveryRuleRequestHeaderCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#match_values CdnEndpoint#match_values}
    */
    readonly matchValues?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#operator CdnEndpoint#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#selector CdnEndpoint#selector}
    */
    readonly selector: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#transforms CdnEndpoint#transforms}
    */
    readonly transforms?: string[];
}
export declare function cdnEndpointDeliveryRuleRequestHeaderConditionToTerraform(struct?: CdnEndpointDeliveryRuleRequestHeaderCondition | cdktf.IResolvable): any;
export declare function cdnEndpointDeliveryRuleRequestHeaderConditionToHclTerraform(struct?: CdnEndpointDeliveryRuleRequestHeaderCondition | cdktf.IResolvable): any;
export declare class CdnEndpointDeliveryRuleRequestHeaderConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnEndpointDeliveryRuleRequestHeaderCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnEndpointDeliveryRuleRequestHeaderCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    resetMatchValues(): void;
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _selector?;
    get selector(): string;
    set selector(value: string);
    get selectorInput(): string | undefined;
    private _transforms?;
    get transforms(): string[];
    set transforms(value: string[]);
    resetTransforms(): void;
    get transformsInput(): string[] | undefined;
}
export declare class CdnEndpointDeliveryRuleRequestHeaderConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnEndpointDeliveryRuleRequestHeaderCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnEndpointDeliveryRuleRequestHeaderConditionOutputReference;
}
export interface CdnEndpointDeliveryRuleRequestMethodCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#match_values CdnEndpoint#match_values}
    */
    readonly matchValues: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#operator CdnEndpoint#operator}
    */
    readonly operator?: string;
}
export declare function cdnEndpointDeliveryRuleRequestMethodConditionToTerraform(struct?: CdnEndpointDeliveryRuleRequestMethodConditionOutputReference | CdnEndpointDeliveryRuleRequestMethodCondition): any;
export declare function cdnEndpointDeliveryRuleRequestMethodConditionToHclTerraform(struct?: CdnEndpointDeliveryRuleRequestMethodConditionOutputReference | CdnEndpointDeliveryRuleRequestMethodCondition): any;
export declare class CdnEndpointDeliveryRuleRequestMethodConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnEndpointDeliveryRuleRequestMethodCondition | undefined;
    set internalValue(value: CdnEndpointDeliveryRuleRequestMethodCondition | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
}
export interface CdnEndpointDeliveryRuleRequestSchemeCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#match_values CdnEndpoint#match_values}
    */
    readonly matchValues: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#operator CdnEndpoint#operator}
    */
    readonly operator?: string;
}
export declare function cdnEndpointDeliveryRuleRequestSchemeConditionToTerraform(struct?: CdnEndpointDeliveryRuleRequestSchemeConditionOutputReference | CdnEndpointDeliveryRuleRequestSchemeCondition): any;
export declare function cdnEndpointDeliveryRuleRequestSchemeConditionToHclTerraform(struct?: CdnEndpointDeliveryRuleRequestSchemeConditionOutputReference | CdnEndpointDeliveryRuleRequestSchemeCondition): any;
export declare class CdnEndpointDeliveryRuleRequestSchemeConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnEndpointDeliveryRuleRequestSchemeCondition | undefined;
    set internalValue(value: CdnEndpointDeliveryRuleRequestSchemeCondition | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
}
export interface CdnEndpointDeliveryRuleRequestUriCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#match_values CdnEndpoint#match_values}
    */
    readonly matchValues?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#operator CdnEndpoint#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#transforms CdnEndpoint#transforms}
    */
    readonly transforms?: string[];
}
export declare function cdnEndpointDeliveryRuleRequestUriConditionToTerraform(struct?: CdnEndpointDeliveryRuleRequestUriCondition | cdktf.IResolvable): any;
export declare function cdnEndpointDeliveryRuleRequestUriConditionToHclTerraform(struct?: CdnEndpointDeliveryRuleRequestUriCondition | cdktf.IResolvable): any;
export declare class CdnEndpointDeliveryRuleRequestUriConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnEndpointDeliveryRuleRequestUriCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnEndpointDeliveryRuleRequestUriCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    resetMatchValues(): void;
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _transforms?;
    get transforms(): string[];
    set transforms(value: string[]);
    resetTransforms(): void;
    get transformsInput(): string[] | undefined;
}
export declare class CdnEndpointDeliveryRuleRequestUriConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnEndpointDeliveryRuleRequestUriCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnEndpointDeliveryRuleRequestUriConditionOutputReference;
}
export interface CdnEndpointDeliveryRuleUrlFileExtensionCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#match_values CdnEndpoint#match_values}
    */
    readonly matchValues?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#operator CdnEndpoint#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#transforms CdnEndpoint#transforms}
    */
    readonly transforms?: string[];
}
export declare function cdnEndpointDeliveryRuleUrlFileExtensionConditionToTerraform(struct?: CdnEndpointDeliveryRuleUrlFileExtensionCondition | cdktf.IResolvable): any;
export declare function cdnEndpointDeliveryRuleUrlFileExtensionConditionToHclTerraform(struct?: CdnEndpointDeliveryRuleUrlFileExtensionCondition | cdktf.IResolvable): any;
export declare class CdnEndpointDeliveryRuleUrlFileExtensionConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnEndpointDeliveryRuleUrlFileExtensionCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnEndpointDeliveryRuleUrlFileExtensionCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    resetMatchValues(): void;
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _transforms?;
    get transforms(): string[];
    set transforms(value: string[]);
    resetTransforms(): void;
    get transformsInput(): string[] | undefined;
}
export declare class CdnEndpointDeliveryRuleUrlFileExtensionConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnEndpointDeliveryRuleUrlFileExtensionCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnEndpointDeliveryRuleUrlFileExtensionConditionOutputReference;
}
export interface CdnEndpointDeliveryRuleUrlFileNameCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#match_values CdnEndpoint#match_values}
    */
    readonly matchValues?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#operator CdnEndpoint#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#transforms CdnEndpoint#transforms}
    */
    readonly transforms?: string[];
}
export declare function cdnEndpointDeliveryRuleUrlFileNameConditionToTerraform(struct?: CdnEndpointDeliveryRuleUrlFileNameCondition | cdktf.IResolvable): any;
export declare function cdnEndpointDeliveryRuleUrlFileNameConditionToHclTerraform(struct?: CdnEndpointDeliveryRuleUrlFileNameCondition | cdktf.IResolvable): any;
export declare class CdnEndpointDeliveryRuleUrlFileNameConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnEndpointDeliveryRuleUrlFileNameCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnEndpointDeliveryRuleUrlFileNameCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    resetMatchValues(): void;
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _transforms?;
    get transforms(): string[];
    set transforms(value: string[]);
    resetTransforms(): void;
    get transformsInput(): string[] | undefined;
}
export declare class CdnEndpointDeliveryRuleUrlFileNameConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnEndpointDeliveryRuleUrlFileNameCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnEndpointDeliveryRuleUrlFileNameConditionOutputReference;
}
export interface CdnEndpointDeliveryRuleUrlPathCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#match_values CdnEndpoint#match_values}
    */
    readonly matchValues?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#operator CdnEndpoint#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#transforms CdnEndpoint#transforms}
    */
    readonly transforms?: string[];
}
export declare function cdnEndpointDeliveryRuleUrlPathConditionToTerraform(struct?: CdnEndpointDeliveryRuleUrlPathCondition | cdktf.IResolvable): any;
export declare function cdnEndpointDeliveryRuleUrlPathConditionToHclTerraform(struct?: CdnEndpointDeliveryRuleUrlPathCondition | cdktf.IResolvable): any;
export declare class CdnEndpointDeliveryRuleUrlPathConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnEndpointDeliveryRuleUrlPathCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnEndpointDeliveryRuleUrlPathCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    resetMatchValues(): void;
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _transforms?;
    get transforms(): string[];
    set transforms(value: string[]);
    resetTransforms(): void;
    get transformsInput(): string[] | undefined;
}
export declare class CdnEndpointDeliveryRuleUrlPathConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnEndpointDeliveryRuleUrlPathCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnEndpointDeliveryRuleUrlPathConditionOutputReference;
}
export interface CdnEndpointDeliveryRuleUrlRedirectAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#fragment CdnEndpoint#fragment}
    */
    readonly fragment?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#hostname CdnEndpoint#hostname}
    */
    readonly hostname?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#path CdnEndpoint#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#protocol CdnEndpoint#protocol}
    */
    readonly protocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#query_string CdnEndpoint#query_string}
    */
    readonly queryString?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#redirect_type CdnEndpoint#redirect_type}
    */
    readonly redirectType: string;
}
export declare function cdnEndpointDeliveryRuleUrlRedirectActionToTerraform(struct?: CdnEndpointDeliveryRuleUrlRedirectActionOutputReference | CdnEndpointDeliveryRuleUrlRedirectAction): any;
export declare function cdnEndpointDeliveryRuleUrlRedirectActionToHclTerraform(struct?: CdnEndpointDeliveryRuleUrlRedirectActionOutputReference | CdnEndpointDeliveryRuleUrlRedirectAction): any;
export declare class CdnEndpointDeliveryRuleUrlRedirectActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnEndpointDeliveryRuleUrlRedirectAction | undefined;
    set internalValue(value: CdnEndpointDeliveryRuleUrlRedirectAction | undefined);
    private _fragment?;
    get fragment(): string;
    set fragment(value: string);
    resetFragment(): void;
    get fragmentInput(): string | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    resetHostname(): void;
    get hostnameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
    private _queryString?;
    get queryString(): string;
    set queryString(value: string);
    resetQueryString(): void;
    get queryStringInput(): string | undefined;
    private _redirectType?;
    get redirectType(): string;
    set redirectType(value: string);
    get redirectTypeInput(): string | undefined;
}
export interface CdnEndpointDeliveryRuleUrlRewriteAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#destination CdnEndpoint#destination}
    */
    readonly destination: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#preserve_unmatched_path CdnEndpoint#preserve_unmatched_path}
    */
    readonly preserveUnmatchedPath?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#source_pattern CdnEndpoint#source_pattern}
    */
    readonly sourcePattern: string;
}
export declare function cdnEndpointDeliveryRuleUrlRewriteActionToTerraform(struct?: CdnEndpointDeliveryRuleUrlRewriteActionOutputReference | CdnEndpointDeliveryRuleUrlRewriteAction): any;
export declare function cdnEndpointDeliveryRuleUrlRewriteActionToHclTerraform(struct?: CdnEndpointDeliveryRuleUrlRewriteActionOutputReference | CdnEndpointDeliveryRuleUrlRewriteAction): any;
export declare class CdnEndpointDeliveryRuleUrlRewriteActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnEndpointDeliveryRuleUrlRewriteAction | undefined;
    set internalValue(value: CdnEndpointDeliveryRuleUrlRewriteAction | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _preserveUnmatchedPath?;
    get preserveUnmatchedPath(): boolean | cdktf.IResolvable;
    set preserveUnmatchedPath(value: boolean | cdktf.IResolvable);
    resetPreserveUnmatchedPath(): void;
    get preserveUnmatchedPathInput(): boolean | cdktf.IResolvable | undefined;
    private _sourcePattern?;
    get sourcePattern(): string;
    set sourcePattern(value: string);
    get sourcePatternInput(): string | undefined;
}
export interface CdnEndpointDeliveryRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#name CdnEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#order CdnEndpoint#order}
    */
    readonly order: number;
    /**
    * cache_expiration_action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#cache_expiration_action CdnEndpoint#cache_expiration_action}
    */
    readonly cacheExpirationAction?: CdnEndpointDeliveryRuleCacheExpirationAction;
    /**
    * cache_key_query_string_action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#cache_key_query_string_action CdnEndpoint#cache_key_query_string_action}
    */
    readonly cacheKeyQueryStringAction?: CdnEndpointDeliveryRuleCacheKeyQueryStringAction;
    /**
    * cookies_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#cookies_condition CdnEndpoint#cookies_condition}
    */
    readonly cookiesCondition?: CdnEndpointDeliveryRuleCookiesCondition[] | cdktf.IResolvable;
    /**
    * device_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#device_condition CdnEndpoint#device_condition}
    */
    readonly deviceCondition?: CdnEndpointDeliveryRuleDeviceCondition;
    /**
    * http_version_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#http_version_condition CdnEndpoint#http_version_condition}
    */
    readonly httpVersionCondition?: CdnEndpointDeliveryRuleHttpVersionCondition[] | cdktf.IResolvable;
    /**
    * modify_request_header_action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#modify_request_header_action CdnEndpoint#modify_request_header_action}
    */
    readonly modifyRequestHeaderAction?: CdnEndpointDeliveryRuleModifyRequestHeaderAction[] | cdktf.IResolvable;
    /**
    * modify_response_header_action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#modify_response_header_action CdnEndpoint#modify_response_header_action}
    */
    readonly modifyResponseHeaderAction?: CdnEndpointDeliveryRuleModifyResponseHeaderAction[] | cdktf.IResolvable;
    /**
    * post_arg_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#post_arg_condition CdnEndpoint#post_arg_condition}
    */
    readonly postArgCondition?: CdnEndpointDeliveryRulePostArgCondition[] | cdktf.IResolvable;
    /**
    * query_string_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#query_string_condition CdnEndpoint#query_string_condition}
    */
    readonly queryStringCondition?: CdnEndpointDeliveryRuleQueryStringCondition[] | cdktf.IResolvable;
    /**
    * remote_address_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#remote_address_condition CdnEndpoint#remote_address_condition}
    */
    readonly remoteAddressCondition?: CdnEndpointDeliveryRuleRemoteAddressCondition[] | cdktf.IResolvable;
    /**
    * request_body_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#request_body_condition CdnEndpoint#request_body_condition}
    */
    readonly requestBodyCondition?: CdnEndpointDeliveryRuleRequestBodyCondition[] | cdktf.IResolvable;
    /**
    * request_header_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#request_header_condition CdnEndpoint#request_header_condition}
    */
    readonly requestHeaderCondition?: CdnEndpointDeliveryRuleRequestHeaderCondition[] | cdktf.IResolvable;
    /**
    * request_method_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#request_method_condition CdnEndpoint#request_method_condition}
    */
    readonly requestMethodCondition?: CdnEndpointDeliveryRuleRequestMethodCondition;
    /**
    * request_scheme_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#request_scheme_condition CdnEndpoint#request_scheme_condition}
    */
    readonly requestSchemeCondition?: CdnEndpointDeliveryRuleRequestSchemeCondition;
    /**
    * request_uri_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#request_uri_condition CdnEndpoint#request_uri_condition}
    */
    readonly requestUriCondition?: CdnEndpointDeliveryRuleRequestUriCondition[] | cdktf.IResolvable;
    /**
    * url_file_extension_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#url_file_extension_condition CdnEndpoint#url_file_extension_condition}
    */
    readonly urlFileExtensionCondition?: CdnEndpointDeliveryRuleUrlFileExtensionCondition[] | cdktf.IResolvable;
    /**
    * url_file_name_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#url_file_name_condition CdnEndpoint#url_file_name_condition}
    */
    readonly urlFileNameCondition?: CdnEndpointDeliveryRuleUrlFileNameCondition[] | cdktf.IResolvable;
    /**
    * url_path_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#url_path_condition CdnEndpoint#url_path_condition}
    */
    readonly urlPathCondition?: CdnEndpointDeliveryRuleUrlPathCondition[] | cdktf.IResolvable;
    /**
    * url_redirect_action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#url_redirect_action CdnEndpoint#url_redirect_action}
    */
    readonly urlRedirectAction?: CdnEndpointDeliveryRuleUrlRedirectAction;
    /**
    * url_rewrite_action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#url_rewrite_action CdnEndpoint#url_rewrite_action}
    */
    readonly urlRewriteAction?: CdnEndpointDeliveryRuleUrlRewriteAction;
}
export declare function cdnEndpointDeliveryRuleToTerraform(struct?: CdnEndpointDeliveryRule | cdktf.IResolvable): any;
export declare function cdnEndpointDeliveryRuleToHclTerraform(struct?: CdnEndpointDeliveryRule | cdktf.IResolvable): any;
export declare class CdnEndpointDeliveryRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnEndpointDeliveryRule | cdktf.IResolvable | undefined;
    set internalValue(value: CdnEndpointDeliveryRule | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _order?;
    get order(): number;
    set order(value: number);
    get orderInput(): number | undefined;
    private _cacheExpirationAction;
    get cacheExpirationAction(): CdnEndpointDeliveryRuleCacheExpirationActionOutputReference;
    putCacheExpirationAction(value: CdnEndpointDeliveryRuleCacheExpirationAction): void;
    resetCacheExpirationAction(): void;
    get cacheExpirationActionInput(): CdnEndpointDeliveryRuleCacheExpirationAction | undefined;
    private _cacheKeyQueryStringAction;
    get cacheKeyQueryStringAction(): CdnEndpointDeliveryRuleCacheKeyQueryStringActionOutputReference;
    putCacheKeyQueryStringAction(value: CdnEndpointDeliveryRuleCacheKeyQueryStringAction): void;
    resetCacheKeyQueryStringAction(): void;
    get cacheKeyQueryStringActionInput(): CdnEndpointDeliveryRuleCacheKeyQueryStringAction | undefined;
    private _cookiesCondition;
    get cookiesCondition(): CdnEndpointDeliveryRuleCookiesConditionList;
    putCookiesCondition(value: CdnEndpointDeliveryRuleCookiesCondition[] | cdktf.IResolvable): void;
    resetCookiesCondition(): void;
    get cookiesConditionInput(): cdktf.IResolvable | CdnEndpointDeliveryRuleCookiesCondition[] | undefined;
    private _deviceCondition;
    get deviceCondition(): CdnEndpointDeliveryRuleDeviceConditionOutputReference;
    putDeviceCondition(value: CdnEndpointDeliveryRuleDeviceCondition): void;
    resetDeviceCondition(): void;
    get deviceConditionInput(): CdnEndpointDeliveryRuleDeviceCondition | undefined;
    private _httpVersionCondition;
    get httpVersionCondition(): CdnEndpointDeliveryRuleHttpVersionConditionList;
    putHttpVersionCondition(value: CdnEndpointDeliveryRuleHttpVersionCondition[] | cdktf.IResolvable): void;
    resetHttpVersionCondition(): void;
    get httpVersionConditionInput(): cdktf.IResolvable | CdnEndpointDeliveryRuleHttpVersionCondition[] | undefined;
    private _modifyRequestHeaderAction;
    get modifyRequestHeaderAction(): CdnEndpointDeliveryRuleModifyRequestHeaderActionList;
    putModifyRequestHeaderAction(value: CdnEndpointDeliveryRuleModifyRequestHeaderAction[] | cdktf.IResolvable): void;
    resetModifyRequestHeaderAction(): void;
    get modifyRequestHeaderActionInput(): cdktf.IResolvable | CdnEndpointDeliveryRuleModifyRequestHeaderAction[] | undefined;
    private _modifyResponseHeaderAction;
    get modifyResponseHeaderAction(): CdnEndpointDeliveryRuleModifyResponseHeaderActionList;
    putModifyResponseHeaderAction(value: CdnEndpointDeliveryRuleModifyResponseHeaderAction[] | cdktf.IResolvable): void;
    resetModifyResponseHeaderAction(): void;
    get modifyResponseHeaderActionInput(): cdktf.IResolvable | CdnEndpointDeliveryRuleModifyResponseHeaderAction[] | undefined;
    private _postArgCondition;
    get postArgCondition(): CdnEndpointDeliveryRulePostArgConditionList;
    putPostArgCondition(value: CdnEndpointDeliveryRulePostArgCondition[] | cdktf.IResolvable): void;
    resetPostArgCondition(): void;
    get postArgConditionInput(): cdktf.IResolvable | CdnEndpointDeliveryRulePostArgCondition[] | undefined;
    private _queryStringCondition;
    get queryStringCondition(): CdnEndpointDeliveryRuleQueryStringConditionList;
    putQueryStringCondition(value: CdnEndpointDeliveryRuleQueryStringCondition[] | cdktf.IResolvable): void;
    resetQueryStringCondition(): void;
    get queryStringConditionInput(): cdktf.IResolvable | CdnEndpointDeliveryRuleQueryStringCondition[] | undefined;
    private _remoteAddressCondition;
    get remoteAddressCondition(): CdnEndpointDeliveryRuleRemoteAddressConditionList;
    putRemoteAddressCondition(value: CdnEndpointDeliveryRuleRemoteAddressCondition[] | cdktf.IResolvable): void;
    resetRemoteAddressCondition(): void;
    get remoteAddressConditionInput(): cdktf.IResolvable | CdnEndpointDeliveryRuleRemoteAddressCondition[] | undefined;
    private _requestBodyCondition;
    get requestBodyCondition(): CdnEndpointDeliveryRuleRequestBodyConditionList;
    putRequestBodyCondition(value: CdnEndpointDeliveryRuleRequestBodyCondition[] | cdktf.IResolvable): void;
    resetRequestBodyCondition(): void;
    get requestBodyConditionInput(): cdktf.IResolvable | CdnEndpointDeliveryRuleRequestBodyCondition[] | undefined;
    private _requestHeaderCondition;
    get requestHeaderCondition(): CdnEndpointDeliveryRuleRequestHeaderConditionList;
    putRequestHeaderCondition(value: CdnEndpointDeliveryRuleRequestHeaderCondition[] | cdktf.IResolvable): void;
    resetRequestHeaderCondition(): void;
    get requestHeaderConditionInput(): cdktf.IResolvable | CdnEndpointDeliveryRuleRequestHeaderCondition[] | undefined;
    private _requestMethodCondition;
    get requestMethodCondition(): CdnEndpointDeliveryRuleRequestMethodConditionOutputReference;
    putRequestMethodCondition(value: CdnEndpointDeliveryRuleRequestMethodCondition): void;
    resetRequestMethodCondition(): void;
    get requestMethodConditionInput(): CdnEndpointDeliveryRuleRequestMethodCondition | undefined;
    private _requestSchemeCondition;
    get requestSchemeCondition(): CdnEndpointDeliveryRuleRequestSchemeConditionOutputReference;
    putRequestSchemeCondition(value: CdnEndpointDeliveryRuleRequestSchemeCondition): void;
    resetRequestSchemeCondition(): void;
    get requestSchemeConditionInput(): CdnEndpointDeliveryRuleRequestSchemeCondition | undefined;
    private _requestUriCondition;
    get requestUriCondition(): CdnEndpointDeliveryRuleRequestUriConditionList;
    putRequestUriCondition(value: CdnEndpointDeliveryRuleRequestUriCondition[] | cdktf.IResolvable): void;
    resetRequestUriCondition(): void;
    get requestUriConditionInput(): cdktf.IResolvable | CdnEndpointDeliveryRuleRequestUriCondition[] | undefined;
    private _urlFileExtensionCondition;
    get urlFileExtensionCondition(): CdnEndpointDeliveryRuleUrlFileExtensionConditionList;
    putUrlFileExtensionCondition(value: CdnEndpointDeliveryRuleUrlFileExtensionCondition[] | cdktf.IResolvable): void;
    resetUrlFileExtensionCondition(): void;
    get urlFileExtensionConditionInput(): cdktf.IResolvable | CdnEndpointDeliveryRuleUrlFileExtensionCondition[] | undefined;
    private _urlFileNameCondition;
    get urlFileNameCondition(): CdnEndpointDeliveryRuleUrlFileNameConditionList;
    putUrlFileNameCondition(value: CdnEndpointDeliveryRuleUrlFileNameCondition[] | cdktf.IResolvable): void;
    resetUrlFileNameCondition(): void;
    get urlFileNameConditionInput(): cdktf.IResolvable | CdnEndpointDeliveryRuleUrlFileNameCondition[] | undefined;
    private _urlPathCondition;
    get urlPathCondition(): CdnEndpointDeliveryRuleUrlPathConditionList;
    putUrlPathCondition(value: CdnEndpointDeliveryRuleUrlPathCondition[] | cdktf.IResolvable): void;
    resetUrlPathCondition(): void;
    get urlPathConditionInput(): cdktf.IResolvable | CdnEndpointDeliveryRuleUrlPathCondition[] | undefined;
    private _urlRedirectAction;
    get urlRedirectAction(): CdnEndpointDeliveryRuleUrlRedirectActionOutputReference;
    putUrlRedirectAction(value: CdnEndpointDeliveryRuleUrlRedirectAction): void;
    resetUrlRedirectAction(): void;
    get urlRedirectActionInput(): CdnEndpointDeliveryRuleUrlRedirectAction | undefined;
    private _urlRewriteAction;
    get urlRewriteAction(): CdnEndpointDeliveryRuleUrlRewriteActionOutputReference;
    putUrlRewriteAction(value: CdnEndpointDeliveryRuleUrlRewriteAction): void;
    resetUrlRewriteAction(): void;
    get urlRewriteActionInput(): CdnEndpointDeliveryRuleUrlRewriteAction | undefined;
}
export declare class CdnEndpointDeliveryRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnEndpointDeliveryRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnEndpointDeliveryRuleOutputReference;
}
export interface CdnEndpointGeoFilter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#action CdnEndpoint#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#country_codes CdnEndpoint#country_codes}
    */
    readonly countryCodes: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#relative_path CdnEndpoint#relative_path}
    */
    readonly relativePath: string;
}
export declare function cdnEndpointGeoFilterToTerraform(struct?: CdnEndpointGeoFilter | cdktf.IResolvable): any;
export declare function cdnEndpointGeoFilterToHclTerraform(struct?: CdnEndpointGeoFilter | cdktf.IResolvable): any;
export declare class CdnEndpointGeoFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnEndpointGeoFilter | cdktf.IResolvable | undefined;
    set internalValue(value: CdnEndpointGeoFilter | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _countryCodes?;
    get countryCodes(): string[];
    set countryCodes(value: string[]);
    get countryCodesInput(): string[] | undefined;
    private _relativePath?;
    get relativePath(): string;
    set relativePath(value: string);
    get relativePathInput(): string | undefined;
}
export declare class CdnEndpointGeoFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnEndpointGeoFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnEndpointGeoFilterOutputReference;
}
export interface CdnEndpointGlobalDeliveryRuleCacheExpirationAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#behavior CdnEndpoint#behavior}
    */
    readonly behavior: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#duration CdnEndpoint#duration}
    */
    readonly duration?: string;
}
export declare function cdnEndpointGlobalDeliveryRuleCacheExpirationActionToTerraform(struct?: CdnEndpointGlobalDeliveryRuleCacheExpirationActionOutputReference | CdnEndpointGlobalDeliveryRuleCacheExpirationAction): any;
export declare function cdnEndpointGlobalDeliveryRuleCacheExpirationActionToHclTerraform(struct?: CdnEndpointGlobalDeliveryRuleCacheExpirationActionOutputReference | CdnEndpointGlobalDeliveryRuleCacheExpirationAction): any;
export declare class CdnEndpointGlobalDeliveryRuleCacheExpirationActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnEndpointGlobalDeliveryRuleCacheExpirationAction | undefined;
    set internalValue(value: CdnEndpointGlobalDeliveryRuleCacheExpirationAction | undefined);
    private _behavior?;
    get behavior(): string;
    set behavior(value: string);
    get behaviorInput(): string | undefined;
    private _duration?;
    get duration(): string;
    set duration(value: string);
    resetDuration(): void;
    get durationInput(): string | undefined;
}
export interface CdnEndpointGlobalDeliveryRuleCacheKeyQueryStringAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#behavior CdnEndpoint#behavior}
    */
    readonly behavior: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#parameters CdnEndpoint#parameters}
    */
    readonly parameters?: string;
}
export declare function cdnEndpointGlobalDeliveryRuleCacheKeyQueryStringActionToTerraform(struct?: CdnEndpointGlobalDeliveryRuleCacheKeyQueryStringActionOutputReference | CdnEndpointGlobalDeliveryRuleCacheKeyQueryStringAction): any;
export declare function cdnEndpointGlobalDeliveryRuleCacheKeyQueryStringActionToHclTerraform(struct?: CdnEndpointGlobalDeliveryRuleCacheKeyQueryStringActionOutputReference | CdnEndpointGlobalDeliveryRuleCacheKeyQueryStringAction): any;
export declare class CdnEndpointGlobalDeliveryRuleCacheKeyQueryStringActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnEndpointGlobalDeliveryRuleCacheKeyQueryStringAction | undefined;
    set internalValue(value: CdnEndpointGlobalDeliveryRuleCacheKeyQueryStringAction | undefined);
    private _behavior?;
    get behavior(): string;
    set behavior(value: string);
    get behaviorInput(): string | undefined;
    private _parameters?;
    get parameters(): string;
    set parameters(value: string);
    resetParameters(): void;
    get parametersInput(): string | undefined;
}
export interface CdnEndpointGlobalDeliveryRuleModifyRequestHeaderAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#action CdnEndpoint#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#name CdnEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#value CdnEndpoint#value}
    */
    readonly value?: string;
}
export declare function cdnEndpointGlobalDeliveryRuleModifyRequestHeaderActionToTerraform(struct?: CdnEndpointGlobalDeliveryRuleModifyRequestHeaderAction | cdktf.IResolvable): any;
export declare function cdnEndpointGlobalDeliveryRuleModifyRequestHeaderActionToHclTerraform(struct?: CdnEndpointGlobalDeliveryRuleModifyRequestHeaderAction | cdktf.IResolvable): any;
export declare class CdnEndpointGlobalDeliveryRuleModifyRequestHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnEndpointGlobalDeliveryRuleModifyRequestHeaderAction | cdktf.IResolvable | undefined;
    set internalValue(value: CdnEndpointGlobalDeliveryRuleModifyRequestHeaderAction | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class CdnEndpointGlobalDeliveryRuleModifyRequestHeaderActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnEndpointGlobalDeliveryRuleModifyRequestHeaderAction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnEndpointGlobalDeliveryRuleModifyRequestHeaderActionOutputReference;
}
export interface CdnEndpointGlobalDeliveryRuleModifyResponseHeaderAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#action CdnEndpoint#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#name CdnEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#value CdnEndpoint#value}
    */
    readonly value?: string;
}
export declare function cdnEndpointGlobalDeliveryRuleModifyResponseHeaderActionToTerraform(struct?: CdnEndpointGlobalDeliveryRuleModifyResponseHeaderAction | cdktf.IResolvable): any;
export declare function cdnEndpointGlobalDeliveryRuleModifyResponseHeaderActionToHclTerraform(struct?: CdnEndpointGlobalDeliveryRuleModifyResponseHeaderAction | cdktf.IResolvable): any;
export declare class CdnEndpointGlobalDeliveryRuleModifyResponseHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnEndpointGlobalDeliveryRuleModifyResponseHeaderAction | cdktf.IResolvable | undefined;
    set internalValue(value: CdnEndpointGlobalDeliveryRuleModifyResponseHeaderAction | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class CdnEndpointGlobalDeliveryRuleModifyResponseHeaderActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnEndpointGlobalDeliveryRuleModifyResponseHeaderAction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnEndpointGlobalDeliveryRuleModifyResponseHeaderActionOutputReference;
}
export interface CdnEndpointGlobalDeliveryRuleUrlRedirectAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#fragment CdnEndpoint#fragment}
    */
    readonly fragment?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#hostname CdnEndpoint#hostname}
    */
    readonly hostname?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#path CdnEndpoint#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#protocol CdnEndpoint#protocol}
    */
    readonly protocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#query_string CdnEndpoint#query_string}
    */
    readonly queryString?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#redirect_type CdnEndpoint#redirect_type}
    */
    readonly redirectType: string;
}
export declare function cdnEndpointGlobalDeliveryRuleUrlRedirectActionToTerraform(struct?: CdnEndpointGlobalDeliveryRuleUrlRedirectActionOutputReference | CdnEndpointGlobalDeliveryRuleUrlRedirectAction): any;
export declare function cdnEndpointGlobalDeliveryRuleUrlRedirectActionToHclTerraform(struct?: CdnEndpointGlobalDeliveryRuleUrlRedirectActionOutputReference | CdnEndpointGlobalDeliveryRuleUrlRedirectAction): any;
export declare class CdnEndpointGlobalDeliveryRuleUrlRedirectActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnEndpointGlobalDeliveryRuleUrlRedirectAction | undefined;
    set internalValue(value: CdnEndpointGlobalDeliveryRuleUrlRedirectAction | undefined);
    private _fragment?;
    get fragment(): string;
    set fragment(value: string);
    resetFragment(): void;
    get fragmentInput(): string | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    resetHostname(): void;
    get hostnameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
    private _queryString?;
    get queryString(): string;
    set queryString(value: string);
    resetQueryString(): void;
    get queryStringInput(): string | undefined;
    private _redirectType?;
    get redirectType(): string;
    set redirectType(value: string);
    get redirectTypeInput(): string | undefined;
}
export interface CdnEndpointGlobalDeliveryRuleUrlRewriteAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#destination CdnEndpoint#destination}
    */
    readonly destination: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#preserve_unmatched_path CdnEndpoint#preserve_unmatched_path}
    */
    readonly preserveUnmatchedPath?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#source_pattern CdnEndpoint#source_pattern}
    */
    readonly sourcePattern: string;
}
export declare function cdnEndpointGlobalDeliveryRuleUrlRewriteActionToTerraform(struct?: CdnEndpointGlobalDeliveryRuleUrlRewriteActionOutputReference | CdnEndpointGlobalDeliveryRuleUrlRewriteAction): any;
export declare function cdnEndpointGlobalDeliveryRuleUrlRewriteActionToHclTerraform(struct?: CdnEndpointGlobalDeliveryRuleUrlRewriteActionOutputReference | CdnEndpointGlobalDeliveryRuleUrlRewriteAction): any;
export declare class CdnEndpointGlobalDeliveryRuleUrlRewriteActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnEndpointGlobalDeliveryRuleUrlRewriteAction | undefined;
    set internalValue(value: CdnEndpointGlobalDeliveryRuleUrlRewriteAction | undefined);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _preserveUnmatchedPath?;
    get preserveUnmatchedPath(): boolean | cdktf.IResolvable;
    set preserveUnmatchedPath(value: boolean | cdktf.IResolvable);
    resetPreserveUnmatchedPath(): void;
    get preserveUnmatchedPathInput(): boolean | cdktf.IResolvable | undefined;
    private _sourcePattern?;
    get sourcePattern(): string;
    set sourcePattern(value: string);
    get sourcePatternInput(): string | undefined;
}
export interface CdnEndpointGlobalDeliveryRule {
    /**
    * cache_expiration_action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#cache_expiration_action CdnEndpoint#cache_expiration_action}
    */
    readonly cacheExpirationAction?: CdnEndpointGlobalDeliveryRuleCacheExpirationAction;
    /**
    * cache_key_query_string_action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#cache_key_query_string_action CdnEndpoint#cache_key_query_string_action}
    */
    readonly cacheKeyQueryStringAction?: CdnEndpointGlobalDeliveryRuleCacheKeyQueryStringAction;
    /**
    * modify_request_header_action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#modify_request_header_action CdnEndpoint#modify_request_header_action}
    */
    readonly modifyRequestHeaderAction?: CdnEndpointGlobalDeliveryRuleModifyRequestHeaderAction[] | cdktf.IResolvable;
    /**
    * modify_response_header_action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#modify_response_header_action CdnEndpoint#modify_response_header_action}
    */
    readonly modifyResponseHeaderAction?: CdnEndpointGlobalDeliveryRuleModifyResponseHeaderAction[] | cdktf.IResolvable;
    /**
    * url_redirect_action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#url_redirect_action CdnEndpoint#url_redirect_action}
    */
    readonly urlRedirectAction?: CdnEndpointGlobalDeliveryRuleUrlRedirectAction;
    /**
    * url_rewrite_action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#url_rewrite_action CdnEndpoint#url_rewrite_action}
    */
    readonly urlRewriteAction?: CdnEndpointGlobalDeliveryRuleUrlRewriteAction;
}
export declare function cdnEndpointGlobalDeliveryRuleToTerraform(struct?: CdnEndpointGlobalDeliveryRuleOutputReference | CdnEndpointGlobalDeliveryRule): any;
export declare function cdnEndpointGlobalDeliveryRuleToHclTerraform(struct?: CdnEndpointGlobalDeliveryRuleOutputReference | CdnEndpointGlobalDeliveryRule): any;
export declare class CdnEndpointGlobalDeliveryRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnEndpointGlobalDeliveryRule | undefined;
    set internalValue(value: CdnEndpointGlobalDeliveryRule | undefined);
    private _cacheExpirationAction;
    get cacheExpirationAction(): CdnEndpointGlobalDeliveryRuleCacheExpirationActionOutputReference;
    putCacheExpirationAction(value: CdnEndpointGlobalDeliveryRuleCacheExpirationAction): void;
    resetCacheExpirationAction(): void;
    get cacheExpirationActionInput(): CdnEndpointGlobalDeliveryRuleCacheExpirationAction | undefined;
    private _cacheKeyQueryStringAction;
    get cacheKeyQueryStringAction(): CdnEndpointGlobalDeliveryRuleCacheKeyQueryStringActionOutputReference;
    putCacheKeyQueryStringAction(value: CdnEndpointGlobalDeliveryRuleCacheKeyQueryStringAction): void;
    resetCacheKeyQueryStringAction(): void;
    get cacheKeyQueryStringActionInput(): CdnEndpointGlobalDeliveryRuleCacheKeyQueryStringAction | undefined;
    private _modifyRequestHeaderAction;
    get modifyRequestHeaderAction(): CdnEndpointGlobalDeliveryRuleModifyRequestHeaderActionList;
    putModifyRequestHeaderAction(value: CdnEndpointGlobalDeliveryRuleModifyRequestHeaderAction[] | cdktf.IResolvable): void;
    resetModifyRequestHeaderAction(): void;
    get modifyRequestHeaderActionInput(): cdktf.IResolvable | CdnEndpointGlobalDeliveryRuleModifyRequestHeaderAction[] | undefined;
    private _modifyResponseHeaderAction;
    get modifyResponseHeaderAction(): CdnEndpointGlobalDeliveryRuleModifyResponseHeaderActionList;
    putModifyResponseHeaderAction(value: CdnEndpointGlobalDeliveryRuleModifyResponseHeaderAction[] | cdktf.IResolvable): void;
    resetModifyResponseHeaderAction(): void;
    get modifyResponseHeaderActionInput(): cdktf.IResolvable | CdnEndpointGlobalDeliveryRuleModifyResponseHeaderAction[] | undefined;
    private _urlRedirectAction;
    get urlRedirectAction(): CdnEndpointGlobalDeliveryRuleUrlRedirectActionOutputReference;
    putUrlRedirectAction(value: CdnEndpointGlobalDeliveryRuleUrlRedirectAction): void;
    resetUrlRedirectAction(): void;
    get urlRedirectActionInput(): CdnEndpointGlobalDeliveryRuleUrlRedirectAction | undefined;
    private _urlRewriteAction;
    get urlRewriteAction(): CdnEndpointGlobalDeliveryRuleUrlRewriteActionOutputReference;
    putUrlRewriteAction(value: CdnEndpointGlobalDeliveryRuleUrlRewriteAction): void;
    resetUrlRewriteAction(): void;
    get urlRewriteActionInput(): CdnEndpointGlobalDeliveryRuleUrlRewriteAction | undefined;
}
export interface CdnEndpointOrigin {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#host_name CdnEndpoint#host_name}
    */
    readonly hostName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#http_port CdnEndpoint#http_port}
    */
    readonly httpPort?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#https_port CdnEndpoint#https_port}
    */
    readonly httpsPort?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#name CdnEndpoint#name}
    */
    readonly name: string;
}
export declare function cdnEndpointOriginToTerraform(struct?: CdnEndpointOrigin | cdktf.IResolvable): any;
export declare function cdnEndpointOriginToHclTerraform(struct?: CdnEndpointOrigin | cdktf.IResolvable): any;
export declare class CdnEndpointOriginOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnEndpointOrigin | cdktf.IResolvable | undefined;
    set internalValue(value: CdnEndpointOrigin | cdktf.IResolvable | undefined);
    private _hostName?;
    get hostName(): string;
    set hostName(value: string);
    get hostNameInput(): string | undefined;
    private _httpPort?;
    get httpPort(): number;
    set httpPort(value: number);
    resetHttpPort(): void;
    get httpPortInput(): number | undefined;
    private _httpsPort?;
    get httpsPort(): number;
    set httpsPort(value: number);
    resetHttpsPort(): void;
    get httpsPortInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class CdnEndpointOriginList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnEndpointOrigin[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnEndpointOriginOutputReference;
}
export interface CdnEndpointTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#create CdnEndpoint#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#delete CdnEndpoint#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#read CdnEndpoint#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#update CdnEndpoint#update}
    */
    readonly update?: string;
}
export declare function cdnEndpointTimeoutsToTerraform(struct?: CdnEndpointTimeouts | cdktf.IResolvable): any;
export declare function cdnEndpointTimeoutsToHclTerraform(struct?: CdnEndpointTimeouts | cdktf.IResolvable): any;
export declare class CdnEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnEndpointTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CdnEndpointTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint azurerm_cdn_endpoint}
*/
export declare class CdnEndpoint extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cdn_endpoint";
    /**
    * Generates CDKTF code for importing a CdnEndpoint resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CdnEndpoint to import
    * @param importFromId The id of the existing CdnEndpoint that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CdnEndpoint to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/cdn_endpoint azurerm_cdn_endpoint} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CdnEndpointConfig
    */
    constructor(scope: Construct, id: string, config: CdnEndpointConfig);
    private _contentTypesToCompress?;
    get contentTypesToCompress(): string[];
    set contentTypesToCompress(value: string[]);
    resetContentTypesToCompress(): void;
    get contentTypesToCompressInput(): string[] | undefined;
    get fqdn(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isCompressionEnabled?;
    get isCompressionEnabled(): boolean | cdktf.IResolvable;
    set isCompressionEnabled(value: boolean | cdktf.IResolvable);
    resetIsCompressionEnabled(): void;
    get isCompressionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _isHttpAllowed?;
    get isHttpAllowed(): boolean | cdktf.IResolvable;
    set isHttpAllowed(value: boolean | cdktf.IResolvable);
    resetIsHttpAllowed(): void;
    get isHttpAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _isHttpsAllowed?;
    get isHttpsAllowed(): boolean | cdktf.IResolvable;
    set isHttpsAllowed(value: boolean | cdktf.IResolvable);
    resetIsHttpsAllowed(): void;
    get isHttpsAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _optimizationType?;
    get optimizationType(): string;
    set optimizationType(value: string);
    resetOptimizationType(): void;
    get optimizationTypeInput(): string | undefined;
    private _originHostHeader?;
    get originHostHeader(): string;
    set originHostHeader(value: string);
    resetOriginHostHeader(): void;
    get originHostHeaderInput(): string | undefined;
    private _originPath?;
    get originPath(): string;
    set originPath(value: string);
    resetOriginPath(): void;
    get originPathInput(): string | undefined;
    private _probePath?;
    get probePath(): string;
    set probePath(value: string);
    resetProbePath(): void;
    get probePathInput(): string | undefined;
    private _profileName?;
    get profileName(): string;
    set profileName(value: string);
    get profileNameInput(): string | undefined;
    private _querystringCachingBehaviour?;
    get querystringCachingBehaviour(): string;
    set querystringCachingBehaviour(value: string);
    resetQuerystringCachingBehaviour(): void;
    get querystringCachingBehaviourInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _deliveryRule;
    get deliveryRule(): CdnEndpointDeliveryRuleList;
    putDeliveryRule(value: CdnEndpointDeliveryRule[] | cdktf.IResolvable): void;
    resetDeliveryRule(): void;
    get deliveryRuleInput(): cdktf.IResolvable | CdnEndpointDeliveryRule[] | undefined;
    private _geoFilter;
    get geoFilter(): CdnEndpointGeoFilterList;
    putGeoFilter(value: CdnEndpointGeoFilter[] | cdktf.IResolvable): void;
    resetGeoFilter(): void;
    get geoFilterInput(): cdktf.IResolvable | CdnEndpointGeoFilter[] | undefined;
    private _globalDeliveryRule;
    get globalDeliveryRule(): CdnEndpointGlobalDeliveryRuleOutputReference;
    putGlobalDeliveryRule(value: CdnEndpointGlobalDeliveryRule): void;
    resetGlobalDeliveryRule(): void;
    get globalDeliveryRuleInput(): CdnEndpointGlobalDeliveryRule | undefined;
    private _origin;
    get origin(): CdnEndpointOriginList;
    putOrigin(value: CdnEndpointOrigin[] | cdktf.IResolvable): void;
    get originInput(): cdktf.IResolvable | CdnEndpointOrigin[] | undefined;
    private _timeouts;
    get timeouts(): CdnEndpointTimeoutsOutputReference;
    putTimeouts(value: CdnEndpointTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CdnEndpointTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
