/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermBastionHostConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/bastion_host#id DataAzurermBastionHost#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/bastion_host#name DataAzurermBastionHost#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/bastion_host#resource_group_name DataAzurermBastionHost#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/bastion_host#timeouts DataAzurermBastionHost#timeouts}
    */
    readonly timeouts?: DataAzurermBastionHostTimeouts;
}
export interface DataAzurermBastionHostIpConfiguration {
}
export declare function dataAzurermBastionHostIpConfigurationToTerraform(struct?: DataAzurermBastionHostIpConfiguration): any;
export declare function dataAzurermBastionHostIpConfigurationToHclTerraform(struct?: DataAzurermBastionHostIpConfiguration): any;
export declare class DataAzurermBastionHostIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBastionHostIpConfiguration | undefined;
    set internalValue(value: DataAzurermBastionHostIpConfiguration | undefined);
    get name(): string;
    get publicIpAddressId(): string;
    get subnetId(): string;
}
export declare class DataAzurermBastionHostIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBastionHostIpConfigurationOutputReference;
}
export interface DataAzurermBastionHostTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/bastion_host#read DataAzurermBastionHost#read}
    */
    readonly read?: string;
}
export declare function dataAzurermBastionHostTimeoutsToTerraform(struct?: DataAzurermBastionHostTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermBastionHostTimeoutsToHclTerraform(struct?: DataAzurermBastionHostTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermBastionHostTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermBastionHostTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermBastionHostTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/bastion_host azurerm_bastion_host}
*/
export declare class DataAzurermBastionHost extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_bastion_host";
    /**
    * Generates CDKTF code for importing a DataAzurermBastionHost resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermBastionHost to import
    * @param importFromId The id of the existing DataAzurermBastionHost that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/bastion_host#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermBastionHost to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/bastion_host azurerm_bastion_host} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermBastionHostConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermBastionHostConfig);
    get copyPasteEnabled(): cdktf.IResolvable;
    get dnsName(): string;
    get fileCopyEnabled(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipConfiguration;
    get ipConfiguration(): DataAzurermBastionHostIpConfigurationList;
    get ipConnectEnabled(): cdktf.IResolvable;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get scaleUnits(): number;
    get sessionRecordingEnabled(): cdktf.IResolvable;
    get shareableLinkEnabled(): cdktf.IResolvable;
    get sku(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get tunnelingEnabled(): cdktf.IResolvable;
    get zones(): string[];
    private _timeouts;
    get timeouts(): DataAzurermBastionHostTimeoutsOutputReference;
    putTimeouts(value: DataAzurermBastionHostTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermBastionHostTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
