/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermCognitiveAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/cognitive_account#id DataAzurermCognitiveAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/cognitive_account#name DataAzurermCognitiveAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/cognitive_account#resource_group_name DataAzurermCognitiveAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/cognitive_account#tags DataAzurermCognitiveAccount#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/cognitive_account#timeouts DataAzurermCognitiveAccount#timeouts}
    */
    readonly timeouts?: DataAzurermCognitiveAccountTimeouts;
}
export interface DataAzurermCognitiveAccountIdentity {
}
export declare function dataAzurermCognitiveAccountIdentityToTerraform(struct?: DataAzurermCognitiveAccountIdentity): any;
export declare function dataAzurermCognitiveAccountIdentityToHclTerraform(struct?: DataAzurermCognitiveAccountIdentity): any;
export declare class DataAzurermCognitiveAccountIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermCognitiveAccountIdentity | undefined;
    set internalValue(value: DataAzurermCognitiveAccountIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermCognitiveAccountIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermCognitiveAccountIdentityOutputReference;
}
export interface DataAzurermCognitiveAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/cognitive_account#read DataAzurermCognitiveAccount#read}
    */
    readonly read?: string;
}
export declare function dataAzurermCognitiveAccountTimeoutsToTerraform(struct?: DataAzurermCognitiveAccountTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermCognitiveAccountTimeoutsToHclTerraform(struct?: DataAzurermCognitiveAccountTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermCognitiveAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermCognitiveAccountTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermCognitiveAccountTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/cognitive_account azurerm_cognitive_account}
*/
export declare class DataAzurermCognitiveAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_cognitive_account";
    /**
    * Generates CDKTF code for importing a DataAzurermCognitiveAccount resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermCognitiveAccount to import
    * @param importFromId The id of the existing DataAzurermCognitiveAccount that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/cognitive_account#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermCognitiveAccount to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/cognitive_account azurerm_cognitive_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermCognitiveAccountConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermCognitiveAccountConfig);
    get endpoint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermCognitiveAccountIdentityList;
    get kind(): string;
    get localAuthEnabled(): cdktf.IResolvable;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primaryAccessKey(): string;
    get qnaRuntimeEndpoint(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    get skuName(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): DataAzurermCognitiveAccountTimeoutsOutputReference;
    putTimeouts(value: DataAzurermCognitiveAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermCognitiveAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
