/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDataShareDatasetDataLakeGen2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/data_share_dataset_data_lake_gen2#id DataAzurermDataShareDatasetDataLakeGen2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/data_share_dataset_data_lake_gen2#name DataAzurermDataShareDatasetDataLakeGen2#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/data_share_dataset_data_lake_gen2#share_id DataAzurermDataShareDatasetDataLakeGen2#share_id}
    */
    readonly shareId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/data_share_dataset_data_lake_gen2#timeouts DataAzurermDataShareDatasetDataLakeGen2#timeouts}
    */
    readonly timeouts?: DataAzurermDataShareDatasetDataLakeGen2Timeouts;
}
export interface DataAzurermDataShareDatasetDataLakeGen2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/data_share_dataset_data_lake_gen2#read DataAzurermDataShareDatasetDataLakeGen2#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDataShareDatasetDataLakeGen2TimeoutsToTerraform(struct?: DataAzurermDataShareDatasetDataLakeGen2Timeouts | cdktf.IResolvable): any;
export declare function dataAzurermDataShareDatasetDataLakeGen2TimeoutsToHclTerraform(struct?: DataAzurermDataShareDatasetDataLakeGen2Timeouts | cdktf.IResolvable): any;
export declare class DataAzurermDataShareDatasetDataLakeGen2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDataShareDatasetDataLakeGen2Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermDataShareDatasetDataLakeGen2Timeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/data_share_dataset_data_lake_gen2 azurerm_data_share_dataset_data_lake_gen2}
*/
export declare class DataAzurermDataShareDatasetDataLakeGen2 extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_data_share_dataset_data_lake_gen2";
    /**
    * Generates CDKTF code for importing a DataAzurermDataShareDatasetDataLakeGen2 resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermDataShareDatasetDataLakeGen2 to import
    * @param importFromId The id of the existing DataAzurermDataShareDatasetDataLakeGen2 that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/data_share_dataset_data_lake_gen2#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermDataShareDatasetDataLakeGen2 to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/data_share_dataset_data_lake_gen2 azurerm_data_share_dataset_data_lake_gen2} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDataShareDatasetDataLakeGen2Config
    */
    constructor(scope: Construct, id: string, config: DataAzurermDataShareDatasetDataLakeGen2Config);
    get displayName(): string;
    get filePath(): string;
    get fileSystemName(): string;
    get folderPath(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _shareId?;
    get shareId(): string;
    set shareId(value: string);
    get shareIdInput(): string | undefined;
    get storageAccountId(): string;
    private _timeouts;
    get timeouts(): DataAzurermDataShareDatasetDataLakeGen2TimeoutsOutputReference;
    putTimeouts(value: DataAzurermDataShareDatasetDataLakeGen2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermDataShareDatasetDataLakeGen2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
