/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermElasticCloudElasticsearchConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/elastic_cloud_elasticsearch#id DataAzurermElasticCloudElasticsearch#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/elastic_cloud_elasticsearch#name DataAzurermElasticCloudElasticsearch#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/elastic_cloud_elasticsearch#resource_group_name DataAzurermElasticCloudElasticsearch#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * logs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/elastic_cloud_elasticsearch#logs DataAzurermElasticCloudElasticsearch#logs}
    */
    readonly logs?: DataAzurermElasticCloudElasticsearchLogs[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/elastic_cloud_elasticsearch#timeouts DataAzurermElasticCloudElasticsearch#timeouts}
    */
    readonly timeouts?: DataAzurermElasticCloudElasticsearchTimeouts;
}
export interface DataAzurermElasticCloudElasticsearchLogsFilteringTag {
}
export declare function dataAzurermElasticCloudElasticsearchLogsFilteringTagToTerraform(struct?: DataAzurermElasticCloudElasticsearchLogsFilteringTag): any;
export declare function dataAzurermElasticCloudElasticsearchLogsFilteringTagToHclTerraform(struct?: DataAzurermElasticCloudElasticsearchLogsFilteringTag): any;
export declare class DataAzurermElasticCloudElasticsearchLogsFilteringTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermElasticCloudElasticsearchLogsFilteringTag | undefined;
    set internalValue(value: DataAzurermElasticCloudElasticsearchLogsFilteringTag | undefined);
    get action(): string;
    get name(): string;
    get value(): string;
}
export declare class DataAzurermElasticCloudElasticsearchLogsFilteringTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermElasticCloudElasticsearchLogsFilteringTagOutputReference;
}
export interface DataAzurermElasticCloudElasticsearchLogs {
}
export declare function dataAzurermElasticCloudElasticsearchLogsToTerraform(struct?: DataAzurermElasticCloudElasticsearchLogs | cdktf.IResolvable): any;
export declare function dataAzurermElasticCloudElasticsearchLogsToHclTerraform(struct?: DataAzurermElasticCloudElasticsearchLogs | cdktf.IResolvable): any;
export declare class DataAzurermElasticCloudElasticsearchLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermElasticCloudElasticsearchLogs | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermElasticCloudElasticsearchLogs | cdktf.IResolvable | undefined);
    private _filteringTag;
    get filteringTag(): DataAzurermElasticCloudElasticsearchLogsFilteringTagList;
    get sendActivityLogs(): cdktf.IResolvable;
    get sendAzureadLogs(): cdktf.IResolvable;
    get sendSubscriptionLogs(): cdktf.IResolvable;
}
export declare class DataAzurermElasticCloudElasticsearchLogsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataAzurermElasticCloudElasticsearchLogs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermElasticCloudElasticsearchLogsOutputReference;
}
export interface DataAzurermElasticCloudElasticsearchTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/elastic_cloud_elasticsearch#read DataAzurermElasticCloudElasticsearch#read}
    */
    readonly read?: string;
}
export declare function dataAzurermElasticCloudElasticsearchTimeoutsToTerraform(struct?: DataAzurermElasticCloudElasticsearchTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermElasticCloudElasticsearchTimeoutsToHclTerraform(struct?: DataAzurermElasticCloudElasticsearchTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermElasticCloudElasticsearchTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermElasticCloudElasticsearchTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermElasticCloudElasticsearchTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/elastic_cloud_elasticsearch azurerm_elastic_cloud_elasticsearch}
*/
export declare class DataAzurermElasticCloudElasticsearch extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_elastic_cloud_elasticsearch";
    /**
    * Generates CDKTF code for importing a DataAzurermElasticCloudElasticsearch resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermElasticCloudElasticsearch to import
    * @param importFromId The id of the existing DataAzurermElasticCloudElasticsearch that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/elastic_cloud_elasticsearch#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermElasticCloudElasticsearch to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/elastic_cloud_elasticsearch azurerm_elastic_cloud_elasticsearch} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermElasticCloudElasticsearchConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermElasticCloudElasticsearchConfig);
    get elasticCloudDeploymentId(): string;
    get elasticCloudEmailAddress(): string;
    get elasticCloudSsoDefaultUrl(): string;
    get elasticCloudUserId(): string;
    get elasticsearchServiceUrl(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kibanaServiceUrl(): string;
    get kibanaSsoUri(): string;
    get location(): string;
    get monitoringEnabled(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get skuName(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    private _logs;
    get logs(): DataAzurermElasticCloudElasticsearchLogsList;
    putLogs(value: DataAzurermElasticCloudElasticsearchLogs[] | cdktf.IResolvable): void;
    resetLogs(): void;
    get logsInput(): cdktf.IResolvable | DataAzurermElasticCloudElasticsearchLogs[] | undefined;
    private _timeouts;
    get timeouts(): DataAzurermElasticCloudElasticsearchTimeoutsOutputReference;
    putTimeouts(value: DataAzurermElasticCloudElasticsearchTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermElasticCloudElasticsearchTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
