/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermFirewallPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/firewall_policy#id DataAzurermFirewallPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/firewall_policy#name DataAzurermFirewallPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/firewall_policy#resource_group_name DataAzurermFirewallPolicy#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/firewall_policy#timeouts DataAzurermFirewallPolicy#timeouts}
    */
    readonly timeouts?: DataAzurermFirewallPolicyTimeouts;
}
export interface DataAzurermFirewallPolicyDns {
}
export declare function dataAzurermFirewallPolicyDnsToTerraform(struct?: DataAzurermFirewallPolicyDns): any;
export declare function dataAzurermFirewallPolicyDnsToHclTerraform(struct?: DataAzurermFirewallPolicyDns): any;
export declare class DataAzurermFirewallPolicyDnsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermFirewallPolicyDns | undefined;
    set internalValue(value: DataAzurermFirewallPolicyDns | undefined);
    get networkRuleFqdnEnabled(): cdktf.IResolvable;
    get proxyEnabled(): cdktf.IResolvable;
    get servers(): string[];
}
export declare class DataAzurermFirewallPolicyDnsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermFirewallPolicyDnsOutputReference;
}
export interface DataAzurermFirewallPolicyThreatIntelligenceAllowlistStruct {
}
export declare function dataAzurermFirewallPolicyThreatIntelligenceAllowlistStructToTerraform(struct?: DataAzurermFirewallPolicyThreatIntelligenceAllowlistStruct): any;
export declare function dataAzurermFirewallPolicyThreatIntelligenceAllowlistStructToHclTerraform(struct?: DataAzurermFirewallPolicyThreatIntelligenceAllowlistStruct): any;
export declare class DataAzurermFirewallPolicyThreatIntelligenceAllowlistStructOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermFirewallPolicyThreatIntelligenceAllowlistStruct | undefined;
    set internalValue(value: DataAzurermFirewallPolicyThreatIntelligenceAllowlistStruct | undefined);
    get fqdns(): string[];
    get ipAddresses(): string[];
}
export declare class DataAzurermFirewallPolicyThreatIntelligenceAllowlistStructList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermFirewallPolicyThreatIntelligenceAllowlistStructOutputReference;
}
export interface DataAzurermFirewallPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/firewall_policy#read DataAzurermFirewallPolicy#read}
    */
    readonly read?: string;
}
export declare function dataAzurermFirewallPolicyTimeoutsToTerraform(struct?: DataAzurermFirewallPolicyTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermFirewallPolicyTimeoutsToHclTerraform(struct?: DataAzurermFirewallPolicyTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermFirewallPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermFirewallPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermFirewallPolicyTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/firewall_policy azurerm_firewall_policy}
*/
export declare class DataAzurermFirewallPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_firewall_policy";
    /**
    * Generates CDKTF code for importing a DataAzurermFirewallPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermFirewallPolicy to import
    * @param importFromId The id of the existing DataAzurermFirewallPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/firewall_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermFirewallPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/firewall_policy azurerm_firewall_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermFirewallPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermFirewallPolicyConfig);
    get basePolicyId(): string;
    get childPolicies(): string[];
    private _dns;
    get dns(): DataAzurermFirewallPolicyDnsList;
    get firewalls(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get ruleCollectionGroups(): string[];
    private _tags;
    get tags(): cdktf.StringMap;
    private _threatIntelligenceAllowlist;
    get threatIntelligenceAllowlist(): DataAzurermFirewallPolicyThreatIntelligenceAllowlistStructList;
    get threatIntelligenceMode(): string;
    private _timeouts;
    get timeouts(): DataAzurermFirewallPolicyTimeoutsOutputReference;
    putTimeouts(value: DataAzurermFirewallPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermFirewallPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
