/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermIothubDpsSharedAccessPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/iothub_dps_shared_access_policy#id DataAzurermIothubDpsSharedAccessPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/iothub_dps_shared_access_policy#iothub_dps_name DataAzurermIothubDpsSharedAccessPolicy#iothub_dps_name}
    */
    readonly iothubDpsName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/iothub_dps_shared_access_policy#name DataAzurermIothubDpsSharedAccessPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/iothub_dps_shared_access_policy#resource_group_name DataAzurermIothubDpsSharedAccessPolicy#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/iothub_dps_shared_access_policy#timeouts DataAzurermIothubDpsSharedAccessPolicy#timeouts}
    */
    readonly timeouts?: DataAzurermIothubDpsSharedAccessPolicyTimeouts;
}
export interface DataAzurermIothubDpsSharedAccessPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/iothub_dps_shared_access_policy#read DataAzurermIothubDpsSharedAccessPolicy#read}
    */
    readonly read?: string;
}
export declare function dataAzurermIothubDpsSharedAccessPolicyTimeoutsToTerraform(struct?: DataAzurermIothubDpsSharedAccessPolicyTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermIothubDpsSharedAccessPolicyTimeoutsToHclTerraform(struct?: DataAzurermIothubDpsSharedAccessPolicyTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermIothubDpsSharedAccessPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermIothubDpsSharedAccessPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermIothubDpsSharedAccessPolicyTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/iothub_dps_shared_access_policy azurerm_iothub_dps_shared_access_policy}
*/
export declare class DataAzurermIothubDpsSharedAccessPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_iothub_dps_shared_access_policy";
    /**
    * Generates CDKTF code for importing a DataAzurermIothubDpsSharedAccessPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermIothubDpsSharedAccessPolicy to import
    * @param importFromId The id of the existing DataAzurermIothubDpsSharedAccessPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/iothub_dps_shared_access_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermIothubDpsSharedAccessPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/iothub_dps_shared_access_policy azurerm_iothub_dps_shared_access_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermIothubDpsSharedAccessPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermIothubDpsSharedAccessPolicyConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _iothubDpsName?;
    get iothubDpsName(): string;
    set iothubDpsName(value: string);
    get iothubDpsNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primaryConnectionString(): string;
    get primaryKey(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryConnectionString(): string;
    get secondaryKey(): string;
    private _timeouts;
    get timeouts(): DataAzurermIothubDpsSharedAccessPolicyTimeoutsOutputReference;
    putTimeouts(value: DataAzurermIothubDpsSharedAccessPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermIothubDpsSharedAccessPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
