/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermOracleExadataInfrastructureConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/oracle_exadata_infrastructure#id DataAzurermOracleExadataInfrastructure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/oracle_exadata_infrastructure#name DataAzurermOracleExadataInfrastructure#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/oracle_exadata_infrastructure#resource_group_name DataAzurermOracleExadataInfrastructure#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/oracle_exadata_infrastructure#timeouts DataAzurermOracleExadataInfrastructure#timeouts}
    */
    readonly timeouts?: DataAzurermOracleExadataInfrastructureTimeouts;
}
export interface DataAzurermOracleExadataInfrastructureEstimatedPatchingTime {
}
export declare function dataAzurermOracleExadataInfrastructureEstimatedPatchingTimeToTerraform(struct?: DataAzurermOracleExadataInfrastructureEstimatedPatchingTime): any;
export declare function dataAzurermOracleExadataInfrastructureEstimatedPatchingTimeToHclTerraform(struct?: DataAzurermOracleExadataInfrastructureEstimatedPatchingTime): any;
export declare class DataAzurermOracleExadataInfrastructureEstimatedPatchingTimeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermOracleExadataInfrastructureEstimatedPatchingTime | undefined;
    set internalValue(value: DataAzurermOracleExadataInfrastructureEstimatedPatchingTime | undefined);
    get estimatedDbServerPatchingTime(): number;
    get estimatedNetworkSwitchesPatchingTime(): number;
    get estimatedStorageServerPatchingTime(): number;
    get totalEstimatedPatchingTime(): number;
}
export declare class DataAzurermOracleExadataInfrastructureEstimatedPatchingTimeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermOracleExadataInfrastructureEstimatedPatchingTimeOutputReference;
}
export interface DataAzurermOracleExadataInfrastructureMaintenanceWindow {
}
export declare function dataAzurermOracleExadataInfrastructureMaintenanceWindowToTerraform(struct?: DataAzurermOracleExadataInfrastructureMaintenanceWindow): any;
export declare function dataAzurermOracleExadataInfrastructureMaintenanceWindowToHclTerraform(struct?: DataAzurermOracleExadataInfrastructureMaintenanceWindow): any;
export declare class DataAzurermOracleExadataInfrastructureMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermOracleExadataInfrastructureMaintenanceWindow | undefined;
    set internalValue(value: DataAzurermOracleExadataInfrastructureMaintenanceWindow | undefined);
    get customActionTimeoutEnabled(): cdktf.IResolvable;
    get customActionTimeoutInMins(): number;
    get daysOfWeek(): string[];
    get hoursOfDay(): number[];
    get leadTimeInWeeks(): number;
    get monthlyPatchingEnabled(): cdktf.IResolvable;
    get months(): string[];
    get patchingMode(): string;
    get preference(): string;
    get weeksOfMonth(): number[];
}
export declare class DataAzurermOracleExadataInfrastructureMaintenanceWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermOracleExadataInfrastructureMaintenanceWindowOutputReference;
}
export interface DataAzurermOracleExadataInfrastructureTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/oracle_exadata_infrastructure#read DataAzurermOracleExadataInfrastructure#read}
    */
    readonly read?: string;
}
export declare function dataAzurermOracleExadataInfrastructureTimeoutsToTerraform(struct?: DataAzurermOracleExadataInfrastructureTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermOracleExadataInfrastructureTimeoutsToHclTerraform(struct?: DataAzurermOracleExadataInfrastructureTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermOracleExadataInfrastructureTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermOracleExadataInfrastructureTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermOracleExadataInfrastructureTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/oracle_exadata_infrastructure azurerm_oracle_exadata_infrastructure}
*/
export declare class DataAzurermOracleExadataInfrastructure extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_oracle_exadata_infrastructure";
    /**
    * Generates CDKTF code for importing a DataAzurermOracleExadataInfrastructure resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermOracleExadataInfrastructure to import
    * @param importFromId The id of the existing DataAzurermOracleExadataInfrastructure that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/oracle_exadata_infrastructure#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermOracleExadataInfrastructure to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/oracle_exadata_infrastructure azurerm_oracle_exadata_infrastructure} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermOracleExadataInfrastructureConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermOracleExadataInfrastructureConfig);
    get activatedStorageCount(): number;
    get additionalStorageCount(): number;
    get availableStorageSizeInGbs(): number;
    get computeCount(): number;
    get cpuCount(): number;
    get customerContacts(): string[];
    get dataStorageSizeInTbs(): number;
    get dbNodeStorageSizeInGbs(): number;
    get dbServerVersion(): string;
    get displayName(): string;
    private _estimatedPatchingTime;
    get estimatedPatchingTime(): DataAzurermOracleExadataInfrastructureEstimatedPatchingTimeList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lastMaintenanceRunId(): string;
    get lifecycleDetails(): string;
    get lifecycleState(): string;
    get location(): string;
    private _maintenanceWindow;
    get maintenanceWindow(): DataAzurermOracleExadataInfrastructureMaintenanceWindowList;
    get maxCpuCount(): number;
    get maxDataStorageInTbs(): number;
    get maxDbNodeStorageSizeInGbs(): number;
    get maxMemoryInGbs(): number;
    get memorySizeInGbs(): number;
    get monthlyDbServerVersion(): string;
    get monthlyStorageServerVersion(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get nextMaintenanceRunId(): string;
    get ociUrl(): string;
    get ocid(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get shape(): string;
    get storageCount(): number;
    get storageServerVersion(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get timeCreated(): string;
    get totalStorageSizeInGbs(): number;
    get zones(): string[];
    private _timeouts;
    get timeouts(): DataAzurermOracleExadataInfrastructureTimeoutsOutputReference;
    putTimeouts(value: DataAzurermOracleExadataInfrastructureTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermOracleExadataInfrastructureTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
