/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPublicIpPrefixConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/public_ip_prefix#id DataAzurermPublicIpPrefix#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/public_ip_prefix#name DataAzurermPublicIpPrefix#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/public_ip_prefix#resource_group_name DataAzurermPublicIpPrefix#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/public_ip_prefix#timeouts DataAzurermPublicIpPrefix#timeouts}
    */
    readonly timeouts?: DataAzurermPublicIpPrefixTimeouts;
}
export interface DataAzurermPublicIpPrefixTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/public_ip_prefix#read DataAzurermPublicIpPrefix#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPublicIpPrefixTimeoutsToTerraform(struct?: DataAzurermPublicIpPrefixTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermPublicIpPrefixTimeoutsToHclTerraform(struct?: DataAzurermPublicIpPrefixTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPublicIpPrefixTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermPublicIpPrefixTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermPublicIpPrefixTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/public_ip_prefix azurerm_public_ip_prefix}
*/
export declare class DataAzurermPublicIpPrefix extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_public_ip_prefix";
    /**
    * Generates CDKTF code for importing a DataAzurermPublicIpPrefix resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermPublicIpPrefix to import
    * @param importFromId The id of the existing DataAzurermPublicIpPrefix that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/public_ip_prefix#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermPublicIpPrefix to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/public_ip_prefix azurerm_public_ip_prefix} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPublicIpPrefixConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermPublicIpPrefixConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ipPrefix(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get prefixLength(): number;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sku(): string;
    get skuTier(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get zones(): string[];
    private _timeouts;
    get timeouts(): DataAzurermPublicIpPrefixTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPublicIpPrefixTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermPublicIpPrefixTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
