/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermStackHciStoragePathConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/stack_hci_storage_path#id DataAzurermStackHciStoragePath#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/stack_hci_storage_path#name DataAzurermStackHciStoragePath#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/stack_hci_storage_path#resource_group_name DataAzurermStackHciStoragePath#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/stack_hci_storage_path#timeouts DataAzurermStackHciStoragePath#timeouts}
    */
    readonly timeouts?: DataAzurermStackHciStoragePathTimeouts;
}
export interface DataAzurermStackHciStoragePathTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/stack_hci_storage_path#read DataAzurermStackHciStoragePath#read}
    */
    readonly read?: string;
}
export declare function dataAzurermStackHciStoragePathTimeoutsToTerraform(struct?: DataAzurermStackHciStoragePathTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermStackHciStoragePathTimeoutsToHclTerraform(struct?: DataAzurermStackHciStoragePathTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermStackHciStoragePathTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermStackHciStoragePathTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermStackHciStoragePathTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/stack_hci_storage_path azurerm_stack_hci_storage_path}
*/
export declare class DataAzurermStackHciStoragePath extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_stack_hci_storage_path";
    /**
    * Generates CDKTF code for importing a DataAzurermStackHciStoragePath resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermStackHciStoragePath to import
    * @param importFromId The id of the existing DataAzurermStackHciStoragePath that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/stack_hci_storage_path#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermStackHciStoragePath to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/data-sources/stack_hci_storage_path azurerm_stack_hci_storage_path} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermStackHciStoragePathConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermStackHciStoragePathConfig);
    get customLocationId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get path(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermStackHciStoragePathTimeoutsOutputReference;
    putTimeouts(value: DataAzurermStackHciStoragePathTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermStackHciStoragePathTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
