/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataProtectionBackupVaultConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/data_protection_backup_vault#cross_region_restore_enabled DataProtectionBackupVault#cross_region_restore_enabled}
    */
    readonly crossRegionRestoreEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/data_protection_backup_vault#datastore_type DataProtectionBackupVault#datastore_type}
    */
    readonly datastoreType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/data_protection_backup_vault#id DataProtectionBackupVault#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/data_protection_backup_vault#immutability DataProtectionBackupVault#immutability}
    */
    readonly immutability?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/data_protection_backup_vault#location DataProtectionBackupVault#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/data_protection_backup_vault#name DataProtectionBackupVault#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/data_protection_backup_vault#redundancy DataProtectionBackupVault#redundancy}
    */
    readonly redundancy: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/data_protection_backup_vault#resource_group_name DataProtectionBackupVault#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/data_protection_backup_vault#retention_duration_in_days DataProtectionBackupVault#retention_duration_in_days}
    */
    readonly retentionDurationInDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/data_protection_backup_vault#soft_delete DataProtectionBackupVault#soft_delete}
    */
    readonly softDelete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/data_protection_backup_vault#tags DataProtectionBackupVault#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/data_protection_backup_vault#identity DataProtectionBackupVault#identity}
    */
    readonly identity?: DataProtectionBackupVaultIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/data_protection_backup_vault#timeouts DataProtectionBackupVault#timeouts}
    */
    readonly timeouts?: DataProtectionBackupVaultTimeouts;
}
export interface DataProtectionBackupVaultIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/data_protection_backup_vault#type DataProtectionBackupVault#type}
    */
    readonly type: string;
}
export declare function dataProtectionBackupVaultIdentityToTerraform(struct?: DataProtectionBackupVaultIdentityOutputReference | DataProtectionBackupVaultIdentity): any;
export declare function dataProtectionBackupVaultIdentityToHclTerraform(struct?: DataProtectionBackupVaultIdentityOutputReference | DataProtectionBackupVaultIdentity): any;
export declare class DataProtectionBackupVaultIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataProtectionBackupVaultIdentity | undefined;
    set internalValue(value: DataProtectionBackupVaultIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface DataProtectionBackupVaultTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/data_protection_backup_vault#create DataProtectionBackupVault#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/data_protection_backup_vault#delete DataProtectionBackupVault#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/data_protection_backup_vault#read DataProtectionBackupVault#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/data_protection_backup_vault#update DataProtectionBackupVault#update}
    */
    readonly update?: string;
}
export declare function dataProtectionBackupVaultTimeoutsToTerraform(struct?: DataProtectionBackupVaultTimeouts | cdktf.IResolvable): any;
export declare function dataProtectionBackupVaultTimeoutsToHclTerraform(struct?: DataProtectionBackupVaultTimeouts | cdktf.IResolvable): any;
export declare class DataProtectionBackupVaultTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataProtectionBackupVaultTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataProtectionBackupVaultTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/data_protection_backup_vault azurerm_data_protection_backup_vault}
*/
export declare class DataProtectionBackupVault extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_data_protection_backup_vault";
    /**
    * Generates CDKTF code for importing a DataProtectionBackupVault resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataProtectionBackupVault to import
    * @param importFromId The id of the existing DataProtectionBackupVault that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/data_protection_backup_vault#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataProtectionBackupVault to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/data_protection_backup_vault azurerm_data_protection_backup_vault} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataProtectionBackupVaultConfig
    */
    constructor(scope: Construct, id: string, config: DataProtectionBackupVaultConfig);
    private _crossRegionRestoreEnabled?;
    get crossRegionRestoreEnabled(): boolean | cdktf.IResolvable;
    set crossRegionRestoreEnabled(value: boolean | cdktf.IResolvable);
    resetCrossRegionRestoreEnabled(): void;
    get crossRegionRestoreEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _datastoreType?;
    get datastoreType(): string;
    set datastoreType(value: string);
    get datastoreTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _immutability?;
    get immutability(): string;
    set immutability(value: string);
    resetImmutability(): void;
    get immutabilityInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _redundancy?;
    get redundancy(): string;
    set redundancy(value: string);
    get redundancyInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _retentionDurationInDays?;
    get retentionDurationInDays(): number;
    set retentionDurationInDays(value: number);
    resetRetentionDurationInDays(): void;
    get retentionDurationInDaysInput(): number | undefined;
    private _softDelete?;
    get softDelete(): string;
    set softDelete(value: string);
    resetSoftDelete(): void;
    get softDeleteInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _identity;
    get identity(): DataProtectionBackupVaultIdentityOutputReference;
    putIdentity(value: DataProtectionBackupVaultIdentity): void;
    resetIdentity(): void;
    get identityInput(): DataProtectionBackupVaultIdentity | undefined;
    private _timeouts;
    get timeouts(): DataProtectionBackupVaultTimeoutsOutputReference;
    putTimeouts(value: DataProtectionBackupVaultTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataProtectionBackupVaultTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
