/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FabricCapacityConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/fabric_capacity#administration_members FabricCapacity#administration_members}
    */
    readonly administrationMembers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/fabric_capacity#id FabricCapacity#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/fabric_capacity#location FabricCapacity#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/fabric_capacity#name FabricCapacity#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/fabric_capacity#resource_group_name FabricCapacity#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/fabric_capacity#tags FabricCapacity#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * sku block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/fabric_capacity#sku FabricCapacity#sku}
    */
    readonly sku: FabricCapacitySku;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/fabric_capacity#timeouts FabricCapacity#timeouts}
    */
    readonly timeouts?: FabricCapacityTimeouts;
}
export interface FabricCapacitySku {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/fabric_capacity#name FabricCapacity#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/fabric_capacity#tier FabricCapacity#tier}
    */
    readonly tier: string;
}
export declare function fabricCapacitySkuToTerraform(struct?: FabricCapacitySkuOutputReference | FabricCapacitySku): any;
export declare function fabricCapacitySkuToHclTerraform(struct?: FabricCapacitySkuOutputReference | FabricCapacitySku): any;
export declare class FabricCapacitySkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FabricCapacitySku | undefined;
    set internalValue(value: FabricCapacitySku | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    get tierInput(): string | undefined;
}
export interface FabricCapacityTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/fabric_capacity#create FabricCapacity#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/fabric_capacity#delete FabricCapacity#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/fabric_capacity#read FabricCapacity#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/fabric_capacity#update FabricCapacity#update}
    */
    readonly update?: string;
}
export declare function fabricCapacityTimeoutsToTerraform(struct?: FabricCapacityTimeouts | cdktf.IResolvable): any;
export declare function fabricCapacityTimeoutsToHclTerraform(struct?: FabricCapacityTimeouts | cdktf.IResolvable): any;
export declare class FabricCapacityTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FabricCapacityTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: FabricCapacityTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/fabric_capacity azurerm_fabric_capacity}
*/
export declare class FabricCapacity extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_fabric_capacity";
    /**
    * Generates CDKTF code for importing a FabricCapacity resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the FabricCapacity to import
    * @param importFromId The id of the existing FabricCapacity that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/fabric_capacity#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the FabricCapacity to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/fabric_capacity azurerm_fabric_capacity} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FabricCapacityConfig
    */
    constructor(scope: Construct, id: string, config: FabricCapacityConfig);
    private _administrationMembers?;
    get administrationMembers(): string[];
    set administrationMembers(value: string[]);
    resetAdministrationMembers(): void;
    get administrationMembersInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _sku;
    get sku(): FabricCapacitySkuOutputReference;
    putSku(value: FabricCapacitySku): void;
    get skuInput(): FabricCapacitySku | undefined;
    private _timeouts;
    get timeouts(): FabricCapacityTimeoutsOutputReference;
    putTimeouts(value: FabricCapacityTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | FabricCapacityTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
