/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FunctionAppActiveSlotConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/function_app_active_slot#id FunctionAppActiveSlot#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The swap action should overwrite the Production slot's network configuration with the configuration from this slot. Defaults to `true`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/function_app_active_slot#overwrite_network_config FunctionAppActiveSlot#overwrite_network_config}
    */
    readonly overwriteNetworkConfig?: boolean | cdktf.IResolvable;
    /**
    * The ID of the Slot to swap with `Production`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/function_app_active_slot#slot_id FunctionAppActiveSlot#slot_id}
    */
    readonly slotId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/function_app_active_slot#timeouts FunctionAppActiveSlot#timeouts}
    */
    readonly timeouts?: FunctionAppActiveSlotTimeouts;
}
export interface FunctionAppActiveSlotTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/function_app_active_slot#create FunctionAppActiveSlot#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/function_app_active_slot#delete FunctionAppActiveSlot#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/function_app_active_slot#read FunctionAppActiveSlot#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/function_app_active_slot#update FunctionAppActiveSlot#update}
    */
    readonly update?: string;
}
export declare function functionAppActiveSlotTimeoutsToTerraform(struct?: FunctionAppActiveSlotTimeouts | cdktf.IResolvable): any;
export declare function functionAppActiveSlotTimeoutsToHclTerraform(struct?: FunctionAppActiveSlotTimeouts | cdktf.IResolvable): any;
export declare class FunctionAppActiveSlotTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FunctionAppActiveSlotTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: FunctionAppActiveSlotTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/function_app_active_slot azurerm_function_app_active_slot}
*/
export declare class FunctionAppActiveSlot extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_function_app_active_slot";
    /**
    * Generates CDKTF code for importing a FunctionAppActiveSlot resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the FunctionAppActiveSlot to import
    * @param importFromId The id of the existing FunctionAppActiveSlot that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/function_app_active_slot#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the FunctionAppActiveSlot to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/function_app_active_slot azurerm_function_app_active_slot} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FunctionAppActiveSlotConfig
    */
    constructor(scope: Construct, id: string, config: FunctionAppActiveSlotConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lastSuccessfulSwap(): string;
    private _overwriteNetworkConfig?;
    get overwriteNetworkConfig(): boolean | cdktf.IResolvable;
    set overwriteNetworkConfig(value: boolean | cdktf.IResolvable);
    resetOverwriteNetworkConfig(): void;
    get overwriteNetworkConfigInput(): boolean | cdktf.IResolvable | undefined;
    private _slotId?;
    get slotId(): string;
    set slotId(value: string);
    get slotIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): FunctionAppActiveSlotTimeoutsOutputReference;
    putTimeouts(value: FunctionAppActiveSlotTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | FunctionAppActiveSlotTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
