/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GalleryApplicationVersionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#config_file GalleryApplicationVersion#config_file}
    */
    readonly configFile?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#enable_health_check GalleryApplicationVersion#enable_health_check}
    */
    readonly enableHealthCheck?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#end_of_life_date GalleryApplicationVersion#end_of_life_date}
    */
    readonly endOfLifeDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#exclude_from_latest GalleryApplicationVersion#exclude_from_latest}
    */
    readonly excludeFromLatest?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#gallery_application_id GalleryApplicationVersion#gallery_application_id}
    */
    readonly galleryApplicationId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#id GalleryApplicationVersion#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#location GalleryApplicationVersion#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#name GalleryApplicationVersion#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#package_file GalleryApplicationVersion#package_file}
    */
    readonly packageFile?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#tags GalleryApplicationVersion#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * manage_action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#manage_action GalleryApplicationVersion#manage_action}
    */
    readonly manageAction: GalleryApplicationVersionManageAction;
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#source GalleryApplicationVersion#source}
    */
    readonly source: GalleryApplicationVersionSource;
    /**
    * target_region block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#target_region GalleryApplicationVersion#target_region}
    */
    readonly targetRegion: GalleryApplicationVersionTargetRegion[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#timeouts GalleryApplicationVersion#timeouts}
    */
    readonly timeouts?: GalleryApplicationVersionTimeouts;
}
export interface GalleryApplicationVersionManageAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#install GalleryApplicationVersion#install}
    */
    readonly install: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#remove GalleryApplicationVersion#remove}
    */
    readonly remove: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#update GalleryApplicationVersion#update}
    */
    readonly update?: string;
}
export declare function galleryApplicationVersionManageActionToTerraform(struct?: GalleryApplicationVersionManageActionOutputReference | GalleryApplicationVersionManageAction): any;
export declare function galleryApplicationVersionManageActionToHclTerraform(struct?: GalleryApplicationVersionManageActionOutputReference | GalleryApplicationVersionManageAction): any;
export declare class GalleryApplicationVersionManageActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GalleryApplicationVersionManageAction | undefined;
    set internalValue(value: GalleryApplicationVersionManageAction | undefined);
    private _install?;
    get install(): string;
    set install(value: string);
    get installInput(): string | undefined;
    private _remove?;
    get remove(): string;
    set remove(value: string);
    get removeInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GalleryApplicationVersionSource {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#default_configuration_link GalleryApplicationVersion#default_configuration_link}
    */
    readonly defaultConfigurationLink?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#media_link GalleryApplicationVersion#media_link}
    */
    readonly mediaLink: string;
}
export declare function galleryApplicationVersionSourceToTerraform(struct?: GalleryApplicationVersionSourceOutputReference | GalleryApplicationVersionSource): any;
export declare function galleryApplicationVersionSourceToHclTerraform(struct?: GalleryApplicationVersionSourceOutputReference | GalleryApplicationVersionSource): any;
export declare class GalleryApplicationVersionSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GalleryApplicationVersionSource | undefined;
    set internalValue(value: GalleryApplicationVersionSource | undefined);
    private _defaultConfigurationLink?;
    get defaultConfigurationLink(): string;
    set defaultConfigurationLink(value: string);
    resetDefaultConfigurationLink(): void;
    get defaultConfigurationLinkInput(): string | undefined;
    private _mediaLink?;
    get mediaLink(): string;
    set mediaLink(value: string);
    get mediaLinkInput(): string | undefined;
}
export interface GalleryApplicationVersionTargetRegion {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#exclude_from_latest GalleryApplicationVersion#exclude_from_latest}
    */
    readonly excludeFromLatest?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#name GalleryApplicationVersion#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#regional_replica_count GalleryApplicationVersion#regional_replica_count}
    */
    readonly regionalReplicaCount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#storage_account_type GalleryApplicationVersion#storage_account_type}
    */
    readonly storageAccountType?: string;
}
export declare function galleryApplicationVersionTargetRegionToTerraform(struct?: GalleryApplicationVersionTargetRegion | cdktf.IResolvable): any;
export declare function galleryApplicationVersionTargetRegionToHclTerraform(struct?: GalleryApplicationVersionTargetRegion | cdktf.IResolvable): any;
export declare class GalleryApplicationVersionTargetRegionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GalleryApplicationVersionTargetRegion | cdktf.IResolvable | undefined;
    set internalValue(value: GalleryApplicationVersionTargetRegion | cdktf.IResolvable | undefined);
    private _excludeFromLatest?;
    get excludeFromLatest(): boolean | cdktf.IResolvable;
    set excludeFromLatest(value: boolean | cdktf.IResolvable);
    resetExcludeFromLatest(): void;
    get excludeFromLatestInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _regionalReplicaCount?;
    get regionalReplicaCount(): number;
    set regionalReplicaCount(value: number);
    get regionalReplicaCountInput(): number | undefined;
    private _storageAccountType?;
    get storageAccountType(): string;
    set storageAccountType(value: string);
    resetStorageAccountType(): void;
    get storageAccountTypeInput(): string | undefined;
}
export declare class GalleryApplicationVersionTargetRegionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GalleryApplicationVersionTargetRegion[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GalleryApplicationVersionTargetRegionOutputReference;
}
export interface GalleryApplicationVersionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#create GalleryApplicationVersion#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#delete GalleryApplicationVersion#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#read GalleryApplicationVersion#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#update GalleryApplicationVersion#update}
    */
    readonly update?: string;
}
export declare function galleryApplicationVersionTimeoutsToTerraform(struct?: GalleryApplicationVersionTimeouts | cdktf.IResolvable): any;
export declare function galleryApplicationVersionTimeoutsToHclTerraform(struct?: GalleryApplicationVersionTimeouts | cdktf.IResolvable): any;
export declare class GalleryApplicationVersionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GalleryApplicationVersionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GalleryApplicationVersionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version azurerm_gallery_application_version}
*/
export declare class GalleryApplicationVersion extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_gallery_application_version";
    /**
    * Generates CDKTF code for importing a GalleryApplicationVersion resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GalleryApplicationVersion to import
    * @param importFromId The id of the existing GalleryApplicationVersion that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GalleryApplicationVersion to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/gallery_application_version azurerm_gallery_application_version} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GalleryApplicationVersionConfig
    */
    constructor(scope: Construct, id: string, config: GalleryApplicationVersionConfig);
    private _configFile?;
    get configFile(): string;
    set configFile(value: string);
    resetConfigFile(): void;
    get configFileInput(): string | undefined;
    private _enableHealthCheck?;
    get enableHealthCheck(): boolean | cdktf.IResolvable;
    set enableHealthCheck(value: boolean | cdktf.IResolvable);
    resetEnableHealthCheck(): void;
    get enableHealthCheckInput(): boolean | cdktf.IResolvable | undefined;
    private _endOfLifeDate?;
    get endOfLifeDate(): string;
    set endOfLifeDate(value: string);
    resetEndOfLifeDate(): void;
    get endOfLifeDateInput(): string | undefined;
    private _excludeFromLatest?;
    get excludeFromLatest(): boolean | cdktf.IResolvable;
    set excludeFromLatest(value: boolean | cdktf.IResolvable);
    resetExcludeFromLatest(): void;
    get excludeFromLatestInput(): boolean | cdktf.IResolvable | undefined;
    private _galleryApplicationId?;
    get galleryApplicationId(): string;
    set galleryApplicationId(value: string);
    get galleryApplicationIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _packageFile?;
    get packageFile(): string;
    set packageFile(value: string);
    resetPackageFile(): void;
    get packageFileInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _manageAction;
    get manageAction(): GalleryApplicationVersionManageActionOutputReference;
    putManageAction(value: GalleryApplicationVersionManageAction): void;
    get manageActionInput(): GalleryApplicationVersionManageAction | undefined;
    private _source;
    get source(): GalleryApplicationVersionSourceOutputReference;
    putSource(value: GalleryApplicationVersionSource): void;
    get sourceInput(): GalleryApplicationVersionSource | undefined;
    private _targetRegion;
    get targetRegion(): GalleryApplicationVersionTargetRegionList;
    putTargetRegion(value: GalleryApplicationVersionTargetRegion[] | cdktf.IResolvable): void;
    get targetRegionInput(): cdktf.IResolvable | GalleryApplicationVersionTargetRegion[] | undefined;
    private _timeouts;
    get timeouts(): GalleryApplicationVersionTimeoutsOutputReference;
    putTimeouts(value: GalleryApplicationVersionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GalleryApplicationVersionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
