/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KeyVaultSecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/key_vault_secret#content_type KeyVaultSecret#content_type}
    */
    readonly contentType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/key_vault_secret#expiration_date KeyVaultSecret#expiration_date}
    */
    readonly expirationDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/key_vault_secret#id KeyVaultSecret#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/key_vault_secret#key_vault_id KeyVaultSecret#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/key_vault_secret#name KeyVaultSecret#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/key_vault_secret#not_before_date KeyVaultSecret#not_before_date}
    */
    readonly notBeforeDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/key_vault_secret#tags KeyVaultSecret#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/key_vault_secret#value KeyVaultSecret#value}
    */
    readonly value?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/key_vault_secret#value_wo KeyVaultSecret#value_wo}
    */
    readonly valueWo?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/key_vault_secret#value_wo_version KeyVaultSecret#value_wo_version}
    */
    readonly valueWoVersion?: number;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/key_vault_secret#timeouts KeyVaultSecret#timeouts}
    */
    readonly timeouts?: KeyVaultSecretTimeouts;
}
export interface KeyVaultSecretTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/key_vault_secret#create KeyVaultSecret#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/key_vault_secret#delete KeyVaultSecret#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/key_vault_secret#read KeyVaultSecret#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/key_vault_secret#update KeyVaultSecret#update}
    */
    readonly update?: string;
}
export declare function keyVaultSecretTimeoutsToTerraform(struct?: KeyVaultSecretTimeouts | cdktf.IResolvable): any;
export declare function keyVaultSecretTimeoutsToHclTerraform(struct?: KeyVaultSecretTimeouts | cdktf.IResolvable): any;
export declare class KeyVaultSecretTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KeyVaultSecretTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: KeyVaultSecretTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/key_vault_secret azurerm_key_vault_secret}
*/
export declare class KeyVaultSecret extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_key_vault_secret";
    /**
    * Generates CDKTF code for importing a KeyVaultSecret resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the KeyVaultSecret to import
    * @param importFromId The id of the existing KeyVaultSecret that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/key_vault_secret#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the KeyVaultSecret to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/key_vault_secret azurerm_key_vault_secret} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KeyVaultSecretConfig
    */
    constructor(scope: Construct, id: string, config: KeyVaultSecretConfig);
    private _contentType?;
    get contentType(): string;
    set contentType(value: string);
    resetContentType(): void;
    get contentTypeInput(): string | undefined;
    private _expirationDate?;
    get expirationDate(): string;
    set expirationDate(value: string);
    resetExpirationDate(): void;
    get expirationDateInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notBeforeDate?;
    get notBeforeDate(): string;
    set notBeforeDate(value: string);
    resetNotBeforeDate(): void;
    get notBeforeDateInput(): string | undefined;
    get resourceId(): string;
    get resourceVersionlessId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _valueWo?;
    get valueWo(): string;
    set valueWo(value: string);
    resetValueWo(): void;
    get valueWoInput(): string | undefined;
    private _valueWoVersion?;
    get valueWoVersion(): number;
    set valueWoVersion(value: number);
    resetValueWoVersion(): void;
    get valueWoVersionInput(): number | undefined;
    get version(): string;
    get versionlessId(): string;
    private _timeouts;
    get timeouts(): KeyVaultSecretTimeoutsOutputReference;
    putTimeouts(value: KeyVaultSecretTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | KeyVaultSecretTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
