/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LogAnalyticsSolutionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/log_analytics_solution#id LogAnalyticsSolution#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/log_analytics_solution#location LogAnalyticsSolution#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/log_analytics_solution#resource_group_name LogAnalyticsSolution#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/log_analytics_solution#solution_name LogAnalyticsSolution#solution_name}
    */
    readonly solutionName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/log_analytics_solution#tags LogAnalyticsSolution#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/log_analytics_solution#workspace_name LogAnalyticsSolution#workspace_name}
    */
    readonly workspaceName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/log_analytics_solution#workspace_resource_id LogAnalyticsSolution#workspace_resource_id}
    */
    readonly workspaceResourceId: string;
    /**
    * plan block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/log_analytics_solution#plan LogAnalyticsSolution#plan}
    */
    readonly plan: LogAnalyticsSolutionPlan;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/log_analytics_solution#timeouts LogAnalyticsSolution#timeouts}
    */
    readonly timeouts?: LogAnalyticsSolutionTimeouts;
}
export interface LogAnalyticsSolutionPlan {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/log_analytics_solution#product LogAnalyticsSolution#product}
    */
    readonly product: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/log_analytics_solution#promotion_code LogAnalyticsSolution#promotion_code}
    */
    readonly promotionCode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/log_analytics_solution#publisher LogAnalyticsSolution#publisher}
    */
    readonly publisher: string;
}
export declare function logAnalyticsSolutionPlanToTerraform(struct?: LogAnalyticsSolutionPlanOutputReference | LogAnalyticsSolutionPlan): any;
export declare function logAnalyticsSolutionPlanToHclTerraform(struct?: LogAnalyticsSolutionPlanOutputReference | LogAnalyticsSolutionPlan): any;
export declare class LogAnalyticsSolutionPlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogAnalyticsSolutionPlan | undefined;
    set internalValue(value: LogAnalyticsSolutionPlan | undefined);
    get name(): string;
    private _product?;
    get product(): string;
    set product(value: string);
    get productInput(): string | undefined;
    private _promotionCode?;
    get promotionCode(): string;
    set promotionCode(value: string);
    resetPromotionCode(): void;
    get promotionCodeInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
}
export interface LogAnalyticsSolutionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/log_analytics_solution#create LogAnalyticsSolution#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/log_analytics_solution#delete LogAnalyticsSolution#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/log_analytics_solution#read LogAnalyticsSolution#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/log_analytics_solution#update LogAnalyticsSolution#update}
    */
    readonly update?: string;
}
export declare function logAnalyticsSolutionTimeoutsToTerraform(struct?: LogAnalyticsSolutionTimeouts | cdktf.IResolvable): any;
export declare function logAnalyticsSolutionTimeoutsToHclTerraform(struct?: LogAnalyticsSolutionTimeouts | cdktf.IResolvable): any;
export declare class LogAnalyticsSolutionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogAnalyticsSolutionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LogAnalyticsSolutionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/log_analytics_solution azurerm_log_analytics_solution}
*/
export declare class LogAnalyticsSolution extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_log_analytics_solution";
    /**
    * Generates CDKTF code for importing a LogAnalyticsSolution resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the LogAnalyticsSolution to import
    * @param importFromId The id of the existing LogAnalyticsSolution that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/log_analytics_solution#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the LogAnalyticsSolution to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/log_analytics_solution azurerm_log_analytics_solution} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LogAnalyticsSolutionConfig
    */
    constructor(scope: Construct, id: string, config: LogAnalyticsSolutionConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _solutionName?;
    get solutionName(): string;
    set solutionName(value: string);
    get solutionNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _workspaceName?;
    get workspaceName(): string;
    set workspaceName(value: string);
    get workspaceNameInput(): string | undefined;
    private _workspaceResourceId?;
    get workspaceResourceId(): string;
    set workspaceResourceId(value: string);
    get workspaceResourceIdInput(): string | undefined;
    private _plan;
    get plan(): LogAnalyticsSolutionPlanOutputReference;
    putPlan(value: LogAnalyticsSolutionPlan): void;
    get planInput(): LogAnalyticsSolutionPlan | undefined;
    private _timeouts;
    get timeouts(): LogAnalyticsSolutionTimeoutsOutputReference;
    putTimeouts(value: LogAnalyticsSolutionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LogAnalyticsSolutionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
