/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MaintenanceAssignmentDynamicScopeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/maintenance_assignment_dynamic_scope#id MaintenanceAssignmentDynamicScope#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/maintenance_assignment_dynamic_scope#maintenance_configuration_id MaintenanceAssignmentDynamicScope#maintenance_configuration_id}
    */
    readonly maintenanceConfigurationId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/maintenance_assignment_dynamic_scope#name MaintenanceAssignmentDynamicScope#name}
    */
    readonly name: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/maintenance_assignment_dynamic_scope#filter MaintenanceAssignmentDynamicScope#filter}
    */
    readonly filter: MaintenanceAssignmentDynamicScopeFilter;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/maintenance_assignment_dynamic_scope#timeouts MaintenanceAssignmentDynamicScope#timeouts}
    */
    readonly timeouts?: MaintenanceAssignmentDynamicScopeTimeouts;
}
export interface MaintenanceAssignmentDynamicScopeFilterTags {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/maintenance_assignment_dynamic_scope#tag MaintenanceAssignmentDynamicScope#tag}
    */
    readonly tag: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/maintenance_assignment_dynamic_scope#values MaintenanceAssignmentDynamicScope#values}
    */
    readonly values: string[];
}
export declare function maintenanceAssignmentDynamicScopeFilterTagsToTerraform(struct?: MaintenanceAssignmentDynamicScopeFilterTags | cdktf.IResolvable): any;
export declare function maintenanceAssignmentDynamicScopeFilterTagsToHclTerraform(struct?: MaintenanceAssignmentDynamicScopeFilterTags | cdktf.IResolvable): any;
export declare class MaintenanceAssignmentDynamicScopeFilterTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MaintenanceAssignmentDynamicScopeFilterTags | cdktf.IResolvable | undefined;
    set internalValue(value: MaintenanceAssignmentDynamicScopeFilterTags | cdktf.IResolvable | undefined);
    private _tag?;
    get tag(): string;
    set tag(value: string);
    get tagInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class MaintenanceAssignmentDynamicScopeFilterTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MaintenanceAssignmentDynamicScopeFilterTags[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MaintenanceAssignmentDynamicScopeFilterTagsOutputReference;
}
export interface MaintenanceAssignmentDynamicScopeFilter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/maintenance_assignment_dynamic_scope#locations MaintenanceAssignmentDynamicScope#locations}
    */
    readonly locations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/maintenance_assignment_dynamic_scope#os_types MaintenanceAssignmentDynamicScope#os_types}
    */
    readonly osTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/maintenance_assignment_dynamic_scope#resource_groups MaintenanceAssignmentDynamicScope#resource_groups}
    */
    readonly resourceGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/maintenance_assignment_dynamic_scope#resource_types MaintenanceAssignmentDynamicScope#resource_types}
    */
    readonly resourceTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/maintenance_assignment_dynamic_scope#tag_filter MaintenanceAssignmentDynamicScope#tag_filter}
    */
    readonly tagFilter?: string;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/maintenance_assignment_dynamic_scope#tags MaintenanceAssignmentDynamicScope#tags}
    */
    readonly tags?: MaintenanceAssignmentDynamicScopeFilterTags[] | cdktf.IResolvable;
}
export declare function maintenanceAssignmentDynamicScopeFilterToTerraform(struct?: MaintenanceAssignmentDynamicScopeFilterOutputReference | MaintenanceAssignmentDynamicScopeFilter): any;
export declare function maintenanceAssignmentDynamicScopeFilterToHclTerraform(struct?: MaintenanceAssignmentDynamicScopeFilterOutputReference | MaintenanceAssignmentDynamicScopeFilter): any;
export declare class MaintenanceAssignmentDynamicScopeFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MaintenanceAssignmentDynamicScopeFilter | undefined;
    set internalValue(value: MaintenanceAssignmentDynamicScopeFilter | undefined);
    private _locations?;
    get locations(): string[];
    set locations(value: string[]);
    resetLocations(): void;
    get locationsInput(): string[] | undefined;
    private _osTypes?;
    get osTypes(): string[];
    set osTypes(value: string[]);
    resetOsTypes(): void;
    get osTypesInput(): string[] | undefined;
    private _resourceGroups?;
    get resourceGroups(): string[];
    set resourceGroups(value: string[]);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string[] | undefined;
    private _resourceTypes?;
    get resourceTypes(): string[];
    set resourceTypes(value: string[]);
    resetResourceTypes(): void;
    get resourceTypesInput(): string[] | undefined;
    private _tagFilter?;
    get tagFilter(): string;
    set tagFilter(value: string);
    resetTagFilter(): void;
    get tagFilterInput(): string | undefined;
    private _tags;
    get tags(): MaintenanceAssignmentDynamicScopeFilterTagsList;
    putTags(value: MaintenanceAssignmentDynamicScopeFilterTags[] | cdktf.IResolvable): void;
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | MaintenanceAssignmentDynamicScopeFilterTags[] | undefined;
}
export interface MaintenanceAssignmentDynamicScopeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/maintenance_assignment_dynamic_scope#create MaintenanceAssignmentDynamicScope#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/maintenance_assignment_dynamic_scope#delete MaintenanceAssignmentDynamicScope#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/maintenance_assignment_dynamic_scope#read MaintenanceAssignmentDynamicScope#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/maintenance_assignment_dynamic_scope#update MaintenanceAssignmentDynamicScope#update}
    */
    readonly update?: string;
}
export declare function maintenanceAssignmentDynamicScopeTimeoutsToTerraform(struct?: MaintenanceAssignmentDynamicScopeTimeouts | cdktf.IResolvable): any;
export declare function maintenanceAssignmentDynamicScopeTimeoutsToHclTerraform(struct?: MaintenanceAssignmentDynamicScopeTimeouts | cdktf.IResolvable): any;
export declare class MaintenanceAssignmentDynamicScopeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MaintenanceAssignmentDynamicScopeTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MaintenanceAssignmentDynamicScopeTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/maintenance_assignment_dynamic_scope azurerm_maintenance_assignment_dynamic_scope}
*/
export declare class MaintenanceAssignmentDynamicScope extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_maintenance_assignment_dynamic_scope";
    /**
    * Generates CDKTF code for importing a MaintenanceAssignmentDynamicScope resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MaintenanceAssignmentDynamicScope to import
    * @param importFromId The id of the existing MaintenanceAssignmentDynamicScope that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/maintenance_assignment_dynamic_scope#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MaintenanceAssignmentDynamicScope to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/maintenance_assignment_dynamic_scope azurerm_maintenance_assignment_dynamic_scope} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MaintenanceAssignmentDynamicScopeConfig
    */
    constructor(scope: Construct, id: string, config: MaintenanceAssignmentDynamicScopeConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maintenanceConfigurationId?;
    get maintenanceConfigurationId(): string;
    set maintenanceConfigurationId(value: string);
    get maintenanceConfigurationIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _filter;
    get filter(): MaintenanceAssignmentDynamicScopeFilterOutputReference;
    putFilter(value: MaintenanceAssignmentDynamicScopeFilter): void;
    get filterInput(): MaintenanceAssignmentDynamicScopeFilter | undefined;
    private _timeouts;
    get timeouts(): MaintenanceAssignmentDynamicScopeTimeoutsOutputReference;
    putTimeouts(value: MaintenanceAssignmentDynamicScopeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MaintenanceAssignmentDynamicScopeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
