/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MobileNetworkSliceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mobile_network_slice#description MobileNetworkSlice#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mobile_network_slice#id MobileNetworkSlice#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mobile_network_slice#location MobileNetworkSlice#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mobile_network_slice#mobile_network_id MobileNetworkSlice#mobile_network_id}
    */
    readonly mobileNetworkId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mobile_network_slice#name MobileNetworkSlice#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mobile_network_slice#tags MobileNetworkSlice#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * single_network_slice_selection_assistance_information block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mobile_network_slice#single_network_slice_selection_assistance_information MobileNetworkSlice#single_network_slice_selection_assistance_information}
    */
    readonly singleNetworkSliceSelectionAssistanceInformation: MobileNetworkSliceSingleNetworkSliceSelectionAssistanceInformation;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mobile_network_slice#timeouts MobileNetworkSlice#timeouts}
    */
    readonly timeouts?: MobileNetworkSliceTimeouts;
}
export interface MobileNetworkSliceSingleNetworkSliceSelectionAssistanceInformation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mobile_network_slice#slice_differentiator MobileNetworkSlice#slice_differentiator}
    */
    readonly sliceDifferentiator?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mobile_network_slice#slice_service_type MobileNetworkSlice#slice_service_type}
    */
    readonly sliceServiceType: number;
}
export declare function mobileNetworkSliceSingleNetworkSliceSelectionAssistanceInformationToTerraform(struct?: MobileNetworkSliceSingleNetworkSliceSelectionAssistanceInformationOutputReference | MobileNetworkSliceSingleNetworkSliceSelectionAssistanceInformation): any;
export declare function mobileNetworkSliceSingleNetworkSliceSelectionAssistanceInformationToHclTerraform(struct?: MobileNetworkSliceSingleNetworkSliceSelectionAssistanceInformationOutputReference | MobileNetworkSliceSingleNetworkSliceSelectionAssistanceInformation): any;
export declare class MobileNetworkSliceSingleNetworkSliceSelectionAssistanceInformationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MobileNetworkSliceSingleNetworkSliceSelectionAssistanceInformation | undefined;
    set internalValue(value: MobileNetworkSliceSingleNetworkSliceSelectionAssistanceInformation | undefined);
    private _sliceDifferentiator?;
    get sliceDifferentiator(): string;
    set sliceDifferentiator(value: string);
    resetSliceDifferentiator(): void;
    get sliceDifferentiatorInput(): string | undefined;
    private _sliceServiceType?;
    get sliceServiceType(): number;
    set sliceServiceType(value: number);
    get sliceServiceTypeInput(): number | undefined;
}
export interface MobileNetworkSliceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mobile_network_slice#create MobileNetworkSlice#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mobile_network_slice#delete MobileNetworkSlice#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mobile_network_slice#read MobileNetworkSlice#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mobile_network_slice#update MobileNetworkSlice#update}
    */
    readonly update?: string;
}
export declare function mobileNetworkSliceTimeoutsToTerraform(struct?: MobileNetworkSliceTimeouts | cdktf.IResolvable): any;
export declare function mobileNetworkSliceTimeoutsToHclTerraform(struct?: MobileNetworkSliceTimeouts | cdktf.IResolvable): any;
export declare class MobileNetworkSliceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MobileNetworkSliceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MobileNetworkSliceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mobile_network_slice azurerm_mobile_network_slice}
*/
export declare class MobileNetworkSlice extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mobile_network_slice";
    /**
    * Generates CDKTF code for importing a MobileNetworkSlice resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MobileNetworkSlice to import
    * @param importFromId The id of the existing MobileNetworkSlice that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mobile_network_slice#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MobileNetworkSlice to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mobile_network_slice azurerm_mobile_network_slice} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MobileNetworkSliceConfig
    */
    constructor(scope: Construct, id: string, config: MobileNetworkSliceConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _mobileNetworkId?;
    get mobileNetworkId(): string;
    set mobileNetworkId(value: string);
    get mobileNetworkIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _singleNetworkSliceSelectionAssistanceInformation;
    get singleNetworkSliceSelectionAssistanceInformation(): MobileNetworkSliceSingleNetworkSliceSelectionAssistanceInformationOutputReference;
    putSingleNetworkSliceSelectionAssistanceInformation(value: MobileNetworkSliceSingleNetworkSliceSelectionAssistanceInformation): void;
    get singleNetworkSliceSelectionAssistanceInformationInput(): MobileNetworkSliceSingleNetworkSliceSelectionAssistanceInformation | undefined;
    private _timeouts;
    get timeouts(): MobileNetworkSliceTimeoutsOutputReference;
    putTimeouts(value: MobileNetworkSliceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MobileNetworkSliceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
