/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MssqlManagedDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mssql_managed_database#id MssqlManagedDatabase#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mssql_managed_database#managed_instance_id MssqlManagedDatabase#managed_instance_id}
    */
    readonly managedInstanceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mssql_managed_database#name MssqlManagedDatabase#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mssql_managed_database#short_term_retention_days MssqlManagedDatabase#short_term_retention_days}
    */
    readonly shortTermRetentionDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mssql_managed_database#tags MssqlManagedDatabase#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * long_term_retention_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mssql_managed_database#long_term_retention_policy MssqlManagedDatabase#long_term_retention_policy}
    */
    readonly longTermRetentionPolicy?: MssqlManagedDatabaseLongTermRetentionPolicy;
    /**
    * point_in_time_restore block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mssql_managed_database#point_in_time_restore MssqlManagedDatabase#point_in_time_restore}
    */
    readonly pointInTimeRestore?: MssqlManagedDatabasePointInTimeRestore;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mssql_managed_database#timeouts MssqlManagedDatabase#timeouts}
    */
    readonly timeouts?: MssqlManagedDatabaseTimeouts;
}
export interface MssqlManagedDatabaseLongTermRetentionPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mssql_managed_database#immutable_backups_enabled MssqlManagedDatabase#immutable_backups_enabled}
    */
    readonly immutableBackupsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mssql_managed_database#monthly_retention MssqlManagedDatabase#monthly_retention}
    */
    readonly monthlyRetention?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mssql_managed_database#week_of_year MssqlManagedDatabase#week_of_year}
    */
    readonly weekOfYear?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mssql_managed_database#weekly_retention MssqlManagedDatabase#weekly_retention}
    */
    readonly weeklyRetention?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mssql_managed_database#yearly_retention MssqlManagedDatabase#yearly_retention}
    */
    readonly yearlyRetention?: string;
}
export declare function mssqlManagedDatabaseLongTermRetentionPolicyToTerraform(struct?: MssqlManagedDatabaseLongTermRetentionPolicyOutputReference | MssqlManagedDatabaseLongTermRetentionPolicy): any;
export declare function mssqlManagedDatabaseLongTermRetentionPolicyToHclTerraform(struct?: MssqlManagedDatabaseLongTermRetentionPolicyOutputReference | MssqlManagedDatabaseLongTermRetentionPolicy): any;
export declare class MssqlManagedDatabaseLongTermRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlManagedDatabaseLongTermRetentionPolicy | undefined;
    set internalValue(value: MssqlManagedDatabaseLongTermRetentionPolicy | undefined);
    private _immutableBackupsEnabled?;
    get immutableBackupsEnabled(): boolean | cdktf.IResolvable;
    set immutableBackupsEnabled(value: boolean | cdktf.IResolvable);
    resetImmutableBackupsEnabled(): void;
    get immutableBackupsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _monthlyRetention?;
    get monthlyRetention(): string;
    set monthlyRetention(value: string);
    resetMonthlyRetention(): void;
    get monthlyRetentionInput(): string | undefined;
    private _weekOfYear?;
    get weekOfYear(): number;
    set weekOfYear(value: number);
    resetWeekOfYear(): void;
    get weekOfYearInput(): number | undefined;
    private _weeklyRetention?;
    get weeklyRetention(): string;
    set weeklyRetention(value: string);
    resetWeeklyRetention(): void;
    get weeklyRetentionInput(): string | undefined;
    private _yearlyRetention?;
    get yearlyRetention(): string;
    set yearlyRetention(value: string);
    resetYearlyRetention(): void;
    get yearlyRetentionInput(): string | undefined;
}
export interface MssqlManagedDatabasePointInTimeRestore {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mssql_managed_database#restore_point_in_time MssqlManagedDatabase#restore_point_in_time}
    */
    readonly restorePointInTime: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mssql_managed_database#source_database_id MssqlManagedDatabase#source_database_id}
    */
    readonly sourceDatabaseId: string;
}
export declare function mssqlManagedDatabasePointInTimeRestoreToTerraform(struct?: MssqlManagedDatabasePointInTimeRestoreOutputReference | MssqlManagedDatabasePointInTimeRestore): any;
export declare function mssqlManagedDatabasePointInTimeRestoreToHclTerraform(struct?: MssqlManagedDatabasePointInTimeRestoreOutputReference | MssqlManagedDatabasePointInTimeRestore): any;
export declare class MssqlManagedDatabasePointInTimeRestoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlManagedDatabasePointInTimeRestore | undefined;
    set internalValue(value: MssqlManagedDatabasePointInTimeRestore | undefined);
    private _restorePointInTime?;
    get restorePointInTime(): string;
    set restorePointInTime(value: string);
    get restorePointInTimeInput(): string | undefined;
    private _sourceDatabaseId?;
    get sourceDatabaseId(): string;
    set sourceDatabaseId(value: string);
    get sourceDatabaseIdInput(): string | undefined;
}
export interface MssqlManagedDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mssql_managed_database#create MssqlManagedDatabase#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mssql_managed_database#delete MssqlManagedDatabase#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mssql_managed_database#read MssqlManagedDatabase#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mssql_managed_database#update MssqlManagedDatabase#update}
    */
    readonly update?: string;
}
export declare function mssqlManagedDatabaseTimeoutsToTerraform(struct?: MssqlManagedDatabaseTimeouts | cdktf.IResolvable): any;
export declare function mssqlManagedDatabaseTimeoutsToHclTerraform(struct?: MssqlManagedDatabaseTimeouts | cdktf.IResolvable): any;
export declare class MssqlManagedDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlManagedDatabaseTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MssqlManagedDatabaseTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mssql_managed_database azurerm_mssql_managed_database}
*/
export declare class MssqlManagedDatabase extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mssql_managed_database";
    /**
    * Generates CDKTF code for importing a MssqlManagedDatabase resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MssqlManagedDatabase to import
    * @param importFromId The id of the existing MssqlManagedDatabase that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mssql_managed_database#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MssqlManagedDatabase to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/mssql_managed_database azurerm_mssql_managed_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MssqlManagedDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: MssqlManagedDatabaseConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _managedInstanceId?;
    get managedInstanceId(): string;
    set managedInstanceId(value: string);
    get managedInstanceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _shortTermRetentionDays?;
    get shortTermRetentionDays(): number;
    set shortTermRetentionDays(value: number);
    resetShortTermRetentionDays(): void;
    get shortTermRetentionDaysInput(): number | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _longTermRetentionPolicy;
    get longTermRetentionPolicy(): MssqlManagedDatabaseLongTermRetentionPolicyOutputReference;
    putLongTermRetentionPolicy(value: MssqlManagedDatabaseLongTermRetentionPolicy): void;
    resetLongTermRetentionPolicy(): void;
    get longTermRetentionPolicyInput(): MssqlManagedDatabaseLongTermRetentionPolicy | undefined;
    private _pointInTimeRestore;
    get pointInTimeRestore(): MssqlManagedDatabasePointInTimeRestoreOutputReference;
    putPointInTimeRestore(value: MssqlManagedDatabasePointInTimeRestore): void;
    resetPointInTimeRestore(): void;
    get pointInTimeRestoreInput(): MssqlManagedDatabasePointInTimeRestore | undefined;
    private _timeouts;
    get timeouts(): MssqlManagedDatabaseTimeoutsOutputReference;
    putTimeouts(value: MssqlManagedDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MssqlManagedDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
