/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetappVolumeGroupSapHanaConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#account_name NetappVolumeGroupSapHana#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#application_identifier NetappVolumeGroupSapHana#application_identifier}
    */
    readonly applicationIdentifier: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#group_description NetappVolumeGroupSapHana#group_description}
    */
    readonly groupDescription: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#id NetappVolumeGroupSapHana#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#location NetappVolumeGroupSapHana#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#name NetappVolumeGroupSapHana#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#resource_group_name NetappVolumeGroupSapHana#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#timeouts NetappVolumeGroupSapHana#timeouts}
    */
    readonly timeouts?: NetappVolumeGroupSapHanaTimeouts;
    /**
    * volume block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#volume NetappVolumeGroupSapHana#volume}
    */
    readonly volume: NetappVolumeGroupSapHanaVolume[] | cdktf.IResolvable;
}
export interface NetappVolumeGroupSapHanaTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#create NetappVolumeGroupSapHana#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#delete NetappVolumeGroupSapHana#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#read NetappVolumeGroupSapHana#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#update NetappVolumeGroupSapHana#update}
    */
    readonly update?: string;
}
export declare function netappVolumeGroupSapHanaTimeoutsToTerraform(struct?: NetappVolumeGroupSapHanaTimeouts | cdktf.IResolvable): any;
export declare function netappVolumeGroupSapHanaTimeoutsToHclTerraform(struct?: NetappVolumeGroupSapHanaTimeouts | cdktf.IResolvable): any;
export declare class NetappVolumeGroupSapHanaTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetappVolumeGroupSapHanaTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NetappVolumeGroupSapHanaTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface NetappVolumeGroupSapHanaVolumeDataProtectionReplication {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#endpoint_type NetappVolumeGroupSapHana#endpoint_type}
    */
    readonly endpointType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#remote_volume_location NetappVolumeGroupSapHana#remote_volume_location}
    */
    readonly remoteVolumeLocation: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#remote_volume_resource_id NetappVolumeGroupSapHana#remote_volume_resource_id}
    */
    readonly remoteVolumeResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#replication_frequency NetappVolumeGroupSapHana#replication_frequency}
    */
    readonly replicationFrequency: string;
}
export declare function netappVolumeGroupSapHanaVolumeDataProtectionReplicationToTerraform(struct?: NetappVolumeGroupSapHanaVolumeDataProtectionReplicationOutputReference | NetappVolumeGroupSapHanaVolumeDataProtectionReplication): any;
export declare function netappVolumeGroupSapHanaVolumeDataProtectionReplicationToHclTerraform(struct?: NetappVolumeGroupSapHanaVolumeDataProtectionReplicationOutputReference | NetappVolumeGroupSapHanaVolumeDataProtectionReplication): any;
export declare class NetappVolumeGroupSapHanaVolumeDataProtectionReplicationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetappVolumeGroupSapHanaVolumeDataProtectionReplication | undefined;
    set internalValue(value: NetappVolumeGroupSapHanaVolumeDataProtectionReplication | undefined);
    private _endpointType?;
    get endpointType(): string;
    set endpointType(value: string);
    resetEndpointType(): void;
    get endpointTypeInput(): string | undefined;
    private _remoteVolumeLocation?;
    get remoteVolumeLocation(): string;
    set remoteVolumeLocation(value: string);
    get remoteVolumeLocationInput(): string | undefined;
    private _remoteVolumeResourceId?;
    get remoteVolumeResourceId(): string;
    set remoteVolumeResourceId(value: string);
    get remoteVolumeResourceIdInput(): string | undefined;
    private _replicationFrequency?;
    get replicationFrequency(): string;
    set replicationFrequency(value: string);
    get replicationFrequencyInput(): string | undefined;
}
export interface NetappVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#snapshot_policy_id NetappVolumeGroupSapHana#snapshot_policy_id}
    */
    readonly snapshotPolicyId: string;
}
export declare function netappVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyToTerraform(struct?: NetappVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyOutputReference | NetappVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicy): any;
export declare function netappVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyToHclTerraform(struct?: NetappVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyOutputReference | NetappVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicy): any;
export declare class NetappVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetappVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicy | undefined;
    set internalValue(value: NetappVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicy | undefined);
    private _snapshotPolicyId?;
    get snapshotPolicyId(): string;
    set snapshotPolicyId(value: string);
    get snapshotPolicyIdInput(): string | undefined;
}
export interface NetappVolumeGroupSapHanaVolumeExportPolicyRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#allowed_clients NetappVolumeGroupSapHana#allowed_clients}
    */
    readonly allowedClients: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#nfsv3_enabled NetappVolumeGroupSapHana#nfsv3_enabled}
    */
    readonly nfsv3Enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#nfsv41_enabled NetappVolumeGroupSapHana#nfsv41_enabled}
    */
    readonly nfsv41Enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#root_access_enabled NetappVolumeGroupSapHana#root_access_enabled}
    */
    readonly rootAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#rule_index NetappVolumeGroupSapHana#rule_index}
    */
    readonly ruleIndex: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#unix_read_only NetappVolumeGroupSapHana#unix_read_only}
    */
    readonly unixReadOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#unix_read_write NetappVolumeGroupSapHana#unix_read_write}
    */
    readonly unixReadWrite?: boolean | cdktf.IResolvable;
}
export declare function netappVolumeGroupSapHanaVolumeExportPolicyRuleToTerraform(struct?: NetappVolumeGroupSapHanaVolumeExportPolicyRule | cdktf.IResolvable): any;
export declare function netappVolumeGroupSapHanaVolumeExportPolicyRuleToHclTerraform(struct?: NetappVolumeGroupSapHanaVolumeExportPolicyRule | cdktf.IResolvable): any;
export declare class NetappVolumeGroupSapHanaVolumeExportPolicyRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NetappVolumeGroupSapHanaVolumeExportPolicyRule | cdktf.IResolvable | undefined;
    set internalValue(value: NetappVolumeGroupSapHanaVolumeExportPolicyRule | cdktf.IResolvable | undefined);
    private _allowedClients?;
    get allowedClients(): string;
    set allowedClients(value: string);
    get allowedClientsInput(): string | undefined;
    private _nfsv3Enabled?;
    get nfsv3Enabled(): boolean | cdktf.IResolvable;
    set nfsv3Enabled(value: boolean | cdktf.IResolvable);
    get nfsv3EnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _nfsv41Enabled?;
    get nfsv41Enabled(): boolean | cdktf.IResolvable;
    set nfsv41Enabled(value: boolean | cdktf.IResolvable);
    get nfsv41EnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _rootAccessEnabled?;
    get rootAccessEnabled(): boolean | cdktf.IResolvable;
    set rootAccessEnabled(value: boolean | cdktf.IResolvable);
    resetRootAccessEnabled(): void;
    get rootAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ruleIndex?;
    get ruleIndex(): number;
    set ruleIndex(value: number);
    get ruleIndexInput(): number | undefined;
    private _unixReadOnly?;
    get unixReadOnly(): boolean | cdktf.IResolvable;
    set unixReadOnly(value: boolean | cdktf.IResolvable);
    resetUnixReadOnly(): void;
    get unixReadOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _unixReadWrite?;
    get unixReadWrite(): boolean | cdktf.IResolvable;
    set unixReadWrite(value: boolean | cdktf.IResolvable);
    resetUnixReadWrite(): void;
    get unixReadWriteInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class NetappVolumeGroupSapHanaVolumeExportPolicyRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: NetappVolumeGroupSapHanaVolumeExportPolicyRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NetappVolumeGroupSapHanaVolumeExportPolicyRuleOutputReference;
}
export interface NetappVolumeGroupSapHanaVolume {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#capacity_pool_id NetappVolumeGroupSapHana#capacity_pool_id}
    */
    readonly capacityPoolId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#name NetappVolumeGroupSapHana#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#protocols NetappVolumeGroupSapHana#protocols}
    */
    readonly protocols: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#proximity_placement_group_id NetappVolumeGroupSapHana#proximity_placement_group_id}
    */
    readonly proximityPlacementGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#security_style NetappVolumeGroupSapHana#security_style}
    */
    readonly securityStyle: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#service_level NetappVolumeGroupSapHana#service_level}
    */
    readonly serviceLevel: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#snapshot_directory_visible NetappVolumeGroupSapHana#snapshot_directory_visible}
    */
    readonly snapshotDirectoryVisible: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#storage_quota_in_gb NetappVolumeGroupSapHana#storage_quota_in_gb}
    */
    readonly storageQuotaInGb: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#subnet_id NetappVolumeGroupSapHana#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#tags NetappVolumeGroupSapHana#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#throughput_in_mibps NetappVolumeGroupSapHana#throughput_in_mibps}
    */
    readonly throughputInMibps: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#volume_path NetappVolumeGroupSapHana#volume_path}
    */
    readonly volumePath: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#volume_spec_name NetappVolumeGroupSapHana#volume_spec_name}
    */
    readonly volumeSpecName: string;
    /**
    * data_protection_replication block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#data_protection_replication NetappVolumeGroupSapHana#data_protection_replication}
    */
    readonly dataProtectionReplication?: NetappVolumeGroupSapHanaVolumeDataProtectionReplication;
    /**
    * data_protection_snapshot_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#data_protection_snapshot_policy NetappVolumeGroupSapHana#data_protection_snapshot_policy}
    */
    readonly dataProtectionSnapshotPolicy?: NetappVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicy;
    /**
    * export_policy_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#export_policy_rule NetappVolumeGroupSapHana#export_policy_rule}
    */
    readonly exportPolicyRule: NetappVolumeGroupSapHanaVolumeExportPolicyRule[] | cdktf.IResolvable;
}
export declare function netappVolumeGroupSapHanaVolumeToTerraform(struct?: NetappVolumeGroupSapHanaVolume | cdktf.IResolvable): any;
export declare function netappVolumeGroupSapHanaVolumeToHclTerraform(struct?: NetappVolumeGroupSapHanaVolume | cdktf.IResolvable): any;
export declare class NetappVolumeGroupSapHanaVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NetappVolumeGroupSapHanaVolume | cdktf.IResolvable | undefined;
    set internalValue(value: NetappVolumeGroupSapHanaVolume | cdktf.IResolvable | undefined);
    private _capacityPoolId?;
    get capacityPoolId(): string;
    set capacityPoolId(value: string);
    get capacityPoolIdInput(): string | undefined;
    get id(): string;
    get mountIpAddresses(): string[];
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _protocols?;
    get protocols(): string[];
    set protocols(value: string[]);
    get protocolsInput(): string[] | undefined;
    private _proximityPlacementGroupId?;
    get proximityPlacementGroupId(): string;
    set proximityPlacementGroupId(value: string);
    resetProximityPlacementGroupId(): void;
    get proximityPlacementGroupIdInput(): string | undefined;
    private _securityStyle?;
    get securityStyle(): string;
    set securityStyle(value: string);
    get securityStyleInput(): string | undefined;
    private _serviceLevel?;
    get serviceLevel(): string;
    set serviceLevel(value: string);
    get serviceLevelInput(): string | undefined;
    private _snapshotDirectoryVisible?;
    get snapshotDirectoryVisible(): boolean | cdktf.IResolvable;
    set snapshotDirectoryVisible(value: boolean | cdktf.IResolvable);
    get snapshotDirectoryVisibleInput(): boolean | cdktf.IResolvable | undefined;
    private _storageQuotaInGb?;
    get storageQuotaInGb(): number;
    set storageQuotaInGb(value: number);
    get storageQuotaInGbInput(): number | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _throughputInMibps?;
    get throughputInMibps(): number;
    set throughputInMibps(value: number);
    get throughputInMibpsInput(): number | undefined;
    private _volumePath?;
    get volumePath(): string;
    set volumePath(value: string);
    get volumePathInput(): string | undefined;
    private _volumeSpecName?;
    get volumeSpecName(): string;
    set volumeSpecName(value: string);
    get volumeSpecNameInput(): string | undefined;
    private _dataProtectionReplication;
    get dataProtectionReplication(): NetappVolumeGroupSapHanaVolumeDataProtectionReplicationOutputReference;
    putDataProtectionReplication(value: NetappVolumeGroupSapHanaVolumeDataProtectionReplication): void;
    resetDataProtectionReplication(): void;
    get dataProtectionReplicationInput(): NetappVolumeGroupSapHanaVolumeDataProtectionReplication | undefined;
    private _dataProtectionSnapshotPolicy;
    get dataProtectionSnapshotPolicy(): NetappVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyOutputReference;
    putDataProtectionSnapshotPolicy(value: NetappVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicy): void;
    resetDataProtectionSnapshotPolicy(): void;
    get dataProtectionSnapshotPolicyInput(): NetappVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicy | undefined;
    private _exportPolicyRule;
    get exportPolicyRule(): NetappVolumeGroupSapHanaVolumeExportPolicyRuleList;
    putExportPolicyRule(value: NetappVolumeGroupSapHanaVolumeExportPolicyRule[] | cdktf.IResolvable): void;
    get exportPolicyRuleInput(): cdktf.IResolvable | NetappVolumeGroupSapHanaVolumeExportPolicyRule[] | undefined;
}
export declare class NetappVolumeGroupSapHanaVolumeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: NetappVolumeGroupSapHanaVolume[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NetappVolumeGroupSapHanaVolumeOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana azurerm_netapp_volume_group_sap_hana}
*/
export declare class NetappVolumeGroupSapHana extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_netapp_volume_group_sap_hana";
    /**
    * Generates CDKTF code for importing a NetappVolumeGroupSapHana resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NetappVolumeGroupSapHana to import
    * @param importFromId The id of the existing NetappVolumeGroupSapHana that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NetappVolumeGroupSapHana to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/netapp_volume_group_sap_hana azurerm_netapp_volume_group_sap_hana} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetappVolumeGroupSapHanaConfig
    */
    constructor(scope: Construct, id: string, config: NetappVolumeGroupSapHanaConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _applicationIdentifier?;
    get applicationIdentifier(): string;
    set applicationIdentifier(value: string);
    get applicationIdentifierInput(): string | undefined;
    private _groupDescription?;
    get groupDescription(): string;
    set groupDescription(value: string);
    get groupDescriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): NetappVolumeGroupSapHanaTimeoutsOutputReference;
    putTimeouts(value: NetappVolumeGroupSapHanaTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NetappVolumeGroupSapHanaTimeouts | undefined;
    private _volume;
    get volume(): NetappVolumeGroupSapHanaVolumeList;
    putVolume(value: NetappVolumeGroupSapHanaVolume[] | cdktf.IResolvable): void;
    get volumeInput(): cdktf.IResolvable | NetappVolumeGroupSapHanaVolume[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
