/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkManagerStaticMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/network_manager_static_member#id NetworkManagerStaticMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/network_manager_static_member#name NetworkManagerStaticMember#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/network_manager_static_member#network_group_id NetworkManagerStaticMember#network_group_id}
    */
    readonly networkGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/network_manager_static_member#target_virtual_network_id NetworkManagerStaticMember#target_virtual_network_id}
    */
    readonly targetVirtualNetworkId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/network_manager_static_member#timeouts NetworkManagerStaticMember#timeouts}
    */
    readonly timeouts?: NetworkManagerStaticMemberTimeouts;
}
export interface NetworkManagerStaticMemberTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/network_manager_static_member#create NetworkManagerStaticMember#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/network_manager_static_member#delete NetworkManagerStaticMember#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/network_manager_static_member#read NetworkManagerStaticMember#read}
    */
    readonly read?: string;
}
export declare function networkManagerStaticMemberTimeoutsToTerraform(struct?: NetworkManagerStaticMemberTimeouts | cdktf.IResolvable): any;
export declare function networkManagerStaticMemberTimeoutsToHclTerraform(struct?: NetworkManagerStaticMemberTimeouts | cdktf.IResolvable): any;
export declare class NetworkManagerStaticMemberTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkManagerStaticMemberTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkManagerStaticMemberTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/network_manager_static_member azurerm_network_manager_static_member}
*/
export declare class NetworkManagerStaticMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_network_manager_static_member";
    /**
    * Generates CDKTF code for importing a NetworkManagerStaticMember resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NetworkManagerStaticMember to import
    * @param importFromId The id of the existing NetworkManagerStaticMember that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/network_manager_static_member#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NetworkManagerStaticMember to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/network_manager_static_member azurerm_network_manager_static_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkManagerStaticMemberConfig
    */
    constructor(scope: Construct, id: string, config: NetworkManagerStaticMemberConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkGroupId?;
    get networkGroupId(): string;
    set networkGroupId(value: string);
    get networkGroupIdInput(): string | undefined;
    get region(): string;
    private _targetVirtualNetworkId?;
    get targetVirtualNetworkId(): string;
    set targetVirtualNetworkId(value: string);
    get targetVirtualNetworkIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): NetworkManagerStaticMemberTimeoutsOutputReference;
    putTimeouts(value: NetworkManagerStaticMemberTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NetworkManagerStaticMemberTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
