/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NotificationHubConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub#id NotificationHub#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub#location NotificationHub#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub#name NotificationHub#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub#namespace_name NotificationHub#namespace_name}
    */
    readonly namespaceName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub#resource_group_name NotificationHub#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub#tags NotificationHub#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * apns_credential block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub#apns_credential NotificationHub#apns_credential}
    */
    readonly apnsCredential?: NotificationHubApnsCredential;
    /**
    * browser_credential block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub#browser_credential NotificationHub#browser_credential}
    */
    readonly browserCredential?: NotificationHubBrowserCredential;
    /**
    * gcm_credential block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub#gcm_credential NotificationHub#gcm_credential}
    */
    readonly gcmCredential?: NotificationHubGcmCredential;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub#timeouts NotificationHub#timeouts}
    */
    readonly timeouts?: NotificationHubTimeouts;
}
export interface NotificationHubApnsCredential {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub#application_mode NotificationHub#application_mode}
    */
    readonly applicationMode: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub#bundle_id NotificationHub#bundle_id}
    */
    readonly bundleId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub#key_id NotificationHub#key_id}
    */
    readonly keyId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub#team_id NotificationHub#team_id}
    */
    readonly teamId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub#token NotificationHub#token}
    */
    readonly token: string;
}
export declare function notificationHubApnsCredentialToTerraform(struct?: NotificationHubApnsCredentialOutputReference | NotificationHubApnsCredential): any;
export declare function notificationHubApnsCredentialToHclTerraform(struct?: NotificationHubApnsCredentialOutputReference | NotificationHubApnsCredential): any;
export declare class NotificationHubApnsCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NotificationHubApnsCredential | undefined;
    set internalValue(value: NotificationHubApnsCredential | undefined);
    private _applicationMode?;
    get applicationMode(): string;
    set applicationMode(value: string);
    get applicationModeInput(): string | undefined;
    private _bundleId?;
    get bundleId(): string;
    set bundleId(value: string);
    get bundleIdInput(): string | undefined;
    private _keyId?;
    get keyId(): string;
    set keyId(value: string);
    get keyIdInput(): string | undefined;
    private _teamId?;
    get teamId(): string;
    set teamId(value: string);
    get teamIdInput(): string | undefined;
    private _token?;
    get token(): string;
    set token(value: string);
    get tokenInput(): string | undefined;
}
export interface NotificationHubBrowserCredential {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub#subject NotificationHub#subject}
    */
    readonly subject: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub#vapid_private_key NotificationHub#vapid_private_key}
    */
    readonly vapidPrivateKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub#vapid_public_key NotificationHub#vapid_public_key}
    */
    readonly vapidPublicKey: string;
}
export declare function notificationHubBrowserCredentialToTerraform(struct?: NotificationHubBrowserCredentialOutputReference | NotificationHubBrowserCredential): any;
export declare function notificationHubBrowserCredentialToHclTerraform(struct?: NotificationHubBrowserCredentialOutputReference | NotificationHubBrowserCredential): any;
export declare class NotificationHubBrowserCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NotificationHubBrowserCredential | undefined;
    set internalValue(value: NotificationHubBrowserCredential | undefined);
    private _subject?;
    get subject(): string;
    set subject(value: string);
    get subjectInput(): string | undefined;
    private _vapidPrivateKey?;
    get vapidPrivateKey(): string;
    set vapidPrivateKey(value: string);
    get vapidPrivateKeyInput(): string | undefined;
    private _vapidPublicKey?;
    get vapidPublicKey(): string;
    set vapidPublicKey(value: string);
    get vapidPublicKeyInput(): string | undefined;
}
export interface NotificationHubGcmCredential {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub#api_key NotificationHub#api_key}
    */
    readonly apiKey: string;
}
export declare function notificationHubGcmCredentialToTerraform(struct?: NotificationHubGcmCredentialOutputReference | NotificationHubGcmCredential): any;
export declare function notificationHubGcmCredentialToHclTerraform(struct?: NotificationHubGcmCredentialOutputReference | NotificationHubGcmCredential): any;
export declare class NotificationHubGcmCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NotificationHubGcmCredential | undefined;
    set internalValue(value: NotificationHubGcmCredential | undefined);
    private _apiKey?;
    get apiKey(): string;
    set apiKey(value: string);
    get apiKeyInput(): string | undefined;
}
export interface NotificationHubTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub#create NotificationHub#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub#delete NotificationHub#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub#read NotificationHub#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub#update NotificationHub#update}
    */
    readonly update?: string;
}
export declare function notificationHubTimeoutsToTerraform(struct?: NotificationHubTimeouts | cdktf.IResolvable): any;
export declare function notificationHubTimeoutsToHclTerraform(struct?: NotificationHubTimeouts | cdktf.IResolvable): any;
export declare class NotificationHubTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NotificationHubTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NotificationHubTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub azurerm_notification_hub}
*/
export declare class NotificationHub extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_notification_hub";
    /**
    * Generates CDKTF code for importing a NotificationHub resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NotificationHub to import
    * @param importFromId The id of the existing NotificationHub that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NotificationHub to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/notification_hub azurerm_notification_hub} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NotificationHubConfig
    */
    constructor(scope: Construct, id: string, config: NotificationHubConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespaceName?;
    get namespaceName(): string;
    set namespaceName(value: string);
    get namespaceNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _apnsCredential;
    get apnsCredential(): NotificationHubApnsCredentialOutputReference;
    putApnsCredential(value: NotificationHubApnsCredential): void;
    resetApnsCredential(): void;
    get apnsCredentialInput(): NotificationHubApnsCredential | undefined;
    private _browserCredential;
    get browserCredential(): NotificationHubBrowserCredentialOutputReference;
    putBrowserCredential(value: NotificationHubBrowserCredential): void;
    resetBrowserCredential(): void;
    get browserCredentialInput(): NotificationHubBrowserCredential | undefined;
    private _gcmCredential;
    get gcmCredential(): NotificationHubGcmCredentialOutputReference;
    putGcmCredential(value: NotificationHubGcmCredential): void;
    resetGcmCredential(): void;
    get gcmCredentialInput(): NotificationHubGcmCredential | undefined;
    private _timeouts;
    get timeouts(): NotificationHubTimeoutsOutputReference;
    putTimeouts(value: NotificationHubTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NotificationHubTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
