/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PaloAltoNextGenerationFirewallVirtualHubPanoramaConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#id PaloAltoNextGenerationFirewallVirtualHubPanorama#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#location PaloAltoNextGenerationFirewallVirtualHubPanorama#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#marketplace_offer_id PaloAltoNextGenerationFirewallVirtualHubPanorama#marketplace_offer_id}
    */
    readonly marketplaceOfferId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#name PaloAltoNextGenerationFirewallVirtualHubPanorama#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#panorama_base64_config PaloAltoNextGenerationFirewallVirtualHubPanorama#panorama_base64_config}
    */
    readonly panoramaBase64Config: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#plan_id PaloAltoNextGenerationFirewallVirtualHubPanorama#plan_id}
    */
    readonly planId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#resource_group_name PaloAltoNextGenerationFirewallVirtualHubPanorama#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#tags PaloAltoNextGenerationFirewallVirtualHubPanorama#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * destination_nat block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#destination_nat PaloAltoNextGenerationFirewallVirtualHubPanorama#destination_nat}
    */
    readonly destinationNat?: PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNat[] | cdktf.IResolvable;
    /**
    * dns_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#dns_settings PaloAltoNextGenerationFirewallVirtualHubPanorama#dns_settings}
    */
    readonly dnsSettings?: PaloAltoNextGenerationFirewallVirtualHubPanoramaDnsSettings;
    /**
    * network_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#network_profile PaloAltoNextGenerationFirewallVirtualHubPanorama#network_profile}
    */
    readonly networkProfile: PaloAltoNextGenerationFirewallVirtualHubPanoramaNetworkProfile;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#timeouts PaloAltoNextGenerationFirewallVirtualHubPanorama#timeouts}
    */
    readonly timeouts?: PaloAltoNextGenerationFirewallVirtualHubPanoramaTimeouts;
}
export interface PaloAltoNextGenerationFirewallVirtualHubPanoramaPanorama {
}
export declare function paloAltoNextGenerationFirewallVirtualHubPanoramaPanoramaToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubPanoramaPanorama): any;
export declare function paloAltoNextGenerationFirewallVirtualHubPanoramaPanoramaToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubPanoramaPanorama): any;
export declare class PaloAltoNextGenerationFirewallVirtualHubPanoramaPanoramaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualHubPanoramaPanorama | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualHubPanoramaPanorama | undefined);
    get deviceGroupName(): string;
    get hostName(): string;
    get name(): string;
    get panoramaServer1(): string;
    get panoramaServer2(): string;
    get templateName(): string;
    get virtualMachineSshKey(): string;
}
export declare class PaloAltoNextGenerationFirewallVirtualHubPanoramaPanoramaList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PaloAltoNextGenerationFirewallVirtualHubPanoramaPanoramaOutputReference;
}
export interface PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatBackendConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#port PaloAltoNextGenerationFirewallVirtualHubPanorama#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#public_ip_address PaloAltoNextGenerationFirewallVirtualHubPanorama#public_ip_address}
    */
    readonly publicIpAddress: string;
}
export declare function paloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatBackendConfigToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatBackendConfigOutputReference | PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatBackendConfig): any;
export declare function paloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatBackendConfigToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatBackendConfigOutputReference | PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatBackendConfig): any;
export declare class PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatBackendConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatBackendConfig | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatBackendConfig | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _publicIpAddress?;
    get publicIpAddress(): string;
    set publicIpAddress(value: string);
    get publicIpAddressInput(): string | undefined;
}
export interface PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatFrontendConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#port PaloAltoNextGenerationFirewallVirtualHubPanorama#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#public_ip_address_id PaloAltoNextGenerationFirewallVirtualHubPanorama#public_ip_address_id}
    */
    readonly publicIpAddressId: string;
}
export declare function paloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatFrontendConfigToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatFrontendConfigOutputReference | PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatFrontendConfig): any;
export declare function paloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatFrontendConfigToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatFrontendConfigOutputReference | PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatFrontendConfig): any;
export declare class PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatFrontendConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatFrontendConfig | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatFrontendConfig | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _publicIpAddressId?;
    get publicIpAddressId(): string;
    set publicIpAddressId(value: string);
    get publicIpAddressIdInput(): string | undefined;
}
export interface PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNat {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#name PaloAltoNextGenerationFirewallVirtualHubPanorama#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#protocol PaloAltoNextGenerationFirewallVirtualHubPanorama#protocol}
    */
    readonly protocol: string;
    /**
    * backend_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#backend_config PaloAltoNextGenerationFirewallVirtualHubPanorama#backend_config}
    */
    readonly backendConfig?: PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatBackendConfig;
    /**
    * frontend_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#frontend_config PaloAltoNextGenerationFirewallVirtualHubPanorama#frontend_config}
    */
    readonly frontendConfig?: PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatFrontendConfig;
}
export declare function paloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNat | cdktf.IResolvable): any;
export declare function paloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNat | cdktf.IResolvable): any;
export declare class PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNat | cdktf.IResolvable | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNat | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _backendConfig;
    get backendConfig(): PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatBackendConfigOutputReference;
    putBackendConfig(value: PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatBackendConfig): void;
    resetBackendConfig(): void;
    get backendConfigInput(): PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatBackendConfig | undefined;
    private _frontendConfig;
    get frontendConfig(): PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatFrontendConfigOutputReference;
    putFrontendConfig(value: PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatFrontendConfig): void;
    resetFrontendConfig(): void;
    get frontendConfigInput(): PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatFrontendConfig | undefined;
}
export declare class PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNat[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatOutputReference;
}
export interface PaloAltoNextGenerationFirewallVirtualHubPanoramaDnsSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#dns_servers PaloAltoNextGenerationFirewallVirtualHubPanorama#dns_servers}
    */
    readonly dnsServers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#use_azure_dns PaloAltoNextGenerationFirewallVirtualHubPanorama#use_azure_dns}
    */
    readonly useAzureDns?: boolean | cdktf.IResolvable;
}
export declare function paloAltoNextGenerationFirewallVirtualHubPanoramaDnsSettingsToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubPanoramaDnsSettingsOutputReference | PaloAltoNextGenerationFirewallVirtualHubPanoramaDnsSettings): any;
export declare function paloAltoNextGenerationFirewallVirtualHubPanoramaDnsSettingsToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubPanoramaDnsSettingsOutputReference | PaloAltoNextGenerationFirewallVirtualHubPanoramaDnsSettings): any;
export declare class PaloAltoNextGenerationFirewallVirtualHubPanoramaDnsSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualHubPanoramaDnsSettings | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualHubPanoramaDnsSettings | undefined);
    get azureDnsServers(): string[];
    private _dnsServers?;
    get dnsServers(): string[];
    set dnsServers(value: string[]);
    resetDnsServers(): void;
    get dnsServersInput(): string[] | undefined;
    private _useAzureDns?;
    get useAzureDns(): boolean | cdktf.IResolvable;
    set useAzureDns(value: boolean | cdktf.IResolvable);
    resetUseAzureDns(): void;
    get useAzureDnsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PaloAltoNextGenerationFirewallVirtualHubPanoramaNetworkProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#egress_nat_ip_address_ids PaloAltoNextGenerationFirewallVirtualHubPanorama#egress_nat_ip_address_ids}
    */
    readonly egressNatIpAddressIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#network_virtual_appliance_id PaloAltoNextGenerationFirewallVirtualHubPanorama#network_virtual_appliance_id}
    */
    readonly networkVirtualApplianceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#public_ip_address_ids PaloAltoNextGenerationFirewallVirtualHubPanorama#public_ip_address_ids}
    */
    readonly publicIpAddressIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#trusted_address_ranges PaloAltoNextGenerationFirewallVirtualHubPanorama#trusted_address_ranges}
    */
    readonly trustedAddressRanges?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#virtual_hub_id PaloAltoNextGenerationFirewallVirtualHubPanorama#virtual_hub_id}
    */
    readonly virtualHubId: string;
}
export declare function paloAltoNextGenerationFirewallVirtualHubPanoramaNetworkProfileToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubPanoramaNetworkProfileOutputReference | PaloAltoNextGenerationFirewallVirtualHubPanoramaNetworkProfile): any;
export declare function paloAltoNextGenerationFirewallVirtualHubPanoramaNetworkProfileToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubPanoramaNetworkProfileOutputReference | PaloAltoNextGenerationFirewallVirtualHubPanoramaNetworkProfile): any;
export declare class PaloAltoNextGenerationFirewallVirtualHubPanoramaNetworkProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualHubPanoramaNetworkProfile | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualHubPanoramaNetworkProfile | undefined);
    private _egressNatIpAddressIds?;
    get egressNatIpAddressIds(): string[];
    set egressNatIpAddressIds(value: string[]);
    resetEgressNatIpAddressIds(): void;
    get egressNatIpAddressIdsInput(): string[] | undefined;
    get egressNatIpAddresses(): string[];
    get ipOfTrustForUserDefinedRoutes(): string;
    private _networkVirtualApplianceId?;
    get networkVirtualApplianceId(): string;
    set networkVirtualApplianceId(value: string);
    get networkVirtualApplianceIdInput(): string | undefined;
    private _publicIpAddressIds?;
    get publicIpAddressIds(): string[];
    set publicIpAddressIds(value: string[]);
    get publicIpAddressIdsInput(): string[] | undefined;
    get publicIpAddresses(): string[];
    private _trustedAddressRanges?;
    get trustedAddressRanges(): string[];
    set trustedAddressRanges(value: string[]);
    resetTrustedAddressRanges(): void;
    get trustedAddressRangesInput(): string[] | undefined;
    get trustedSubnetId(): string;
    get untrustedSubnetId(): string;
    private _virtualHubId?;
    get virtualHubId(): string;
    set virtualHubId(value: string);
    get virtualHubIdInput(): string | undefined;
}
export interface PaloAltoNextGenerationFirewallVirtualHubPanoramaTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#create PaloAltoNextGenerationFirewallVirtualHubPanorama#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#delete PaloAltoNextGenerationFirewallVirtualHubPanorama#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#read PaloAltoNextGenerationFirewallVirtualHubPanorama#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#update PaloAltoNextGenerationFirewallVirtualHubPanorama#update}
    */
    readonly update?: string;
}
export declare function paloAltoNextGenerationFirewallVirtualHubPanoramaTimeoutsToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubPanoramaTimeouts | cdktf.IResolvable): any;
export declare function paloAltoNextGenerationFirewallVirtualHubPanoramaTimeoutsToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualHubPanoramaTimeouts | cdktf.IResolvable): any;
export declare class PaloAltoNextGenerationFirewallVirtualHubPanoramaTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualHubPanoramaTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualHubPanoramaTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama azurerm_palo_alto_next_generation_firewall_virtual_hub_panorama}
*/
export declare class PaloAltoNextGenerationFirewallVirtualHubPanorama extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_palo_alto_next_generation_firewall_virtual_hub_panorama";
    /**
    * Generates CDKTF code for importing a PaloAltoNextGenerationFirewallVirtualHubPanorama resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the PaloAltoNextGenerationFirewallVirtualHubPanorama to import
    * @param importFromId The id of the existing PaloAltoNextGenerationFirewallVirtualHubPanorama that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the PaloAltoNextGenerationFirewallVirtualHubPanorama to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_hub_panorama azurerm_palo_alto_next_generation_firewall_virtual_hub_panorama} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PaloAltoNextGenerationFirewallVirtualHubPanoramaConfig
    */
    constructor(scope: Construct, id: string, config: PaloAltoNextGenerationFirewallVirtualHubPanoramaConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _marketplaceOfferId?;
    get marketplaceOfferId(): string;
    set marketplaceOfferId(value: string);
    resetMarketplaceOfferId(): void;
    get marketplaceOfferIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _panorama;
    get panorama(): PaloAltoNextGenerationFirewallVirtualHubPanoramaPanoramaList;
    private _panoramaBase64Config?;
    get panoramaBase64Config(): string;
    set panoramaBase64Config(value: string);
    get panoramaBase64ConfigInput(): string | undefined;
    private _planId?;
    get planId(): string;
    set planId(value: string);
    resetPlanId(): void;
    get planIdInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _destinationNat;
    get destinationNat(): PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNatList;
    putDestinationNat(value: PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNat[] | cdktf.IResolvable): void;
    resetDestinationNat(): void;
    get destinationNatInput(): cdktf.IResolvable | PaloAltoNextGenerationFirewallVirtualHubPanoramaDestinationNat[] | undefined;
    private _dnsSettings;
    get dnsSettings(): PaloAltoNextGenerationFirewallVirtualHubPanoramaDnsSettingsOutputReference;
    putDnsSettings(value: PaloAltoNextGenerationFirewallVirtualHubPanoramaDnsSettings): void;
    resetDnsSettings(): void;
    get dnsSettingsInput(): PaloAltoNextGenerationFirewallVirtualHubPanoramaDnsSettings | undefined;
    private _networkProfile;
    get networkProfile(): PaloAltoNextGenerationFirewallVirtualHubPanoramaNetworkProfileOutputReference;
    putNetworkProfile(value: PaloAltoNextGenerationFirewallVirtualHubPanoramaNetworkProfile): void;
    get networkProfileInput(): PaloAltoNextGenerationFirewallVirtualHubPanoramaNetworkProfile | undefined;
    private _timeouts;
    get timeouts(): PaloAltoNextGenerationFirewallVirtualHubPanoramaTimeoutsOutputReference;
    putTimeouts(value: PaloAltoNextGenerationFirewallVirtualHubPanoramaTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PaloAltoNextGenerationFirewallVirtualHubPanoramaTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
