/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#id PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#marketplace_offer_id PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#marketplace_offer_id}
    */
    readonly marketplaceOfferId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#name PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#plan_id PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#plan_id}
    */
    readonly planId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#resource_group_name PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#rulestack_id PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#rulestack_id}
    */
    readonly rulestackId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#tags PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * destination_nat block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#destination_nat PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#destination_nat}
    */
    readonly destinationNat?: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNat[] | cdktf.IResolvable;
    /**
    * dns_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#dns_settings PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#dns_settings}
    */
    readonly dnsSettings?: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDnsSettings;
    /**
    * network_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#network_profile PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#network_profile}
    */
    readonly networkProfile: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfile;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#timeouts PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#timeouts}
    */
    readonly timeouts?: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackTimeouts;
}
export interface PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatBackendConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#port PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#public_ip_address PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#public_ip_address}
    */
    readonly publicIpAddress: string;
}
export declare function paloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatBackendConfigToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatBackendConfigOutputReference | PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatBackendConfig): any;
export declare function paloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatBackendConfigToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatBackendConfigOutputReference | PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatBackendConfig): any;
export declare class PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatBackendConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatBackendConfig | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatBackendConfig | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _publicIpAddress?;
    get publicIpAddress(): string;
    set publicIpAddress(value: string);
    get publicIpAddressInput(): string | undefined;
}
export interface PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatFrontendConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#port PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#public_ip_address_id PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#public_ip_address_id}
    */
    readonly publicIpAddressId: string;
}
export declare function paloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatFrontendConfigToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatFrontendConfigOutputReference | PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatFrontendConfig): any;
export declare function paloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatFrontendConfigToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatFrontendConfigOutputReference | PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatFrontendConfig): any;
export declare class PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatFrontendConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatFrontendConfig | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatFrontendConfig | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _publicIpAddressId?;
    get publicIpAddressId(): string;
    set publicIpAddressId(value: string);
    get publicIpAddressIdInput(): string | undefined;
}
export interface PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNat {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#name PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#protocol PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#protocol}
    */
    readonly protocol: string;
    /**
    * backend_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#backend_config PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#backend_config}
    */
    readonly backendConfig?: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatBackendConfig;
    /**
    * frontend_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#frontend_config PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#frontend_config}
    */
    readonly frontendConfig?: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatFrontendConfig;
}
export declare function paloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNat | cdktf.IResolvable): any;
export declare function paloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNat | cdktf.IResolvable): any;
export declare class PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNat | cdktf.IResolvable | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNat | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _backendConfig;
    get backendConfig(): PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatBackendConfigOutputReference;
    putBackendConfig(value: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatBackendConfig): void;
    resetBackendConfig(): void;
    get backendConfigInput(): PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatBackendConfig | undefined;
    private _frontendConfig;
    get frontendConfig(): PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatFrontendConfigOutputReference;
    putFrontendConfig(value: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatFrontendConfig): void;
    resetFrontendConfig(): void;
    get frontendConfigInput(): PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatFrontendConfig | undefined;
}
export declare class PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNat[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatOutputReference;
}
export interface PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDnsSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#dns_servers PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#dns_servers}
    */
    readonly dnsServers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#use_azure_dns PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#use_azure_dns}
    */
    readonly useAzureDns?: boolean | cdktf.IResolvable;
}
export declare function paloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDnsSettingsToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDnsSettingsOutputReference | PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDnsSettings): any;
export declare function paloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDnsSettingsToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDnsSettingsOutputReference | PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDnsSettings): any;
export declare class PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDnsSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDnsSettings | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDnsSettings | undefined);
    get azureDnsServers(): string[];
    private _dnsServers?;
    get dnsServers(): string[];
    set dnsServers(value: string[]);
    resetDnsServers(): void;
    get dnsServersInput(): string[] | undefined;
    private _useAzureDns?;
    get useAzureDns(): boolean | cdktf.IResolvable;
    set useAzureDns(value: boolean | cdktf.IResolvable);
    resetUseAzureDns(): void;
    get useAzureDnsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileVnetConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#trusted_subnet_id PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#trusted_subnet_id}
    */
    readonly trustedSubnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#untrusted_subnet_id PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#untrusted_subnet_id}
    */
    readonly untrustedSubnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#virtual_network_id PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#virtual_network_id}
    */
    readonly virtualNetworkId: string;
}
export declare function paloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileVnetConfigurationToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileVnetConfigurationOutputReference | PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileVnetConfiguration): any;
export declare function paloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileVnetConfigurationToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileVnetConfigurationOutputReference | PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileVnetConfiguration): any;
export declare class PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileVnetConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileVnetConfiguration | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileVnetConfiguration | undefined);
    get ipOfTrustForUserDefinedRoutes(): string;
    private _trustedSubnetId?;
    get trustedSubnetId(): string;
    set trustedSubnetId(value: string);
    resetTrustedSubnetId(): void;
    get trustedSubnetIdInput(): string | undefined;
    private _untrustedSubnetId?;
    get untrustedSubnetId(): string;
    set untrustedSubnetId(value: string);
    resetUntrustedSubnetId(): void;
    get untrustedSubnetIdInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    get virtualNetworkIdInput(): string | undefined;
}
export interface PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#egress_nat_ip_address_ids PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#egress_nat_ip_address_ids}
    */
    readonly egressNatIpAddressIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#public_ip_address_ids PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#public_ip_address_ids}
    */
    readonly publicIpAddressIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#trusted_address_ranges PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#trusted_address_ranges}
    */
    readonly trustedAddressRanges?: string[];
    /**
    * vnet_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#vnet_configuration PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#vnet_configuration}
    */
    readonly vnetConfiguration: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileVnetConfiguration;
}
export declare function paloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileOutputReference | PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfile): any;
export declare function paloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileOutputReference | PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfile): any;
export declare class PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfile | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfile | undefined);
    private _egressNatIpAddressIds?;
    get egressNatIpAddressIds(): string[];
    set egressNatIpAddressIds(value: string[]);
    resetEgressNatIpAddressIds(): void;
    get egressNatIpAddressIdsInput(): string[] | undefined;
    get egressNatIpAddresses(): string[];
    private _publicIpAddressIds?;
    get publicIpAddressIds(): string[];
    set publicIpAddressIds(value: string[]);
    get publicIpAddressIdsInput(): string[] | undefined;
    get publicIpAddresses(): string[];
    private _trustedAddressRanges?;
    get trustedAddressRanges(): string[];
    set trustedAddressRanges(value: string[]);
    resetTrustedAddressRanges(): void;
    get trustedAddressRangesInput(): string[] | undefined;
    private _vnetConfiguration;
    get vnetConfiguration(): PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileVnetConfigurationOutputReference;
    putVnetConfiguration(value: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileVnetConfiguration): void;
    get vnetConfigurationInput(): PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileVnetConfiguration | undefined;
}
export interface PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#create PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#delete PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#read PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#update PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack#update}
    */
    readonly update?: string;
}
export declare function paloAltoNextGenerationFirewallVirtualNetworkLocalRulestackTimeoutsToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackTimeouts | cdktf.IResolvable): any;
export declare function paloAltoNextGenerationFirewallVirtualNetworkLocalRulestackTimeoutsToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackTimeouts | cdktf.IResolvable): any;
export declare class PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack azurerm_palo_alto_next_generation_firewall_virtual_network_local_rulestack}
*/
export declare class PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_palo_alto_next_generation_firewall_virtual_network_local_rulestack";
    /**
    * Generates CDKTF code for importing a PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack to import
    * @param importFromId The id of the existing PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestack to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_local_rulestack azurerm_palo_alto_next_generation_firewall_virtual_network_local_rulestack} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackConfig
    */
    constructor(scope: Construct, id: string, config: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _marketplaceOfferId?;
    get marketplaceOfferId(): string;
    set marketplaceOfferId(value: string);
    resetMarketplaceOfferId(): void;
    get marketplaceOfferIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _planId?;
    get planId(): string;
    set planId(value: string);
    resetPlanId(): void;
    get planIdInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _rulestackId?;
    get rulestackId(): string;
    set rulestackId(value: string);
    get rulestackIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _destinationNat;
    get destinationNat(): PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatList;
    putDestinationNat(value: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNat[] | cdktf.IResolvable): void;
    resetDestinationNat(): void;
    get destinationNatInput(): cdktf.IResolvable | PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDestinationNat[] | undefined;
    private _dnsSettings;
    get dnsSettings(): PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDnsSettingsOutputReference;
    putDnsSettings(value: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDnsSettings): void;
    resetDnsSettings(): void;
    get dnsSettingsInput(): PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackDnsSettings | undefined;
    private _networkProfile;
    get networkProfile(): PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileOutputReference;
    putNetworkProfile(value: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfile): void;
    get networkProfileInput(): PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfile | undefined;
    private _timeouts;
    get timeouts(): PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackTimeoutsOutputReference;
    putTimeouts(value: PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PaloAltoNextGenerationFirewallVirtualNetworkLocalRulestackTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
