/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PostgresqlDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/postgresql_database#charset PostgresqlDatabase#charset}
    */
    readonly charset: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/postgresql_database#collation PostgresqlDatabase#collation}
    */
    readonly collation: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/postgresql_database#id PostgresqlDatabase#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/postgresql_database#name PostgresqlDatabase#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/postgresql_database#resource_group_name PostgresqlDatabase#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/postgresql_database#server_name PostgresqlDatabase#server_name}
    */
    readonly serverName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/postgresql_database#timeouts PostgresqlDatabase#timeouts}
    */
    readonly timeouts?: PostgresqlDatabaseTimeouts;
}
export interface PostgresqlDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/postgresql_database#create PostgresqlDatabase#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/postgresql_database#delete PostgresqlDatabase#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/postgresql_database#read PostgresqlDatabase#read}
    */
    readonly read?: string;
}
export declare function postgresqlDatabaseTimeoutsToTerraform(struct?: PostgresqlDatabaseTimeouts | cdktf.IResolvable): any;
export declare function postgresqlDatabaseTimeoutsToHclTerraform(struct?: PostgresqlDatabaseTimeouts | cdktf.IResolvable): any;
export declare class PostgresqlDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PostgresqlDatabaseTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PostgresqlDatabaseTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/postgresql_database azurerm_postgresql_database}
*/
export declare class PostgresqlDatabase extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_postgresql_database";
    /**
    * Generates CDKTF code for importing a PostgresqlDatabase resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the PostgresqlDatabase to import
    * @param importFromId The id of the existing PostgresqlDatabase that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/postgresql_database#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the PostgresqlDatabase to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/postgresql_database azurerm_postgresql_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PostgresqlDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: PostgresqlDatabaseConfig);
    private _charset?;
    get charset(): string;
    set charset(value: string);
    get charsetInput(): string | undefined;
    private _collation?;
    get collation(): string;
    set collation(value: string);
    get collationInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _serverName?;
    get serverName(): string;
    set serverName(value: string);
    get serverNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): PostgresqlDatabaseTimeoutsOutputReference;
    putTimeouts(value: PostgresqlDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PostgresqlDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
