/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ResourceManagementPrivateLinkAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/resource_management_private_link_association#id ResourceManagementPrivateLinkAssociation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/resource_management_private_link_association#management_group_id ResourceManagementPrivateLinkAssociation#management_group_id}
    */
    readonly managementGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/resource_management_private_link_association#name ResourceManagementPrivateLinkAssociation#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/resource_management_private_link_association#public_network_access_enabled ResourceManagementPrivateLinkAssociation#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/resource_management_private_link_association#resource_management_private_link_id ResourceManagementPrivateLinkAssociation#resource_management_private_link_id}
    */
    readonly resourceManagementPrivateLinkId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/resource_management_private_link_association#timeouts ResourceManagementPrivateLinkAssociation#timeouts}
    */
    readonly timeouts?: ResourceManagementPrivateLinkAssociationTimeouts;
}
export interface ResourceManagementPrivateLinkAssociationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/resource_management_private_link_association#create ResourceManagementPrivateLinkAssociation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/resource_management_private_link_association#delete ResourceManagementPrivateLinkAssociation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/resource_management_private_link_association#read ResourceManagementPrivateLinkAssociation#read}
    */
    readonly read?: string;
}
export declare function resourceManagementPrivateLinkAssociationTimeoutsToTerraform(struct?: ResourceManagementPrivateLinkAssociationTimeouts | cdktf.IResolvable): any;
export declare function resourceManagementPrivateLinkAssociationTimeoutsToHclTerraform(struct?: ResourceManagementPrivateLinkAssociationTimeouts | cdktf.IResolvable): any;
export declare class ResourceManagementPrivateLinkAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourceManagementPrivateLinkAssociationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ResourceManagementPrivateLinkAssociationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/resource_management_private_link_association azurerm_resource_management_private_link_association}
*/
export declare class ResourceManagementPrivateLinkAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_resource_management_private_link_association";
    /**
    * Generates CDKTF code for importing a ResourceManagementPrivateLinkAssociation resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ResourceManagementPrivateLinkAssociation to import
    * @param importFromId The id of the existing ResourceManagementPrivateLinkAssociation that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/resource_management_private_link_association#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ResourceManagementPrivateLinkAssociation to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/resource_management_private_link_association azurerm_resource_management_private_link_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ResourceManagementPrivateLinkAssociationConfig
    */
    constructor(scope: Construct, id: string, config: ResourceManagementPrivateLinkAssociationConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _managementGroupId?;
    get managementGroupId(): string;
    set managementGroupId(value: string);
    get managementGroupIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceManagementPrivateLinkId?;
    get resourceManagementPrivateLinkId(): string;
    set resourceManagementPrivateLinkId(value: string);
    get resourceManagementPrivateLinkIdInput(): string | undefined;
    get tenantId(): string;
    private _timeouts;
    get timeouts(): ResourceManagementPrivateLinkAssociationTimeoutsOutputReference;
    putTimeouts(value: ResourceManagementPrivateLinkAssociationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ResourceManagementPrivateLinkAssociationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
