/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SentinelAlertRuleAnomalyBuiltInConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/sentinel_alert_rule_anomaly_built_in#display_name SentinelAlertRuleAnomalyBuiltIn#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/sentinel_alert_rule_anomaly_built_in#enabled SentinelAlertRuleAnomalyBuiltIn#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/sentinel_alert_rule_anomaly_built_in#id SentinelAlertRuleAnomalyBuiltIn#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/sentinel_alert_rule_anomaly_built_in#log_analytics_workspace_id SentinelAlertRuleAnomalyBuiltIn#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/sentinel_alert_rule_anomaly_built_in#mode SentinelAlertRuleAnomalyBuiltIn#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/sentinel_alert_rule_anomaly_built_in#name SentinelAlertRuleAnomalyBuiltIn#name}
    */
    readonly name?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/sentinel_alert_rule_anomaly_built_in#timeouts SentinelAlertRuleAnomalyBuiltIn#timeouts}
    */
    readonly timeouts?: SentinelAlertRuleAnomalyBuiltInTimeouts;
}
export interface SentinelAlertRuleAnomalyBuiltInMultiSelectObservation {
}
export declare function sentinelAlertRuleAnomalyBuiltInMultiSelectObservationToTerraform(struct?: SentinelAlertRuleAnomalyBuiltInMultiSelectObservation): any;
export declare function sentinelAlertRuleAnomalyBuiltInMultiSelectObservationToHclTerraform(struct?: SentinelAlertRuleAnomalyBuiltInMultiSelectObservation): any;
export declare class SentinelAlertRuleAnomalyBuiltInMultiSelectObservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelAlertRuleAnomalyBuiltInMultiSelectObservation | undefined;
    set internalValue(value: SentinelAlertRuleAnomalyBuiltInMultiSelectObservation | undefined);
    get description(): string;
    get name(): string;
    get supportedValues(): string[];
    get values(): string[];
}
export declare class SentinelAlertRuleAnomalyBuiltInMultiSelectObservationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelAlertRuleAnomalyBuiltInMultiSelectObservationOutputReference;
}
export interface SentinelAlertRuleAnomalyBuiltInPrioritizedExcludeObservation {
}
export declare function sentinelAlertRuleAnomalyBuiltInPrioritizedExcludeObservationToTerraform(struct?: SentinelAlertRuleAnomalyBuiltInPrioritizedExcludeObservation): any;
export declare function sentinelAlertRuleAnomalyBuiltInPrioritizedExcludeObservationToHclTerraform(struct?: SentinelAlertRuleAnomalyBuiltInPrioritizedExcludeObservation): any;
export declare class SentinelAlertRuleAnomalyBuiltInPrioritizedExcludeObservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelAlertRuleAnomalyBuiltInPrioritizedExcludeObservation | undefined;
    set internalValue(value: SentinelAlertRuleAnomalyBuiltInPrioritizedExcludeObservation | undefined);
    get description(): string;
    get exclude(): string;
    get name(): string;
    get prioritize(): string;
}
export declare class SentinelAlertRuleAnomalyBuiltInPrioritizedExcludeObservationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelAlertRuleAnomalyBuiltInPrioritizedExcludeObservationOutputReference;
}
export interface SentinelAlertRuleAnomalyBuiltInRequiredDataConnector {
}
export declare function sentinelAlertRuleAnomalyBuiltInRequiredDataConnectorToTerraform(struct?: SentinelAlertRuleAnomalyBuiltInRequiredDataConnector): any;
export declare function sentinelAlertRuleAnomalyBuiltInRequiredDataConnectorToHclTerraform(struct?: SentinelAlertRuleAnomalyBuiltInRequiredDataConnector): any;
export declare class SentinelAlertRuleAnomalyBuiltInRequiredDataConnectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelAlertRuleAnomalyBuiltInRequiredDataConnector | undefined;
    set internalValue(value: SentinelAlertRuleAnomalyBuiltInRequiredDataConnector | undefined);
    get connectorId(): string;
    get dataTypes(): string[];
}
export declare class SentinelAlertRuleAnomalyBuiltInRequiredDataConnectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelAlertRuleAnomalyBuiltInRequiredDataConnectorOutputReference;
}
export interface SentinelAlertRuleAnomalyBuiltInSingleSelectObservation {
}
export declare function sentinelAlertRuleAnomalyBuiltInSingleSelectObservationToTerraform(struct?: SentinelAlertRuleAnomalyBuiltInSingleSelectObservation): any;
export declare function sentinelAlertRuleAnomalyBuiltInSingleSelectObservationToHclTerraform(struct?: SentinelAlertRuleAnomalyBuiltInSingleSelectObservation): any;
export declare class SentinelAlertRuleAnomalyBuiltInSingleSelectObservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelAlertRuleAnomalyBuiltInSingleSelectObservation | undefined;
    set internalValue(value: SentinelAlertRuleAnomalyBuiltInSingleSelectObservation | undefined);
    get description(): string;
    get name(): string;
    get supportedValues(): string[];
    get value(): string;
}
export declare class SentinelAlertRuleAnomalyBuiltInSingleSelectObservationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelAlertRuleAnomalyBuiltInSingleSelectObservationOutputReference;
}
export interface SentinelAlertRuleAnomalyBuiltInThresholdObservation {
}
export declare function sentinelAlertRuleAnomalyBuiltInThresholdObservationToTerraform(struct?: SentinelAlertRuleAnomalyBuiltInThresholdObservation): any;
export declare function sentinelAlertRuleAnomalyBuiltInThresholdObservationToHclTerraform(struct?: SentinelAlertRuleAnomalyBuiltInThresholdObservation): any;
export declare class SentinelAlertRuleAnomalyBuiltInThresholdObservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelAlertRuleAnomalyBuiltInThresholdObservation | undefined;
    set internalValue(value: SentinelAlertRuleAnomalyBuiltInThresholdObservation | undefined);
    get description(): string;
    get max(): string;
    get min(): string;
    get name(): string;
    get value(): string;
}
export declare class SentinelAlertRuleAnomalyBuiltInThresholdObservationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelAlertRuleAnomalyBuiltInThresholdObservationOutputReference;
}
export interface SentinelAlertRuleAnomalyBuiltInTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/sentinel_alert_rule_anomaly_built_in#create SentinelAlertRuleAnomalyBuiltIn#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/sentinel_alert_rule_anomaly_built_in#delete SentinelAlertRuleAnomalyBuiltIn#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/sentinel_alert_rule_anomaly_built_in#read SentinelAlertRuleAnomalyBuiltIn#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/sentinel_alert_rule_anomaly_built_in#update SentinelAlertRuleAnomalyBuiltIn#update}
    */
    readonly update?: string;
}
export declare function sentinelAlertRuleAnomalyBuiltInTimeoutsToTerraform(struct?: SentinelAlertRuleAnomalyBuiltInTimeouts | cdktf.IResolvable): any;
export declare function sentinelAlertRuleAnomalyBuiltInTimeoutsToHclTerraform(struct?: SentinelAlertRuleAnomalyBuiltInTimeouts | cdktf.IResolvable): any;
export declare class SentinelAlertRuleAnomalyBuiltInTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SentinelAlertRuleAnomalyBuiltInTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelAlertRuleAnomalyBuiltInTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/sentinel_alert_rule_anomaly_built_in azurerm_sentinel_alert_rule_anomaly_built_in}
*/
export declare class SentinelAlertRuleAnomalyBuiltIn extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_sentinel_alert_rule_anomaly_built_in";
    /**
    * Generates CDKTF code for importing a SentinelAlertRuleAnomalyBuiltIn resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SentinelAlertRuleAnomalyBuiltIn to import
    * @param importFromId The id of the existing SentinelAlertRuleAnomalyBuiltIn that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/sentinel_alert_rule_anomaly_built_in#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SentinelAlertRuleAnomalyBuiltIn to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/sentinel_alert_rule_anomaly_built_in azurerm_sentinel_alert_rule_anomaly_built_in} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SentinelAlertRuleAnomalyBuiltInConfig
    */
    constructor(scope: Construct, id: string, config: SentinelAlertRuleAnomalyBuiltInConfig);
    get anomalySettingsVersion(): number;
    get anomalyVersion(): string;
    get description(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get frequency(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
    private _multiSelectObservation;
    get multiSelectObservation(): SentinelAlertRuleAnomalyBuiltInMultiSelectObservationList;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _prioritizedExcludeObservation;
    get prioritizedExcludeObservation(): SentinelAlertRuleAnomalyBuiltInPrioritizedExcludeObservationList;
    private _requiredDataConnector;
    get requiredDataConnector(): SentinelAlertRuleAnomalyBuiltInRequiredDataConnectorList;
    get settingsDefinitionId(): string;
    private _singleSelectObservation;
    get singleSelectObservation(): SentinelAlertRuleAnomalyBuiltInSingleSelectObservationList;
    get tactics(): string[];
    get techniques(): string[];
    private _thresholdObservation;
    get thresholdObservation(): SentinelAlertRuleAnomalyBuiltInThresholdObservationList;
    private _timeouts;
    get timeouts(): SentinelAlertRuleAnomalyBuiltInTimeoutsOutputReference;
    putTimeouts(value: SentinelAlertRuleAnomalyBuiltInTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SentinelAlertRuleAnomalyBuiltInTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
