/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SharedImageGalleryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/shared_image_gallery#description SharedImageGallery#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/shared_image_gallery#id SharedImageGallery#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/shared_image_gallery#location SharedImageGallery#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/shared_image_gallery#name SharedImageGallery#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/shared_image_gallery#resource_group_name SharedImageGallery#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/shared_image_gallery#tags SharedImageGallery#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * sharing block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/shared_image_gallery#sharing SharedImageGallery#sharing}
    */
    readonly sharing?: SharedImageGallerySharing;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/shared_image_gallery#timeouts SharedImageGallery#timeouts}
    */
    readonly timeouts?: SharedImageGalleryTimeouts;
}
export interface SharedImageGallerySharingCommunityGallery {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/shared_image_gallery#eula SharedImageGallery#eula}
    */
    readonly eula: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/shared_image_gallery#prefix SharedImageGallery#prefix}
    */
    readonly prefix: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/shared_image_gallery#publisher_email SharedImageGallery#publisher_email}
    */
    readonly publisherEmail: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/shared_image_gallery#publisher_uri SharedImageGallery#publisher_uri}
    */
    readonly publisherUri: string;
}
export declare function sharedImageGallerySharingCommunityGalleryToTerraform(struct?: SharedImageGallerySharingCommunityGalleryOutputReference | SharedImageGallerySharingCommunityGallery): any;
export declare function sharedImageGallerySharingCommunityGalleryToHclTerraform(struct?: SharedImageGallerySharingCommunityGalleryOutputReference | SharedImageGallerySharingCommunityGallery): any;
export declare class SharedImageGallerySharingCommunityGalleryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SharedImageGallerySharingCommunityGallery | undefined;
    set internalValue(value: SharedImageGallerySharingCommunityGallery | undefined);
    private _eula?;
    get eula(): string;
    set eula(value: string);
    get eulaInput(): string | undefined;
    get name(): string;
    private _prefix?;
    get prefix(): string;
    set prefix(value: string);
    get prefixInput(): string | undefined;
    private _publisherEmail?;
    get publisherEmail(): string;
    set publisherEmail(value: string);
    get publisherEmailInput(): string | undefined;
    private _publisherUri?;
    get publisherUri(): string;
    set publisherUri(value: string);
    get publisherUriInput(): string | undefined;
}
export interface SharedImageGallerySharing {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/shared_image_gallery#permission SharedImageGallery#permission}
    */
    readonly permission: string;
    /**
    * community_gallery block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/shared_image_gallery#community_gallery SharedImageGallery#community_gallery}
    */
    readonly communityGallery?: SharedImageGallerySharingCommunityGallery;
}
export declare function sharedImageGallerySharingToTerraform(struct?: SharedImageGallerySharingOutputReference | SharedImageGallerySharing): any;
export declare function sharedImageGallerySharingToHclTerraform(struct?: SharedImageGallerySharingOutputReference | SharedImageGallerySharing): any;
export declare class SharedImageGallerySharingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SharedImageGallerySharing | undefined;
    set internalValue(value: SharedImageGallerySharing | undefined);
    private _permission?;
    get permission(): string;
    set permission(value: string);
    get permissionInput(): string | undefined;
    private _communityGallery;
    get communityGallery(): SharedImageGallerySharingCommunityGalleryOutputReference;
    putCommunityGallery(value: SharedImageGallerySharingCommunityGallery): void;
    resetCommunityGallery(): void;
    get communityGalleryInput(): SharedImageGallerySharingCommunityGallery | undefined;
}
export interface SharedImageGalleryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/shared_image_gallery#create SharedImageGallery#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/shared_image_gallery#delete SharedImageGallery#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/shared_image_gallery#read SharedImageGallery#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/shared_image_gallery#update SharedImageGallery#update}
    */
    readonly update?: string;
}
export declare function sharedImageGalleryTimeoutsToTerraform(struct?: SharedImageGalleryTimeouts | cdktf.IResolvable): any;
export declare function sharedImageGalleryTimeoutsToHclTerraform(struct?: SharedImageGalleryTimeouts | cdktf.IResolvable): any;
export declare class SharedImageGalleryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SharedImageGalleryTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SharedImageGalleryTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/shared_image_gallery azurerm_shared_image_gallery}
*/
export declare class SharedImageGallery extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_shared_image_gallery";
    /**
    * Generates CDKTF code for importing a SharedImageGallery resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SharedImageGallery to import
    * @param importFromId The id of the existing SharedImageGallery that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/shared_image_gallery#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SharedImageGallery to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/shared_image_gallery azurerm_shared_image_gallery} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SharedImageGalleryConfig
    */
    constructor(scope: Construct, id: string, config: SharedImageGalleryConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get uniqueName(): string;
    private _sharing;
    get sharing(): SharedImageGallerySharingOutputReference;
    putSharing(value: SharedImageGallerySharing): void;
    resetSharing(): void;
    get sharingInput(): SharedImageGallerySharing | undefined;
    private _timeouts;
    get timeouts(): SharedImageGalleryTimeoutsOutputReference;
    putTimeouts(value: SharedImageGalleryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SharedImageGalleryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
