/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SiteRecoveryNetworkMappingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_network_mapping#id SiteRecoveryNetworkMapping#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_network_mapping#name SiteRecoveryNetworkMapping#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_network_mapping#recovery_vault_name SiteRecoveryNetworkMapping#recovery_vault_name}
    */
    readonly recoveryVaultName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_network_mapping#resource_group_name SiteRecoveryNetworkMapping#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_network_mapping#source_network_id SiteRecoveryNetworkMapping#source_network_id}
    */
    readonly sourceNetworkId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_network_mapping#source_recovery_fabric_name SiteRecoveryNetworkMapping#source_recovery_fabric_name}
    */
    readonly sourceRecoveryFabricName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_network_mapping#target_network_id SiteRecoveryNetworkMapping#target_network_id}
    */
    readonly targetNetworkId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_network_mapping#target_recovery_fabric_name SiteRecoveryNetworkMapping#target_recovery_fabric_name}
    */
    readonly targetRecoveryFabricName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_network_mapping#timeouts SiteRecoveryNetworkMapping#timeouts}
    */
    readonly timeouts?: SiteRecoveryNetworkMappingTimeouts;
}
export interface SiteRecoveryNetworkMappingTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_network_mapping#create SiteRecoveryNetworkMapping#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_network_mapping#delete SiteRecoveryNetworkMapping#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_network_mapping#read SiteRecoveryNetworkMapping#read}
    */
    readonly read?: string;
}
export declare function siteRecoveryNetworkMappingTimeoutsToTerraform(struct?: SiteRecoveryNetworkMappingTimeouts | cdktf.IResolvable): any;
export declare function siteRecoveryNetworkMappingTimeoutsToHclTerraform(struct?: SiteRecoveryNetworkMappingTimeouts | cdktf.IResolvable): any;
export declare class SiteRecoveryNetworkMappingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SiteRecoveryNetworkMappingTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SiteRecoveryNetworkMappingTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_network_mapping azurerm_site_recovery_network_mapping}
*/
export declare class SiteRecoveryNetworkMapping extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_site_recovery_network_mapping";
    /**
    * Generates CDKTF code for importing a SiteRecoveryNetworkMapping resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SiteRecoveryNetworkMapping to import
    * @param importFromId The id of the existing SiteRecoveryNetworkMapping that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_network_mapping#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SiteRecoveryNetworkMapping to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_network_mapping azurerm_site_recovery_network_mapping} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SiteRecoveryNetworkMappingConfig
    */
    constructor(scope: Construct, id: string, config: SiteRecoveryNetworkMappingConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _recoveryVaultName?;
    get recoveryVaultName(): string;
    set recoveryVaultName(value: string);
    get recoveryVaultNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sourceNetworkId?;
    get sourceNetworkId(): string;
    set sourceNetworkId(value: string);
    get sourceNetworkIdInput(): string | undefined;
    private _sourceRecoveryFabricName?;
    get sourceRecoveryFabricName(): string;
    set sourceRecoveryFabricName(value: string);
    get sourceRecoveryFabricNameInput(): string | undefined;
    private _targetNetworkId?;
    get targetNetworkId(): string;
    set targetNetworkId(value: string);
    get targetNetworkIdInput(): string | undefined;
    private _targetRecoveryFabricName?;
    get targetRecoveryFabricName(): string;
    set targetRecoveryFabricName(value: string);
    get targetRecoveryFabricNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): SiteRecoveryNetworkMappingTimeoutsOutputReference;
    putTimeouts(value: SiteRecoveryNetworkMappingTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SiteRecoveryNetworkMappingTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
