/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SiteRecoveryReplicatedVmConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#id SiteRecoveryReplicatedVm#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#managed_disk SiteRecoveryReplicatedVm#managed_disk}
    */
    readonly managedDisk?: SiteRecoveryReplicatedVmManagedDisk[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#multi_vm_group_name SiteRecoveryReplicatedVm#multi_vm_group_name}
    */
    readonly multiVmGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#name SiteRecoveryReplicatedVm#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#network_interface SiteRecoveryReplicatedVm#network_interface}
    */
    readonly networkInterface?: SiteRecoveryReplicatedVmNetworkInterface[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#recovery_replication_policy_id SiteRecoveryReplicatedVm#recovery_replication_policy_id}
    */
    readonly recoveryReplicationPolicyId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#recovery_vault_name SiteRecoveryReplicatedVm#recovery_vault_name}
    */
    readonly recoveryVaultName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#resource_group_name SiteRecoveryReplicatedVm#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#source_recovery_fabric_name SiteRecoveryReplicatedVm#source_recovery_fabric_name}
    */
    readonly sourceRecoveryFabricName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#source_recovery_protection_container_name SiteRecoveryReplicatedVm#source_recovery_protection_container_name}
    */
    readonly sourceRecoveryProtectionContainerName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#source_vm_id SiteRecoveryReplicatedVm#source_vm_id}
    */
    readonly sourceVmId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#target_availability_set_id SiteRecoveryReplicatedVm#target_availability_set_id}
    */
    readonly targetAvailabilitySetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#target_boot_diagnostic_storage_account_id SiteRecoveryReplicatedVm#target_boot_diagnostic_storage_account_id}
    */
    readonly targetBootDiagnosticStorageAccountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#target_capacity_reservation_group_id SiteRecoveryReplicatedVm#target_capacity_reservation_group_id}
    */
    readonly targetCapacityReservationGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#target_edge_zone SiteRecoveryReplicatedVm#target_edge_zone}
    */
    readonly targetEdgeZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#target_network_id SiteRecoveryReplicatedVm#target_network_id}
    */
    readonly targetNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#target_proximity_placement_group_id SiteRecoveryReplicatedVm#target_proximity_placement_group_id}
    */
    readonly targetProximityPlacementGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#target_recovery_fabric_id SiteRecoveryReplicatedVm#target_recovery_fabric_id}
    */
    readonly targetRecoveryFabricId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#target_recovery_protection_container_id SiteRecoveryReplicatedVm#target_recovery_protection_container_id}
    */
    readonly targetRecoveryProtectionContainerId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#target_resource_group_id SiteRecoveryReplicatedVm#target_resource_group_id}
    */
    readonly targetResourceGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#target_virtual_machine_scale_set_id SiteRecoveryReplicatedVm#target_virtual_machine_scale_set_id}
    */
    readonly targetVirtualMachineScaleSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#target_virtual_machine_size SiteRecoveryReplicatedVm#target_virtual_machine_size}
    */
    readonly targetVirtualMachineSize?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#target_zone SiteRecoveryReplicatedVm#target_zone}
    */
    readonly targetZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#test_network_id SiteRecoveryReplicatedVm#test_network_id}
    */
    readonly testNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#unmanaged_disk SiteRecoveryReplicatedVm#unmanaged_disk}
    */
    readonly unmanagedDisk?: SiteRecoveryReplicatedVmUnmanagedDisk[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#timeouts SiteRecoveryReplicatedVm#timeouts}
    */
    readonly timeouts?: SiteRecoveryReplicatedVmTimeouts;
}
export interface SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionDiskEncryptionKey {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#secret_url SiteRecoveryReplicatedVm#secret_url}
    */
    readonly secretUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#vault_id SiteRecoveryReplicatedVm#vault_id}
    */
    readonly vaultId?: string;
}
export declare function siteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionDiskEncryptionKeyToTerraform(struct?: SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionDiskEncryptionKey | cdktf.IResolvable): any;
export declare function siteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionDiskEncryptionKeyToHclTerraform(struct?: SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionDiskEncryptionKey | cdktf.IResolvable): any;
export declare class SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionDiskEncryptionKey | cdktf.IResolvable | undefined;
    set internalValue(value: SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionDiskEncryptionKey | cdktf.IResolvable | undefined);
    private _secretUrl?;
    get secretUrl(): string;
    set secretUrl(value: string);
    resetSecretUrl(): void;
    get secretUrlInput(): string | undefined;
    private _vaultId?;
    get vaultId(): string;
    set vaultId(value: string);
    resetVaultId(): void;
    get vaultIdInput(): string | undefined;
}
export declare class SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionDiskEncryptionKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionDiskEncryptionKey[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionDiskEncryptionKeyOutputReference;
}
export interface SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionKeyEncryptionKey {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#key_url SiteRecoveryReplicatedVm#key_url}
    */
    readonly keyUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#vault_id SiteRecoveryReplicatedVm#vault_id}
    */
    readonly vaultId?: string;
}
export declare function siteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionKeyEncryptionKeyToTerraform(struct?: SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionKeyEncryptionKey | cdktf.IResolvable): any;
export declare function siteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionKeyEncryptionKeyToHclTerraform(struct?: SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionKeyEncryptionKey | cdktf.IResolvable): any;
export declare class SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionKeyEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionKeyEncryptionKey | cdktf.IResolvable | undefined;
    set internalValue(value: SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionKeyEncryptionKey | cdktf.IResolvable | undefined);
    private _keyUrl?;
    get keyUrl(): string;
    set keyUrl(value: string);
    resetKeyUrl(): void;
    get keyUrlInput(): string | undefined;
    private _vaultId?;
    get vaultId(): string;
    set vaultId(value: string);
    resetVaultId(): void;
    get vaultIdInput(): string | undefined;
}
export declare class SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionKeyEncryptionKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionKeyEncryptionKey[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionKeyEncryptionKeyOutputReference;
}
export interface SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryption {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#disk_encryption_key SiteRecoveryReplicatedVm#disk_encryption_key}
    */
    readonly diskEncryptionKey?: SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionDiskEncryptionKey[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#key_encryption_key SiteRecoveryReplicatedVm#key_encryption_key}
    */
    readonly keyEncryptionKey?: SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionKeyEncryptionKey[] | cdktf.IResolvable;
}
export declare function siteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionToTerraform(struct?: SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryption | cdktf.IResolvable): any;
export declare function siteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionToHclTerraform(struct?: SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryption | cdktf.IResolvable): any;
export declare class SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryption | cdktf.IResolvable | undefined;
    set internalValue(value: SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryption | cdktf.IResolvable | undefined);
    private _diskEncryptionKey;
    get diskEncryptionKey(): SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionDiskEncryptionKeyList;
    putDiskEncryptionKey(value: SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionDiskEncryptionKey[] | cdktf.IResolvable): void;
    resetDiskEncryptionKey(): void;
    get diskEncryptionKeyInput(): cdktf.IResolvable | SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionDiskEncryptionKey[] | undefined;
    private _keyEncryptionKey;
    get keyEncryptionKey(): SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionKeyEncryptionKeyList;
    putKeyEncryptionKey(value: SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionKeyEncryptionKey[] | cdktf.IResolvable): void;
    resetKeyEncryptionKey(): void;
    get keyEncryptionKeyInput(): cdktf.IResolvable | SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionKeyEncryptionKey[] | undefined;
}
export declare class SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryption[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionOutputReference;
}
export interface SiteRecoveryReplicatedVmManagedDisk {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#disk_id SiteRecoveryReplicatedVm#disk_id}
    */
    readonly diskId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#staging_storage_account_id SiteRecoveryReplicatedVm#staging_storage_account_id}
    */
    readonly stagingStorageAccountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#target_disk_encryption SiteRecoveryReplicatedVm#target_disk_encryption}
    */
    readonly targetDiskEncryption?: SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryption[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#target_disk_encryption_set_id SiteRecoveryReplicatedVm#target_disk_encryption_set_id}
    */
    readonly targetDiskEncryptionSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#target_disk_type SiteRecoveryReplicatedVm#target_disk_type}
    */
    readonly targetDiskType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#target_replica_disk_type SiteRecoveryReplicatedVm#target_replica_disk_type}
    */
    readonly targetReplicaDiskType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#target_resource_group_id SiteRecoveryReplicatedVm#target_resource_group_id}
    */
    readonly targetResourceGroupId?: string;
}
export declare function siteRecoveryReplicatedVmManagedDiskToTerraform(struct?: SiteRecoveryReplicatedVmManagedDisk | cdktf.IResolvable): any;
export declare function siteRecoveryReplicatedVmManagedDiskToHclTerraform(struct?: SiteRecoveryReplicatedVmManagedDisk | cdktf.IResolvable): any;
export declare class SiteRecoveryReplicatedVmManagedDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SiteRecoveryReplicatedVmManagedDisk | cdktf.IResolvable | undefined;
    set internalValue(value: SiteRecoveryReplicatedVmManagedDisk | cdktf.IResolvable | undefined);
    private _diskId?;
    get diskId(): string;
    set diskId(value: string);
    resetDiskId(): void;
    get diskIdInput(): string | undefined;
    private _stagingStorageAccountId?;
    get stagingStorageAccountId(): string;
    set stagingStorageAccountId(value: string);
    resetStagingStorageAccountId(): void;
    get stagingStorageAccountIdInput(): string | undefined;
    private _targetDiskEncryption;
    get targetDiskEncryption(): SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryptionList;
    putTargetDiskEncryption(value: SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryption[] | cdktf.IResolvable): void;
    resetTargetDiskEncryption(): void;
    get targetDiskEncryptionInput(): cdktf.IResolvable | SiteRecoveryReplicatedVmManagedDiskTargetDiskEncryption[] | undefined;
    private _targetDiskEncryptionSetId?;
    get targetDiskEncryptionSetId(): string;
    set targetDiskEncryptionSetId(value: string);
    resetTargetDiskEncryptionSetId(): void;
    get targetDiskEncryptionSetIdInput(): string | undefined;
    private _targetDiskType?;
    get targetDiskType(): string;
    set targetDiskType(value: string);
    resetTargetDiskType(): void;
    get targetDiskTypeInput(): string | undefined;
    private _targetReplicaDiskType?;
    get targetReplicaDiskType(): string;
    set targetReplicaDiskType(value: string);
    resetTargetReplicaDiskType(): void;
    get targetReplicaDiskTypeInput(): string | undefined;
    private _targetResourceGroupId?;
    get targetResourceGroupId(): string;
    set targetResourceGroupId(value: string);
    resetTargetResourceGroupId(): void;
    get targetResourceGroupIdInput(): string | undefined;
}
export declare class SiteRecoveryReplicatedVmManagedDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SiteRecoveryReplicatedVmManagedDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SiteRecoveryReplicatedVmManagedDiskOutputReference;
}
export interface SiteRecoveryReplicatedVmNetworkInterface {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#failover_test_public_ip_address_id SiteRecoveryReplicatedVm#failover_test_public_ip_address_id}
    */
    readonly failoverTestPublicIpAddressId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#failover_test_static_ip SiteRecoveryReplicatedVm#failover_test_static_ip}
    */
    readonly failoverTestStaticIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#failover_test_subnet_name SiteRecoveryReplicatedVm#failover_test_subnet_name}
    */
    readonly failoverTestSubnetName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#recovery_load_balancer_backend_address_pool_ids SiteRecoveryReplicatedVm#recovery_load_balancer_backend_address_pool_ids}
    */
    readonly recoveryLoadBalancerBackendAddressPoolIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#recovery_public_ip_address_id SiteRecoveryReplicatedVm#recovery_public_ip_address_id}
    */
    readonly recoveryPublicIpAddressId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#source_network_interface_id SiteRecoveryReplicatedVm#source_network_interface_id}
    */
    readonly sourceNetworkInterfaceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#target_static_ip SiteRecoveryReplicatedVm#target_static_ip}
    */
    readonly targetStaticIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#target_subnet_name SiteRecoveryReplicatedVm#target_subnet_name}
    */
    readonly targetSubnetName?: string;
}
export declare function siteRecoveryReplicatedVmNetworkInterfaceToTerraform(struct?: SiteRecoveryReplicatedVmNetworkInterface | cdktf.IResolvable): any;
export declare function siteRecoveryReplicatedVmNetworkInterfaceToHclTerraform(struct?: SiteRecoveryReplicatedVmNetworkInterface | cdktf.IResolvable): any;
export declare class SiteRecoveryReplicatedVmNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SiteRecoveryReplicatedVmNetworkInterface | cdktf.IResolvable | undefined;
    set internalValue(value: SiteRecoveryReplicatedVmNetworkInterface | cdktf.IResolvable | undefined);
    private _failoverTestPublicIpAddressId?;
    get failoverTestPublicIpAddressId(): string;
    set failoverTestPublicIpAddressId(value: string);
    resetFailoverTestPublicIpAddressId(): void;
    get failoverTestPublicIpAddressIdInput(): string | undefined;
    private _failoverTestStaticIp?;
    get failoverTestStaticIp(): string;
    set failoverTestStaticIp(value: string);
    resetFailoverTestStaticIp(): void;
    get failoverTestStaticIpInput(): string | undefined;
    private _failoverTestSubnetName?;
    get failoverTestSubnetName(): string;
    set failoverTestSubnetName(value: string);
    resetFailoverTestSubnetName(): void;
    get failoverTestSubnetNameInput(): string | undefined;
    private _recoveryLoadBalancerBackendAddressPoolIds?;
    get recoveryLoadBalancerBackendAddressPoolIds(): string[];
    set recoveryLoadBalancerBackendAddressPoolIds(value: string[]);
    resetRecoveryLoadBalancerBackendAddressPoolIds(): void;
    get recoveryLoadBalancerBackendAddressPoolIdsInput(): string[] | undefined;
    private _recoveryPublicIpAddressId?;
    get recoveryPublicIpAddressId(): string;
    set recoveryPublicIpAddressId(value: string);
    resetRecoveryPublicIpAddressId(): void;
    get recoveryPublicIpAddressIdInput(): string | undefined;
    private _sourceNetworkInterfaceId?;
    get sourceNetworkInterfaceId(): string;
    set sourceNetworkInterfaceId(value: string);
    resetSourceNetworkInterfaceId(): void;
    get sourceNetworkInterfaceIdInput(): string | undefined;
    private _targetStaticIp?;
    get targetStaticIp(): string;
    set targetStaticIp(value: string);
    resetTargetStaticIp(): void;
    get targetStaticIpInput(): string | undefined;
    private _targetSubnetName?;
    get targetSubnetName(): string;
    set targetSubnetName(value: string);
    resetTargetSubnetName(): void;
    get targetSubnetNameInput(): string | undefined;
}
export declare class SiteRecoveryReplicatedVmNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SiteRecoveryReplicatedVmNetworkInterface[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SiteRecoveryReplicatedVmNetworkInterfaceOutputReference;
}
export interface SiteRecoveryReplicatedVmUnmanagedDisk {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#disk_uri SiteRecoveryReplicatedVm#disk_uri}
    */
    readonly diskUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#staging_storage_account_id SiteRecoveryReplicatedVm#staging_storage_account_id}
    */
    readonly stagingStorageAccountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#target_storage_account_id SiteRecoveryReplicatedVm#target_storage_account_id}
    */
    readonly targetStorageAccountId?: string;
}
export declare function siteRecoveryReplicatedVmUnmanagedDiskToTerraform(struct?: SiteRecoveryReplicatedVmUnmanagedDisk | cdktf.IResolvable): any;
export declare function siteRecoveryReplicatedVmUnmanagedDiskToHclTerraform(struct?: SiteRecoveryReplicatedVmUnmanagedDisk | cdktf.IResolvable): any;
export declare class SiteRecoveryReplicatedVmUnmanagedDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SiteRecoveryReplicatedVmUnmanagedDisk | cdktf.IResolvable | undefined;
    set internalValue(value: SiteRecoveryReplicatedVmUnmanagedDisk | cdktf.IResolvable | undefined);
    private _diskUri?;
    get diskUri(): string;
    set diskUri(value: string);
    resetDiskUri(): void;
    get diskUriInput(): string | undefined;
    private _stagingStorageAccountId?;
    get stagingStorageAccountId(): string;
    set stagingStorageAccountId(value: string);
    resetStagingStorageAccountId(): void;
    get stagingStorageAccountIdInput(): string | undefined;
    private _targetStorageAccountId?;
    get targetStorageAccountId(): string;
    set targetStorageAccountId(value: string);
    resetTargetStorageAccountId(): void;
    get targetStorageAccountIdInput(): string | undefined;
}
export declare class SiteRecoveryReplicatedVmUnmanagedDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SiteRecoveryReplicatedVmUnmanagedDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SiteRecoveryReplicatedVmUnmanagedDiskOutputReference;
}
export interface SiteRecoveryReplicatedVmTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#create SiteRecoveryReplicatedVm#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#delete SiteRecoveryReplicatedVm#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#read SiteRecoveryReplicatedVm#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#update SiteRecoveryReplicatedVm#update}
    */
    readonly update?: string;
}
export declare function siteRecoveryReplicatedVmTimeoutsToTerraform(struct?: SiteRecoveryReplicatedVmTimeouts | cdktf.IResolvable): any;
export declare function siteRecoveryReplicatedVmTimeoutsToHclTerraform(struct?: SiteRecoveryReplicatedVmTimeouts | cdktf.IResolvable): any;
export declare class SiteRecoveryReplicatedVmTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SiteRecoveryReplicatedVmTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SiteRecoveryReplicatedVmTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm azurerm_site_recovery_replicated_vm}
*/
export declare class SiteRecoveryReplicatedVm extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_site_recovery_replicated_vm";
    /**
    * Generates CDKTF code for importing a SiteRecoveryReplicatedVm resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SiteRecoveryReplicatedVm to import
    * @param importFromId The id of the existing SiteRecoveryReplicatedVm that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SiteRecoveryReplicatedVm to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/site_recovery_replicated_vm azurerm_site_recovery_replicated_vm} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SiteRecoveryReplicatedVmConfig
    */
    constructor(scope: Construct, id: string, config: SiteRecoveryReplicatedVmConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _managedDisk;
    get managedDisk(): SiteRecoveryReplicatedVmManagedDiskList;
    putManagedDisk(value: SiteRecoveryReplicatedVmManagedDisk[] | cdktf.IResolvable): void;
    resetManagedDisk(): void;
    get managedDiskInput(): cdktf.IResolvable | SiteRecoveryReplicatedVmManagedDisk[] | undefined;
    private _multiVmGroupName?;
    get multiVmGroupName(): string;
    set multiVmGroupName(value: string);
    resetMultiVmGroupName(): void;
    get multiVmGroupNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkInterface;
    get networkInterface(): SiteRecoveryReplicatedVmNetworkInterfaceList;
    putNetworkInterface(value: SiteRecoveryReplicatedVmNetworkInterface[] | cdktf.IResolvable): void;
    resetNetworkInterface(): void;
    get networkInterfaceInput(): cdktf.IResolvable | SiteRecoveryReplicatedVmNetworkInterface[] | undefined;
    private _recoveryReplicationPolicyId?;
    get recoveryReplicationPolicyId(): string;
    set recoveryReplicationPolicyId(value: string);
    get recoveryReplicationPolicyIdInput(): string | undefined;
    private _recoveryVaultName?;
    get recoveryVaultName(): string;
    set recoveryVaultName(value: string);
    get recoveryVaultNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sourceRecoveryFabricName?;
    get sourceRecoveryFabricName(): string;
    set sourceRecoveryFabricName(value: string);
    get sourceRecoveryFabricNameInput(): string | undefined;
    private _sourceRecoveryProtectionContainerName?;
    get sourceRecoveryProtectionContainerName(): string;
    set sourceRecoveryProtectionContainerName(value: string);
    get sourceRecoveryProtectionContainerNameInput(): string | undefined;
    private _sourceVmId?;
    get sourceVmId(): string;
    set sourceVmId(value: string);
    get sourceVmIdInput(): string | undefined;
    private _targetAvailabilitySetId?;
    get targetAvailabilitySetId(): string;
    set targetAvailabilitySetId(value: string);
    resetTargetAvailabilitySetId(): void;
    get targetAvailabilitySetIdInput(): string | undefined;
    private _targetBootDiagnosticStorageAccountId?;
    get targetBootDiagnosticStorageAccountId(): string;
    set targetBootDiagnosticStorageAccountId(value: string);
    resetTargetBootDiagnosticStorageAccountId(): void;
    get targetBootDiagnosticStorageAccountIdInput(): string | undefined;
    private _targetCapacityReservationGroupId?;
    get targetCapacityReservationGroupId(): string;
    set targetCapacityReservationGroupId(value: string);
    resetTargetCapacityReservationGroupId(): void;
    get targetCapacityReservationGroupIdInput(): string | undefined;
    private _targetEdgeZone?;
    get targetEdgeZone(): string;
    set targetEdgeZone(value: string);
    resetTargetEdgeZone(): void;
    get targetEdgeZoneInput(): string | undefined;
    private _targetNetworkId?;
    get targetNetworkId(): string;
    set targetNetworkId(value: string);
    resetTargetNetworkId(): void;
    get targetNetworkIdInput(): string | undefined;
    private _targetProximityPlacementGroupId?;
    get targetProximityPlacementGroupId(): string;
    set targetProximityPlacementGroupId(value: string);
    resetTargetProximityPlacementGroupId(): void;
    get targetProximityPlacementGroupIdInput(): string | undefined;
    private _targetRecoveryFabricId?;
    get targetRecoveryFabricId(): string;
    set targetRecoveryFabricId(value: string);
    get targetRecoveryFabricIdInput(): string | undefined;
    private _targetRecoveryProtectionContainerId?;
    get targetRecoveryProtectionContainerId(): string;
    set targetRecoveryProtectionContainerId(value: string);
    get targetRecoveryProtectionContainerIdInput(): string | undefined;
    private _targetResourceGroupId?;
    get targetResourceGroupId(): string;
    set targetResourceGroupId(value: string);
    get targetResourceGroupIdInput(): string | undefined;
    private _targetVirtualMachineScaleSetId?;
    get targetVirtualMachineScaleSetId(): string;
    set targetVirtualMachineScaleSetId(value: string);
    resetTargetVirtualMachineScaleSetId(): void;
    get targetVirtualMachineScaleSetIdInput(): string | undefined;
    private _targetVirtualMachineSize?;
    get targetVirtualMachineSize(): string;
    set targetVirtualMachineSize(value: string);
    resetTargetVirtualMachineSize(): void;
    get targetVirtualMachineSizeInput(): string | undefined;
    private _targetZone?;
    get targetZone(): string;
    set targetZone(value: string);
    resetTargetZone(): void;
    get targetZoneInput(): string | undefined;
    private _testNetworkId?;
    get testNetworkId(): string;
    set testNetworkId(value: string);
    resetTestNetworkId(): void;
    get testNetworkIdInput(): string | undefined;
    private _unmanagedDisk;
    get unmanagedDisk(): SiteRecoveryReplicatedVmUnmanagedDiskList;
    putUnmanagedDisk(value: SiteRecoveryReplicatedVmUnmanagedDisk[] | cdktf.IResolvable): void;
    resetUnmanagedDisk(): void;
    get unmanagedDiskInput(): cdktf.IResolvable | SiteRecoveryReplicatedVmUnmanagedDisk[] | undefined;
    private _timeouts;
    get timeouts(): SiteRecoveryReplicatedVmTimeoutsOutputReference;
    putTimeouts(value: SiteRecoveryReplicatedVmTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SiteRecoveryReplicatedVmTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
