/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SnapshotConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#create_option Snapshot#create_option}
    */
    readonly createOption: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#disk_access_id Snapshot#disk_access_id}
    */
    readonly diskAccessId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#disk_size_gb Snapshot#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#id Snapshot#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#incremental_enabled Snapshot#incremental_enabled}
    */
    readonly incrementalEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#location Snapshot#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#name Snapshot#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#network_access_policy Snapshot#network_access_policy}
    */
    readonly networkAccessPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#public_network_access_enabled Snapshot#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#resource_group_name Snapshot#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#source_resource_id Snapshot#source_resource_id}
    */
    readonly sourceResourceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#source_uri Snapshot#source_uri}
    */
    readonly sourceUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#storage_account_id Snapshot#storage_account_id}
    */
    readonly storageAccountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#tags Snapshot#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * encryption_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#encryption_settings Snapshot#encryption_settings}
    */
    readonly encryptionSettings?: SnapshotEncryptionSettings;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#timeouts Snapshot#timeouts}
    */
    readonly timeouts?: SnapshotTimeouts;
}
export interface SnapshotEncryptionSettingsDiskEncryptionKey {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#secret_url Snapshot#secret_url}
    */
    readonly secretUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#source_vault_id Snapshot#source_vault_id}
    */
    readonly sourceVaultId: string;
}
export declare function snapshotEncryptionSettingsDiskEncryptionKeyToTerraform(struct?: SnapshotEncryptionSettingsDiskEncryptionKeyOutputReference | SnapshotEncryptionSettingsDiskEncryptionKey): any;
export declare function snapshotEncryptionSettingsDiskEncryptionKeyToHclTerraform(struct?: SnapshotEncryptionSettingsDiskEncryptionKeyOutputReference | SnapshotEncryptionSettingsDiskEncryptionKey): any;
export declare class SnapshotEncryptionSettingsDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SnapshotEncryptionSettingsDiskEncryptionKey | undefined;
    set internalValue(value: SnapshotEncryptionSettingsDiskEncryptionKey | undefined);
    private _secretUrl?;
    get secretUrl(): string;
    set secretUrl(value: string);
    get secretUrlInput(): string | undefined;
    private _sourceVaultId?;
    get sourceVaultId(): string;
    set sourceVaultId(value: string);
    get sourceVaultIdInput(): string | undefined;
}
export interface SnapshotEncryptionSettingsKeyEncryptionKey {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#key_url Snapshot#key_url}
    */
    readonly keyUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#source_vault_id Snapshot#source_vault_id}
    */
    readonly sourceVaultId: string;
}
export declare function snapshotEncryptionSettingsKeyEncryptionKeyToTerraform(struct?: SnapshotEncryptionSettingsKeyEncryptionKeyOutputReference | SnapshotEncryptionSettingsKeyEncryptionKey): any;
export declare function snapshotEncryptionSettingsKeyEncryptionKeyToHclTerraform(struct?: SnapshotEncryptionSettingsKeyEncryptionKeyOutputReference | SnapshotEncryptionSettingsKeyEncryptionKey): any;
export declare class SnapshotEncryptionSettingsKeyEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SnapshotEncryptionSettingsKeyEncryptionKey | undefined;
    set internalValue(value: SnapshotEncryptionSettingsKeyEncryptionKey | undefined);
    private _keyUrl?;
    get keyUrl(): string;
    set keyUrl(value: string);
    get keyUrlInput(): string | undefined;
    private _sourceVaultId?;
    get sourceVaultId(): string;
    set sourceVaultId(value: string);
    get sourceVaultIdInput(): string | undefined;
}
export interface SnapshotEncryptionSettings {
    /**
    * disk_encryption_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#disk_encryption_key Snapshot#disk_encryption_key}
    */
    readonly diskEncryptionKey: SnapshotEncryptionSettingsDiskEncryptionKey;
    /**
    * key_encryption_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#key_encryption_key Snapshot#key_encryption_key}
    */
    readonly keyEncryptionKey?: SnapshotEncryptionSettingsKeyEncryptionKey;
}
export declare function snapshotEncryptionSettingsToTerraform(struct?: SnapshotEncryptionSettingsOutputReference | SnapshotEncryptionSettings): any;
export declare function snapshotEncryptionSettingsToHclTerraform(struct?: SnapshotEncryptionSettingsOutputReference | SnapshotEncryptionSettings): any;
export declare class SnapshotEncryptionSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SnapshotEncryptionSettings | undefined;
    set internalValue(value: SnapshotEncryptionSettings | undefined);
    private _diskEncryptionKey;
    get diskEncryptionKey(): SnapshotEncryptionSettingsDiskEncryptionKeyOutputReference;
    putDiskEncryptionKey(value: SnapshotEncryptionSettingsDiskEncryptionKey): void;
    get diskEncryptionKeyInput(): SnapshotEncryptionSettingsDiskEncryptionKey | undefined;
    private _keyEncryptionKey;
    get keyEncryptionKey(): SnapshotEncryptionSettingsKeyEncryptionKeyOutputReference;
    putKeyEncryptionKey(value: SnapshotEncryptionSettingsKeyEncryptionKey): void;
    resetKeyEncryptionKey(): void;
    get keyEncryptionKeyInput(): SnapshotEncryptionSettingsKeyEncryptionKey | undefined;
}
export interface SnapshotTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#create Snapshot#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#delete Snapshot#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#read Snapshot#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#update Snapshot#update}
    */
    readonly update?: string;
}
export declare function snapshotTimeoutsToTerraform(struct?: SnapshotTimeouts | cdktf.IResolvable): any;
export declare function snapshotTimeoutsToHclTerraform(struct?: SnapshotTimeouts | cdktf.IResolvable): any;
export declare class SnapshotTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SnapshotTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SnapshotTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot azurerm_snapshot}
*/
export declare class Snapshot extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_snapshot";
    /**
    * Generates CDKTF code for importing a Snapshot resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Snapshot to import
    * @param importFromId The id of the existing Snapshot that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Snapshot to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/snapshot azurerm_snapshot} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SnapshotConfig
    */
    constructor(scope: Construct, id: string, config: SnapshotConfig);
    private _createOption?;
    get createOption(): string;
    set createOption(value: string);
    get createOptionInput(): string | undefined;
    private _diskAccessId?;
    get diskAccessId(): string;
    set diskAccessId(value: string);
    resetDiskAccessId(): void;
    get diskAccessIdInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _incrementalEnabled?;
    get incrementalEnabled(): boolean | cdktf.IResolvable;
    set incrementalEnabled(value: boolean | cdktf.IResolvable);
    resetIncrementalEnabled(): void;
    get incrementalEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkAccessPolicy?;
    get networkAccessPolicy(): string;
    set networkAccessPolicy(value: string);
    resetNetworkAccessPolicy(): void;
    get networkAccessPolicyInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sourceResourceId?;
    get sourceResourceId(): string;
    set sourceResourceId(value: string);
    resetSourceResourceId(): void;
    get sourceResourceIdInput(): string | undefined;
    private _sourceUri?;
    get sourceUri(): string;
    set sourceUri(value: string);
    resetSourceUri(): void;
    get sourceUriInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    resetStorageAccountId(): void;
    get storageAccountIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get trustedLaunchEnabled(): cdktf.IResolvable;
    private _encryptionSettings;
    get encryptionSettings(): SnapshotEncryptionSettingsOutputReference;
    putEncryptionSettings(value: SnapshotEncryptionSettings): void;
    resetEncryptionSettings(): void;
    get encryptionSettingsInput(): SnapshotEncryptionSettings | undefined;
    private _timeouts;
    get timeouts(): SnapshotTimeoutsOutputReference;
    putTimeouts(value: SnapshotTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SnapshotTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
