/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SpringCloudCustomizedAcceleratorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#accelerator_tags SpringCloudCustomizedAccelerator#accelerator_tags}
    */
    readonly acceleratorTags?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#accelerator_type SpringCloudCustomizedAccelerator#accelerator_type}
    */
    readonly acceleratorType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#description SpringCloudCustomizedAccelerator#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#display_name SpringCloudCustomizedAccelerator#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#icon_url SpringCloudCustomizedAccelerator#icon_url}
    */
    readonly iconUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#id SpringCloudCustomizedAccelerator#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#name SpringCloudCustomizedAccelerator#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#spring_cloud_accelerator_id SpringCloudCustomizedAccelerator#spring_cloud_accelerator_id}
    */
    readonly springCloudAcceleratorId: string;
    /**
    * git_repository block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#git_repository SpringCloudCustomizedAccelerator#git_repository}
    */
    readonly gitRepository: SpringCloudCustomizedAcceleratorGitRepository;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#timeouts SpringCloudCustomizedAccelerator#timeouts}
    */
    readonly timeouts?: SpringCloudCustomizedAcceleratorTimeouts;
}
export interface SpringCloudCustomizedAcceleratorGitRepositoryBasicAuth {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#password SpringCloudCustomizedAccelerator#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#username SpringCloudCustomizedAccelerator#username}
    */
    readonly username: string;
}
export declare function springCloudCustomizedAcceleratorGitRepositoryBasicAuthToTerraform(struct?: SpringCloudCustomizedAcceleratorGitRepositoryBasicAuthOutputReference | SpringCloudCustomizedAcceleratorGitRepositoryBasicAuth): any;
export declare function springCloudCustomizedAcceleratorGitRepositoryBasicAuthToHclTerraform(struct?: SpringCloudCustomizedAcceleratorGitRepositoryBasicAuthOutputReference | SpringCloudCustomizedAcceleratorGitRepositoryBasicAuth): any;
export declare class SpringCloudCustomizedAcceleratorGitRepositoryBasicAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudCustomizedAcceleratorGitRepositoryBasicAuth | undefined;
    set internalValue(value: SpringCloudCustomizedAcceleratorGitRepositoryBasicAuth | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface SpringCloudCustomizedAcceleratorGitRepositorySshAuth {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#host_key SpringCloudCustomizedAccelerator#host_key}
    */
    readonly hostKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#host_key_algorithm SpringCloudCustomizedAccelerator#host_key_algorithm}
    */
    readonly hostKeyAlgorithm?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#private_key SpringCloudCustomizedAccelerator#private_key}
    */
    readonly privateKey: string;
}
export declare function springCloudCustomizedAcceleratorGitRepositorySshAuthToTerraform(struct?: SpringCloudCustomizedAcceleratorGitRepositorySshAuthOutputReference | SpringCloudCustomizedAcceleratorGitRepositorySshAuth): any;
export declare function springCloudCustomizedAcceleratorGitRepositorySshAuthToHclTerraform(struct?: SpringCloudCustomizedAcceleratorGitRepositorySshAuthOutputReference | SpringCloudCustomizedAcceleratorGitRepositorySshAuth): any;
export declare class SpringCloudCustomizedAcceleratorGitRepositorySshAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudCustomizedAcceleratorGitRepositorySshAuth | undefined;
    set internalValue(value: SpringCloudCustomizedAcceleratorGitRepositorySshAuth | undefined);
    private _hostKey?;
    get hostKey(): string;
    set hostKey(value: string);
    resetHostKey(): void;
    get hostKeyInput(): string | undefined;
    private _hostKeyAlgorithm?;
    get hostKeyAlgorithm(): string;
    set hostKeyAlgorithm(value: string);
    resetHostKeyAlgorithm(): void;
    get hostKeyAlgorithmInput(): string | undefined;
    private _privateKey?;
    get privateKey(): string;
    set privateKey(value: string);
    get privateKeyInput(): string | undefined;
}
export interface SpringCloudCustomizedAcceleratorGitRepository {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#branch SpringCloudCustomizedAccelerator#branch}
    */
    readonly branch?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#ca_certificate_id SpringCloudCustomizedAccelerator#ca_certificate_id}
    */
    readonly caCertificateId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#commit SpringCloudCustomizedAccelerator#commit}
    */
    readonly commit?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#git_tag SpringCloudCustomizedAccelerator#git_tag}
    */
    readonly gitTag?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#interval_in_seconds SpringCloudCustomizedAccelerator#interval_in_seconds}
    */
    readonly intervalInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#path SpringCloudCustomizedAccelerator#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#url SpringCloudCustomizedAccelerator#url}
    */
    readonly url: string;
    /**
    * basic_auth block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#basic_auth SpringCloudCustomizedAccelerator#basic_auth}
    */
    readonly basicAuth?: SpringCloudCustomizedAcceleratorGitRepositoryBasicAuth;
    /**
    * ssh_auth block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#ssh_auth SpringCloudCustomizedAccelerator#ssh_auth}
    */
    readonly sshAuth?: SpringCloudCustomizedAcceleratorGitRepositorySshAuth;
}
export declare function springCloudCustomizedAcceleratorGitRepositoryToTerraform(struct?: SpringCloudCustomizedAcceleratorGitRepositoryOutputReference | SpringCloudCustomizedAcceleratorGitRepository): any;
export declare function springCloudCustomizedAcceleratorGitRepositoryToHclTerraform(struct?: SpringCloudCustomizedAcceleratorGitRepositoryOutputReference | SpringCloudCustomizedAcceleratorGitRepository): any;
export declare class SpringCloudCustomizedAcceleratorGitRepositoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudCustomizedAcceleratorGitRepository | undefined;
    set internalValue(value: SpringCloudCustomizedAcceleratorGitRepository | undefined);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    resetBranch(): void;
    get branchInput(): string | undefined;
    private _caCertificateId?;
    get caCertificateId(): string;
    set caCertificateId(value: string);
    resetCaCertificateId(): void;
    get caCertificateIdInput(): string | undefined;
    private _commit?;
    get commit(): string;
    set commit(value: string);
    resetCommit(): void;
    get commitInput(): string | undefined;
    private _gitTag?;
    get gitTag(): string;
    set gitTag(value: string);
    resetGitTag(): void;
    get gitTagInput(): string | undefined;
    private _intervalInSeconds?;
    get intervalInSeconds(): number;
    set intervalInSeconds(value: number);
    resetIntervalInSeconds(): void;
    get intervalInSecondsInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _basicAuth;
    get basicAuth(): SpringCloudCustomizedAcceleratorGitRepositoryBasicAuthOutputReference;
    putBasicAuth(value: SpringCloudCustomizedAcceleratorGitRepositoryBasicAuth): void;
    resetBasicAuth(): void;
    get basicAuthInput(): SpringCloudCustomizedAcceleratorGitRepositoryBasicAuth | undefined;
    private _sshAuth;
    get sshAuth(): SpringCloudCustomizedAcceleratorGitRepositorySshAuthOutputReference;
    putSshAuth(value: SpringCloudCustomizedAcceleratorGitRepositorySshAuth): void;
    resetSshAuth(): void;
    get sshAuthInput(): SpringCloudCustomizedAcceleratorGitRepositorySshAuth | undefined;
}
export interface SpringCloudCustomizedAcceleratorTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#create SpringCloudCustomizedAccelerator#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#delete SpringCloudCustomizedAccelerator#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#read SpringCloudCustomizedAccelerator#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#update SpringCloudCustomizedAccelerator#update}
    */
    readonly update?: string;
}
export declare function springCloudCustomizedAcceleratorTimeoutsToTerraform(struct?: SpringCloudCustomizedAcceleratorTimeouts | cdktf.IResolvable): any;
export declare function springCloudCustomizedAcceleratorTimeoutsToHclTerraform(struct?: SpringCloudCustomizedAcceleratorTimeouts | cdktf.IResolvable): any;
export declare class SpringCloudCustomizedAcceleratorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudCustomizedAcceleratorTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SpringCloudCustomizedAcceleratorTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator azurerm_spring_cloud_customized_accelerator}
*/
export declare class SpringCloudCustomizedAccelerator extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_spring_cloud_customized_accelerator";
    /**
    * Generates CDKTF code for importing a SpringCloudCustomizedAccelerator resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SpringCloudCustomizedAccelerator to import
    * @param importFromId The id of the existing SpringCloudCustomizedAccelerator that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SpringCloudCustomizedAccelerator to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.23.0/docs/resources/spring_cloud_customized_accelerator azurerm_spring_cloud_customized_accelerator} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SpringCloudCustomizedAcceleratorConfig
    */
    constructor(scope: Construct, id: string, config: SpringCloudCustomizedAcceleratorConfig);
    private _acceleratorTags?;
    get acceleratorTags(): string[];
    set acceleratorTags(value: string[]);
    resetAcceleratorTags(): void;
    get acceleratorTagsInput(): string[] | undefined;
    private _acceleratorType?;
    get acceleratorType(): string;
    set acceleratorType(value: string);
    resetAcceleratorType(): void;
    get acceleratorTypeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _iconUrl?;
    get iconUrl(): string;
    set iconUrl(value: string);
    resetIconUrl(): void;
    get iconUrlInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _springCloudAcceleratorId?;
    get springCloudAcceleratorId(): string;
    set springCloudAcceleratorId(value: string);
    get springCloudAcceleratorIdInput(): string | undefined;
    private _gitRepository;
    get gitRepository(): SpringCloudCustomizedAcceleratorGitRepositoryOutputReference;
    putGitRepository(value: SpringCloudCustomizedAcceleratorGitRepository): void;
    get gitRepositoryInput(): SpringCloudCustomizedAcceleratorGitRepository | undefined;
    private _timeouts;
    get timeouts(): SpringCloudCustomizedAcceleratorTimeoutsOutputReference;
    putTimeouts(value: SpringCloudCustomizedAcceleratorTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SpringCloudCustomizedAcceleratorTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
